/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import ghidra.program.model.address.Address;
import ghidra.trace.model.AddressSnap;
import java.util.Objects;

public class DefaultAddressSnap
implements AddressSnap {
    private final Address address;
    private final long snap;

    public DefaultAddressSnap(Address address, long snap) {
        this.address = address;
        this.snap = snap;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public long getSnap() {
        return this.snap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultAddressSnap)) {
            return false;
        }
        DefaultAddressSnap that = (DefaultAddressSnap)obj;
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        return this.snap == that.snap;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.snap);
    }

    @Override
    public int compareTo(AddressSnap that) {
        if (this == that) {
            return 0;
        }
        int result = this.address.compareTo((Object)that.getAddress());
        if (result != 0) {
            return result;
        }
        result = Long.compareUnsigned(this.snap, that.getSnap());
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

