/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.FunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ParseHelper;

class URLUnitImpl
extends FunctionUnitImpl {
    private static final long serialVersionUID = 1L;

    public URLUnitImpl() {
        super(LexicalUnit.LexicalType.URI);
    }

    @Override
    URLUnitImpl instantiateLexicalUnit() {
        return new URLUnitImpl();
    }

    @Override
    CSSValueSyntax.Match typeMatch(CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        CSSValueSyntax.Category cat = syntax.getCategory();
        return cat == CSSValueSyntax.Category.url || cat == CSSValueSyntax.Category.image ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
    }

    @Override
    CharSequence currentToString() {
        StringBuilder buf = new StringBuilder(32);
        String quri = this.identCssText != null ? this.identCssText : (this.value != null ? ParseHelper.quote(this.value, '\'') : "");
        buf.append("url(").append(quri);
        if (this.parameters != null) {
            buf.append(' ').append(this.parameters.toString());
        }
        buf.append(')');
        return buf;
    }
}

