/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot;

import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class LongDateTime {
    private static final long BASE;

    public static Date toDate(long l) {
        return new Date(LongDateTime.toSystemMillis(l));
    }

    public static long toSystemMillis(long l) {
        return BASE + 1000L * l;
    }

    public static long fromDate(Date date) {
        return LongDateTime.fromSystemMillis(date.getTime());
    }

    public static long fromSystemMillis(long l) {
        return (l - BASE) / 1000L;
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone(ZoneId.of("UTC")));
        gregorianCalendar.set(1, 1904);
        gregorianCalendar.set(2, 0);
        gregorianCalendar.set(5, 1);
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        BASE = gregorianCalendar.getTimeInMillis();
    }
}

