# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "monitor log-profiles create",
)
class Create(AAZCommand):
    """Create a log profile in Azure Monitoring REST API.

    :example: Create a log profile. (autogenerated)
        az monitor log-profiles create --categories "Delete" --days 0 --enabled true --location westus2 --locations westus --name MyLogProfile --service-bus-rule-id "/subscriptions/{YOUR SUBSCRIPTION ID}/resourceGroups/{RESOURCE GROUP NAME}/providers/Microsoft.EventHub/namespaces/{EVENT HUB NAME SPACE}/authorizationrules/RootManageSharedAccessKey"
    """

    _aaz_info = {
        "version": "2016-03-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.insights/logprofiles/{}", "2016-03-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the log profile.",
            required=True,
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Location. Values from: `az account list-locations`. You can configure the default location using `az configure --defaults location=<location>`.",
            required=True,
        )
        _args_schema.categories = AAZListArg(
            options=["--categories"],
            help="Space-separated categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'",
            required=True,
        )
        _args_schema.locations = AAZListArg(
            options=["--locations"],
            help="Space-separated list of regions for which Activity Log events should be stored.",
            required=True,
        )
        _args_schema.service_bus_rule_id = AAZStrArg(
            options=["--service-bus-rule-id"],
            help="The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'.",
        )
        _args_schema.storage_account_id = AAZStrArg(
            options=["--storage-account-id"],
            help="the resource id of the storage account to which you would like to send the Activity Log.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...]. Use '' to clear existing tags.",
        )

        categories = cls._args_schema.categories
        categories.Element = AAZStrArg()

        locations = cls._args_schema.locations
        locations.Element = AAZStrArg()

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Retention Policy"

        _args_schema = cls._args_schema
        _args_schema.days = AAZIntArg(
            options=["--days"],
            arg_group="Retention Policy",
            help="the number of days for the retention in days. A value of 0 will retain the events indefinitely.",
            required=True,
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )
        _args_schema.enabled = AAZBoolArg(
            options=["--enabled"],
            arg_group="Retention Policy",
            help="Whether the retention policy is enabled.  Allowed values: false, true.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.LogProfilesCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class LogProfilesCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Insights/logprofiles/{logProfileName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "logProfileName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2016-03-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("categories", AAZListType, ".categories", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("locations", AAZListType, ".locations", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("retentionPolicy", AAZObjectType, ".", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("serviceBusRuleId", AAZStrType, ".service_bus_rule_id")
                properties.set_prop("storageAccountId", AAZStrType, ".storage_account_id")

            categories = _builder.get(".properties.categories")
            if categories is not None:
                categories.set_elements(AAZStrType, ".")

            locations = _builder.get(".properties.locations")
            if locations is not None:
                locations.set_elements(AAZStrType, ".")

            retention_policy = _builder.get(".properties.retentionPolicy")
            if retention_policy is not None:
                retention_policy.set_prop("days", AAZIntType, ".days", typ_kwargs={"flags": {"required": True}})
                retention_policy.set_prop("enabled", AAZBoolType, ".enabled", typ_kwargs={"flags": {"required": True}})

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"required": True, "client_flatten": True},
            )
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.categories = AAZListType(
                flags={"required": True},
            )
            properties.locations = AAZListType(
                flags={"required": True},
            )
            properties.retention_policy = AAZObjectType(
                serialized_name="retentionPolicy",
                flags={"required": True},
            )
            properties.service_bus_rule_id = AAZStrType(
                serialized_name="serviceBusRuleId",
            )
            properties.storage_account_id = AAZStrType(
                serialized_name="storageAccountId",
            )

            categories = cls._schema_on_200.properties.categories
            categories.Element = AAZStrType()

            locations = cls._schema_on_200.properties.locations
            locations.Element = AAZStrType()

            retention_policy = cls._schema_on_200.properties.retention_policy
            retention_policy.days = AAZIntType(
                flags={"required": True},
            )
            retention_policy.enabled = AAZBoolType(
                flags={"required": True},
            )

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _CreateHelper:
    """Helper class for Create"""


__all__ = ["Create"]
