# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessScope enums."""

    JOB = "job"
    """Grants access to perform all operations on the Job containing the Task."""


class AllocationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AllocationState enums."""

    STEADY = "steady"
    """The Pool is not resizing. There are no changes to the number of Compute Nodes in the Pool in
    progress. A Pool enters this state when it is created and when no operations are being
    performed on the Pool to change the number of Compute Nodes."""
    RESIZING = "resizing"
    """The Pool is resizing; that is, Compute Nodes are being added to or removed from the Pool."""
    STOPPING = "stopping"
    """The Pool was resizing, but the user has requested that the resize be stopped, but the stop
    request has not yet been completed."""


class AutoUserScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AutoUserScope enums."""

    TASK = "task"
    """Specifies that the service should create a new user for the Task."""
    POOL = "pool"
    """Specifies that the Task runs as the common auto user Account which is created on every Compute
    Node in a Pool."""


class BatchJobAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchJobAction enums."""

    NONE = "none"
    """Take no action."""
    DISABLE = "disable"
    """Disable the Job. This is equivalent to calling the disable Job API, with a disableTasks value
    of requeue."""
    TERMINATE = "terminate"
    """Terminate the Job. The terminationReason in the Job's executionInfo is set to "TaskFailed"."""


class BatchJobPreparationTaskState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchJobPreparationTaskState enums."""

    RUNNING = "running"
    """The Task is currently running (including retrying)."""
    COMPLETED = "completed"
    """The Task has exited with exit code 0, or the Task has exhausted its retry limit, or the Batch
    service was unable to start the Task due to Task preparation errors (such as resource file
    download failures)."""


class BatchJobReleaseTaskState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchJobReleaseTaskState enums."""

    RUNNING = "running"
    """The Task is currently running (including retrying)."""
    COMPLETED = "completed"
    """The Task has exited with exit code 0, or the Task has exhausted its retry limit, or the Batch
    service was unable to start the Task due to Task preparation errors (such as resource file
    download failures)."""


class BatchJobScheduleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchJobScheduleState enums."""

    ACTIVE = "active"
    """The Job Schedule is active and will create Jobs as per its schedule."""
    COMPLETED = "completed"
    """The Job Schedule has terminated, either by reaching its end time or by the user terminating it
    explicitly."""
    DISABLED = "disabled"
    """The user has disabled the Job Schedule. The scheduler will not initiate any new Jobs will on
    this schedule, but any existing active Job will continue to run."""
    TERMINATING = "terminating"
    """The Job Schedule has no more work to do, or has been explicitly terminated by the user, but the
    termination operation is still in progress. The scheduler will not initiate any new Jobs for
    this Job Schedule, nor is any existing Job active."""
    DELETING = "deleting"
    """The user has requested that the Job Schedule be deleted, but the delete operation is still in
    progress. The scheduler will not initiate any new Jobs for this Job Schedule, and will delete
    any existing Jobs and Tasks under the Job Schedule, including any active Job. The Job Schedule
    will be deleted when all Jobs and Tasks under the Job Schedule have been deleted."""


class BatchJobState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchJobState enums."""

    ACTIVE = "active"
    """The Job is available to have Tasks scheduled."""
    DISABLING = "disabling"
    """A user has requested that the Job be disabled, but the disable operation is still in progress
    (for example, waiting for Tasks to terminate)."""
    DISABLED = "disabled"
    """A user has disabled the Job. No Tasks are running, and no new Tasks will be scheduled."""
    ENABLING = "enabling"
    """A user has requested that the Job be enabled, but the enable operation is still in progress."""
    TERMINATING = "terminating"
    """The Job is about to complete, either because a Job Manager Task has completed or because the
    user has terminated the Job, but the terminate operation is still in progress (for example,
    because Job Release Tasks are running)."""
    COMPLETED = "completed"
    """All Tasks have terminated, and the system will not accept any more Tasks or any further changes
    to the Job."""
    DELETING = "deleting"
    """A user has requested that the Job be deleted, but the delete operation is still in progress
    (for example, because the system is still terminating running Tasks)."""


class BatchNodeCommunicationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchNodeCommunicationMode enums."""

    DEFAULT = "default"
    """The node communication mode is automatically set by the Batch service."""
    CLASSIC = "classic"
    """Nodes using the classic communication mode require inbound TCP communication on ports 29876 and
    29877 from the "BatchNodeManagement.{region}" service tag and outbound TCP communication on
    port 443 to the "Storage.region" and "BatchNodeManagement.{region}" service tags."""
    SIMPLIFIED = "simplified"
    """Nodes using the simplified communication mode require outbound TCP communication on port 443 to
    the "BatchNodeManagement.{region}" service tag. No open inbound ports are required."""


class BatchNodeDeallocationOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchNodeDeallocationOption enums."""

    REQUEUE = "requeue"
    """Terminate running Task processes and requeue the Tasks. The Tasks will run again when a Compute
    Node is available. Remove Compute Nodes as soon as Tasks have been terminated."""
    TERMINATE = "terminate"
    """Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were
    terminated, and will not run again. Remove Compute Nodes as soon as Tasks have been terminated."""
    TASK_COMPLETION = "taskcompletion"
    """Allow currently running Tasks to complete. Schedule no new Tasks while waiting. Remove Compute
    Nodes when all Tasks have completed."""
    RETAINED_DATA = "retaineddata"
    """Allow currently running Tasks to complete, then wait for all Task data retention periods to
    expire. Schedule no new Tasks while waiting. Remove Compute Nodes when all Task retention
    periods have expired."""


class BatchNodeDisableSchedulingOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchNodeDisableSchedulingOption enums."""

    REQUEUE = "requeue"
    """Terminate running Task processes and requeue the Tasks. The Tasks may run again on other
    Compute Nodes, or when Task scheduling is re-enabled on this Compute Node. Enter offline state
    as soon as Tasks have been terminated."""
    TERMINATE = "terminate"
    """Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were
    terminated, and will not run again. Enter offline state as soon as Tasks have been terminated."""
    TASK_COMPLETION = "taskcompletion"
    """Allow currently running Tasks to complete. Schedule no new Tasks while waiting. Enter offline
    state when all Tasks have completed."""


class BatchNodeFillType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchNodeFillType enums."""

    SPREAD = "spread"
    """Tasks should be assigned evenly across all Compute Nodes in the Pool."""
    PACK = "pack"
    """As many Tasks as possible (taskSlotsPerNode) should be assigned to each Compute Node in the
    Pool before any Tasks are assigned to the next Compute Node in the Pool."""


class BatchNodePlacementPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchNodePlacementPolicyType enums."""

    REGIONAL = "regional"
    """All nodes in the pool will be allocated in the same region."""
    ZONAL = "zonal"
    """Nodes in the pool will be spread across different availability zones with best effort
    balancing."""


class BatchNodeRebootOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchNodeRebootOption enums."""

    REQUEUE = "requeue"
    """Terminate running Task processes and requeue the Tasks. The Tasks will run again when a Compute
    Node is available. Restart the Compute Node as soon as Tasks have been terminated."""
    TERMINATE = "terminate"
    """Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were
    terminated, and will not run again. Restart the Compute Node as soon as Tasks have been
    terminated."""
    TASK_COMPLETION = "taskcompletion"
    """Allow currently running Tasks to complete. Schedule no new Tasks while waiting. Restart the
    Compute Node when all Tasks have completed."""
    RETAINED_DATA = "retaineddata"
    """Allow currently running Tasks to complete, then wait for all Task data retention periods to
    expire. Schedule no new Tasks while waiting. Restart the Compute Node when all Task retention
    periods have expired."""


class BatchNodeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchNodeState enums."""

    IDLE = "idle"
    """The Compute Node is not currently running a Task."""
    REBOOTING = "rebooting"
    """The Compute Node is rebooting."""
    REIMAGING = "reimaging"
    """The Compute Node is reimaging."""
    RUNNING = "running"
    """The Compute Node is running one or more Tasks (other than a StartTask)."""
    UNUSABLE = "unusable"
    """The Compute Node cannot be used for Task execution due to errors."""
    CREATING = "creating"
    """The Batch service has obtained the underlying virtual machine from Azure Compute, but it has
    not yet started to join the Pool."""
    STARTING = "starting"
    """The Batch service is starting on the underlying virtual machine."""
    WAITING_FOR_START_TASK = "waitingforstarttask"
    """The StartTask has started running on the Compute Node, but waitForSuccess is set and the
    StartTask has not yet completed."""
    START_TASK_FAILED = "starttaskfailed"
    """The StartTask has failed on the Compute Node (and exhausted all retries), and waitForSuccess is
    set. The Compute Node is not usable for running Tasks."""
    UNKNOWN = "unknown"
    """The Batch service has lost contact with the Compute Node, and does not know its true state."""
    LEAVING_POOL = "leavingpool"
    """The Compute Node is leaving the Pool, either because the user explicitly removed it or because
    the Pool is resizing or autoscaling down."""
    OFFLINE = "offline"
    """The Compute Node is not currently running a Task, and scheduling of new Tasks to the Compute
    Node is disabled."""
    PREEMPTED = "preempted"
    """The Spot/Low-priority Compute Node has been preempted. Tasks which were running on the Compute
    Node when it was preempted will be rescheduled when another Compute Node becomes available."""
    UPGRADING_O_S = "upgradingos"
    """The Compute Node is undergoing an OS upgrade operation."""


class BatchPoolIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchPoolIdentityType enums."""

    USER_ASSIGNED = "UserAssigned"
    """Batch pool has user assigned identities with it."""
    NONE = "None"
    """Batch pool has no identity associated with it. Setting ``None`` in update pool will remove
    existing identities."""


class BatchPoolLifetimeOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchPoolLifetimeOption enums."""

    JOB_SCHEDULE = "jobschedule"
    """The Pool exists for the lifetime of the Job Schedule. The Batch Service creates the Pool when
    it creates the first Job on the schedule. You may apply this option only to Job Schedules, not
    to Jobs."""
    JOB = "job"
    """The Pool exists for the lifetime of the Job to which it is dedicated. The Batch service creates
    the Pool when it creates the Job. If the 'job' option is applied to a Job Schedule, the Batch
    service creates a new auto Pool for every Job created on the schedule."""


class BatchPoolState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchPoolState enums."""

    ACTIVE = "active"
    """The Pool is available to run Tasks subject to the availability of Compute Nodes."""
    DELETING = "deleting"
    """The user has requested that the Pool be deleted, but the delete operation has not yet
    completed."""


class BatchStartTaskState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchStartTaskState enums."""

    RUNNING = "running"
    """The StartTask is currently running."""
    COMPLETED = "completed"
    """The StartTask has exited with exit code 0, or the StartTask has failed and the retry limit has
    reached, or the StartTask process did not run due to Task preparation errors (such as resource
    file download failures)."""


class BatchSubtaskState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchSubtaskState enums."""

    PREPARING = "preparing"
    """The Task has been assigned to a Compute Node, but is waiting for a required Job Preparation
    Task to complete on the Compute Node. If the Job Preparation Task succeeds, the Task will move
    to running. If the Job Preparation Task fails, the Task will return to active and will be
    eligible to be assigned to a different Compute Node."""
    RUNNING = "running"
    """The Task is running on a Compute Node. This includes task-level preparation such as downloading
    resource files or deploying Packages specified on the Task - it does not necessarily mean that
    the Task command line has started executing."""
    COMPLETED = "completed"
    """The Task is no longer eligible to run, usually because the Task has finished successfully, or
    the Task has finished unsuccessfully and has exhausted its retry limit. A Task is also marked
    as completed if an error occurred launching the Task, or when the Task has been terminated."""


class BatchTaskAddStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchTaskAddStatus enums."""

    SUCCESS = "success"
    """The Task was added successfully."""
    CLIENT_ERROR = "clienterror"
    """The Task failed to add due to a client error and should not be retried without modifying the
    request as appropriate."""
    SERVER_ERROR = "servererror"
    """Task failed to add due to a server error and can be retried without modification."""


class BatchTaskExecutionResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchTaskExecutionResult enums."""

    SUCCESS = "success"
    """The Task ran successfully."""
    FAILURE = "failure"
    """There was an error during processing of the Task. The failure may have occurred before the Task
    process was launched, while the Task process was executing, or after the Task process exited."""


class BatchTaskState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BatchTaskState enums."""

    ACTIVE = "active"
    """The Task is queued and able to run, but is not currently assigned to a Compute Node. A Task
    enters this state when it is created, when it is enabled after being disabled, or when it is
    awaiting a retry after a failed run."""
    PREPARING = "preparing"
    """The Task has been assigned to a Compute Node, but is waiting for a required Job Preparation
    Task to complete on the Compute Node. If the Job Preparation Task succeeds, the Task will move
    to running. If the Job Preparation Task fails, the Task will return to active and will be
    eligible to be assigned to a different Compute Node."""
    RUNNING = "running"
    """The Task is running on a Compute Node. This includes task-level preparation such as downloading
    resource files or deploying Packages specified on the Task - it does not necessarily mean that
    the Task command line has started executing."""
    COMPLETED = "completed"
    """The Task is no longer eligible to run, usually because the Task has finished successfully, or
    the Task has finished unsuccessfully and has exhausted its retry limit. A Task is also marked
    as completed if an error occurred launching the Task, or when the Task has been terminated."""


class CachingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CachingType enums."""

    NONE = "none"
    """The caching mode for the disk is not enabled."""
    READ_ONLY = "readonly"
    """The caching mode for the disk is read only."""
    READ_WRITE = "readwrite"
    """The caching mode for the disk is read and write."""


class ContainerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ContainerType enums."""

    DOCKER_COMPATIBLE = "dockerCompatible"
    """A Docker compatible container technology will be used to launch the containers."""
    CRI_COMPATIBLE = "criCompatible"
    """A CRI based technology will be used to launch the containers."""


class ContainerWorkingDirectory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ContainerWorkingDirectory enums."""

    TASK_WORKING_DIRECTORY = "taskWorkingDirectory"
    """Use the standard Batch service Task working directory, which will contain the Task Resource
    Files populated by Batch."""
    CONTAINER_IMAGE_DEFAULT = "containerImageDefault"
    """Use the working directory defined in the container Image. Beware that this directory will not
    contain the Resource Files downloaded by Batch."""


class DependencyAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DependencyAction enums."""

    SATISFY = "satisfy"
    """Satisfy tasks waiting on this task; once all dependencies are satisfied, the task will be
    scheduled to run."""
    BLOCK = "block"
    """Blocks tasks waiting on this task, preventing them from being scheduled."""


class DiffDiskPlacement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessDiffDiskPlacementScope enums."""

    CACHE_DISK = "cachedisk"
    """The Ephemeral OS Disk is stored on the VM cache."""


class DisableBatchJobOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DisableBatchJobOption enums."""

    REQUEUE = "requeue"
    """Terminate running Tasks and requeue them. The Tasks will run again when the Job is enabled."""
    TERMINATE = "terminate"
    """Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were
    terminated, and will not run again."""
    WAIT = "wait"
    """Allow currently running Tasks to complete."""


class DiskEncryptionTarget(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DiskEncryptionTarget enums."""

    OS_DISK = "osdisk"
    """The OS Disk on the compute node is encrypted."""
    TEMPORARY_DISK = "temporarydisk"
    """The temporary disk on the compute node is encrypted. On Linux this encryption applies to other
    partitions (such as those on mounted data disks) when encryption occurs at boot time."""


class DynamicVNetAssignmentScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DynamicVNetAssignmentScope enums."""

    NONE = "none"
    """No dynamic VNet assignment is enabled."""
    JOB = "job"
    """Dynamic VNet assignment is done per-job."""


class ElevationLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ElevationLevel enums."""

    NON_ADMIN = "nonadmin"
    """The user is a standard user without elevated access."""
    ADMIN = "admin"
    """The user is a user with elevated access and operates with full Administrator permissions."""


class ErrorCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ErrorCategory enums."""

    USER_ERROR = "usererror"
    """The error is due to a user issue, such as misconfiguration."""
    SERVER_ERROR = "servererror"
    """The error is due to an internal server issue."""


class ImageVerificationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ImageVerificationType enums."""

    VERIFIED = "verified"
    """The Image is guaranteed to be compatible with the associated Compute Node agent SKU and all
    Batch features have been confirmed to work as expected."""
    UNVERIFIED = "unverified"
    """The associated Compute Node agent SKU should have binary compatibility with the Image, but
    specific functionality has not been verified."""


class InboundEndpointProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """InboundEndpointProtocol enums."""

    TCP = "tcp"
    """Use TCP for the endpoint."""
    UDP = "udp"
    """Use UDP for the endpoint."""


class IpAddressProvisioningType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IPAddressProvisioningType enums."""

    BATCH_MANAGED = "batchmanaged"
    """A public IP will be created and managed by Batch. There may be multiple public IPs depending on
    the size of the Pool."""
    USER_MANAGED = "usermanaged"
    """Public IPs are provided by the user and will be used to provision the Compute Nodes."""
    NO_PUBLIC_IP_ADDRESSES = "nopublicipaddresses"
    """No public IP Address will be created."""


class LoginMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LoginMode enums."""

    BATCH = "batch"
    """The LOGON32_LOGON_BATCH Win32 login mode. The batch login mode is recommended for long running
    parallel processes."""
    INTERACTIVE = "interactive"
    """The LOGON32_LOGON_INTERACTIVE Win32 login mode. UAC is enabled on Windows
    VirtualMachineConfiguration Pools. If this option is used with an elevated user identity in a
    Windows VirtualMachineConfiguration Pool, the user session will not be elevated unless the
    application executed by the Task command line is configured to always require administrative
    privilege or to always require maximum privilege."""


class NetworkSecurityGroupRuleAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NetworkSecurityGroupRuleAccess enums."""

    ALLOW = "allow"
    """Allow access."""
    DENY = "deny"
    """Deny access."""


class OnAllBatchTasksComplete(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action the Batch service should take when all Tasks in the Job are in the completed state."""

    NO_ACTION = "noaction"
    """Do nothing. The Job remains active unless terminated or disabled by some other means."""
    TERMINATE_JOB = "terminatejob"
    """Terminate the Job. The Job's terminationReason is set to 'AllTasksComplete'."""


class OnBatchTaskFailure(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OnTaskFailure enums."""

    NO_ACTION = "noaction"
    """Do nothing. The Job remains active unless terminated or disabled by some other means."""
    PERFORM_EXIT_OPTIONS_JOB_ACTION = "performexitoptionsjobaction"
    """Terminate the Job. The Job's terminationReason is set to 'AllTasksComplete'."""


class OSType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OSType enums."""

    LINUX = "linux"
    """The Linux operating system."""
    WINDOWS = "windows"
    """The Windows operating system."""


class OutputFileUploadCondition(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OutputFileUploadCondition enums."""

    TASK_SUCCESS = "tasksuccess"
    """Upload the file(s) only after the Task process exits with an exit code of 0."""
    TASK_FAILURE = "taskfailure"
    """Upload the file(s) only after the Task process exits with a nonzero exit code."""
    TASK_COMPLETION = "taskcompletion"
    """Upload the file(s) after the Task process exits, no matter what the exit code was."""


class SchedulingState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SchedulingState enums."""

    ENABLED = "enabled"
    """Tasks can be scheduled on the Compute Node."""
    DISABLED = "disabled"
    """No new Tasks will be scheduled on the Compute Node. Tasks already running on the Compute Node
    may still run to completion. All Compute Nodes start with scheduling enabled."""


class SecurityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the SecurityType of the virtual machine. It has to be set to any specified value to
    enable UefiSettings.
    """

    TRUSTED_LAUNCH = "trustedLaunch"
    """Trusted launch protects against advanced and persistent attack techniques."""


class StatusLevelTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Level code."""

    ERROR = "Error"
    """Error"""
    INFO = "Info"
    """Info"""
    WARNING = "Warning"
    """Warning"""


class StorageAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """StorageAccountType enums."""

    STANDARD_L_R_S = "standard_lrs"
    """The data disk should use standard locally redundant storage."""
    PREMIUM_L_R_S = "premium_lrs"
    """The data disk should use premium locally redundant storage."""
    STANDARD_S_S_D_L_R_S = "standardssd_lrs"
    """The data disk / OS disk should use standard SSD locally redundant storage."""


class UpgradeMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UpgradeMode enums."""

    AUTOMATIC = "automatic"
    """TAll virtual machines in the scale set are automatically updated at the same time."""
    MANUAL = "manual"
    """You control the application of updates to virtual machines in the scale set. You do this by
    using the manualUpgrade action."""
    ROLLING = "rolling"
    """The existing instances in a scale set are brought down in batches to be upgraded. Once the
    upgraded batch is complete, the instances will begin taking traffic again and the next batch
    will begin. This continues until all instances brought up-to-date."""
