﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrations_EXPORTS.h>
#include <aws/iot-managed-integrations/model/CapabilityReport.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTManagedIntegrations {
namespace Model {
class GetManagedThingCapabilitiesResult {
 public:
  AWS_IOTMANAGEDINTEGRATIONS_API GetManagedThingCapabilitiesResult() = default;
  AWS_IOTMANAGEDINTEGRATIONS_API GetManagedThingCapabilitiesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTMANAGEDINTEGRATIONS_API GetManagedThingCapabilitiesResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The id of the device.</p>
   */
  inline const Aws::String& GetManagedThingId() const { return m_managedThingId; }
  template <typename ManagedThingIdT = Aws::String>
  void SetManagedThingId(ManagedThingIdT&& value) {
    m_managedThingIdHasBeenSet = true;
    m_managedThingId = std::forward<ManagedThingIdT>(value);
  }
  template <typename ManagedThingIdT = Aws::String>
  GetManagedThingCapabilitiesResult& WithManagedThingId(ManagedThingIdT&& value) {
    SetManagedThingId(std::forward<ManagedThingIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The capabilities of the device such as light bulb.</p>
   */
  inline const Aws::String& GetCapabilities() const { return m_capabilities; }
  template <typename CapabilitiesT = Aws::String>
  void SetCapabilities(CapabilitiesT&& value) {
    m_capabilitiesHasBeenSet = true;
    m_capabilities = std::forward<CapabilitiesT>(value);
  }
  template <typename CapabilitiesT = Aws::String>
  GetManagedThingCapabilitiesResult& WithCapabilities(CapabilitiesT&& value) {
    SetCapabilities(std::forward<CapabilitiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A report of the capabilities for the managed thing.</p>
   */
  inline const CapabilityReport& GetCapabilityReport() const { return m_capabilityReport; }
  template <typename CapabilityReportT = CapabilityReport>
  void SetCapabilityReport(CapabilityReportT&& value) {
    m_capabilityReportHasBeenSet = true;
    m_capabilityReport = std::forward<CapabilityReportT>(value);
  }
  template <typename CapabilityReportT = CapabilityReport>
  GetManagedThingCapabilitiesResult& WithCapabilityReport(CapabilityReportT&& value) {
    SetCapabilityReport(std::forward<CapabilityReportT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetManagedThingCapabilitiesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_managedThingId;

  Aws::String m_capabilities;

  CapabilityReport m_capabilityReport;

  Aws::String m_requestId;
  bool m_managedThingIdHasBeenSet = false;
  bool m_capabilitiesHasBeenSet = false;
  bool m_capabilityReportHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTManagedIntegrations
}  // namespace Aws
