/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.DisjunctIndex;
import ai.grazie.rules.tree.HeadRelations;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodeMatcher;
import ai.grazie.rules.tree.OrCondition;
import ai.grazie.rules.tree.PatternHint;
import ai.grazie.rules.tree.PosMatcher;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.util.regex.Regex;
import ai.grazie.rules.util.regex.RegexMatcher;
import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class NodePattern
implements NodeMatcher {
    public static final NodePattern N = new NodePattern(0, new NodeMatcher[0], PatternHint.ALLOW_ANYTHING, () -> "N", null);
    public static final NodePattern ROOT = N.withHeadRelation("root");
    public static final NodePattern PUNCT = N.withHeadRelation("punct");
    private static final int MAX_FORM_POSSIBLE_VALUES = 1000;
    private static final int MAX_FORM_POSSIBLE_SUBSTRINGS = 200;
    @ApiStatus.Internal
    public static final String TRACE_PREVENTION_PREFIX = "trace ";
    @ApiStatus.Internal
    public static final String CRAZY_PARSE_PREVENTION_PREFIX = "crazy-parse ";
    private final int flags;
    private final NodeMatcher[] conditions;
    private final Supplier<String> toString;
    @Nullable
    private final String formRegex;
    @ApiStatus.Internal
    public final PatternHint hint;
    private static final Pattern msgInjection = Pattern.compile("\\$([\\w_]+)");
    @VisibleForTesting
    public static BiFunction<String, NodePattern, NodeMatcher> costCenterTransform = (__, pattern) -> pattern;

    public String toString() {
        return this.toString.get();
    }

    private NodePattern(int flags, NodeMatcher[] conditions, PatternHint hint, Supplier<String> toString, @Nullable String formRegex) {
        this.flags = flags;
        this.conditions = conditions;
        this.hint = hint;
        this.toString = toString;
        this.formRegex = formRegex;
    }

    @NotNull
    public String getFormRegex() {
        if (this.formRegex == null) {
            throw new UnsupportedOperationException("No form was specified");
        }
        return this.formRegex;
    }

    public boolean matches(@Nullable Node node) {
        return node != null && this.match(node, NodeMatch.EMPTY_NO_TOUCHING) != null;
    }

    @Nullable
    public NodeMatch match(@NotNull Node node) {
        return this.match(node, NodeMatch.EMPTY);
    }

    public NodeMatch match(@NotNull Node node, @NotNull NodeMatch match) {
        NodeMatch result = this.matchWithPrevention(node, match);
        return NodeMatch.isVisible(result) ? result : null;
    }

    @Override
    @Nullable
    public NodeMatch matchWithPrevention(Node node, NodeMatch match) {
        NodeMatch result = this.matchNoTouch(node, match);
        return result == null ? null : result.withTouchedNode(node).withAnchor(node);
    }

    @Nullable
    NodeMatch matchNoTouch(Node node, NodeMatch match) {
        if (this.flags != 0 && (this.flags & node.flags()) != this.flags) {
            return null;
        }
        for (NodeMatcher condition : this.conditions) {
            if (NodeMatch.isVisible(match = condition.matchWithPrevention(node, match))) continue;
            return match;
        }
        return match;
    }

    public static NodePattern markedNodeMatches(String id, NodePattern pattern) {
        return NodePattern.custom((Node node, NodeMatch match) -> {
            Node marked = match.findMarkedNode(id);
            return marked == null ? null : pattern.matchNoTouch(marked, match);
        }).withHint(PatternHint.ALLOW_ANYTHING.withAnotherNode(pattern.hint));
    }

    public static NodePattern custom(Predicate<Node> condition) {
        return N.with(() -> "custom(" + String.valueOf(condition) + ")", (node, match) -> condition.test(node) ? match : null);
    }

    public static NodePattern custom(NodeMatcher matcher) {
        if (matcher instanceof NodePattern) {
            throw new AssertionError((Object)"Excessive custom()");
        }
        return N.with(() -> "custom(" + String.valueOf(matcher) + ")", (node, match) -> matcher.matchWithPrevention(node, match.withAnchor(node)));
    }

    private NodePattern with(Supplier<String> toString, NodeMatcher matcher) {
        return new NodePattern(this.flags, this.appendCondition(matcher), this.hint, this.appendToString(toString), this.formRegex);
    }

    private NodePattern withFlag(int flag, String toString) {
        return new NodePattern(this.flags | flag, this.conditions, this.hint, this.appendToString(() -> toString), this.formRegex);
    }

    private Supplier<String> appendToString(Supplier<String> toString) {
        Supplier<String> prevToString = this.toString;
        return () -> (String)prevToString.get() + "." + (String)toString.get();
    }

    private NodePattern withHint(@NotNull PatternHint hint) {
        return new NodePattern(this.flags, this.conditions, hint, this.toString, this.formRegex);
    }

    private NodeMatcher[] appendCondition(NodeMatcher matcher) {
        NodeMatcher[] newConditions = new NodeMatcher[this.conditions.length + 1];
        System.arraycopy(this.conditions, 0, newConditions, 0, this.conditions.length);
        newConditions[this.conditions.length] = matcher;
        return newConditions;
    }

    public NodePattern potentialPos(@Language(value="RegExp") String regex) {
        return this.with(() -> "withPotentialPos(\"" + regex + "\")", PosMatcher.create(regex, true));
    }

    public NodePattern potentialLemma(@Language(value="RegExp") String regex) {
        RegexMatcher matcher = Regex.parse(regex).caseSensitiveMatcher();
        return this.with(() -> "potentialLemma(\"" + regex + "\")", (node, match) -> NodePattern.anyMatch(matcher, node.tagIndependently().lemmaReadings()) ? match : null);
    }

    public NodePattern noPos(@Language(value="RegExp") String regex) {
        return regex.equals(".*") ? this.withFlag(128, "noPos()") : this.andNot(N.pos(regex));
    }

    public NodePattern noPos() {
        return this.noPos(".*");
    }

    public NodePattern noPotentialPos(@Language(value="RegExp") String regex) {
        return this.andNot(N.potentialPos(regex));
    }

    public NodePattern anyPos() {
        return this.pos(".*");
    }

    public NodePattern pos(@Language(value="RegExp") String regex) {
        if (regex.equals(".*")) {
            return this.withFlag(64, "pos()");
        }
        return this.with(() -> "pos(\"" + regex + "\")", PosMatcher.create(regex, false));
    }

    private static boolean anyMatch(RegexMatcher matcher, List<String> readings) {
        for (int i = 0; i < readings.size(); ++i) {
            if (!matcher.matches(readings.get(i))) continue;
            return true;
        }
        return false;
    }

    public NodePattern onlyPos(@Language(value="RegExp") String regex) {
        RegexMatcher matcher = Regex.parse(regex).caseSensitiveMatcher();
        return this.pos(regex).and((Node n) -> n.tokenReadings().stream().noneMatch(r -> r.pos() == null || !matcher.matches(r.pos())));
    }

    public NodePattern label(@Language(value="RegExp") String regex) {
        RegexMatcher matcher = Regex.parse(regex).caseSensitiveMatcher();
        return this.with(() -> "label(\"" + regex + "\")", (node, match) -> {
            SentenceWithNERAnnotations.Annotation.Label label = node.nerLabel();
            return label != null && matcher.matches(label.toString()) ? match : null;
        });
    }

    public NodePattern noLabel(@Language(value="RegExp") String regex) {
        RegexMatcher matcher = Regex.parse(regex).caseSensitiveMatcher();
        return this.with(() -> "noLabel(\"" + regex + "\")", (node, match) -> {
            SentenceWithNERAnnotations.Annotation.Label label = node.nerLabel();
            return label == null || !matcher.matches(label.toString()) ? match : null;
        });
    }

    public NodePattern sameWordAs(String id) {
        Supplier<String> toString = () -> "sameFormAs(\"" + id + "\")";
        return this.with(toString, (cc, match) -> {
            String marked = NodePattern.getMarkedNode(id, match, toString).form();
            return cc.form().equalsIgnoreCase(marked) ? match : null;
        });
    }

    public NodePattern sameWordAs(int indexDelta) {
        assert (indexDelta != 0);
        return this.with(() -> "sameFormAs(\"" + indexDelta + "\")", (node, match) -> {
            int index = node.index + indexDelta;
            if (index < 0 || index >= node.tree().nodes().size()) {
                return null;
            }
            Node neighbor = node.neighbor(indexDelta);
            return node.form().equalsIgnoreCase(neighbor.form()) ? match.withTouchedNode(neighbor) : null;
        });
    }

    public NodePattern form(Set<String> forms) {
        List<String> nonLowerCase = forms.stream().filter(f -> !f.toLowerCase(Locale.ROOT).equals(f)).toList();
        assert (nonLowerCase.isEmpty()) : "Expected lowercase forms, but found " + String.valueOf(nonLowerCase);
        return this.with(() -> "form(" + String.valueOf(forms) + ")", (node, match) -> forms.contains(node.lowForm()) ? match : null).withHint(this.hint.withNodeForms(forms));
    }

    public NodePattern formSuffix(@Language(value="RegExp") String regex) {
        Set<String> suffixes = Regex.parse(regex).possibleValues();
        assert (suffixes != null) : "Couldn't enumerate the possible values from: " + regex;
        assert (StreamEx.of(suffixes).allMatch(f -> f.toLowerCase(Locale.ROOT).equals(f)));
        return this.formSuffix(suffixes);
    }

    private NodePattern formSuffix(Set<String> suffixes) {
        NodeMatcher matcher;
        if (suffixes.size() == 1) {
            String suffix = suffixes.iterator().next();
            matcher = (node, match) -> node.lowForm().endsWith(suffix) ? match : null;
        } else {
            int maxLength = StreamEx.of(suffixes).mapToInt(s -> s.length()).max().orElseThrow();
            int minLength = StreamEx.of(suffixes).mapToInt(s -> s.length()).min().orElseThrow();
            matcher = (node, match) -> {
                String form = node.lowForm();
                for (int i = Math.max(0, form.length() - maxLength); i <= form.length() - minLength; ++i) {
                    if (!suffixes.contains(form.substring(i))) continue;
                    return match;
                }
                return null;
            };
        }
        return this.with(() -> "formSuffix(" + String.join((CharSequence)",", suffixes) + ")", matcher).withHint(this.hint.withNodeSubstrings(suffixes.toArray(new String[0])));
    }

    public NodePattern form(@Language(value="RegExp") String regex) {
        Set<String> values;
        NodePattern.checkRegexpSanity(regex);
        if (regex.startsWith(".*") && (values = Regex.parse(regex.substring(2)).possibleValues(1000)) != null && values.stream().allMatch(s -> s.equals(s.toLowerCase(Locale.ROOT)))) {
            return this.formSuffix(values).withFormRegex(regex);
        }
        Regex parsed = Regex.parse(regex);
        RegexMatcher matcher = RegexMatcher.create(parsed, false, 1000);
        Predicate<Node> predicate = NodePattern.ciPredicate(matcher);
        return this.with(() -> "form(\"" + regex + "\")", (node, match) -> predicate.test(node) ? match : null).withHint(this.formHint(parsed, matcher)).withFormRegex(regex);
    }

    private PatternHint formHint(Regex parsed, RegexMatcher matcher) {
        Set<String> possibleValues = matcher.possibleValues();
        if (possibleValues != null) {
            return this.hint.withNodeForms(possibleValues);
        }
        Set<String> substrings = parsed.possibleSubstrings(200);
        if (substrings == null || substrings.stream().anyMatch(s -> s.length() == 1 && Character.isLetter(s.charAt(0)))) {
            return this.hint;
        }
        return this.hint.withNodeSubstrings((String[])substrings.stream().map(s -> s.toLowerCase(Locale.ROOT)).toArray(String[]::new));
    }

    public NodePattern noForm(@Language(value="RegExp") String regex) {
        return this.andNot(N.form(regex));
    }

    private static void checkRegexpSanity(@Language(value="RegExp") String regex) {
        if (".*".equals(regex) || ".+".equals(regex)) {
            throw new IllegalArgumentException("A useless form regex " + regex + " that accepts everything");
        }
        char first = regex.charAt(0);
        if (regex.contains("\\p{Lu}") || first > 'z' && Character.isUpperCase(first)) {
            throw new IllegalArgumentException("The pattern contains Unicode uppercase expectations, it may match unexpectedly on some Java versions.Did you mean to call *FormCaseSensitive(\"" + regex + "\")?");
        }
    }

    public NodePattern formCaseSensitive(@Language(value="RegExp") String regex) {
        Regex parsed = Regex.parse(regex);
        RegexMatcher matcher = RegexMatcher.create(parsed, true, 1000);
        return this.with(() -> "formCaseSensitive(\"" + regex + "\")", (node, match) -> matcher.matches(node.form()) ? match : null).withHint(this.formHint(parsed, matcher)).withFormRegex(regex);
    }

    private NodePattern withFormRegex(String formRegex) {
        if (this.formRegex != null) {
            return this;
        }
        return new NodePattern(this.flags, this.conditions, this.hint, this.toString, formRegex);
    }

    public NodePattern noFormCaseSensitive(@Language(value="RegExp") String regex) {
        return this.andNot(N.formCaseSensitive(regex));
    }

    public NodePattern lemma(Set<String> lemmas) {
        return this.with(() -> "lemma(" + String.valueOf(lemmas) + ")", (node, match) -> node.lemmaReadings().stream().anyMatch(lemmas::contains) ? match : null).withHint(this.hint.withNodeLemmas(lemmas));
    }

    public NodePattern lemma(@Language(value="RegExp") String regex) {
        Regex parsed = Regex.parse(regex);
        RegexMatcher matcher = parsed.caseInsensitiveMatcher();
        return this.with(() -> "lemma(\"" + regex + "\")", (node, match) -> NodePattern.anyMatch(matcher, node.lemmaReadings()) ? match : null).withHint(this.hint.withNodeLemmas(matcher.possibleValues()));
    }

    public NodePattern lemmaCaseSensitive(@Language(value="RegExp") String regex) {
        Regex parsed = Regex.parse(regex);
        RegexMatcher matcher = parsed.caseSensitiveMatcher();
        return this.with(() -> "lemmaCaseSensitive(\"" + regex + "\")", (node, match) -> NodePattern.anyMatch(matcher, node.lemmaReadings()) ? match : null).withHint(this.hint.withNodeLemmas(matcher.possibleValues()));
    }

    public NodePattern noLemma(@Language(value="RegExp") String regex) {
        return this.andNot(N.lemma(regex));
    }

    public NodePattern noLemmaCaseSensitive(@Language(value="RegExp") String regex) {
        return this.andNot(N.lemmaCaseSensitive(regex));
    }

    @NotNull
    private static Predicate<Node> ciPredicate(RegexMatcher matcher) {
        Set<String> possibleValues = matcher.possibleValues();
        if (possibleValues != null) {
            if (possibleValues.size() == 1) {
                String single = possibleValues.iterator().next().toLowerCase(Locale.ROOT);
                return n -> n.lowForm().equals(single);
            }
            Set lowSet = (Set)StreamEx.of(possibleValues).map(s -> s.toLowerCase(Locale.ROOT)).toCollection(ObjectOpenHashSet::new);
            return n -> lowSet.contains(n.lowForm());
        }
        return n -> matcher.matches(n.form());
    }

    public NodePattern includeIntoReport() {
        return this.includeIntoReport(ReportingKind.Always);
    }

    public NodePattern includeIntoReport(ReportingKind kind) {
        return this.with(() -> "includeIntoReport()", (node, match) -> match.withReportedNode(node, kind));
    }

    public NodePattern reportRangeTo(String id) {
        return this.reportRangeTo(id, ReportingKind.Always);
    }

    public NodePattern reportRangeTo(String id, ReportingKind kind) {
        Supplier<String> toString = () -> "reportRangeTo(" + id + ")";
        return this.with(toString, (node, match) -> {
            Node n2 = NodePattern.getMarkedNode(id, match, toString);
            Tree tree = node.tree();
            assert (n2.tree() == tree);
            TextRange range = new TextRange((node.isBefore(n2) ? node : n2).startOffset(), (node.isBefore(n2) ? n2 : node).endOffset());
            return match.withReportedRange(range, tree, kind);
        });
    }

    private static Node getMarkedNode(String id, NodeMatch match, Supplier<String> source) {
        Node node = match.findMarkedNode(id);
        if (node == null) {
            throw new NullPointerException("Cannot find node marked " + id + " in " + source.get());
        }
        return node;
    }

    public NodePattern withHeadRelation(@Language(value="RegExp") String relations) {
        HeadRelations.Matcher matcher = HeadRelations.matcher(relations);
        PatternHint hint = this.hint.withHeadRelations(matcher.possibleRelations);
        if (relations.equals("root")) {
            return this.withFlag(1, "ROOT").withHint(hint);
        }
        if (relations.equals("punct")) {
            return this.withFlag(2, "PUNCT").withHint(hint);
        }
        return this.with(() -> "withHeadRelation(\"" + relations + "\")", (node, match) -> matcher.matches(node) ? match : null).withHint(hint);
    }

    public NodePattern noHeadRelation(@Language(value="RegExp") String relations) {
        return this.andNot(N.withHeadRelation(relations));
    }

    public NodePattern withHead(@Language(value="RegExp") String relations, NodePattern headPattern) {
        return this.withHeadRelation(relations).withHead(headPattern);
    }

    public NodePattern withHead(NodePattern headPattern) {
        return this.with(() -> "withHead(...)", (node, context) -> {
            Node head = node.head();
            return head == null ? null : headPattern.matchWithPrevention(head, context);
        }).withHint(this.hint.withAnotherNode(headPattern.hint));
    }

    public NodePattern withOptionalDependent(@NotNull @Language(value="RegExp") String relations, @NotNull NodePattern depPattern) {
        return this.and(NodePattern.or(N.withDependent(relations, depPattern), N));
    }

    public NodePattern withDependent(@NotNull @Language(value="RegExp") String relations) {
        return this.withDependent(relations, N);
    }

    public NodePattern withDependent(@NotNull @Language(value="RegExp") String relations, @NotNull NodePattern depPattern) {
        HeadRelations.Matcher matcher = HeadRelations.matcher(relations);
        return new NodePattern(this.flags | 8, this.appendCondition((node, match) -> {
            List<Node> dependents = node.dependents;
            String preventedBy = null;
            for (int i = 0; i < dependents.size(); ++i) {
                NodeMatch eachMatch;
                Node dep = dependents.get(i);
                if (!matcher.matches(dep) || (eachMatch = depPattern.matchWithPrevention(dep, match)) == null) continue;
                if (eachMatch.preventedBy == null) {
                    return eachMatch;
                }
                preventedBy = NodeMatch.appendPrevention(preventedBy, eachMatch);
            }
            return preventedBy == null ? null : match.preventedBy(preventedBy);
        }), this.hint.withAnotherNode(depPattern.hint).withDependentRelations(matcher.possibleRelations), this.appendToString(() -> "withDependent(\"" + relations + "\", ...)"), this.formRegex);
    }

    public NodePattern noDependents() {
        return this.noDependents(".*");
    }

    public NodePattern noDependents(@NotNull @Language(value="RegExp") String relations) {
        return relations.equals(".*") ? this.withFlag(4, "noDependents()") : this.noDependents(relations, N);
    }

    public NodePattern noDependents(@NotNull NodePattern depPattern) {
        return this.with(() -> "noDependents(...)", (node, match) -> {
            List<Node> dependents = node.dependents;
            for (int i = 0; i < dependents.size(); ++i) {
                Node dep = dependents.get(i);
                NodeMatch depMatch = depPattern.matchNoTouch(dep, match);
                if (!NodeMatch.isVisible(depMatch)) continue;
                if (depMatch.traceLog.length() > match.traceLog.length()) {
                    return match.preventedBy(TRACE_PREVENTION_PREFIX + depMatch.traceLog);
                }
                return null;
            }
            return match;
        });
    }

    public NodePattern noDependents(@NotNull @Language(value="RegExp") String relations, @NotNull NodePattern depPattern) {
        HeadRelations.Matcher matcher = HeadRelations.matcher(relations);
        return this.with(() -> "noDependents(\"" + relations + "\", ...)", (node, match) -> {
            List<Node> dependents = node.dependents;
            for (int i = 0; i < dependents.size(); ++i) {
                NodeMatch depMatch;
                Node dep = dependents.get(i);
                if (!matcher.matches(dep) || !NodeMatch.isVisible(depMatch = depPattern.matchNoTouch(dep, match))) continue;
                if (depMatch.traceLog.length() > match.traceLog.length()) {
                    return match.preventedBy(TRACE_PREVENTION_PREFIX + depMatch.traceLog);
                }
                return null;
            }
            return match;
        });
    }

    public NodePattern withOnlyDependents(NodePattern pattern) {
        return this.noDependents(NodePattern.not(pattern));
    }

    public NodePattern withPhraseStart(@NotNull NodePattern startPattern) {
        return this.with(() -> "withPhraseStart(" + String.valueOf(startPattern) + ")", (node, match) -> startPattern.matchWithPrevention(node.phraseStart(), match)).withHint(this.hint.withAnotherNode(startPattern.hint));
    }

    public NodePattern withPhraseEnd(@NotNull NodePattern endPattern) {
        return this.with(() -> "withPhraseEnd(" + String.valueOf(endPattern) + ")", (node, match) -> endPattern.matchWithPrevention(node.phraseEnd(), match)).withHint(this.hint.withAnotherNode(endPattern.hint));
    }

    public NodePattern inPhrase(NodePattern headPattern) {
        return this.with(() -> "inPhrase(" + String.valueOf(headPattern) + ")", (node, match) -> NodePattern.matchAnyNode(headPattern, match, node.hierarchy())).withHint(this.hint.withAnotherNode(headPattern.hint));
    }

    @Nullable
    private static NodeMatch matchAnyNode(NodePattern pattern, NodeMatch match, Iterable<Node> nodes) {
        String preventedBy = null;
        for (Node each : nodes) {
            NodeMatch eachMatch = pattern.matchWithPrevention(each, match);
            if (eachMatch == null) continue;
            if (eachMatch.preventedBy == null) {
                return eachMatch;
            }
            preventedBy = NodeMatch.appendPrevention(preventedBy, eachMatch);
        }
        return preventedBy == null ? null : match.preventedBy(preventedBy);
    }

    public NodePattern markAs(@NotNull String id) {
        return this.with(() -> "markAs(\"" + id + "\")", (node, match) -> match.withMarkedNode(id, node));
    }

    public NodePattern unmark(@NotNull String id) {
        return this.with(() -> "unmark(\"" + id + "\")", (node, match) -> match.withMarkedNode(id, null));
    }

    public NodePattern alreadyMarkedAs(String mark) {
        return this.with(() -> "alreadyMarkedAs(\"" + mark + "\")", (node, match) -> node.equals(match.findMarkedNode(mark)) ? match : null);
    }

    public NodePattern correct(@NotNull NodeCorrector.Relative corrector) {
        return this.with(() -> "correct(...)", (node, match) -> match.withCorrector(corrector.eval(match.withAnchor(node))));
    }

    public NodePattern directlyBefore(@NotNull String id) {
        return this.directlyBefore(N.alreadyMarkedAs(id));
    }

    public NodePattern directlyBefore(NodePattern nextPattern) {
        return this.with(() -> "directlyBefore(" + String.valueOf(nextPattern) + ")", (node, match) -> {
            Node nextNode = node.nextNode();
            return nextNode == null ? null : nextPattern.matchWithPrevention(nextNode, match);
        }).withHint(this.hint.withAnotherNode(nextPattern.hint));
    }

    public NodePattern directlyAfter(@NotNull String id) {
        return this.directlyAfter(N.alreadyMarkedAs(id));
    }

    public NodePattern directlyAfter(NodePattern prevPattern) {
        return this.with(() -> "directlyAfter(" + String.valueOf(prevPattern) + ")", (node, match) -> {
            Node prevNode = node.prevNode();
            return prevNode == null ? null : prevPattern.matchWithPrevention(prevNode, match);
        }).withHint(this.hint.withAnotherNode(prevPattern.hint));
    }

    public NodePattern before(NodePattern pattern) {
        return this.with(() -> "before(" + String.valueOf(pattern) + ")", (node, match) -> NodePattern.matchAnyNode(pattern, match, (Iterable<Node>)node.forward().skip(1L))).withHint(this.hint.withAnotherNode(pattern.hint));
    }

    public NodePattern after(NodePattern pattern) {
        return this.with(() -> "after(" + String.valueOf(pattern) + ")", (node, match) -> NodePattern.matchAnyNode(pattern, match, (Iterable<Node>)node.back().skip(1L))).withHint(this.hint.withAnotherNode(pattern.hint));
    }

    public NodePattern inSentenceWith(NodePattern pattern) {
        return NodePattern.or(this.before(pattern), this.after(pattern));
    }

    public NodePattern before(@NotNull String id) {
        Supplier<String> toString = () -> "before(\"" + id + "\")";
        return this.with(toString, (node, match) -> node.isBefore(NodePattern.getMarkedNode(id, match, toString)) ? match : null);
    }

    public NodePattern directlyBeforeHead() {
        return this.withFlag(512, "directlyBeforeHead()");
    }

    public NodePattern beforeHead() {
        return this.withFlag(256, "beforeHead()");
    }

    public NodePattern directlyAfterHead() {
        return this.withFlag(2048, "directlyAfterHead()");
    }

    public NodePattern afterHead() {
        return this.withFlag(1024, "afterHead()");
    }

    public NodePattern after(@NotNull String id) {
        Supplier<String> toString = () -> "after(\"" + id + "\")";
        return this.with(toString, (node, match) -> NodePattern.getMarkedNode(id, match, toString).isBefore(node) ? match : null);
    }

    public NodePattern between(@NotNull String idBefore, @NotNull String idAfter) {
        return this.after(idBefore).before(idAfter);
    }

    public NodePattern andNot(@NotNull NodePattern not) {
        return this.with(() -> "andNot(" + String.valueOf(not) + ")", (node, match) -> {
            NodeMatch negMatch = not.matchNoTouch(node, match.withoutMessage());
            if (NodeMatch.isVisible(negMatch)) {
                if (negMatch.traceLog.length() > match.traceLog.length()) {
                    return match.preventedBy(TRACE_PREVENTION_PREFIX + negMatch.traceLog);
                }
                return null;
            }
            return match;
        });
    }

    public NodePattern andNot(Predicate<Node> predicate) {
        return this.andNot(NodePattern.custom(predicate));
    }

    public NodePattern message(@NotNull String message) {
        Supplier<String> toString = () -> "message(\"" + message + "\")";
        return this.with(toString, (node, match) -> {
            Matcher matcher;
            Object actual = message;
            int offset = 0;
            while ((matcher = msgInjection.matcher((CharSequence)actual)).find(offset)) {
                String id = matcher.group(1);
                Node toInsert = "_".equals(id) ? node : NodePattern.getMarkedNode(id, match, toString);
                actual = ((String)actual).substring(0, matcher.start()) + toInsert.presentableText() + ((String)actual).substring(matcher.end());
                offset = matcher.start() + toInsert.presentableText().length();
            }
            return match.withMessage((String)actual);
        });
    }

    public NodePattern inFlatTree() {
        return this.with(() -> "inFlatTree()", (node, match) -> node.tree().isFlat() ? match : null);
    }

    public NodePattern inCloudTree() {
        return this.andNot(N.inFlatTree());
    }

    public NodePattern spaceAfter() {
        return this.withFlag(8192, "spaceAfter()");
    }

    public NodePattern spaceBefore() {
        return this.withFlag(4096, "spaceBefore()");
    }

    public NodePattern spaceAround() {
        return this.spaceBefore().spaceAfter();
    }

    public NodePattern noSpaceAfter() {
        return this.withFlag(32768, "noSpaceAfter()");
    }

    public NodePattern noSpaceBefore() {
        return this.withFlag(16384, "noSpaceBefore()");
    }

    public NodePattern noSpaceAround() {
        return this.noSpaceBefore().noSpaceAfter();
    }

    public static NodePattern not(@NotNull NodePattern negated) {
        return N.andNot(negated);
    }

    @Deprecated
    public static NodePattern or(@NotNull NodePattern singleDisjunct) {
        return singleDisjunct;
    }

    public static NodePattern or(NodePattern ... disjuncts) {
        if (disjuncts.length == 1) {
            return disjuncts[0];
        }
        ArrayList<NodePattern> flatConditions = new ArrayList<NodePattern>();
        ArrayList<PatternHint> flatHints = new ArrayList<PatternHint>();
        for (NodePattern part : disjuncts) {
            NodeMatcher nodeMatcher;
            NodeMatcher[] conditions = part.conditions;
            if (part.flags == 0 && conditions.length == 1 && (nodeMatcher = conditions[0]) instanceof OrCondition) {
                OrCondition or = (OrCondition)nodeMatcher;
                Collections.addAll(flatConditions, or.disjuncts());
                for (DisjunctIndex index = or.index(); index != null; index = index.next()) {
                    flatHints.addAll(index.ownHints());
                }
                continue;
            }
            flatConditions.add(part);
            flatHints.add(part.hint);
        }
        int flags = -1;
        for (NodePattern condition : flatConditions) {
            flags &= condition.flags;
        }
        OrCondition condition = new OrCondition((NodePattern[])flatConditions.toArray(NodePattern[]::new), DisjunctIndex.build(flatHints));
        return new NodePattern(flags, new NodeMatcher[]{condition}, PatternHint.or(flatHints), () -> "or(" + StreamEx.of((Object[])disjuncts).map(p -> "\n  " + String.valueOf(p) + ",").joining() + "\n)", null);
    }

    @Deprecated
    public NodePattern andOr(NodePattern singleDisjunct) {
        return this.and(singleDisjunct);
    }

    public NodePattern andOr(NodePattern ... disjuncts) {
        return this.and(NodePattern.or(disjuncts));
    }

    public NodePattern andOptionally(NodePattern pattern) {
        return this.and(NodePattern.or(pattern, N));
    }

    public NodePattern and(NodeMatcher matcher) {
        return this.and(NodePattern.custom(matcher));
    }

    public NodePattern and(Predicate<Node> predicate) {
        return this.and(NodePattern.custom(predicate));
    }

    public NodePattern and(NodePattern pattern) {
        return new NodePattern(this.flags | pattern.flags, this.appendConditions(pattern.conditions), this.hint.and(pattern.hint), this.appendToString(() -> "and(" + String.valueOf(pattern) + ")"), this.formRegex == null ? pattern.formRegex : this.formRegex);
    }

    private NodeMatcher[] appendConditions(NodeMatcher[] appended) {
        NodeMatcher[] newConditions = new NodeMatcher[this.conditions.length + appended.length];
        System.arraycopy(this.conditions, 0, newConditions, 0, this.conditions.length);
        System.arraycopy(appended, 0, newConditions, this.conditions.length, appended.length);
        return newConditions;
    }

    public NodePattern withPrevSibling(NodePattern pattern) {
        return this.with(() -> "withPrevSibling(" + String.valueOf(pattern) + ")", (node, match) -> {
            Node prev = node.prevSibling();
            return prev == null ? null : pattern.matchWithPrevention(prev, match);
        }).withHint(this.hint.withAnotherNode(pattern.hint));
    }

    public NodePattern withPrevSiblingIncludingOtherSide(NodePattern pattern) {
        return this.with(() -> "withPrevSiblingIncludingOtherSide(" + String.valueOf(pattern) + ")", (node, match) -> {
            Node prev = node.prevSiblingIncludingOtherSide();
            return prev == null ? null : pattern.matchWithPrevention(prev, match);
        }).withHint(this.hint.withAnotherNode(pattern.hint));
    }

    public NodePattern withNextSibling(NodePattern pattern) {
        return this.with(() -> "withNextSibling(" + String.valueOf(pattern) + ")", (node, match) -> {
            Node next = node.nextSibling();
            return next == null ? null : pattern.matchWithPrevention(next, match);
        }).withHint(this.hint.withAnotherNode(pattern.hint));
    }

    public NodePattern withNextSiblingIncludingOtherSide(NodePattern pattern) {
        return this.with(() -> "withNextSiblingIncludingOtherSide(" + String.valueOf(pattern) + ")", (node, match) -> {
            Node next = node.nextSiblingIncludingOtherSide();
            return next == null ? null : pattern.matchWithPrevention(next, match);
        }).withHint(this.hint.withAnotherNode(pattern.hint));
    }

    public NodePattern inFormSequence(int headIndex, String ... forms) {
        assert (headIndex >= 0 && headIndex < forms.length);
        List<Regex> parsed = Arrays.stream(forms).map(Regex::parse).toList();
        List<RegexMatcher> matchers = parsed.stream().map(Regex::caseInsensitiveMatcher).toList();
        Predicate[] patterns = (Predicate[])matchers.stream().map(NodePattern::ciPredicate).toArray(Predicate[]::new);
        PatternHint hint = this.hint.withNodeForms(matchers.get(headIndex).possibleValues());
        for (int i = 0; i < patterns.length; ++i) {
            if (i == headIndex) continue;
            hint = hint.withAnotherNode(PatternHint.ALLOW_ANYTHING.withNodeForms(matchers.get(i).possibleValues()));
        }
        return this.with(() -> "formSequence(" + headIndex + ", " + String.valueOf(List.of(forms)) + ")", (node, match) -> {
            List<Node> nodes = node.tree().nodes();
            int start = node.index - headIndex;
            int end = node.index + patterns.length - headIndex;
            if (start < 0 || end > nodes.size()) {
                return null;
            }
            for (int i = start; i < end; ++i) {
                if (patterns[i - start].test(nodes.get(i))) continue;
                return null;
            }
            return match.withTouchedNodes(nodes.subList(start, end));
        }).withHint(hint);
    }

    public NodePattern inFormSequence(int headIndex, int orAnotherHeadIndex, String ... forms) {
        return NodePattern.or(this.inFormSequence(headIndex, forms), this.inFormSequence(orAnotherHeadIndex, forms));
    }

    public NodePattern reportEverythingTouched() {
        return this.reportEverythingTouched(ReportingKind.Always);
    }

    public NodePattern reportEverythingTouched(ReportingKind kind) {
        return this.with(() -> "reportEverythingTouched", (node, match) -> match.withReportedNodes((Iterable<Node>)StreamEx.of(match.allTouchedNodes()).append((Object)node), kind));
    }

    public NodePattern withNeighbor(int indexDelta, NodePattern neighborPattern) {
        assert (indexDelta != 0);
        return this.with(() -> "withNeighbor(" + indexDelta + ", " + String.valueOf(neighborPattern) + ")", (node, match) -> {
            int index = node.index + indexDelta;
            if (index < 0 || index >= node.tree().nodes().size()) {
                return null;
            }
            return neighborPattern.matchWithPrevention(node.neighbor(indexDelta), match);
        }).withHint(this.hint.withAnotherNode(neighborPattern.hint));
    }

    public NodePattern anyMatchUntil(String untilLabel, NodePattern intermediateNode) {
        Supplier<String> toString = () -> "anyMatchUntil(" + untilLabel + ", " + String.valueOf(intermediateNode) + ")";
        return this.with(toString, (node, match) -> {
            Node target = NodePattern.getMarkedNode(untilLabel, match, toString);
            if (target == node) {
                return null;
            }
            StreamEx<Node> stream = target.isBefore(node) ? target.nextUntil(node) : node.nextUntil(target);
            return NodePattern.matchAnyNode(intermediateNode, match, stream);
        }).withHint(this.hint.withAnotherNode(intermediateNode.hint));
    }

    public NodePattern noMatchUntil(String untilLabel, NodePattern intermediateNode) {
        return this.andNot(N.anyMatchUntil(untilLabel, intermediateNode));
    }

    public NodePattern suggestActions(ActionSuggestion ... suggestions) {
        return this.with(() -> "suggest(" + String.valueOf(List.of(suggestions)) + ")", (node, match) -> match.withActions(suggestions));
    }

    public NodePattern withSubstringHint(@Language(value="RegExp") String regex) {
        Set<String> values = Regex.parse(regex).possibleValues();
        assert (values != null) : "Couldn't enumerate the possible values from: " + regex;
        return this.withSubstringHint(values);
    }

    public NodePattern withSubstringHint(Set<String> possibleNodeSubstrings) {
        Object[] low = (String[])possibleNodeSubstrings.stream().map(s -> s.toLowerCase(Locale.ROOT)).distinct().toArray(String[]::new);
        List<PatternHint.Disjunct> disjuncts = this.hint.disjuncts();
        HashSet auto = new HashSet();
        for (PatternHint.Disjunct disjunct : disjuncts) {
            String[] autoSubstrings = disjunct.nodeSubstring();
            if (autoSubstrings == null) {
                autoSubstrings = disjunct.nodeForm();
            }
            if (autoSubstrings == null) {
                auto = null;
                continue;
            }
            if (auto == null) continue;
            Collections.addAll(auto, autoSubstrings);
        }
        if (auto != null && !PatternHint.Disjunct.areAllLonger((String[])low, auto.toArray(new String[0]))) {
            throw new RuntimeException("Substring hints were inferred automatically: " + String.valueOf(auto));
        }
        AhoCorasickDoubleArrayTrie trie = new AhoCorasickDoubleArrayTrie();
        trie.build(StreamEx.of((Object[])low).mapToEntry(__ -> true).toMap());
        return this.withHint(this.hint.withNodeSubstrings((String[])low)).with(() -> "withSubstringHint(" + String.valueOf(List.of(possibleNodeSubstrings)) + ")", (node, match) -> trie.findFirst(node.lowForm()) != null ? match : null);
    }

    public NodePattern costCenter(String name) {
        return N.with(() -> name, costCenterTransform.apply(name, this)).withHint(this.hint);
    }

    public NodePattern trace(String name) {
        return this.with(() -> name, (node, match) -> match.trace(name));
    }

    public NodePattern nonCrazy() {
        return this.with(() -> "nonCrazy()", (node, match) -> {
            if (match.preventedBy != null) {
                return match;
            }
            StreamEx allTouched = StreamEx.of(match.allTouchedNodes()).append((Object)node);
            for (Node n2 : (StreamEx)allTouched.sortedByInt(n -> n.tree().startOffset() + n.startOffset())) {
                String msg = n2.tree().crazyParseNodes().getCrazyMessage(n2);
                if (msg == null) continue;
                return match.preventedBy(CRAZY_PARSE_PREVENTION_PREFIX + msg);
            }
            return match;
        });
    }

    public NodePattern onlyWithSuggestions() {
        return this.with(() -> "onlyWithSuggestions()", (node, match) -> match.calcCorrectionChanges().isEmpty() ? null : match);
    }

    public NodePattern letterWord() {
        return this.withFlag(32, "letterWord()");
    }

    public NodePattern capitalized() {
        return this.withFlag(16, "capitalized()");
    }
}

