/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUnsignedLiteralsDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 @2\u00020\u0001:\u0001@B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J1\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b J$\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J&\u0010&\u001a\u00020'2\u0014\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d0)2\u0006\u0010$\u001a\u00020%H\u0002J(\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010-\u001a\u00020'H\u0002J,\u0010.\u001a\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00152\u0006\u0010-\u001a\u00020'H\u0002J\u0018\u00101\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u00102\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010)2\u0006\u0010\u0014\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u00104\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010)2\u0006\u0010\u0014\u001a\u0002052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u00106\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010)2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u0010\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020%H\u0002J2\u00109\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003000)2\u0006\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010=\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u0013J$\u0010>\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u0013J.\u0010?\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\b\u0010<\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;)V", "getModule$frontend", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getLanguageVersionSettings$frontend", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getInlineConstTracker$frontend", "()Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "updateNumberType", "", "numberType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveAnnotationArguments", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolveAnnotationArguments$frontend", "getAnnotationArgumentValue", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "isArrayPassedInNamedForm", "", "constants", "", "checkCompileTimeConstant", "argumentExpression", "expressionType", "useDeprecationWarning", "checkInnerPartsOfCompileTimeConstant", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "reportDeprecationWarningOnNonConst", "getArgumentExpressionsForArrayCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getArgumentExpressionsForCollectionLiteralCall", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "getArgumentExpressionsForArrayLikeCall", "hasSpread", "argument", "resolveAnnotationValueArguments", "resolvedValueArgument", "deprecatedExpectedType", "expectedType", "evaluateExpression", "evaluateToConstantValue", "checkExperimentalityOfConstantLiteral", "Companion", "frontend"})
@SourceDebugExtension(value={"SMAP\nConstantExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantExpressionEvaluator.kt\norg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1293:1\n1586#2:1294\n1661#2,3:1295\n*S KotlinDebug\n*F\n+ 1 ConstantExpressionEvaluator.kt\norg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator\n*L\n107#1:1294\n107#1:1295,3\n*E\n"})
public final class ConstantExpressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private static final OptInUsageChecker.OptInReporterMultiplexer EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS;

    public ConstantExpressionEvaluator(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull InlineConstTracker inlineConstTracker) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)inlineConstTracker, (String)"inlineConstTracker");
        this.module = module2;
        this.languageVersionSettings = languageVersionSettings;
        this.inlineConstTracker = inlineConstTracker;
    }

    public /* synthetic */ ConstantExpressionEvaluator(ModuleDescriptor moduleDescriptor, LanguageVersionSettings languageVersionSettings, InlineConstTracker inlineConstTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            inlineConstTracker = (InlineConstTracker)InlineConstTracker.DoNothing.INSTANCE;
        }
        this(moduleDescriptor, languageVersionSettings, inlineConstTracker);
    }

    @NotNull
    public final ModuleDescriptor getModule$frontend() {
        return this.module;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings$frontend() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final InlineConstTracker getInlineConstTracker$frontend() {
        return this.inlineConstTracker;
    }

    public final void updateNumberType(@NotNull KotlinType numberType, @Nullable KtExpression expression2, @NotNull StatementFilter statementFilter, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)numberType, (String)"numberType");
        Intrinsics.checkNotNullParameter((Object)statementFilter, (String)"statementFilter");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (expression2 == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression2, trace, false);
        if (!(expression2 instanceof KtConstantExpression)) {
            KtExpression deparenthesized = KtPsiUtil.getLastElementDeparenthesized((KtExpression)expression2, (StatementFilter)statementFilter);
            if (deparenthesized != expression2) {
                this.updateNumberType(numberType, deparenthesized, statementFilter, trace);
            }
            return;
        }
        this.evaluateExpression(expression2, trace, numberType);
    }

    @NotNull
    public final Map<Name, ConstantValue<?>> resolveAnnotationArguments$frontend(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        HashMap arguments = new HashMap();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall2.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            Intrinsics.checkNotNull((Object)parameterDescriptor);
            Intrinsics.checkNotNull((Object)resolvedArgument);
            ConstantValue<?> value = this.getAnnotationArgumentValue(trace, parameterDescriptor, resolvedArgument);
            if (value == null) continue;
            ((Map)arguments).put(parameterDescriptor.getName(), value);
        }
        return arguments;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument) {
        void $this$mapTo$iv$iv;
        KotlinType kotlinType;
        boolean argumentsAsVararg;
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)resolvedArgument, (String)"resolvedArgument");
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        boolean bl = argumentsAsVararg = varargElementType != null && !this.hasSpread(resolvedArgument);
        if (argumentsAsVararg) {
            kotlinType = varargElementType;
        } else {
            KotlinType kotlinType2 = parameterDescriptor.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        }
        KotlinType constantType = kotlinType;
        KotlinType expectedType = CallResolverUtilKt.getEffectiveExpectedType(parameterDescriptor, resolvedArgument, this.languageVersionSettings, trace);
        List<CompileTimeConstant<?>> compileTimeConstants = this.resolveAnnotationValueArguments(resolvedArgument, constantType, expectedType, trace);
        Iterable $this$map$iv = compileTimeConstants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toConstantValue(expectedType));
        }
        List constants = (List)destination$iv$iv;
        if (argumentsAsVararg) {
            if (this.isArrayPassedInNamedForm(constants, resolvedArgument)) {
                return (ConstantValue)CollectionsKt.single((List)constants);
            }
            if (parameterDescriptor.declaresDefaultValue() && compileTimeConstants.isEmpty()) {
                return null;
            }
            KotlinType kotlinType3 = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"getType(...)");
            return ConstantValueFactory.INSTANCE.createArrayValue(constants, kotlinType3);
        }
        return (ConstantValue)CollectionsKt.lastOrNull((List)constants);
    }

    private final boolean isArrayPassedInNamedForm(List<? extends ConstantValue<? extends Object>> constants, ResolvedValueArgument resolvedArgument) {
        ConstantValue constantValue = (ConstantValue)CollectionsKt.singleOrNull(constants);
        if (constantValue == null) {
            return false;
        }
        ConstantValue constant = constantValue;
        List<ValueArgument> list = resolvedArgument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.singleOrNull(list);
        if (valueArgument == null) {
            return false;
        }
        ValueArgument argument = valueArgument;
        return constant instanceof ArrayValue && argument.isNamed();
    }

    private final void checkCompileTimeConstant(KtExpression argumentExpression, KotlinType expressionType, BindingTrace trace, boolean useDeprecationWarning) {
        DiagnosticFactory0<KtExpression> diagnosticFactory;
        DiagnosticFactory0<KtExpression> diagnosticFactory0;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        CompileTimeConstant<?> constant = Companion.getConstant(argumentExpression, bindingContext);
        if (constant != null && constant.getCanBeUsedInAnnotations()) {
            this.checkInnerPartsOfCompileTimeConstant(constant, trace, argumentExpression, useDeprecationWarning);
            return;
        }
        ClassifierDescriptor descriptor = expressionType.getConstructor().getDeclarationDescriptor();
        if (DescriptorUtils.isEnumClass(descriptor)) {
            diagnosticFactory0 = Errors.ANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST;
        } else if (descriptor instanceof ClassDescriptor && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor)) {
            TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(expressionType.getArguments());
            diagnosticFactory0 = Companion.isTypeParameterOrArrayOfTypeParameter$frontend(typeProjection != null ? typeProjection.getType() : null) ? Errors.ANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR : Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL;
        } else {
            diagnosticFactory0 = diagnosticFactory = Errors.ANNOTATION_ARGUMENT_MUST_BE_CONST;
        }
        if (useDeprecationWarning) {
            this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
        } else {
            trace.report(diagnosticFactory.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    private final void checkInnerPartsOfCompileTimeConstant(CompileTimeConstant<?> constant, BindingTrace trace, KtExpression argumentExpression, boolean useDeprecationWarning) {
        KtExpression lhsExpression;
        List<KtExpression> callArguments;
        KtExpression ktExpression = argumentExpression;
        List<KtExpression> list = ktExpression instanceof KtCallExpression ? this.getArgumentExpressionsForArrayCall((KtCallExpression)argumentExpression, trace) : (callArguments = ktExpression instanceof KtCollectionLiteralExpression ? this.getArgumentExpressionsForCollectionLiteralCall((KtCollectionLiteralExpression)argumentExpression, trace) : null);
        if (callArguments != null) {
            for (KtExpression argument : callArguments) {
                KotlinType type;
                if (trace.getType(argument) == null) continue;
                this.checkCompileTimeConstant(argument, type, trace, useDeprecationWarning);
            }
        }
        if (constant.getUsesNonConstValAsConstant()) {
            if (useDeprecationWarning) {
                this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
            } else {
                trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)argumentExpression)));
            }
        }
        if (argumentExpression instanceof KtClassLiteralExpression && (lhsExpression = ((KtClassLiteralExpression)argumentExpression).getReceiverExpression()) != null) {
            DoubleColonLHS doubleColonLhs = (DoubleColonLHS)trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, lhsExpression);
            if (doubleColonLhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)doubleColonLhs).isObjectQualifier()) {
                if (useDeprecationWarning) {
                    this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
                } else {
                    trace.report(Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
                }
            } else if (doubleColonLhs instanceof DoubleColonLHS.Type && Companion.isTypeParameterOrArrayOfTypeParameter$frontend(((DoubleColonLHS.Type)doubleColonLhs).getType())) {
                trace.report(Errors.ANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER.on((KtExpression)((PsiElement)argumentExpression)));
            }
        }
    }

    private final void reportDeprecationWarningOnNonConst(KtExpression expression2, BindingTrace trace) {
        trace.report(Errors.ANNOTATION_ARGUMENT_IS_NON_CONST.on((KtExpression)((PsiElement)expression2)));
    }

    private final List<KtExpression> getArgumentExpressionsForArrayCall(KtCallExpression expression2, BindingTrace trace) {
        KtElement ktElement = (KtElement)expression2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForCollectionLiteralCall(KtCollectionLiteralExpression expression2, BindingTrace trace) {
        ResolvedCall resolvedCall2 = (ResolvedCall)trace.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForArrayLikeCall(ResolvedCall<?> resolvedCall2) {
        if (!CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2)) {
            return null;
        }
        ArrayList<KtExpression> result = new ArrayList<KtExpression>();
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedValueArgument = iterator2.next().getValue();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                KtExpression valueArgumentExpression = valueArgument.getArgumentExpression();
                if (valueArgumentExpression == null) continue;
                result.add(valueArgumentExpression);
            }
        }
        return result;
    }

    private final boolean hasSpread(ResolvedValueArgument argument) {
        List<ValueArgument> list = argument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
        List<ValueArgument> arguments = list;
        return arguments.size() == 1 && arguments.get(0).getSpreadElement() != null;
    }

    private final List<CompileTimeConstant<?>> resolveAnnotationValueArguments(ResolvedValueArgument resolvedValueArgument, KotlinType deprecatedExpectedType, KotlinType expectedType, BindingTrace trace) {
        ArrayList constants = new ArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            KotlinType expressionType;
            KtExpression argumentExpression;
            if (argument.getArgumentExpression() == null) continue;
            CompileTimeConstant<?> constant = this.evaluateExpression(argumentExpression, trace, expectedType);
            if (constant instanceof IntegerValueTypeConstant) {
                KotlinType defaultType = ((IntegerValueTypeConstant)constant).getType(expectedType);
                this.updateNumberType(defaultType, argumentExpression, StatementFilter.NONE, trace);
            }
            if (constant != null) {
                constants.add(constant);
            }
            if (trace.getType(argumentExpression) == null) continue;
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonConstValuesAsVarargsInAnnotations) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, deprecatedExpectedType)) {
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType)) continue;
                this.checkCompileTimeConstant(argumentExpression, expressionType, trace, true);
                continue;
            }
            this.checkCompileTimeConstant(argumentExpression, expressionType, trace, false);
        }
        return constants;
    }

    @Nullable
    public final CompileTimeConstant<?> evaluateExpression(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        ConstantExpressionEvaluatorVisitor visitor2 = new ConstantExpressionEvaluatorVisitor(this, trace);
        CompileTimeConstant<?> compileTimeConstant = visitor2.evaluate(expression2, expectedType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        this.checkExperimentalityOfConstantLiteral(expression2, constant, expectedType, trace);
        return !constant.isError() ? constant : null;
    }

    public static /* synthetic */ CompileTimeConstant evaluateExpression$default(ConstantExpressionEvaluator constantExpressionEvaluator, KtExpression ktExpression, BindingTrace bindingTrace, KotlinType kotlinType, int n, Object object) {
        if ((n & 4) != 0) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        return constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, kotlinType);
    }

    @Nullable
    public final ConstantValue<?> evaluateToConstantValue(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        CompileTimeConstant<?> compileTimeConstant = this.evaluateExpression(expression2, trace, expectedType);
        return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType) : null;
    }

    private final void checkExperimentalityOfConstantLiteral(KtExpression expression2, CompileTimeConstant<?> constant, KotlinType expectedType, BindingTrace trace) {
        KotlinType kotlinType;
        if (constant.isError()) {
            return;
        }
        if (!constant.getParameters().isUnsignedNumberLiteral() && !constant.getParameters().isUnsignedLongNumberLiteral()) {
            return;
        }
        if (constant instanceof TypedCompileTimeConstant) {
            kotlinType = ((TypedCompileTimeConstant)constant).getType();
        } else {
            KotlinType kotlinType2 = expectedType;
            if (kotlinType2 != null) {
                kotlinType = constant.toConstantValue(kotlinType2).getType(this.module);
            } else {
                return;
            }
        }
        KotlinType constantType = kotlinType;
        if (!UnsignedTypes.isUnsignedType(constantType)) {
            return;
        }
        OptInUsageChecker.Companion $this$checkExperimentalityOfConstantLiteral_u24lambda_u240 = OptInUsageChecker.Companion;
        boolean bl = false;
        ClassifierDescriptor classifierDescriptor = constantType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        ClassifierDescriptor descriptor = classifierDescriptor;
        DeclarationDescriptor declarationDescriptor = descriptor;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        Set optInDescriptions = OptInUsageChecker.Companion.loadOptIns$default($this$checkExperimentalityOfConstantLiteral_u24lambda_u240, declarationDescriptor, bindingContext, this.languageVersionSettings, null, false, false, false, 60, null);
        $this$checkExperimentalityOfConstantLiteral_u24lambda_u240.reportNotAllowedOptIns(optInDescriptions, (PsiElement)expression2, this.languageVersionSettings, trace, EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS);
    }

    private static final OptInUsageChecker.OptInDiagnosticReporter EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS$lambda$0(boolean it) {
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, (String)"EXPERIMENTAL_UNSIGNED_LITERALS");
        return new Companion.ExperimentalityDiagnostic1(diagnosticFactory1, "should");
    }

    private static final OptInUsageChecker.OptInDiagnosticReporter EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS$lambda$1(boolean it) {
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, (String)"EXPERIMENTAL_UNSIGNED_LITERALS_ERROR");
        return new Companion.ExperimentalityDiagnostic1(diagnosticFactory1, "must");
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
        return Companion.getConstant(expression2, bindingContext);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
        return Companion.getPossiblyErrorConstant(expression2, bindingContext);
    }

    static {
        Function1 function1 = ConstantExpressionEvaluator::EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS$lambda$0;
        Function1 function12 = ConstantExpressionEvaluator::EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS$lambda$1;
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, (String)"EXPERIMENTAL_UNSIGNED_LITERALS_ERROR");
        EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS = new OptInUsageChecker.OptInReporterMultiplexer((Function1<? super Boolean, ? extends OptInUsageChecker.OptInDiagnosticReporter>)function1, (Function1<? super Boolean, ? extends OptInUsageChecker.OptInDiagnosticReporter>)function12, new Companion.ExperimentalityDiagnostic1(diagnosticFactory1, "must"));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001e\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0017\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001a\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion;", "", "<init>", "()V", "EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "getConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getPossiblyErrorConstant", "isTypeParameterOrArrayOfTypeParameter", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isTypeParameterOrArrayOfTypeParameter$frontend", "isComplexBooleanConstant", "constant", "ExperimentalityDiagnostic1", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            CompileTimeConstant<?> compileTimeConstant = this.getPossiblyErrorConstant(expression2, bindingContext);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> constant = compileTimeConstant;
            return !constant.isError() ? constant : null;
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        }

        public final boolean isTypeParameterOrArrayOfTypeParameter$frontend(@Nullable KotlinType type) {
            boolean bl;
            if (type == null) {
                bl = false;
            } else if (KotlinBuiltIns.isArray(type)) {
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(type.getArguments());
                bl = this.isTypeParameterOrArrayOfTypeParameter$frontend(typeProjection != null ? typeProjection.getType() : null);
            } else {
                bl = type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
            }
            return bl;
        }

        public final boolean isComplexBooleanConstant(@NotNull KtExpression expression2, @NotNull CompileTimeConstant<?> constant) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter(constant, (String)"constant");
            if (constant.isError()) {
                return false;
            }
            SimpleType simpleType = constant.getModuleDescriptor().getBuiltIns().getBooleanType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getBooleanType(...)");
            ConstantValue<?> constantValue = constant.toConstantValue(simpleType);
            if (!TypeUtilsKt.isBoolean(constantValue.getType(constant.getModuleDescriptor()))) {
                return false;
            }
            return !(expression2 instanceof KtConstantExpression) && !constant.getParameters().getUsesVariableAsConstant();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion$ExperimentalityDiagnostic1;", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lcom/intellij/psi/PsiElement;", "", "verb", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;Ljava/lang/String;)V", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "getVerb", "()Ljava/lang/String;", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "message", "frontend"})
        private static final class ExperimentalityDiagnostic1
        implements OptInUsageChecker.OptInDiagnosticReporter {
            @NotNull
            private final DiagnosticFactory1<PsiElement, String> factory;
            @NotNull
            private final String verb;

            public ExperimentalityDiagnostic1(@NotNull DiagnosticFactory1<PsiElement, String> factory, @NotNull String verb) {
                Intrinsics.checkNotNullParameter(factory, (String)"factory");
                Intrinsics.checkNotNullParameter((Object)verb, (String)"verb");
                this.factory = factory;
                this.verb = verb;
            }

            @NotNull
            public final DiagnosticFactory1<PsiElement, String> getFactory() {
                return this.factory;
            }

            @NotNull
            public final String getVerb() {
                return this.verb;
            }

            @Override
            public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName, @Nullable String message) {
                Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
                Function1<FqName, String> defaultMessage = OptInUsageChecker.Companion.getDefaultDiagnosticMessage$frontend((OptInDiagnosticMessageProvider)ExperimentalUnsignedLiteralsDiagnosticMessageProvider.INSTANCE, this.verb);
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = this.factory.on(element, (String)defaultMessage.invoke((Object)fqName));
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                DiagnosticUtilsKt.reportDiagnosticOnce(trace, parametrizedDiagnostic);
            }
        }
    }
}

