/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ir.PreSerializationJsSymbols;
import org.jetbrains.kotlin.backend.common.ir.PreSerializationSymbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.lower.JsCodeOutlineTransformer;
import org.jetbrains.kotlin.ir.backend.js.lower.JsCodeOutliningLoweringKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="JsCodeOutliningLowering")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012(\b\u0002\u0010\u0004\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0005j\u0004\u0018\u0001`\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J&\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR1\u0010\u0004\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0005j\u0004\u0018\u0001`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "loweringContext", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "reportInlinableFunctionCaptured", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/InlinableLambdaCapturingReporter;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;Lkotlin/jvm/functions/Function3;)V", "getLoweringContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "getReportInlinableFunctionCaptured", "()Lkotlin/jvm/functions/Function3;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/PreSerializationJsSymbols;", "lower", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "putOutlinedFunctionsIntoContainer", "outlinedFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Companion", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCodeOutliningLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,412:1\n18#2,2:413\n379#3,13:415\n133#4,2:428\n*S KotlinDebug\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering\n*L\n117#1:413,2\n125#1:415,13\n125#1:428,2\n*E\n"})
public final class JsCodeOutliningLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoweringContext loweringContext;
    @Nullable
    private final Function3<IrExpression, IrValueDeclaration, IrDeclaration, Unit> reportInlinableFunctionCaptured;
    @NotNull
    private final PreSerializationJsSymbols symbols;
    @NotNull
    private static final IrDeclarationOriginImpl OUTLINED_JS_CODE_ORIGIN = new IrDeclarationOriginImpl("OUTLINED_JS_CODE", false, 2, null);

    public JsCodeOutliningLowering(@NotNull LoweringContext loweringContext, @Nullable Function3<? super IrExpression, ? super IrValueDeclaration, ? super IrDeclaration, Unit> reportInlinableFunctionCaptured) {
        Intrinsics.checkNotNullParameter((Object)loweringContext, (String)"loweringContext");
        this.loweringContext = loweringContext;
        this.reportInlinableFunctionCaptured = reportInlinableFunctionCaptured;
        PreSerializationSymbols preSerializationSymbols = this.loweringContext.getSymbols();
        Intrinsics.checkNotNull((Object)preSerializationSymbols, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.backend.common.ir.PreSerializationJsSymbols");
        this.symbols = (PreSerializationJsSymbols)preSerializationSymbols;
    }

    public /* synthetic */ JsCodeOutliningLowering(LoweringContext loweringContext, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function3 = null;
        }
        this(loweringContext, (Function3<? super IrExpression, ? super IrValueDeclaration, ? super IrDeclaration, Unit>)function3);
    }

    @NotNull
    public final LoweringContext getLoweringContext() {
        return this.loweringContext;
    }

    @Nullable
    public final Function3<IrExpression, IrValueDeclaration, IrDeclaration, Unit> getReportInlinableFunctionCaptured() {
        return this.reportInlinableFunctionCaptured;
    }

    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!JsCodeOutliningLoweringKt.access$containsCallsTo((IrElement)irBody, (IrFunctionSymbol)this.symbols.getJsCode())) {
            return;
        }
        JsCodeOutlineTransformer replacer = new JsCodeOutlineTransformer(this.loweringContext, container, this.reportInlinableFunctionCaptured);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irBody), (IrElementTransformerVoid)replacer);
        List<IrFunction> outlinedFunctions = replacer.getOutlinedFunctions();
        if (outlinedFunctions.isEmpty()) {
            return;
        }
        this.putOutlinedFunctionsIntoContainer(outlinedFunctions, container, irBody);
    }

    /*
     * WARNING - void declaration
     */
    private final void putOutlinedFunctionsIntoContainer(List<? extends IrFunction> outlinedFunctions, IrDeclaration container, IrBody irBody) {
        IrFunction irFunction;
        for (IrFunction irFunction2 : outlinedFunctions) {
            Object v0;
            block8: {
                void $this$firstIsInstanceOrNull$iv;
                Sequence sequence = IrUtilsKt.getParentDeclarationsWithSelf((IrDeclaration)container);
                irFunction = irFunction2;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof IrDeclarationParent)) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            IrDeclarationParent irDeclarationParent = v0;
            if (irDeclarationParent == null) {
                CompilationExceptionKt.compilationException((String)"Unexpected container to insert the outlined function to", (IrDeclaration)container);
                throw new KotlinNothingValueException();
            }
            irFunction.setParent(irDeclarationParent);
        }
        IrBody irBody2 = irBody;
        if (irBody2 instanceof IrBlockBody) {
            ((IrBlockBody)irBody).getStatements().addAll(0, (Collection)outlinedFunctions);
        } else if (irBody2 instanceof IrExpressionBody) {
            void $this$putOutlinedFunctionsIntoContainer_u24lambda_u240;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlock_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default((LoweringContext)this.loweringContext, (IrSymbol)container.getSymbol(), (int)0, (int)0, (int)6, null);
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)declarationIrBuilder;
            int $this$firstIsInstanceOrNull$iv = irBody.getStartOffset();
            int endOffset$iv = irBody.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void var14_17 = this_$iv$iv;
            irFunction = (IrExpressionBody)irBody;
            boolean bl = false;
            $this$putOutlinedFunctionsIntoContainer_u24lambda_u240.unaryPlus(outlinedFunctions);
            $this$putOutlinedFunctionsIntoContainer_u24lambda_u240.unaryPlus((IrStatement)((IrExpressionBody)irBody).getExpression());
            irFunction.setExpression((IrExpression)this_$iv$iv.doBuild());
        } else {
            if (irBody2 instanceof IrSyntheticBody) {
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported((IrDeclaration)container);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering$Companion;", "", "<init>", "()V", "OUTLINED_JS_CODE_ORIGIN", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getOUTLINED_JS_CODE_ORIGIN", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrDeclarationOriginImpl getOUTLINED_JS_CODE_ORIGIN() {
            return OUTLINED_JS_CODE_ORIGIN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

