/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.SurroundWithLambdaForTypeMismatchFix;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithLambdaForTypeMismatchFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSurroundWithLambdaForTypeMismatchFixFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SurroundWithLambdaForTypeMismatchFixFactory.kt\norg/jetbrains/kotlin/idea/quickfix/SurroundWithLambdaForTypeMismatchFixFactory\n+ 2 ResolutionUtils.kt\norg/jetbrains/kotlin/idea/caches/resolve/ResolutionUtils\n+ 3 ExtendedResolutionApi.kt\norg/jetbrains/kotlin/idea/caches/resolve/ExtendedResolutionApiKt\n*L\n1#1,68:1\n154#2:69\n152#3:70\n*S KotlinDebug\n*F\n+ 1 SurroundWithLambdaForTypeMismatchFixFactory.kt\norg/jetbrains/kotlin/idea/quickfix/SurroundWithLambdaForTypeMismatchFixFactory\n*L\n39#1:69\n39#1:70\n*E\n"})
public final class SurroundWithLambdaForTypeMismatchFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final SurroundWithLambdaForTypeMismatchFixFactory INSTANCE = new SurroundWithLambdaForTypeMismatchFixFactory();
    @NotNull
    private static final Logger LOG;

    private SurroundWithLambdaForTypeMismatchFixFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
        KotlinType expectedType = null;
        KotlinType expressionType = null;
        DiagnosticFactory diagnosticFactory2 = diagnosticFactory;
        if (Intrinsics.areEqual((Object)diagnosticFactory2, (Object)Errors.TYPE_MISMATCH)) {
            diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast((UnboundDiagnostic)diagnostic);
            Object object = diagnosticWithParameters.getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
            expectedType = (KotlinType)object;
            Object object2 = diagnosticWithParameters.getB();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-b>(...)");
            expressionType = (KotlinType)object2;
        } else if (Intrinsics.areEqual((Object)diagnosticFactory2, (Object)Errors.TYPE_MISMATCH_WARNING)) {
            diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH_WARNING.cast((UnboundDiagnostic)diagnostic);
            Object object = diagnosticWithParameters.getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
            expectedType = (KotlinType)object;
            Object object3 = diagnosticWithParameters.getB();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"<get-b>(...)");
            expressionType = (KotlinType)object3;
        } else if (Intrinsics.areEqual((Object)diagnosticFactory2, (Object)Errors.CONSTANT_EXPECTED_TYPE_MISMATCH)) {
            void $this$analyzeWithContent$iv$iv;
            PsiFile psiFile = diagnostic.getPsiFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtDeclarationContainer $this$analyzeWithContent$iv = (KtDeclarationContainer)((KtFile)psiFile);
            boolean $i$f$analyzeWithContent = false;
            KtDeclarationContainer ktDeclarationContainer = $this$analyzeWithContent$iv;
            ResolutionFacade resolutionFacade$iv$iv = ResolutionUtils.getResolutionFacade((KtElement)$this$analyzeWithContent$iv);
            boolean $i$f$analyzeWithContent2 = false;
            BindingContext context = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade$iv$iv, (KtElement)$this$analyzeWithContent$iv$iv, null, 2, null).getBindingContext();
            DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.cast((UnboundDiagnostic)diagnostic);
            PsiElement diagnosticElement = diagnostic.getPsiElement();
            if (!(diagnosticElement instanceof KtExpression)) {
                LOG.error("Unexpected element: " + diagnosticElement.getText());
                return null;
            }
            Object object = diagnosticWithParameters.getB();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-b>(...)");
            expectedType = (KotlinType)object;
            KotlinType kotlinType = context.getType((KtExpression)diagnosticElement);
            if (kotlinType == null) {
                return null;
            }
            expressionType = kotlinType;
        } else {
            LOG.error("Unexpected diagnostic: " + DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic)));
            return null;
        }
        if (!FunctionTypesKt.isFunctionOrSuspendFunctionType((KotlinType)expectedType)) {
            return null;
        }
        if (expectedType.getArguments().size() != 1) {
            return null;
        }
        KotlinType kotlinType = ((TypeProjection)expectedType.getArguments().get(0)).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType lambdaReturnType = kotlinType;
        if (!(TypeUtilsKt.isSubtypeOf((KotlinType)TypeUtilsKt.makeNotNullable((KotlinType)expressionType), (KotlinType)lambdaReturnType) || TypeUtilsKt.isPrimitiveNumberType((KotlinType)expressionType) && TypeUtilsKt.isPrimitiveNumberType((KotlinType)lambdaReturnType))) {
            return null;
        }
        PsiElement psiElement = diagnostic.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        KtExpression diagnosticElement = (KtExpression)psiElement;
        return new SurroundWithLambdaForTypeMismatchFix(diagnosticElement).asIntention();
    }

    static {
        Logger logger = Logger.getInstance(SurroundWithLambdaForTypeMismatchFix.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

