/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.filter;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.SuspendContext;
import com.sun.jdi.Location;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/filter/KotlinExtraSteppingFilter;", "Lcom/intellij/debugger/engine/ExtraSteppingFilter;", "<init>", "()V", "isApplicable", "", "context", "Lcom/intellij/debugger/engine/SuspendContext;", "getStepRequestDepth", "", "kotlin.jvm-debugger.core"})
public final class KotlinExtraSteppingFilter
implements ExtraSteppingFilter {
    public boolean isApplicable(@Nullable SuspendContext context) {
        SuspendContext suspendContext = context;
        if (suspendContext == null || (suspendContext = suspendContext.getDebugProcess()) == null) {
            return false;
        }
        SuspendContext debugProcess = suspendContext;
        Object object = context.getFrameProxy();
        if (object == null || (object = SafeUtilKt.safeLocation(object)) == null) {
            return false;
        }
        Object location = object;
        if (!DebuggerUtil.isInKotlinSources((Location)location)) {
            return false;
        }
        KotlinPositionManager positionManager = new KotlinPositionManager((DebugProcess)debugProcess);
        return DebuggerUtil.isLocationFiltered((Location)location, (PositionManager)positionManager);
    }

    public int getStepRequestDepth(@Nullable SuspendContext context) {
        return 1;
    }
}

