/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import schemacrawler.crawl.AbstractNamedObjectWithAttributes;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.TypedObject;
import schemacrawler.schemacrawler.Identifiers;

abstract class AbstractDatabaseObject
extends AbstractNamedObjectWithAttributes
implements DatabaseObject {
    private static final long serialVersionUID = 3099561832386790624L;
    private final Schema schema;
    private transient NamedObjectKey key;
    private transient String fullName;

    AbstractDatabaseObject(Schema schema, String name) {
        super(name);
        this.schema = Objects.requireNonNull(schema, "No schema provided");
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        if (obj instanceof DatabaseObject) {
            DatabaseObject object2 = (DatabaseObject)obj;
            int schemaCompareTo = this.getSchema().compareTo(object2.getSchema());
            if (schemaCompareTo != 0) {
                return schemaCompareTo;
            }
            AbstractDatabaseObject abstractDatabaseObject = this;
            if (abstractDatabaseObject instanceof TypedObject) {
                TypedObject object = (TypedObject)((Object)abstractDatabaseObject);
                if (obj instanceof TypedObject) {
                    TypedObject object1 = (TypedObject)((Object)obj);
                    try {
                        int typeCompareTo = object.getType().compareTo(object1.getType());
                        if (typeCompareTo != 0) {
                            return typeCompareTo;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return super.compareTo(obj);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof DatabaseObject)) {
            return false;
        }
        return Objects.equals(this.schema, ((DatabaseObject)obj).getSchema());
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.schema);
        return result;
    }

    @Override
    public NamedObjectKey key() {
        this.buildKey();
        return this.key;
    }

    @Override
    public void withQuoting(Identifiers identifiers) {
        if (identifiers == null) {
            return;
        }
        this.fullName = identifiers.quoteFullName(this);
    }

    private void buildFullName() {
        if (this.fullName != null) {
            return;
        }
        this.fullName = Identifiers.STANDARD.quoteFullName(this);
    }

    private void buildKey() {
        if (this.key != null) {
            return;
        }
        this.key = this.schema.key().with(this.getName());
    }
}

