/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx;

import com.ibm.db2.cmx.TransactionRule;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;

public abstract class Profile
implements Serializable {
    private String name_;
    private long version_ = -1L;
    private HashMap<String, String> jccDirectives_;
    private HashMap<String, String> cliDirectives_;
    private HashMap<String, String> dotNetDirectives_;
    private HashMap<String, String> wasDirectives_;
    private HashMap<String, String> cmxDirectives_;
    private Properties specialRegisters_;

    Profile(String string, long l2, Properties properties, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5) {
        this.name_ = string;
        this.version_ = l2;
        this.specialRegisters_ = properties;
        this.jccDirectives_ = hashMap;
        this.cliDirectives_ = hashMap2;
        this.dotNetDirectives_ = hashMap3;
        this.wasDirectives_ = hashMap4;
        this.cmxDirectives_ = hashMap5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateToNewVersion(Profile profile) {
        Profile profile2 = this;
        synchronized (profile2) {
            this.name_ = profile.name_;
            this.version_ = profile.version_;
            this.specialRegisters_ = profile.specialRegisters_;
            this.jccDirectives_ = profile.jccDirectives_;
            this.cliDirectives_ = profile.cliDirectives_;
            this.dotNetDirectives_ = profile.dotNetDirectives_;
            this.wasDirectives_ = profile.wasDirectives_;
            this.cmxDirectives_ = profile.cmxDirectives_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Profile profile = this;
        synchronized (profile) {
            return this.name_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVersion() {
        Profile profile = this;
        synchronized (profile) {
            return this.version_;
        }
    }

    public Properties getSpecialRegisters() {
        return this.specialRegisters_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getJccDirectives() {
        Profile profile = this;
        synchronized (profile) {
            return this.jccDirectives_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getCliDirectives() {
        Profile profile = this;
        synchronized (profile) {
            return this.cliDirectives_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getDotNetDirectives() {
        Profile profile = this;
        synchronized (profile) {
            return this.dotNetDirectives_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getWasDirectives() {
        Profile profile = this;
        synchronized (profile) {
            return this.wasDirectives_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getCmxDirectives() {
        Profile profile = this;
        synchronized (profile) {
            return this.cmxDirectives_;
        }
    }

    public class Constants {
        public static final String MONITOR_ENABLED = "monitorEnabled";
        public static final String MONITOR_INTERVAL = "monitorCollectionInterval";
    }

    public static class Database
    extends Profile {
        private static final long serialVersionUID = 5849318206690514830L;
        private TransactionRule.Remapping[] transactionRemappingRules_;
        private TransactionRule.PenaltyBox[] transactionPenaltyBoxRules_;

        public Database(String string, long l2, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5, TransactionRule.Remapping remapping, TransactionRule.PenaltyBox penaltyBox) {
            TransactionRule.PenaltyBox[] penaltyBoxArray;
            TransactionRule.Remapping[] remappingArray;
            if (remapping != null) {
                TransactionRule.Remapping[] remappingArray2 = new TransactionRule.Remapping[1];
                remappingArray = remappingArray2;
                remappingArray2[0] = remapping;
            } else {
                remappingArray = null;
            }
            if (penaltyBox != null) {
                TransactionRule.PenaltyBox[] penaltyBoxArray2 = new TransactionRule.PenaltyBox[1];
                penaltyBoxArray = penaltyBoxArray2;
                penaltyBoxArray2[0] = penaltyBox;
            } else {
                penaltyBoxArray = null;
            }
            this(string, l2, hashMap, hashMap2, hashMap3, hashMap4, hashMap5, remappingArray, penaltyBoxArray);
        }

        public Database(String string, long l2, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5, TransactionRule.Remapping[] remappingArray, TransactionRule.PenaltyBox[] penaltyBoxArray) {
            super(string, l2, null, hashMap, hashMap2, hashMap3, hashMap4, hashMap5);
            this.transactionRemappingRules_ = remappingArray;
            this.transactionPenaltyBoxRules_ = penaltyBoxArray;
        }

        public Database(String string, long l2, Properties properties, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5, TransactionRule.Remapping[] remappingArray, TransactionRule.PenaltyBox[] penaltyBoxArray) {
            super(string, l2, properties, hashMap, hashMap2, hashMap3, hashMap4, hashMap5);
            this.transactionRemappingRules_ = remappingArray;
            this.transactionPenaltyBoxRules_ = penaltyBoxArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateToNewVersion(Database database) {
            Database database2 = this;
            synchronized (database2) {
                super.updateToNewVersion(database);
                this.transactionRemappingRules_ = database.transactionRemappingRules_;
                this.transactionPenaltyBoxRules_ = database.transactionPenaltyBoxRules_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionRule.Remapping[] getTransactionRemappingRules() {
            Database database = this;
            synchronized (database) {
                return this.transactionRemappingRules_;
            }
        }

        public TransactionRule.PenaltyBox getTransactionPenaltyBoxRule() {
            return this.transactionPenaltyBoxRules_ == null ? null : this.transactionPenaltyBoxRules_[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionRule.PenaltyBox[] getTransactionPenaltyBoxRules() {
            Database database = this;
            synchronized (database) {
                return this.transactionPenaltyBoxRules_;
            }
        }
    }

    public static class DataSource
    extends Profile {
        private static final long serialVersionUID = 874071731225746104L;
        private TransactionRule.Remapping[] transactionRemappingRules_;
        private TransactionRule.PenaltyBox[] transactionPenaltyBoxRules_;
        private com.ibm.db2.cmx.Database targetDatabase_;
        private com.ibm.db2.cmx.Database rerouteDatabase_;
        private com.ibm.db2.cmx.Database redirectDatabase_;
        private transient long numberOfTransactions_;

        public DataSource(String string, long l2, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5, TransactionRule.Remapping remapping, TransactionRule.PenaltyBox penaltyBox, com.ibm.db2.cmx.Database database, com.ibm.db2.cmx.Database database2, com.ibm.db2.cmx.Database database3) {
            TransactionRule.PenaltyBox[] penaltyBoxArray;
            TransactionRule.Remapping[] remappingArray;
            if (remapping != null) {
                TransactionRule.Remapping[] remappingArray2 = new TransactionRule.Remapping[1];
                remappingArray = remappingArray2;
                remappingArray2[0] = remapping;
            } else {
                remappingArray = null;
            }
            if (penaltyBox != null) {
                TransactionRule.PenaltyBox[] penaltyBoxArray2 = new TransactionRule.PenaltyBox[1];
                penaltyBoxArray = penaltyBoxArray2;
                penaltyBoxArray2[0] = penaltyBox;
            } else {
                penaltyBoxArray = null;
            }
            this(string, l2, hashMap, hashMap2, hashMap3, hashMap4, hashMap5, remappingArray, penaltyBoxArray, database, database2, database3);
        }

        public DataSource(String string, long l2, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5, TransactionRule.Remapping[] remappingArray, TransactionRule.PenaltyBox[] penaltyBoxArray, com.ibm.db2.cmx.Database database, com.ibm.db2.cmx.Database database2, com.ibm.db2.cmx.Database database3) {
            super(string, l2, null, hashMap, hashMap2, hashMap3, hashMap4, hashMap5);
            this.transactionRemappingRules_ = remappingArray;
            this.transactionPenaltyBoxRules_ = penaltyBoxArray;
            this.targetDatabase_ = database;
            this.rerouteDatabase_ = database2;
            this.redirectDatabase_ = database3;
        }

        public DataSource(String string, long l2, Properties properties, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5, TransactionRule.Remapping[] remappingArray, TransactionRule.PenaltyBox[] penaltyBoxArray, com.ibm.db2.cmx.Database database, com.ibm.db2.cmx.Database database2, com.ibm.db2.cmx.Database database3) {
            super(string, l2, properties, hashMap, hashMap2, hashMap3, hashMap4, hashMap5);
            this.transactionRemappingRules_ = remappingArray;
            this.transactionPenaltyBoxRules_ = penaltyBoxArray;
            this.targetDatabase_ = database;
            this.rerouteDatabase_ = database2;
            this.redirectDatabase_ = database3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateToNewVersion(DataSource dataSource) {
            DataSource dataSource2 = this;
            synchronized (dataSource2) {
                super.updateToNewVersion(dataSource);
                this.transactionRemappingRules_ = dataSource.transactionRemappingRules_;
                this.transactionPenaltyBoxRules_ = dataSource.transactionPenaltyBoxRules_;
                if (this.targetDatabase_ != null && dataSource.targetDatabase_ != null) {
                    this.targetDatabase_.updateToNewVersion(dataSource.targetDatabase_);
                }
                if (this.rerouteDatabase_ != null && dataSource.rerouteDatabase_ != null) {
                    this.rerouteDatabase_.updateToNewVersion(dataSource.rerouteDatabase_);
                } else {
                    this.rerouteDatabase_ = dataSource.rerouteDatabase_;
                }
                if (this.redirectDatabase_ != null && dataSource.redirectDatabase_ != null) {
                    this.redirectDatabase_.updateToNewVersion(dataSource.redirectDatabase_);
                } else {
                    this.redirectDatabase_ = dataSource.redirectDatabase_;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionRule.Remapping[] getTransactionRemappingRules() {
            DataSource dataSource = this;
            synchronized (dataSource) {
                return this.transactionRemappingRules_;
            }
        }

        public TransactionRule.PenaltyBox getTransactionPenaltyBoxRule() {
            return this.transactionPenaltyBoxRules_ == null ? null : this.transactionPenaltyBoxRules_[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionRule.PenaltyBox[] getTransactionPenaltyBoxRules() {
            DataSource dataSource = this;
            synchronized (dataSource) {
                return this.transactionPenaltyBoxRules_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public com.ibm.db2.cmx.Database getTargetDatabase() {
            DataSource dataSource = this;
            synchronized (dataSource) {
                return this.targetDatabase_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public com.ibm.db2.cmx.Database getRedirectDatabase() {
            DataSource dataSource = this;
            synchronized (dataSource) {
                return this.redirectDatabase_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public com.ibm.db2.cmx.Database getRerouteDatabase() {
            DataSource dataSource = this;
            synchronized (dataSource) {
                return this.rerouteDatabase_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumberOfTransactions() {
            DataSource dataSource = this;
            synchronized (dataSource) {
                return this.numberOfTransactions_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrNumberOfTimesApplied() {
            DataSource dataSource = this;
            synchronized (dataSource) {
                ++this.numberOfTransactions_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetNumberOfTimesApplied() {
            DataSource dataSource = this;
            synchronized (dataSource) {
                this.numberOfTransactions_ = 0L;
            }
        }
    }

    public static class Driver
    extends Profile {
        private static final long serialVersionUID = -8399424192679753381L;
        private int pollingInterval_ = 120;
        private int statisticsCollectionInterval_ = 900;
        private int maxClientInfoToLogPerDataSource_ = 1000;

        public Driver(String string, long l2, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5) {
            super(string, l2, null, hashMap, hashMap2, hashMap3, hashMap4, hashMap5);
        }

        public Driver(String string, long l2, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5, int n2, int n3, int n4) {
            super(string, l2, null, hashMap, hashMap2, hashMap3, hashMap4, hashMap5);
            this.pollingInterval_ = n2;
            this.statisticsCollectionInterval_ = n3;
            this.maxClientInfoToLogPerDataSource_ = n4;
        }

        public Driver(String string, long l2, Properties properties, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5) {
            super(string, l2, properties, hashMap, hashMap2, hashMap3, hashMap4, hashMap5);
        }

        public Driver(String string, long l2, Properties properties, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, String> hashMap3, HashMap<String, String> hashMap4, HashMap<String, String> hashMap5, int n2, int n3, int n4) {
            super(string, l2, properties, hashMap, hashMap2, hashMap3, hashMap4, hashMap5);
            this.pollingInterval_ = n2;
            this.statisticsCollectionInterval_ = n3;
            this.maxClientInfoToLogPerDataSource_ = n4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateToNewVersion(Driver driver) {
            Driver driver2 = this;
            synchronized (driver2) {
                super.updateToNewVersion(driver);
                this.pollingInterval_ = driver.pollingInterval_;
                this.statisticsCollectionInterval_ = driver.statisticsCollectionInterval_;
                this.maxClientInfoToLogPerDataSource_ = driver.maxClientInfoToLogPerDataSource_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPollingInterval() {
            Driver driver = this;
            synchronized (driver) {
                return this.pollingInterval_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStatisticsCollectionInterval() {
            Driver driver = this;
            synchronized (driver) {
                return this.statisticsCollectionInterval_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMaxClientInfoToLogPerDataSource() {
            Driver driver = this;
            synchronized (driver) {
                return this.maxClientInfoToLogPerDataSource_;
            }
        }
    }
}

