/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;

@ImportStatic(value={TemporalConstants.class})
public abstract class GetRoundingIncrementOptionNode
extends JavaScriptBaseNode {
    public abstract int execute(Object var1);

    @Specialization
    protected final int toTemporalRoundingIncrement(Object options, @Cached(value="create(ROUNDING_INCREMENT, getJSContext())") PropertyGetNode getRoundingIncrement, @Cached JSToDoubleNode toDouble, @Cached InlinedBranchProfile errorBranch) {
        Object value = getRoundingIncrement.getValue(options);
        if (value == Undefined.instance) {
            return 1;
        }
        double doubleValue = toDouble.executeDouble(value);
        double increment = Math.floor(doubleValue);
        if (!Double.isFinite(doubleValue) || increment < 1.0 || increment > 1.0E9) {
            errorBranch.enter((Node)this);
            throw Errors.createRangeError("Increment out of range.");
        }
        return (int)increment;
    }
}

