# This file has been autogenerated by the pywayland scanner

# Copyright 2019 Sebastian Wick
# Copyright 2019 Erwin Burema
# Copyright 2020 AMD
# Copyright 2020-2024 Collabora, Ltd.
# Copyright 2024 Xaver Hugl
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wp_image_description_v1 import WpImageDescriptionV1


class WpColorManagementOutputV1(Interface):
    """Output color properties

    A :class:`WpColorManagementOutputV1` describes the color properties of an
    output.

    The :class:`WpColorManagementOutputV1` is associated with the
    :class:`~pywayland.protocol.wayland.WlOutput` global underlying the
    :class:`~pywayland.protocol.wayland.WlOutput` object. Therefore the client
    destroying the :class:`~pywayland.protocol.wayland.WlOutput` object has no
    impact, but the compositor removing the output global makes the
    :class:`WpColorManagementOutputV1` object inert.
    """

    name = "wp_color_management_output_v1"
    version = 1


class WpColorManagementOutputV1Proxy(Proxy[WpColorManagementOutputV1]):
    interface = WpColorManagementOutputV1

    @WpColorManagementOutputV1.request()
    def destroy(self) -> None:
        """Destroy the color management output

        Destroy the color :class:`WpColorManagementOutputV1` object. This does
        not affect any remaining protocol objects.
        """
        self._marshal(0)
        self._destroy()

    @WpColorManagementOutputV1.request(
        Argument(ArgumentType.NewId, interface=WpImageDescriptionV1),
    )
    def get_image_description(self) -> Proxy[WpImageDescriptionV1]:
        """Get the image description of the output

        This creates a new
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        object for the current image description of the output. There always is
        exactly one image description active for an output so the client should
        destroy the image description created by earlier invocations of this
        request. This request is usually sent as a reaction to the
        image_description_changed event or when creating a
        :class:`WpColorManagementOutputV1` object.

        The image description of an output represents the color encoding the
        output expects. There might be performance and power advantages, as
        well as improved color reproduction, if a content update matches the
        image description of the output it is being shown on. If a content
        update is shown on any other output than the one it matches the image
        description of, then the color reproduction on those outputs might be
        considerably worse.

        The created
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        object preserves the image description of the output from the time the
        object was created.

        The resulting image description object allows get_information request.

        If this protocol object is inert, the resulting image description
        object shall immediately deliver the
        :func:`WpImageDescriptionV1.failed()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.failed>`
        event with the no_output cause.

        If the interface version is inadequate for the output's image
        description, meaning that the client does not support all the events
        needed to deliver the crucial information, the resulting image
        description object shall immediately deliver the
        :func:`WpImageDescriptionV1.failed()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.failed>`
        event with the low_version cause.

        Otherwise the object shall immediately deliver the ready event.

        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        """
        image_description = self._marshal_constructor(1, WpImageDescriptionV1)
        return image_description


class WpColorManagementOutputV1Resource(Resource):
    interface = WpColorManagementOutputV1

    @WpColorManagementOutputV1.event()
    def image_description_changed(self) -> None:
        """Image description changed

        This event is sent whenever the image description of the output
        changed, followed by one :func:`WlOutput.done()
        <pywayland.protocol.wayland.WlOutput.done>` event common to output
        events across all extensions.

        If the client wants to use the updated image description, it needs to
        do get_image_description again, because image description objects are
        immutable.
        """
        self._post_event(0)


class WpColorManagementOutputV1Global(Global):
    interface = WpColorManagementOutputV1


WpColorManagementOutputV1._gen_c()
WpColorManagementOutputV1.proxy_class = WpColorManagementOutputV1Proxy
WpColorManagementOutputV1.resource_class = WpColorManagementOutputV1Resource
WpColorManagementOutputV1.global_class = WpColorManagementOutputV1Global
