/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.names;

import ancestris.reports.FilterOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatIDOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.ColorUtils;
import ancestris.reports.utils.StringFiller;
import ancestris.util.Utilities;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator;
import genj.report.Report;
import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ReportNames
extends Report {
    public FormattingOptions formattingOptions = new FormattingOptions();
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    public boolean reportOutputBirth = true;
    public boolean reportOutputMarriage = true;
    public boolean reportOutputDeath = true;
    public FilterOptions filterOptions = new FilterOptions();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    public Colors colors = new Colors();
    private Document doc;
    private Gedcom gedcom;
    private static final String SEP = "\u00a7";

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        this.gedcom = gedcom;
        List<Indi> indis = this.scope.getScope(gedcom, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Entity entity) {
        this.gedcom = entity.getGedcom();
        List<Indi> indis = this.scope.getScope(entity, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Indi[] indis) {
        if (indis.length == 0) {
            return null;
        }
        this.gedcom = indis[0].getGedcom();
        List<Indi> indisList = Arrays.asList(indis);
        return this.main(indisList);
    }

    public Document main(List<Indi> indis) {
        Collections.sort(indis, new PropertyComparator("INDI:NAME"));
        Collator collator = this.gedcom.getCollator();
        int nbColumns = 1;
        if (this.reportOutputBirth) {
            nbColumns += 2;
        }
        if (this.reportOutputMarriage) {
            nbColumns += 3;
        }
        if (this.reportOutputDeath) {
            nbColumns += 2;
        }
        String birthLabel = Gedcom.getName((String)"BIRT");
        String marrLabel = Gedcom.getName((String)"MARR");
        String deathLabel = Gedcom.getName((String)"DEAT");
        String nameLabel = Gedcom.getName((String)"NAME");
        String dateLabel = this.translate(Gedcom.getName((String)"DATE"));
        String placeLabel = this.translate(Gedcom.getName((String)"PLAC"));
        String spouseLabel = this.translate(this.translate("spouse"));
        String header_row = ColorUtils.color2string(this.colors.colors.bgHeaderRow);
        String even_row = ColorUtils.color2string(this.colors.colors.bgEvenRow);
        String odd_row = ColorUtils.color2string(this.colors.colors.bgOddRow);
        String textColor = ColorUtils.color2string(this.colors.colors.fgText);
        String backColor = ColorUtils.color2string(this.colors.colors.bgColor);
        String name_col = ColorUtils.color2string(this.colors.nameCol);
        String birth_col = ColorUtils.color2string(this.colors.birthCol);
        String marr_col = ColorUtils.color2string(this.colors.marrCol);
        String death_col = ColorUtils.color2string(this.colors.deathCol);
        ArrayList<String> lines = new ArrayList<String>();
        for (Entity entity : indis) {
            String record = this.analyzeIndi((Indi)entity);
            if (record.isBlank()) continue;
            lines.add(record);
        }
        String number = "" + lines.size();
        String string = this.translate("title", new Object[]{number, this.gedcom.getDisplayName()});
        this.doc = this.formattingOptions.createDocument(this.translate("name"), textColor, backColor);
        this.doc.startSection(string, "title", 1, false, false, "font-size=" + this.formattingOptions.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.includeTOC) {
            this.doc.addTOC(2, false, true);
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.scope.isLimited()) {
            this.doc.addText(this.scope.getMainMessage(), "font-weight=bold");
            for (String[] scopeLine : this.scope.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + scopeLine[0]);
                if (scopeLine[1].isBlank()) continue;
                this.doc.addText(" : " + scopeLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.filterOptions.isFilterOn()) {
            this.doc.addText(this.filterOptions.getMainMessage(), "font-weight=bold");
            for (String[] filterLine : this.filterOptions.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                this.doc.addText(" : " + filterLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=1cm, border-color=" + textColor);
        String letter = "";
        int row = 0;
        for (String line : lines) {
            String[] tokens = line.split(SEP);
            if (tokens.length == 0 || tokens[0].isBlank()) continue;
            int t = 0;
            String newLetter = tokens[t].substring(0, 1).toUpperCase();
            if (!collator.equals(newLetter = Utilities.removeDiacritics((String)newLetter), letter)) {
                letter = newLetter;
                this.doc.nextTableRow();
                this.doc.nextTableCell("number-columns-spanned=" + nbColumns + ", height=48px");
                if (this.formattingOptions.includeTOC) {
                    this.doc.addTOCEntry(letter);
                    this.doc.nextParagraph();
                    this.doc.addText("\u00a0");
                    this.doc.nextParagraph();
                    this.doc.addLink("^^^", "title");
                }
                this.doc.nextTableRow("font-size=" + (this.formattingOptions.getTextSize() + 2) + ", text-align=center, font-weight=bold, background-color=" + header_row, "width=25%, text-align=left, color=" + name_col);
                this.doc.addText(letter, "font-size=" + (this.formattingOptions.getTextSize() + 4) + ", font-weight=bold");
                if (this.reportOutputBirth) {
                    this.doc.nextTableCell("number-columns-spanned=2, color=" + birth_col);
                    this.doc.addText(birthLabel);
                }
                if (this.reportOutputMarriage) {
                    this.doc.nextTableCell("number-columns-spanned=3, color=" + marr_col);
                    this.doc.addText(marrLabel);
                }
                if (this.reportOutputDeath) {
                    this.doc.nextTableCell("number-columns-spanned=2, color=" + death_col);
                    this.doc.addText(deathLabel);
                }
                this.doc.nextTableRow("font-size=" + (this.formattingOptions.getTextSize() + 2) + ",text-align=center, font-weight=bold, background-color=" + header_row, "width=25%, text-align=left, color=" + name_col);
                this.doc.addText(nameLabel);
                if (this.reportOutputBirth) {
                    this.doc.nextTableCell("color=" + birth_col);
                    this.doc.addText(dateLabel);
                    this.doc.nextTableCell("color=" + birth_col);
                    this.doc.addText(placeLabel);
                }
                if (this.reportOutputMarriage) {
                    this.doc.nextTableCell("color=" + marr_col);
                    this.doc.addText(dateLabel);
                    this.doc.nextTableCell("color=" + marr_col);
                    this.doc.addText(placeLabel);
                    this.doc.nextTableCell("color=" + marr_col);
                    this.doc.addText(spouseLabel);
                }
                if (this.reportOutputDeath) {
                    this.doc.nextTableCell("color=" + death_col);
                    this.doc.addText(dateLabel);
                    this.doc.nextTableCell("color=" + death_col);
                    this.doc.addText(placeLabel);
                }
                row = 0;
            }
            String bgColor = row % 2 == 0 ? even_row : odd_row;
            ++row;
            this.doc.nextTableRow("background-color=" + bgColor + ", text-align=center", "width=25%, text-align=left");
            String name = tokens[t++];
            Object userid = tokens[t++];
            if (!((String)userid).isEmpty() && !((String)userid).equals("\u00a0")) {
                userid = "(" + (String)userid + ")";
            }
            String id = tokens[t++];
            if (((String)userid).isBlank()) {
                this.doc.addLink(name, this.gedcom.getEntity(id).getLinkAnchor(), "color=" + name_col);
            } else {
                this.doc.addText(name + " ", "color=" + name_col);
                this.doc.addLink((String)userid, this.gedcom.getEntity(id).getLinkAnchor(), "color=" + name_col);
            }
            if (this.reportOutputBirth) {
                this.doc.nextTableCell("color=" + birth_col);
                this.doc.addText(tokens[t++]);
                this.doc.nextTableCell("color=" + birth_col);
                this.doc.addText(tokens[t++]);
            }
            if (this.reportOutputMarriage) {
                int n = Integer.parseInt(tokens[t++].trim());
                switch (n) {
                    case 0: {
                        this.doc.nextTableCell();
                        this.doc.nextTableCell();
                        this.doc.nextTableCell();
                        break;
                    }
                    case 1: {
                        this.doc.nextTableCell("color=" + marr_col);
                        this.doc.addText(tokens[t++]);
                        this.doc.nextTableCell("color=" + marr_col);
                        this.doc.addText(tokens[t++]);
                        this.doc.nextTableCell("color=" + marr_col);
                        this.doc.addText(tokens[t++]);
                        break;
                    }
                    default: {
                        int fam;
                        String[] famDates = new String[n];
                        String[] famPlaces = new String[n];
                        String[] famSpouses = new String[n];
                        for (fam = 0; fam < n; ++fam) {
                            famDates[fam] = tokens[t++];
                            famPlaces[fam] = tokens[t++];
                            famSpouses[fam] = tokens[t++];
                        }
                        this.doc.nextTableCell("color=" + marr_col);
                        for (fam = 0; fam < n; ++fam) {
                            this.doc.nextParagraph();
                            this.doc.addText(famDates[fam]);
                            if (fam >= n - 1) continue;
                            this.doc.nextParagraph();
                            this.doc.addText("---");
                        }
                        this.doc.nextTableCell("color=" + marr_col);
                        for (fam = 0; fam < n; ++fam) {
                            this.doc.nextParagraph();
                            this.doc.addText(famPlaces[fam]);
                            if (fam >= n - 1) continue;
                            this.doc.nextParagraph();
                            this.doc.addText("---");
                        }
                        this.doc.nextTableCell("color=" + marr_col);
                        for (fam = 0; fam < n; ++fam) {
                            this.doc.nextParagraph();
                            this.doc.addText(famSpouses[fam]);
                            if (fam >= n - 1) continue;
                            this.doc.nextParagraph();
                            this.doc.addText("---");
                        }
                    }
                }
            }
            if (!this.reportOutputDeath) continue;
            this.doc.nextTableCell("color=" + death_col);
            this.doc.addText(tokens[t++]);
            this.doc.nextTableCell("color=" + death_col);
            this.doc.addText(tokens[t++]);
        }
        this.doc.endTable();
        return this.doc;
    }

    private String analyzeIndi(Indi indi) {
        if (indi == null) {
            return "";
        }
        StringFiller sf = new StringFiller(SEP);
        sf.append(indi.getName());
        sf.append(this.dataFormatOptions.id.getId(indi));
        sf.append(indi.getId());
        if (this.reportOutputBirth) {
            sf.append(this.dataFormatOptions.date.getDate((Property)indi.getBirthDateOption()));
            sf.append(this.dataFormatOptions.place.getPlace((Property)indi.getBirthPlaceOption()));
        }
        if (this.reportOutputMarriage) {
            Fam[] families = indi.getFamiliesWhereSpouse();
            sf.append(families.length);
            for (Fam fam : families) {
                sf.append(this.dataFormatOptions.date.getDate((Property)fam.getMarriageDate()));
                sf.append(this.dataFormatOptions.place.getPlace((Property)fam.getMarriagePlace()));
                Indi spouse = fam.getOtherSpouse(indi);
                sf.append(spouse != null ? spouse.getName() : "");
            }
        }
        if (this.reportOutputDeath) {
            sf.append(this.dataFormatOptions.date.getDate((Property)indi.getDeathDateOption()));
            sf.append(this.dataFormatOptions.place.getPlace((Property)indi.getDeathPlaceOption()));
        }
        sf.append("END");
        if (this.filterOptions.matchRecord((Property)indi, indi.getName().toLowerCase(), sf.toString().toLowerCase())) {
            return sf.toString();
        }
        return "";
    }

    public class MyDataFormatOptions {
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
        public FormatIDOptions id = new FormatIDOptions();
    }

    public class Colors {
        public SimpleColorsOptions colors = new SimpleColorsOptions();
        public Color nameCol = new Color(0, 122, 0);
        public Color birthCol = Color.BLUE;
        public Color marrCol = Color.RED;
        public Color deathCol = Color.BLACK;
    }
}

