/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.multdesc;

import ancestris.core.TextOptions;
import ancestris.gedcom.privacy.PrivacyPolicy;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.ColorUtils;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyMultilineValue;
import genj.report.Report;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ReportMultDesc
extends Report {
    public FormatOptions formatOptions = new FormatOptions();
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public DataNumberingOptions numberingOptions = new DataNumberingOptions();
    public DataGenerationsOptions generationOptions = new DataGenerationsOptions();
    public DataEventOptions eventOptions = new DataEventOptions();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    private final SimpleColorsOptions defaultColors = new SimpleColorsOptions();
    public Colors colors = new Colors();
    private int nbIndi = 0;
    private int nbFam = 0;
    private int nbLiving = 0;
    private Output output;
    private static final int ONE_LINE = 0;
    private static final int ONE_EVT_PER_LINE = 1;
    private static final int TABLE = 2;
    private static final String FORMAT_STRONG = "font-weight=bold";
    private static final int NUM_NONE = 0;
    private static final int NUM_ABBO = 1;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.main(new Indi[]{indi}) : null;
    }

    public Object start(Indi indi) {
        return this.main(new Indi[]{indi});
    }

    public Object start(Indi[] indis) {
        return this.main(indis);
    }

    private Document main(Indi[] indis) {
        String textColor = ColorUtils.color2string(this.colors.fgText);
        String backColor = ColorUtils.color2string(this.colors.bgColor);
        this.nbIndi = 0;
        this.nbFam = 0;
        this.nbLiving = 0;
        switch (this.formatOptions.reportFormat) {
            case 2: {
                this.output = new OutputTable();
                break;
            }
            case 0: 
            case 1: {
                this.output = new OutputStandard();
                break;
            }
            default: {
                throw new IllegalArgumentException("no such report type");
            }
        }
        HashMap<Fam, String> done = new HashMap<Fam, String>();
        PrivacyPolicy policy = PrivacyPolicy.getDefault();
        Document doc = this.formatOptions.common.createDocument(this.translate("name"), textColor, backColor);
        for (int i = 0; i < indis.length; ++i) {
            Indi indi = indis[i];
            this.output.title(indi, doc);
            this.iterate(indi, 1, String.valueOf(i + 1), done, policy, doc);
        }
        this.output.statistiques(doc);
        return doc;
    }

    private void iterate(Indi indi, int level, String num, HashMap<Fam, String> done, PrivacyPolicy policy, Document doc) {
        ++this.nbIndi;
        if (!indi.isDeceased()) {
            ++this.nbLiving;
        }
        if (level > this.generationOptions.reportMaxGenerations) {
            return;
        }
        PrivacyPolicy localPolicy = this.generationOptions.publicGen == 0 || level < this.generationOptions.publicGen + 1 ? PrivacyPolicy.getDefault().getAllPublic() : policy;
        this.output.startIndi(doc);
        this.format(indi, null, level + ".", num, localPolicy, doc);
        Character suffix = Character.valueOf('a');
        Fam[] fams = indi.getFamiliesWhereSpouse();
        boolean several = fams.length > 1;
        for (Fam fam : fams) {
            Indi spouse = fam.getOtherSpouse(indi);
            this.output.startSpouse(doc);
            this.format(spouse, fam, level + ".", num + suffix.toString(), localPolicy, doc);
            if (done.containsKey(fam)) {
                this.output.link(fam, done.get(fam), doc);
            } else {
                this.output.anchor(fam, doc);
                done.put(fam, level + "." + num);
                ++this.nbIndi;
                ++this.nbFam;
                if (spouse != null && !spouse.isDeceased()) {
                    ++this.nbLiving;
                }
                Indi[] children = fam.getChildren();
                for (int c = 0; c < children.length; ++c) {
                    this.iterate(children[c], level + 1, num + (several ? suffix.toString() : "") + "." + (c + 1), done, policy, doc);
                }
            }
            Character c = suffix;
            suffix = Character.valueOf((char)(suffix.charValue() + '\u0001'));
        }
        this.output.endIndi(indi, doc);
    }

    private void format(Indi indi, Fam fam, String level, String prefix, PrivacyPolicy policy, Document doc) {
        PropertyMultilineValue addr;
        Property p;
        String[] stringArray;
        if (indi == null) {
            return;
        }
        this.output.number(level, prefix, doc);
        if (this.numberingOptions.reportGender) {
            this.output.sex(indi, doc);
        }
        this.output.name(policy.getReportValue((Property)indi, "NAME"), doc);
        if (this.numberingOptions.reportIds) {
            this.output.id(indi.getId(), doc);
        }
        ArrayList<Object> infos = new ArrayList<Object>();
        this.output.startEvents(doc);
        if (this.eventOptions.reportDateOfBirth || this.eventOptions.reportPlaceOfBirth) {
            String birt = this.output.format((Entity)indi, "BIRT", this.OPTIONS.getBirthSymbol(), this.eventOptions.reportDateOfBirth, this.eventOptions.reportPlaceOfBirth, policy);
            infos.add(birt);
        }
        if (this.eventOptions.reportDateOfMarriage || this.eventOptions.reportPlaceOfMarriage) {
            String marr = fam != null ? this.output.format((Entity)fam, "MARR", this.OPTIONS.getMarriageSymbol(), this.eventOptions.reportDateOfMarriage, this.eventOptions.reportPlaceOfMarriage, policy) : "";
            infos.add(marr);
        }
        if (this.eventOptions.reportDateOfDeath || this.eventOptions.reportPlaceOfDeath) {
            String deat = this.output.format((Entity)indi, "DEAT", this.OPTIONS.getDeathSymbol(), this.eventOptions.reportDateOfDeath, this.eventOptions.reportPlaceOfDeath, policy);
            infos.add(deat);
        }
        if (this.eventOptions.reportDateOfOccu || this.eventOptions.reportPlaceOfOccu) {
            Object occu = "";
            List list = indi.getAllProperties("OCCU");
            Collections.reverse(list);
            stringArray = list.iterator();
            if (stringArray.hasNext()) {
                p = (Property)stringArray.next();
                switch (this.formatOptions.reportFormat) {
                    case 1: {
                        infos.add(this.output.format(p, this.OPTIONS.getOccuSymbol() + " ", this.eventOptions.reportDateOfOccu, this.eventOptions.reportPlaceOfOccu, policy));
                        break;
                    }
                    default: {
                        occu = (String)occu + " " + this.output.format(p, this.OPTIONS.getOccuSymbol() + " ", this.eventOptions.reportDateOfOccu, this.eventOptions.reportPlaceOfOccu, policy);
                        break;
                    }
                }
            }
            infos.add(occu);
        }
        if (this.eventOptions.reportDateOfResi || this.eventOptions.reportPlaceOfResi) {
            Object resi = "";
            List list = indi.getAllProperties("RESI");
            Collections.reverse(list);
            stringArray = list.iterator();
            if (stringArray.hasNext()) {
                p = (Property)stringArray.next();
                switch (this.formatOptions.reportFormat) {
                    case 1: {
                        infos.add(this.output.format(p, this.OPTIONS.getResiSymbol() + " ", this.eventOptions.reportDateOfResi, this.eventOptions.reportPlaceOfResi, policy));
                        break;
                    }
                    default: {
                        resi = (String)resi + " " + this.output.format(p, this.OPTIONS.getResiSymbol() + " ", this.eventOptions.reportDateOfResi, this.eventOptions.reportPlaceOfResi, policy);
                        break;
                    }
                }
            }
            infos.add(resi);
        }
        for (String string : infos) {
            this.output.event(string, doc);
        }
        PropertyMultilineValue propertyMultilineValue = addr = this.eventOptions.reportMailingAddress ? indi.getAddress() : null;
        if (addr != null && policy.isPrivate((Property)addr)) {
            addr = null;
        }
        if (addr != null) {
            this.output.addressPrefix(doc);
            String[] stringArray2 = addr.getLines(true);
            this.output.startEvents(doc);
            for (String line : stringArray2) {
                this.output.event(line, doc);
            }
            this.output.endEvents(doc);
        }
        this.output.endEvents(doc);
    }

    public class FormatOptions {
        public FormattingOptions common = new FormattingOptions();
        public int reportFormat = 0;
        public String[] reportFormats = new String[]{ReportMultDesc.this.translate("IndiPerLine"), ReportMultDesc.this.translate("EventPerLine"), ReportMultDesc.this.translate("Table")};
        public boolean short_indentation = true;
    }

    public class DataNumberingOptions {
        public boolean reportIds = true;
        public int reportNumberScheme = 1;
        public String[] reportNumberSchemes = new String[]{ReportMultDesc.this.translate("NumNone"), ReportMultDesc.this.translate("NumAbbo")};
        public boolean reportGender = false;
    }

    public class DataGenerationsOptions {
        public int reportMaxGenerations = 999;
        public int publicGen = 0;
    }

    public class DataEventOptions {
        public boolean reportPlaceOfBirth = true;
        public boolean reportDateOfBirth = true;
        public boolean reportPlaceOfMarriage = true;
        public boolean reportDateOfMarriage = true;
        public boolean reportPlaceOfDeath = true;
        public boolean reportDateOfDeath = true;
        public boolean reportPlaceOfOccu = true;
        public boolean reportDateOfOccu = true;
        public boolean reportPlaceOfResi = true;
        public boolean reportDateOfResi = true;
        public boolean reportMailingAddress = true;
    }

    public class MyDataFormatOptions {
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
    }

    public class Colors {
        public Color fgText;
        public Color bgColor;

        public Colors() {
            this.fgText = ReportMultDesc.this.defaultColors.fgText;
            this.bgColor = ReportMultDesc.this.defaultColors.bgColor;
        }
    }

    class OutputTable
    extends Output {
        OutputTable() {
        }

        @Override
        String format(Entity e, String tag, String prefix, boolean date, boolean place, PrivacyPolicy policy) {
            return super.format(e, tag, "", date, place, policy);
        }

        @Override
        void title(Indi indi, Document doc) {
            doc.startTable("genj:csv=true, border-style=none, border-color=black, border=0");
            doc.nextTableRow();
            doc.nextTableCell("number-columns-spanned=7,font-weight=bold");
            doc.addText(ReportMultDesc.this.translate("title.descendant", new Object[]{indi.getReportName()}));
            doc.nextTableRow();
            doc.addText(ReportMultDesc.this.translate("num.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"NAME"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"BIRT"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"MARR"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"DEAT"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"OCCU"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"RESI"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr1.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr2.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr3.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr4.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr5.col"), ReportMultDesc.FORMAT_STRONG);
        }

        @Override
        void statistiques(Document doc) {
            doc.startSection(ReportMultDesc.this.translate("title.stats"));
            doc.addText(ReportMultDesc.this.translate("nb.fam", new Object[]{ReportMultDesc.this.nbFam}));
            doc.nextParagraph();
            doc.addText(ReportMultDesc.this.translate("nb.indi", new Object[]{ReportMultDesc.this.nbIndi}));
            doc.nextParagraph();
            doc.addText(ReportMultDesc.this.translate("nb.living", new Object[]{ReportMultDesc.this.nbLiving}));
        }

        @Override
        void startIndi(Document doc) {
            doc.nextTableRow();
        }

        @Override
        void startSpouse(Document doc) {
            doc.nextTableRow();
        }

        @Override
        void link(Fam fam, String label, Document doc) {
            doc.nextTableRow();
            doc.nextTableCell();
            doc.nextTableCell();
            doc.addText("====> " + ReportMultDesc.this.translate("see") + " ");
            if (ReportMultDesc.this.numberingOptions.reportNumberScheme != 0) {
                doc.addText(label);
            } else {
                doc.addText(fam.getDisplayValue());
            }
        }

        @Override
        void anchor(Fam fam, Document doc) {
        }

        @Override
        void endIndi(Indi indi, Document doc) {
        }

        @Override
        void name(String name, Document doc) {
            if (!ReportMultDesc.this.numberingOptions.reportGender) {
                doc.nextTableCell();
            }
            doc.addText(name, ReportMultDesc.FORMAT_STRONG);
        }

        @Override
        void id(String id, Document doc) {
            doc.addText(" (" + id + ")");
        }

        @Override
        void sex(Indi indi, Document doc) {
            doc.nextTableCell();
            String symbol = "";
            symbol = switch (indi.getSex()) {
                case 0 -> Character.toString(9893);
                case 1 -> Character.toString(9794);
                case 2 -> Character.toString(9792);
                default -> "o";
            };
            doc.addText(symbol + " ");
        }

        @Override
        void startEvents(Document doc) {
        }

        @Override
        void endEvents(Document doc) {
        }

        @Override
        void event(String event, Document doc) {
            doc.nextTableCell();
            doc.addText(event);
        }

        @Override
        void number(String level, String num, Document doc) {
            doc.nextTableCell();
            if (ReportMultDesc.this.numberingOptions.reportNumberScheme == 0) {
                doc.addText(level);
            } else {
                doc.addText(level + num);
            }
        }

        @Override
        void addressPrefix(Document doc) {
        }
    }

    abstract class Output {
        Output() {
        }

        abstract void title(Indi var1, Document var2);

        abstract void statistiques(Document var1);

        abstract void startIndi(Document var1);

        abstract void startSpouse(Document var1);

        abstract void link(Fam var1, String var2, Document var3);

        abstract void anchor(Fam var1, Document var2);

        abstract void endIndi(Indi var1, Document var2);

        abstract void name(String var1, Document var2);

        abstract void id(String var1, Document var2);

        abstract void sex(Indi var1, Document var2);

        abstract void startEvents(Document var1);

        abstract void endEvents(Document var1);

        abstract void event(String var1, Document var2);

        abstract void number(String var1, String var2, Document var3);

        abstract void addressPrefix(Document var1);

        String format(Entity e, String tag, String prefix, boolean date, boolean place, PrivacyPolicy policy) {
            String dateFmt = ReportMultDesc.this.dataFormatOptions.date.getDateFormat();
            String placeFmt = ReportMultDesc.this.dataFormatOptions.place.getPlaceFormat();
            Property prop = e.getProperty(tag);
            if (prop == null) {
                if ("BIRT".equals(tag) && TextOptions.getInstance().isUseChr()) {
                    prop = e.getProperty("CHR");
                } else if ("DEAT".equals(tag) && TextOptions.getInstance().isUseBuri()) {
                    prop = e.getProperty("BURI");
                }
                if (prop == null) {
                    return "";
                }
            }
            String vdate = prop.format("{$v}" + (date ? dateFmt : ""), policy, true);
            String vplace = prop.format(place ? placeFmt : "");
            if (place && ReportMultDesc.this.dataFormatOptions.place.isCustom()) {
                vplace = ReportMultDesc.this.dataFormatOptions.place.getCustomFormat(prop);
            }
            if (vdate.trim().isEmpty() || prop instanceof PropertyEvent && ((PropertyEvent)prop).isKnownToHaveHappened().booleanValue()) {
                return prefix + vplace;
            }
            return prefix + vdate + vplace;
        }

        String format(Property prop, String prefix, boolean date, boolean place, PrivacyPolicy policy) {
            if (prop == null) {
                return "";
            }
            String dateFmt = ReportMultDesc.this.dataFormatOptions.date.getDateFormat();
            String placeFmt = ReportMultDesc.this.dataFormatOptions.place.getPlaceFormat();
            String vdate = prop.format("{$v}" + (date ? dateFmt : ""), policy, true);
            String vplace = prop.format(place ? placeFmt : "");
            if (place && ReportMultDesc.this.dataFormatOptions.place.isCustom()) {
                vplace = ReportMultDesc.this.dataFormatOptions.place.getCustomFormat(prop);
            }
            if (vdate.isBlank() || prop instanceof PropertyEvent && ((PropertyEvent)prop).isKnownToHaveHappened().booleanValue()) {
                return prefix + vplace;
            }
            return prefix + vdate + vplace;
        }
    }

    class OutputStandard
    extends Output {
        private boolean isFirstEvent = true;

        OutputStandard() {
        }

        @Override
        void title(Indi indi, Document doc) {
            doc.startSection(ReportMultDesc.this.translate("title.descendant", new Object[]{indi.getReportName()}));
        }

        @Override
        void statistiques(Document doc) {
            doc.startSection(ReportMultDesc.this.translate("title.stats"));
            doc.addText(ReportMultDesc.this.translate("nb.fam", new Object[]{ReportMultDesc.this.nbFam}));
            doc.nextParagraph();
            doc.addText(ReportMultDesc.this.translate("nb.indi", new Object[]{ReportMultDesc.this.nbIndi}));
            doc.nextParagraph();
            doc.addText(ReportMultDesc.this.translate("nb.living", new Object[]{ReportMultDesc.this.nbLiving}));
        }

        @Override
        void startIndi(Document doc) {
            doc.startList();
        }

        @Override
        void startSpouse(Document doc) {
        }

        @Override
        void link(Fam fam, String label, Document doc) {
            doc.nextParagraph();
            doc.addText("====> " + ReportMultDesc.this.translate("see") + " ");
            if (ReportMultDesc.this.numberingOptions.reportNumberScheme != 0) {
                doc.addLink(label, fam.getLinkAnchor());
            } else {
                doc.addLink(fam.getDisplayTitle(ReportMultDesc.this.numberingOptions.reportIds), fam.getLinkAnchor());
            }
        }

        @Override
        void anchor(Fam fam, Document doc) {
            doc.addAnchor(fam.getLinkAnchor());
        }

        @Override
        void endIndi(Indi indi, Document doc) {
            doc.endList();
        }

        @Override
        void number(String level, String number, Document doc) {
            doc.nextParagraph();
            if (ReportMultDesc.this.numberingOptions.reportNumberScheme == 0) {
                if (ReportMultDesc.this.formatOptions.short_indentation) {
                    doc.nextListItem();
                } else {
                    doc.nextListItem("genj:label=" + level);
                }
            } else if (ReportMultDesc.this.formatOptions.short_indentation) {
                doc.nextListItem();
                doc.addText(level + number + "\u00a0");
            } else {
                doc.nextListItem("genj:label=" + level + number);
            }
        }

        @Override
        void name(String name, Document doc) {
            doc.addText(name, ReportMultDesc.FORMAT_STRONG);
        }

        @Override
        void id(String id, Document doc) {
            doc.addText(" (" + id + ") ");
        }

        @Override
        void sex(Indi indi, Document doc) {
            String symbol = "";
            symbol = switch (indi.getSex()) {
                case 0 -> Character.toString(9893);
                case 1 -> Character.toString(9794);
                case 2 -> Character.toString(9792);
                default -> "o";
            };
            doc.addText(symbol + " ");
        }

        @Override
        void startEvents(Document doc) {
            if (ReportMultDesc.this.formatOptions.reportFormat != 0) {
                doc.startList();
            }
            this.isFirstEvent = true;
        }

        @Override
        void endEvents(Document doc) {
            if (ReportMultDesc.this.formatOptions.reportFormat != 0) {
                doc.endList();
            }
        }

        @Override
        void event(String event, Document doc) {
            if (event.isBlank()) {
                return;
            }
            if (!this.isFirstEvent) {
                if (ReportMultDesc.this.formatOptions.reportFormat == 0) {
                    doc.addText(" ");
                } else {
                    doc.nextListItem();
                }
            }
            doc.addText(event);
            this.isFirstEvent = false;
        }

        @Override
        void addressPrefix(Document doc) {
            if (!this.isFirstEvent) {
                if (ReportMultDesc.this.formatOptions.reportFormat == 0) {
                    doc.addText(" ");
                } else {
                    doc.nextListItem();
                }
            }
        }
    }
}

