/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.io.IOException;
import java.io.InputStream;

public class MeteredInputStream
extends InputStream {
    private long meter = 0L;
    private long marked = -1L;
    private InputStream in;

    public MeteredInputStream(InputStream in) {
        this.in = in;
    }

    public long getCount() {
        return this.meter;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.marked = this.meter;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        ++this.meter;
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        this.meter += (long)read;
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        this.meter += (long)read;
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.marked < 0L) {
            throw new IOException("reset() without mark()");
        }
        this.in.reset();
        this.meter = this.marked;
    }

    @Override
    public long skip(long n) throws IOException {
        int skipped = (int)super.skip(n);
        this.meter += (long)skipped;
        return skipped;
    }
}

