/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.tools.LocalGedcomFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import org.openide.util.NbBundle;

public class LocalGedcomsPopup
extends JPopupMenu {
    private List<LocalGedcomFrame> listOfGedcoms;
    private ButtonGroup buttonGroup = new ButtonGroup();

    public LocalGedcomsPopup(List<LocalGedcomFrame> list) {
        this.listOfGedcoms = list;
        this.updateItems();
    }

    public void updateItems() {
        while (this.buttonGroup.getElements().hasMoreElements()) {
            this.buttonGroup.remove(this.buttonGroup.getElements().nextElement());
        }
        this.removeAll();
        if (this.listOfGedcoms.isEmpty()) {
            return;
        }
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JLabel label = new JLabel(NbBundle.getMessage(this.getClass(), (String)"LocalGedcomsPopup_Choose_Main"));
        this.add(label);
        this.listOfGedcoms.stream().sorted((gedcom1, gedcom2) -> gedcom1.getGedcom().getDisplayName().toUpperCase().compareTo(gedcom2.getGedcom().getDisplayName().toUpperCase())).forEachOrdered(gedcom -> {
            JRadioButton button = new JRadioButton(gedcom.getGedcom().getDisplayName() + "   ");
            button.setSelected(gedcom.isMain());
            button.addActionListener(new ActionListener(){
                final /* synthetic */ LocalGedcomFrame val$gedcom;
                {
                    this.val$gedcom = localGedcomFrame;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.val$gedcom.setMain(true);
                }
            });
            this.buttonGroup.add(button);
            this.add(button);
        });
        boolean isSelected = false;
        Enumeration<AbstractButton> buttons = this.buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            isSelected |= buttons.nextElement().isSelected();
        }
        if (!isSelected) {
            JRadioButton button = (JRadioButton)this.buttonGroup.getElements().nextElement();
            button.doClick();
        }
    }
}

