/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.model;

public class ObjectState {
    private static final ObjectState NORMAL = new ObjectState(false, false, false, false, false, false, false);
    private boolean objectSelected;
    private boolean objectHighlighted;
    private boolean objectHovered;
    private boolean objectFocused;
    private boolean widgetHovered;
    private boolean widgetFocused;
    private boolean widgetAimed;

    private ObjectState(boolean objectSelected, boolean objectHighlighted, boolean objectHovered, boolean objectFocused, boolean widgetHovered, boolean widgetFocused, boolean widgetAimed) {
        this.objectSelected = objectSelected;
        this.objectHighlighted = objectHighlighted;
        this.objectHovered = objectHovered;
        this.objectFocused = objectFocused;
        this.widgetHovered = widgetHovered;
        this.widgetFocused = widgetFocused;
        this.widgetAimed = widgetAimed;
    }

    public boolean isSelected() {
        return this.objectSelected;
    }

    public ObjectState deriveSelected(boolean selected) {
        return new ObjectState(selected, this.objectHighlighted, this.objectHovered, this.objectFocused, this.widgetHovered, this.widgetFocused, this.widgetAimed);
    }

    public boolean isHighlighted() {
        return this.objectHighlighted;
    }

    public ObjectState deriveHighlighted(boolean highlighted) {
        return new ObjectState(this.objectSelected, highlighted, this.objectHovered, this.objectFocused, this.widgetHovered, this.widgetFocused, this.widgetAimed);
    }

    public boolean isHovered() {
        return this.objectHovered || this.widgetHovered;
    }

    public boolean isObjectHovered() {
        return this.objectHovered;
    }

    public ObjectState deriveObjectHovered(boolean hovered) {
        return new ObjectState(this.objectSelected, this.objectHighlighted, hovered, this.objectFocused, this.widgetHovered, this.widgetFocused, this.widgetAimed);
    }

    public boolean isWidgetHovered() {
        return this.widgetHovered;
    }

    public ObjectState deriveWidgetHovered(boolean hovered) {
        return new ObjectState(this.objectSelected, this.objectHighlighted, this.objectHovered, this.objectFocused, hovered, this.widgetFocused, this.widgetAimed);
    }

    public boolean isFocused() {
        return this.objectFocused || this.widgetFocused;
    }

    public boolean isObjectFocused() {
        return this.objectFocused;
    }

    public ObjectState deriveObjectFocused(boolean focused) {
        return new ObjectState(this.objectSelected, this.objectHighlighted, this.objectHovered, focused, this.widgetHovered, this.widgetFocused, this.widgetAimed);
    }

    public boolean isWidgetFocused() {
        return this.widgetFocused;
    }

    public ObjectState deriveWidgetFocused(boolean focused) {
        return new ObjectState(this.objectSelected, this.objectHighlighted, this.objectHovered, this.objectFocused, this.widgetHovered, focused, this.widgetAimed);
    }

    public boolean isWidgetAimed() {
        return this.widgetAimed;
    }

    public ObjectState deriveWidgetAimed(boolean aimed) {
        return new ObjectState(this.objectSelected, this.objectHighlighted, this.objectHovered, this.objectFocused, this.widgetHovered, this.widgetFocused, aimed);
    }

    public static ObjectState createNormal() {
        return NORMAL;
    }
}

