/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import ancestris.modules.views.tree.style.Style;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.tree.Bookmark;
import genj.tree.GridCache;
import genj.tree.ModelListener;
import genj.tree.Parser;
import genj.tree.TreeArc;
import genj.tree.TreeMetrics;
import genj.tree.TreeNode;
import genj.tree.TreeView;
import gj.layout.LayoutException;
import gj.layout.tree.TreeLayout;
import gj.model.Node;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.windows.WindowManager;

class Model {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private final Callback callback = new Callback();
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private final Collection<TreeArc> arcs = new ArrayList<TreeArc>(100);
    private final Map<Entity, TreeNode> entities2nodes = new HashMap<Entity, TreeNode>(100);
    private final Collection<TreeNode> nodes = new ArrayList<TreeNode>(100);
    private final Rectangle bounds = new Rectangle();
    private GridCache cache = null;
    private boolean isVertical = true;
    private boolean useHorizontalStyle = false;
    private boolean isFamilies = true;
    private Style style;
    private boolean isFoldSymbols = true;
    private int maxAscendants = 20;
    private int maxDescendants = 20;
    private final Set<String> hideAncestors = new HashSet<String>();
    private final Set<String> hideAncestorsTmp = new HashSet<String>();
    private final Set<String> hideDescendants = new HashSet<String>();
    private final Set<String> hideDescendantsTmp = new HashSet<String>();
    private final Map<Indi, Fam> indi2fam = new HashMap<Indi, Fam>();
    private Entity root;
    private final List<Entity> fallbackEntities = new ArrayList<Entity>();
    private TreeView view = null;
    private final LinkedList<Bookmark> bookmarks = new LinkedList();

    public Model(TreeView view, Style style) {
        this.view = view;
        this.style = style;
    }

    public void setRoot(Entity entity) {
        if (this.root == entity) {
            return;
        }
        if (this.root != null) {
            this.root.getGedcom().removeGedcomListener((GedcomListener)this.callback);
            this.root = null;
        }
        if (entity instanceof Indi || entity instanceof Fam) {
            this.root = entity;
            this.root.getGedcom().addGedcomListener((GedcomListener)this.callback);
        }
        this.bookmarks.clear();
        this.update();
    }

    public Entity getRoot() {
        return this.root;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setVertical(boolean set) {
        if (this.isVertical == set) {
            return;
        }
        this.isVertical = set;
        this.update();
    }

    public boolean useHorizontalStyle() {
        return this.useHorizontalStyle;
    }

    public void setUseHorizontalStyle(boolean set) {
        if (this.useHorizontalStyle == set) {
            return;
        }
        this.useHorizontalStyle = set;
        this.update();
    }

    public boolean ishorizontalStyle() {
        return !this.isVertical && this.useHorizontalStyle;
    }

    public int getMaxGenerations() {
        return this.maxAscendants + this.maxDescendants;
    }

    public int getMaxAscendants() {
        return this.maxAscendants;
    }

    public void setMaxAscendants(int gen) {
        if (gen < 1) {
            gen = 1;
        }
        if (gen > 100) {
            gen = 100;
        }
        this.maxAscendants = gen;
        this.update();
    }

    public int getMaxDescendants() {
        return this.maxDescendants;
    }

    public void setMaxDescendants(int gen) {
        if (gen < 1) {
            gen = 1;
        }
        if (gen > 100) {
            gen = 100;
        }
        this.maxDescendants = gen;
        this.update();
    }

    public boolean isBendArcs() {
        return this.style.bend;
    }

    public void setBendArcs(boolean set) {
        if (this.style.bend == set) {
            return;
        }
        this.style.bend = set;
        this.update();
    }

    public boolean isFamilies() {
        return this.isFamilies;
    }

    public void setFamilies(boolean set) {
        if (this.isFamilies == set) {
            return;
        }
        this.isFamilies = set;
        this.getCenteredEntities();
        this.update();
    }

    public boolean isMarrSymbols() {
        return this.style.marr;
    }

    public void setMarrSymbols(boolean set) {
        if (this.style.marr == set) {
            return;
        }
        this.style.marr = set;
        this.update();
    }

    public void setFoldSymbols(boolean set) {
        if (this.isFoldSymbols == set) {
            return;
        }
        this.isFoldSymbols = set;
        this.update();
    }

    public boolean isFoldSymbols() {
        return this.isFoldSymbols;
    }

    public void foldAll() {
        if (!this.hideAncestorsTmp.isEmpty()) {
            this.setHideAncestorsIDs(this.hideAncestorsTmp);
        }
        if (!this.hideDescendantsTmp.isEmpty()) {
            this.setHideDescendantsIDs(this.hideDescendantsTmp);
        }
        this.update();
    }

    public void unfoldAll() {
        this.hideAncestorsTmp.clear();
        this.hideAncestorsTmp.addAll(this.hideAncestors);
        this.setHideAncestorsIDs(new ArrayList<String>());
        this.hideDescendantsTmp.clear();
        this.hideDescendantsTmp.addAll(this.hideDescendants);
        this.setHideDescendantsIDs(new ArrayList<String>());
        this.update();
    }

    public void setStyle(Style set) {
        if (set == null || this.style.equals(set)) {
            return;
        }
        this.style = set;
        this.update();
    }

    public Style getStyle() {
        return this.style;
    }

    public boolean isRoundedRectangle() {
        return this.style.roundrect;
    }

    public void setRoundedRectangle(boolean set) {
        if (this.style.roundrect == set) {
            return;
        }
        this.style.roundrect = set;
        this.update();
    }

    public TreeMetrics getMetrics() {
        return this.style.tm;
    }

    public void setMetrics(TreeMetrics set) {
        if (this.style.tm.equals(set)) {
            return;
        }
        this.style.tm = set;
        this.update();
    }

    public void addListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public Collection<? extends TreeNode> getNodesIn(Rectangle range) {
        if (this.cache == null) {
            return new HashSet();
        }
        return new HashSet<TreeNode>(this.cache.get(range));
    }

    public Collection<TreeArc> getArcsIn(Rectangle range) {
        ArrayList<TreeArc> result = new ArrayList<TreeArc>(this.arcs.size());
        for (TreeArc arc : this.arcs) {
            if (arc.getPath() == null || !arc.getPath().intersects((Rectangle2D)range)) continue;
            result.add(arc);
        }
        return result;
    }

    public TreeNode getNodeAt(int x, int y) {
        if (this.cache == null) {
            return null;
        }
        int w = Math.max(this.style.tm.wIndis, this.style.tm.wFams);
        int h = Math.max(this.style.tm.hIndis, this.style.tm.hFams);
        Rectangle range = new Rectangle(x - w / 2, y - h / 2, w, h);
        for (TreeNode node : this.cache.get(range)) {
            Shape shape = node.getShape();
            if (shape == null || !shape.getBounds2D().contains(x - node.pos.x, y - node.pos.y)) continue;
            return node;
        }
        return null;
    }

    public Object getContentAt(int x, int y) {
        TreeNode node = this.getNodeAt(x, y);
        return node != null ? node.getContent() : null;
    }

    public Entity getEntityAt(int x, int y) {
        Object content = this.getContentAt(x, y);
        return content instanceof Entity ? (Entity)content : null;
    }

    public TreeNode getNode(Entity e) {
        return this.entities2nodes.get(e);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void addBookmark(Bookmark b) {
        this.bookmarks.addFirst(b);
        if (this.bookmarks.size() > 30) {
            this.bookmarks.removeLast();
        }
    }

    public void removeBookmark(Bookmark b) {
        this.bookmarks.remove(b);
    }

    public List<Bookmark> getBookmarks() {
        return Collections.unmodifiableList(this.bookmarks);
    }

    public void setBookmarks(List<Bookmark> set) {
        this.bookmarks.clear();
        this.bookmarks.addAll(set);
    }

    public Bookmark existingBookmark(Entity e) {
        for (Bookmark bookmark : this.bookmarks) {
            if (bookmark.getEntity() == null || !bookmark.getEntity().equals(e)) continue;
            return bookmark;
        }
        return null;
    }

    public Collection<String> getHideAncestorsIDs() {
        return this.hideAncestors;
    }

    public void setHideAncestorsIDs(Collection<String> ids) {
        this.hideAncestors.clear();
        this.hideAncestors.addAll(ids);
    }

    public Collection<String> getHideDescendantsIDs() {
        return this.hideDescendants;
    }

    public void setHideDescendantsIDs(Collection<String> ids) {
        this.hideDescendants.clear();
        this.hideDescendants.addAll(ids);
    }

    boolean isHideDescendants(Indi indi) {
        return this.hideDescendants.contains(indi.getId());
    }

    boolean isHideAncestors(Indi indi) {
        return this.hideAncestors.contains(indi.getId());
    }

    Fam getFamily(Indi indi, Fam[] fams) {
        return this.getFamily(indi, fams, null);
    }

    Fam getFamily(Indi indi, Fam[] fams, Entity entity) {
        if (indi == null) {
            return null;
        }
        if (fams.length > 0) {
            Fam fam = this.indi2fam.get(indi);
            if (fam == null) {
                fam = indi.getPreferredFamily();
            }
            if (entity == null) {
                return fam;
            }
            if (entity instanceof Fam) {
                Fam famE;
                fam = famE = (Fam)entity;
            } else if (entity instanceof Indi) {
                Indi spouse = (Indi)entity;
                for (Fam fam1 : fams) {
                    if (fam1.getOtherSpouse(indi) != spouse) continue;
                    fam = fam1;
                    break;
                }
            }
            for (int f = 0; f < fams.length; ++f) {
                if (fams[f] != fam) continue;
                return fams[(f + 1) % fams.length];
            }
            this.indi2fam.remove(indi);
        }
        return fams[0];
    }

    TreeNode add(TreeNode node) {
        Object content = node.getContent();
        if (content instanceof Entity) {
            Entity entity = (Entity)content;
            this.entities2nodes.put(entity, node);
        }
        this.nodes.add(node);
        return node;
    }

    TreeArc add(TreeArc arc) {
        this.arcs.add(arc);
        return arc;
    }

    Set<Entity> getEntities() {
        return this.entities2nodes.keySet();
    }

    private void update() {
        WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        this.arcs.clear();
        this.nodes.clear();
        this.entities2nodes.clear();
        this.bounds.setFrame(0.0, 0.0, 0.0, 0.0);
        if (this.root == null) {
            this.fireStructureChanged();
            WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        try {
            boolean isFams = this.isFamilies || this.root instanceof Fam;
            Parser descendants = Parser.getInstance(false, isFams, this, this.style.tm);
            this.bounds.add(this.layout(descendants.parse(this.root), true));
            this.bounds.add(this.layout(descendants.align(Parser.getInstance(true, isFams, this, this.style.tm).parse(this.root)), false));
        }
        catch (LayoutException e) {
            LOG.log(Level.INFO, "Layout exception :", e);
            this.root = null;
            this.update();
            WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.cache = new GridCache(this.bounds, 3 * this.style.tm.calcMax());
        for (TreeNode n : this.nodes) {
            if (n.shape == null) continue;
            this.cache.put(n, n.shape.getBounds(), n.pos);
        }
        this.fireStructureChanged();
        WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
    }

    private Rectangle layout(TreeNode root, boolean isTopDown) throws LayoutException {
        double theta = 0.0;
        if (!isTopDown) {
            theta += 180.0;
        }
        if (!this.isVertical) {
            theta -= 90.0;
        }
        TreeLayout layout = new TreeLayout();
        layout.setBendArcs(this.style.bend);
        layout.setDebug(false);
        layout.setIgnoreUnreachables(true);
        layout.setBalanceChildren(false);
        layout.setRoot((Node)root);
        layout.setOrientation(theta);
        Rectangle bds = layout.layout((Node)root, this.nodes.size()).getBounds();
        return new Rectangle(bds.x - 12, bds.y - 12, bds.width + 24, bds.height + 24);
    }

    private void fireStructureChanged() {
        for (int l = this.listeners.size() - 1; l >= 0; --l) {
            this.listeners.get(l).structureChanged(this);
        }
    }

    private void fireNodesChanged(Collection<TreeNode> nodes) {
        for (int l = this.listeners.size() - 1; l >= 0; --l) {
            this.listeners.get(l).nodesChanged(this, nodes);
        }
    }

    public void getCenteredEntities() {
        Point p = this.view.getCenter();
        if (p == null) {
            return;
        }
        int x = p.x;
        int y = p.y;
        int s = 0;
        int inc = 10;
        Entity entity = null;
        while (entity == null) {
            entity = this.getEntityAt(x, y - s);
            if (y - (s += inc) < this.bounds.y) {
                inc = -10;
                y = p.y;
                s = 0;
            }
            if (y - s <= this.bounds.y + this.bounds.height) continue;
        }
        if (entity == null) {
            return;
        }
        this.fallbackEntities.clear();
        this.fallbackEntities.add(entity);
        if (entity instanceof Fam) {
            Indi wife;
            Fam fam = (Fam)entity;
            this.fallbackEntities.add(entity);
            Indi husb = fam.getHusband();
            if (husb != null) {
                this.fallbackEntities.add((Entity)husb);
            }
            if ((wife = fam.getWife()) != null) {
                this.fallbackEntities.add((Entity)wife);
            }
        }
    }

    public List<Entity> getDefaultEntities() {
        return this.fallbackEntities;
    }

    public void clearDefaultEntities() {
        this.fallbackEntities.clear();
    }

    private class Callback
    extends GedcomListenerAdapter {
        private final Set<TreeNode> repaint = new HashSet<TreeNode>();
        private boolean update = false;
        private Entity added;
        private boolean isFamAdded = false;

        private Callback() {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
            this.added = null;
            this.repaint.clear();
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            if (this.isFamAdded) {
                Model.this.setFamilies(true);
                Model.this.view.forceFamilies(true);
                this.isFamAdded = false;
            }
            if (Model.this.root != null && this.added != null && this.added instanceof Indi) {
                Indi addedIndi = (Indi)this.added;
                Fam newRoot = null;
                if (!this.isDirectOf(addedIndi, Model.this.root)) {
                    Fam[] fams = addedIndi.getFamiliesWhereChild();
                    if (fams != null && fams.length != 0) {
                        newRoot = fams[0];
                    } else {
                        Indi[] children = addedIndi.getChildren();
                        if (children != null && children.length != 0) {
                            newRoot = children[0];
                        }
                    }
                }
                if (newRoot != null) {
                    Model.this.root = newRoot;
                    Model.this.view.setRoot(Model.this.root);
                    Model.this.update();
                    return;
                }
            }
            if (Model.this.root == null) {
                if (this.added == null || !gedcom.contains(this.added)) {
                    Model.this.getCenteredEntities();
                    boolean found = false;
                    for (Entity ent : Model.this.fallbackEntities) {
                        if (ent == null || !gedcom.contains(ent)) continue;
                        this.added = ent;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.added = gedcom.getFirstEntity("INDI");
                    }
                }
                Model.this.root = this.added;
                Model.this.view.setRoot(Model.this.root);
                Model.this.update();
                return;
            }
            if (this.update) {
                Model.this.update();
                return;
            }
            if (!this.repaint.isEmpty()) {
                Model.this.fireNodesChanged(this.repaint);
            }
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity added) {
            if (added instanceof Fam || added instanceof Indi) {
                if (!(this.added instanceof Indi) && added instanceof Indi) {
                    this.added = added;
                }
                if (!this.isFamAdded) {
                    this.isFamAdded = added instanceof Fam;
                }
            }
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (entity == Model.this.root) {
                Model.this.root = null;
            }
            ListIterator it = Model.this.bookmarks.listIterator();
            while (it.hasNext()) {
                Bookmark b = (Bookmark)it.next();
                if (entity != b.getEntity()) continue;
                it.remove();
            }
            if (entity instanceof Indi) {
                Indi indien = (Indi)entity;
                Model.this.indi2fam.keySet().remove(indien);
            }
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            this.gedcomPropertyChanged(gedcom, added);
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            if (property instanceof PropertyXRef) {
                this.update = true;
                return;
            }
            if (property.getTag().equals("_PREF")) {
                Indi wife;
                Fam fam = (Fam)property.getEntity();
                Indi husb = fam.getHusband();
                if (husb != null) {
                    Model.this.indi2fam.keySet().remove(husb);
                }
                if ((wife = fam.getWife()) != null) {
                    Model.this.indi2fam.keySet().remove(wife);
                }
                this.update = true;
                return;
            }
            TreeNode node = Model.this.getNode(property.getEntity());
            if (node != null) {
                this.repaint.add(Model.this.getNode(property.getEntity()));
            }
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
            if (deleted instanceof PropertyXRef) {
                this.update = true;
            }
            if (Model.this.root != null) {
                this.repaint.add(Model.this.getNode(property.getEntity()));
            }
        }

        private boolean isDirectOf(Indi addedIndi, Entity root) {
            if (root instanceof Indi) {
                Indi indi = (Indi)root;
                return addedIndi.isAncestorOf(indi) || addedIndi.isDescendantOf(indi);
            }
            if (root instanceof Fam) {
                Fam fam = (Fam)root;
                return addedIndi.isAncestorOf(fam) && !addedIndi.isDescendantOf(fam);
            }
            return false;
        }
    }

    class FoldUnfold
    implements Runnable {
        private final Indi indi;
        private final Set<String> set;

        protected FoldUnfold(Indi individual, boolean ancestors) {
            this.indi = individual;
            this.set = ancestors ? Model.this.hideAncestors : Model.this.hideDescendants;
        }

        @Override
        public void run() {
            if (!this.set.remove(this.indi.getId())) {
                this.set.add(this.indi.getId());
            }
            Model.this.fallbackEntities.clear();
            Model.this.fallbackEntities.add((Entity)this.indi);
            Model.this.update();
        }

        public void fold() {
            this.set.add(this.indi.getId());
            Model.this.update();
        }

        public void unfold() {
            this.set.remove(this.indi.getId());
            Model.this.update();
        }
    }

    class NextFamily
    implements Runnable {
        private final Indi indi;
        private final Fam fam;

        protected NextFamily(Indi individual, Fam[] fams, Entity entity) {
            this.indi = individual;
            this.fam = Model.this.getFamily(this.indi, fams, entity);
        }

        @Override
        public void run() {
            Model.this.indi2fam.put(this.indi, this.fam);
            Model.this.fallbackEntities.clear();
            Model.this.fallbackEntities.add((Entity)this.indi);
            boolean isRoot = Model.this.root == this.indi;
            boolean isDescendantOfRoot = Model.this.root instanceof Indi && ((Indi)Model.this.root).isAncestorOf(this.indi);
            Entity entity = Model.this.root;
            if (entity instanceof Fam) {
                Fam f = (Fam)entity;
                Indi husb = f.getHusband();
                Indi wife = f.getWife();
                boolean bl = isDescendantOfRoot = husb != null && husb.isDescendantOf(this.indi) || wife != null && wife.isAncestorOf(this.indi);
            }
            if (!isRoot && !isDescendantOfRoot) {
                Model.this.view.setRoot((Entity)this.indi);
            }
            Model.this.update();
            SelectionDispatcher.fireSelection((Context)new Context((Entity)this.fam));
        }

        public boolean isEmpty() {
            return this.indi == null;
        }

        public int getSex() {
            return this.indi.getSex();
        }

        public Entity getSpouse() {
            return this.fam.getOtherSpouse(this.indi);
        }
    }
}

