/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ContentHandlerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.InternalSystemBundle;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.UniversalUniqueIdentifier;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.PackageSource;
import org.eclipse.osgi.internal.loader.SystemBundleLoader;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.internal.serviceregistry.HookContext;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.util.tracker.ServiceTracker;

public class Framework
implements EventPublisher,
Runnable {
    private static final String PROP_CONTEXTCLASSLOADER_PARENT = "osgi.contextClassLoaderParent";
    private static final String CONTEXTCLASSLOADER_PARENT_APP = "app";
    private static final String CONTEXTCLASSLOADER_PARENT_EXT = "ext";
    private static final String CONTEXTCLASSLOADER_PARENT_BOOT = "boot";
    private static final String CONTEXTCLASSLOADER_PARENT_FWK = "fwk";
    public static final String PROP_FRAMEWORK_THREAD = "osgi.framework.activeThreadType";
    public static final String THREAD_NORMAL = "normal";
    public static final String PROP_EQUINOX_SECURITY = "eclipse.security";
    public static final String SECURITY_OSGI = "osgi";
    private static String J2SE = "J2SE-";
    private static String JAVASE = "JavaSE-";
    private static String PROFILE_EXT = ".profile";
    protected volatile FrameworkAdaptor adaptor;
    protected Properties properties;
    protected volatile boolean active;
    private FrameworkEvent[] shutdownEvent;
    protected BundleRepository bundles;
    protected volatile PackageAdminImpl packageAdmin;
    protected SecurityAdmin securityAdmin;
    protected StartLevelManager startLevelManager;
    private volatile ServiceRegistry serviceRegistry;
    private final int BSN_VERSION;
    private static final int BSN_VERSION_SINGLE = 1;
    private static final int BSN_VERSION_MULTIPLE = 2;
    private static final int BSN_VERSION_MANAGED = 3;
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> allBundleListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>>();
    protected static final int BUNDLEEVENT = 1;
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> allSyncBundleListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>>();
    protected static final int BUNDLEEVENTSYNC = 2;
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> allFrameworkListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>>();
    protected static final int FRAMEWORKEVENT = 4;
    protected static final int BATCHEVENT_BEGIN = -2147483647;
    protected static final int BATCHEVENT_END = Integer.MIN_VALUE;
    static final String eventHookName = EventHook.class.getName();
    static final String findHookName = FindHook.class.getName();
    static final String collisionHookName = CollisionHook.class.getName();
    protected volatile EventManager eventManager;
    private Map<String, Thread> installLock;
    protected InternalSystemBundle systemBundle;
    private String[] bootDelegation;
    private String[] bootDelegationStems;
    private boolean bootDelegateAll = false;
    public final boolean contextBootDelegation = "true".equals(FrameworkProperties.getProperty("osgi.context.bootdelegation", "true"));
    public final boolean compatibiltyBootDelegation = "true".equals(FrameworkProperties.getProperty(Constants.OSGI_COMPATIBILITY_BOOTDELEGATION, "true"));
    private final boolean allowRefreshDuplicateBSN = Boolean.TRUE.toString().equals(FrameworkProperties.getProperty("equinox.refresh.duplicate.bsn", "true"));
    ClassLoaderDelegateHook[] delegateHooks;
    private volatile boolean forcedRestart = false;
    protected static AliasMapper aliasMapper = new AliasMapper();
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final Map<Long, Map<String, AdminPermission>> adminPermissions = new HashMap<Long, Map<String, AdminPermission>>();
    private StreamHandlerFactory streamHandlerFactory;
    private org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory;
    private volatile ServiceTracker<SignedContentFactory, SignedContentFactory> signedContentFactory;
    private volatile ContextFinder contextFinder;

    public Framework(FrameworkAdaptor frameworkAdaptor) {
        BundleData[] bundleDataArray;
        String string;
        if (Profile.STARTUP) {
            Profile.logEnter("Framework.initialze()", null);
        }
        this.BSN_VERSION = "single".equals(string = FrameworkProperties.getProperty("org.osgi.framework.bsnversion")) ? 1 : ("multiple".equals(string) ? 2 : 3);
        long l = System.currentTimeMillis();
        this.adaptor = frameworkAdaptor;
        this.delegateHooks = frameworkAdaptor instanceof BaseAdaptor ? ((BaseAdaptor)frameworkAdaptor).getHookRegistry().getClassLoaderDelegateHooks() : null;
        this.active = false;
        this.installSecurityManager();
        if (Debug.DEBUG_SECURITY) {
            Debug.println("SecurityManager: " + System.getSecurityManager());
            Debug.println("ProtectionDomain of Framework.class: \n" + this.getClass().getProtectionDomain());
        }
        this.setNLSFrameworkLog();
        this.initializeContextFinder();
        frameworkAdaptor.initialize(this);
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter initialized");
        }
        try {
            frameworkAdaptor.initializeStorage();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter storage initialized");
        }
        this.initializeProperties(frameworkAdaptor.getProperties());
        this.packageAdmin = new PackageAdminImpl(this);
        try {
            this.securityAdmin = new SecurityAdmin(null, this, frameworkAdaptor.getPermissionStorage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done init props & new PermissionAdminImpl");
        }
        this.startLevelManager = new StartLevelManager(this);
        this.eventManager = new EventManager("Framework Event Dispatcher");
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new EventManager");
        }
        this.serviceRegistry = new ServiceRegistry(this);
        this.installLock = new HashMap<String, Thread>(10);
        this.createSystemBundle();
        this.loadVMProfile();
        this.setBootDelegation();
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done createSystemBundle");
        }
        this.installURLStreamHandlerFactory(this.systemBundle.context, frameworkAdaptor);
        this.installContentHandlerFactory(this.systemBundle.context, frameworkAdaptor);
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new URLStream/Content HandlerFactory");
        }
        this.bundles = new BundleRepository((bundleDataArray = frameworkAdaptor.getInstalledBundles()) == null ? 10 : bundleDataArray.length + 1);
        this.bundles.add(this.systemBundle);
        if (bundleDataArray != null) {
            for (int i = 0; i < bundleDataArray.length; ++i) {
                try {
                    AbstractBundle abstractBundle = AbstractBundle.createBundle(bundleDataArray[i], this, true);
                    this.bundles.add(abstractBundle);
                    continue;
                }
                catch (BundleException bundleException) {
                    this.publishFrameworkEvent(2, this.systemBundle, bundleException);
                }
            }
        }
        if (Debug.DEBUG_GENERAL) {
            System.out.println("Initialize the framework: " + (System.currentTimeMillis() - l));
        }
        if (Profile.STARTUP) {
            Profile.logExit("Framework.initialize()");
        }
    }

    public FrameworkAdaptor getAdaptor() {
        return this.adaptor;
    }

    public ClassLoaderDelegateHook[] getDelegateHooks() {
        return this.delegateHooks;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    private void setNLSFrameworkLog() {
        try {
            Field field = NLS.class.getDeclaredField("frameworkLog");
            field.setAccessible(true);
            field.set(null, this.adaptor.getFrameworkLog());
        }
        catch (Exception exception) {
            this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, exception.getMessage(), 0, exception, null));
        }
    }

    private void createSystemBundle() {
        try {
            this.systemBundle = new InternalSystemBundle(this);
            this.systemBundle.getBundleData().setBundle(this.systemBundle);
        }
        catch (BundleException bundleException) {
            bundleException.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, bundleException.getMessage()), bundleException);
        }
    }

    protected void initializeProperties(Properties properties) {
        String string;
        this.properties = FrameworkProperties.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (this.properties.getProperty(string) != null) continue;
            this.properties.put(string, properties.getProperty(string));
        }
        this.properties.put("org.osgi.framework.vendor", "Eclipse");
        this.properties.put("org.osgi.framework.version", "1.3");
        string = this.properties.getProperty("org.osgi.framework.processor");
        if (string == null && (string = this.properties.getProperty("os.arch")) != null) {
            this.properties.put("org.osgi.framework.processor", aliasMapper.aliasProcessor(string));
        }
        if ((string = this.properties.getProperty("org.osgi.framework.os.name")) == null) {
            string = this.properties.getProperty("os.name");
            try {
                String string2 = (String)aliasMapper.aliasOSName(string);
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (string != null) {
                this.properties.put("org.osgi.framework.os.name", string);
            }
        }
        if ((string = this.properties.getProperty("org.osgi.framework.os.version")) == null && (string = this.properties.getProperty("os.version")) != null) {
            int n = string.indexOf(32);
            if (n > 0) {
                string = string.substring(0, n);
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string3 = "";
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
                n2 = this.parseVersionInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    n3 = this.parseVersionInt(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                        n4 = this.parseVersionInt(stringTokenizer.nextToken());
                        if (stringTokenizer.hasMoreTokens()) {
                            stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                        }
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                string = new Version(n2, n3, n4, string3).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = new Version(n2, n3, n4).toString();
            }
            this.properties.put("org.osgi.framework.os.version", string);
        }
        if ((string = this.properties.getProperty("org.osgi.framework.language")) == null) {
            this.properties.put("org.osgi.framework.language", Locale.getDefault().getLanguage());
        }
        this.properties.put("org.osgi.supports.framework.fragment", "true");
        this.properties.put("org.osgi.supports.framework.requirebundle", "true");
        this.properties.put("org.osgi.framework.uuid", new UniversalUniqueIdentifier().toString());
    }

    private int parseVersionInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length && Character.isDigit(cArray[i]); ++i) {
                stringBuffer.append(cArray[i]);
            }
            if (stringBuffer.length() > 0) {
                return Integer.parseInt(stringBuffer.toString());
            }
            return 0;
        }
    }

    private void setBootDelegation() {
        String string = this.properties.getProperty("org.osgi.framework.bootdelegation");
        if (string == null) {
            return;
        }
        if (string.trim().length() == 0) {
            return;
        }
        String[] stringArray = ManifestElement.getArrayFromList(string);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("*")) {
                this.bootDelegateAll = true;
                return;
            }
            if (stringArray[i].endsWith("*")) {
                if (stringArray[i].length() <= 2 || !stringArray[i].endsWith(".*")) continue;
                arrayList2.add(stringArray[i].substring(0, stringArray[i].length() - 1));
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        if (!arrayList.isEmpty()) {
            this.bootDelegation = arrayList.toArray(new String[arrayList.size()]);
        }
        if (!arrayList2.isEmpty()) {
            this.bootDelegationStems = arrayList2.toArray(new String[arrayList2.size()]);
        }
    }

    private void loadVMProfile() {
        String string;
        Properties properties = this.findVMProfile();
        String string2 = this.properties.getProperty("org.osgi.framework.system.packages");
        if (string2 == null && (string2 = properties.getProperty("org.osgi.framework.system.packages")) != null) {
            this.properties.put("org.osgi.framework.system.packages", string2);
        }
        String string3 = this.properties.getProperty("osgi.java.profile.bootdelegation");
        String string4 = properties.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(string3)) {
            if (string4 == null) {
                this.properties.remove("org.osgi.framework.bootdelegation");
            } else {
                this.properties.put("org.osgi.framework.bootdelegation", string4);
            }
        } else if ("none".equals(string3)) {
            this.properties.remove("org.osgi.framework.bootdelegation");
        }
        if (this.properties.getProperty("org.osgi.framework.executionenvironment") == null && (string = properties.getProperty("org.osgi.framework.executionenvironment", properties.getProperty("osgi.java.profile.name"))) != null) {
            this.properties.put("org.osgi.framework.executionenvironment", string);
        }
        if (this.properties.getProperty("org.osgi.framework.system.capabilities") == null && (string = properties.getProperty("org.osgi.framework.system.capabilities")) != null) {
            this.properties.put("org.osgi.framework.system.capabilities", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties findVMProfile() {
        Object object;
        Object object2;
        Object object3;
        Properties properties = new Properties();
        String string = this.properties.getProperty("microedition.configuration");
        String string2 = this.properties.getProperty("microedition.profiles");
        String string3 = null;
        String string4 = null;
        Version version = null;
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            object3 = ManifestElement.getArrayFromList(string2, " ");
            if (object3 != null && ((String[])object3).length > 0) {
                string3 = string + '_' + (String)object3[((Object)object3).length - 1];
            }
        } else {
            object3 = this.properties.getProperty("java.specification.version");
            if (object3 != null) {
                object2 = new StringTokenizer((String)object3, " _-");
                object3 = ((StringTokenizer)object2).nextToken();
                object = this.properties.getProperty("java.specification.name");
                if (object != null && (((String)object).indexOf("Foundation Specification") >= 0 || ((String)object).indexOf("Foundation Profile Specification") >= 0)) {
                    string3 = "CDC-" + (String)object3 + "_Foundation-" + (String)object3;
                } else {
                    Version version2 = new Version("1.6");
                    string4 = J2SE;
                    try {
                        version = new Version((String)object3);
                        if (version2.compareTo(version) <= 0) {
                            string4 = JAVASE;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    string3 = string4 + (String)object3;
                }
            }
        }
        object3 = null;
        object2 = FrameworkProperties.getProperty("osgi.java.profile");
        if (object2 != null) {
            try {
                object3 = new URL((String)object2);
            }
            catch (MalformedURLException malformedURLException) {
                object3 = this.findInSystemBundle((String)object2);
            }
        }
        if (object3 == null && string3 != null && (object3 = this.findInSystemBundle((String)(object = string3 + PROFILE_EXT))) == null) {
            object3 = this.getNextBestProfile(string4, version);
        }
        if (object3 == null) {
            object3 = this.findInSystemBundle("OSGi_Minimum-1.2.profile");
        }
        if (object3 != null) {
            object = null;
            try {
                object = ((URL)object3).openStream();
                properties.load(new BufferedInputStream((InputStream)object));
            }
            catch (IOException iOException) {
            }
            finally {
                if (object != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (properties.getProperty("osgi.java.profile.name") == null) {
            if (string3 != null) {
                properties.put("osgi.java.profile.name", string3.replace('_', '/'));
            } else {
                properties.put("osgi.java.profile.name", "OSGi/Minimum-1.2");
            }
        }
        return properties;
    }

    private URL getNextBestProfile(String string, Version version) {
        if (version == null || string != J2SE && string != JAVASE) {
            return null;
        }
        URL uRL = this.findNextBestProfile(string, version);
        if (uRL == null && string == JAVASE) {
            uRL = this.findNextBestProfile(J2SE, version);
        }
        return uRL;
    }

    private URL findNextBestProfile(String string, Version version) {
        URL uRL = null;
        int n = version.getMajor();
        int n2 = version.getMinor();
        do {
            uRL = this.findInSystemBundle(string + n + "." + n2 + PROFILE_EXT);
            if (n > 9) {
                --n;
                continue;
            }
            if (n == 9) {
                n2 = n - 1;
                n = 1;
                continue;
            }
            --n2;
        } while (uRL == null && (n2 > 0 || n > 1));
        return uRL;
    }

    private URL findInSystemBundle(String string) {
        URL uRL = this.systemBundle.getEntry0(string);
        if (uRL == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        }
        return uRL;
    }

    protected boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.adaptor == null) {
            return;
        }
        if (this.active) {
            this.shutdown(64);
        }
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List<AbstractBundle> list = this.bundles.getBundles();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AbstractBundle abstractBundle = list.get(i);
                abstractBundle.close();
            }
            this.bundles.removeAllBundles();
        }
        this.serviceRegistry = null;
        this.allBundleListeners.clear();
        this.allSyncBundleListeners.clear();
        this.allFrameworkListeners.clear();
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        this.packageAdmin = null;
        this.adaptor = null;
        this.uninstallURLStreamHandlerFactory();
        this.uninstallContentHandlerFactory();
        if (System.getSecurityManager() instanceof EquinoxSecurityManager) {
            System.setSecurityManager(null);
        }
    }

    public synchronized void launch() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.shutdownEvent = new FrameworkEvent[1];
        if (THREAD_NORMAL.equals(FrameworkProperties.getProperty(PROP_FRAMEWORK_THREAD, THREAD_NORMAL))) {
            Thread thread = new Thread((Runnable)this, "Framework Active Thread");
            thread.setDaemon(false);
            thread.start();
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to launch framework");
        }
        this.systemBundle.resume();
        this.signedContentFactory = new ServiceTracker(this.systemBundle.getBundleContext(), SignedContentFactory.class.getName(), null);
        this.signedContentFactory.open();
    }

    public synchronized void shutdown(int n) {
        if (!this.active) {
            return;
        }
        this.shutdownEvent[0] = new FrameworkEvent(n, this.systemBundle, null);
        this.systemBundle.state = 16;
        this.publishBundleEvent(256, this.systemBundle);
        try {
            this.adaptor.frameworkStopping(this.systemBundle.getContext());
        }
        catch (Throwable throwable) {
            this.publishFrameworkEvent(2, this.systemBundle, throwable);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to shutdown Framework");
        }
        this.systemBundle.suspend();
        try {
            this.adaptor.compactStorage();
        }
        catch (IOException iOException) {
            this.publishFrameworkEvent(2, this.systemBundle, iOException);
        }
        if (this.signedContentFactory != null) {
            this.signedContentFactory.close();
        }
        this.active = false;
        this.notifyAll();
    }

    AbstractBundle createAndVerifyBundle(int n, Bundle bundle, BundleData bundleData, boolean bl) throws BundleException {
        if (this.BSN_VERSION != 2 && bundleData.getSymbolicName() != null) {
            List<AbstractBundle> list = this.getBundleBySymbolicName(bundleData.getSymbolicName(), bundleData.getVersion());
            if (n == 2) {
                list.remove(bundle);
            }
            if (this.BSN_VERSION == 3 && !list.isEmpty()) {
                this.notifyCollisionHooks(n, bundle, list);
            }
            if (!list.isEmpty()) {
                Bundle bundle2 = list.iterator().next();
                String string = NLS.bind(Msg.BUNDLE_INSTALL_SAME_UNIQUEID, new Object[]{bundle2.getSymbolicName(), bundle2.getVersion().toString(), bundle2.getLocation()});
                throw new DuplicateBundleException(string, bundle2);
            }
        }
        return AbstractBundle.createBundle(bundleData, this, bl);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    protected String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    protected Object setProperty(String string, String string2) {
        return this.properties.put(string, string2);
    }

    AbstractBundle installBundle(final String string, final InputStream inputStream, final BundleContextImpl bundleContextImpl) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from inputstream: " + string + ", " + inputStream);
        }
        final AccessControlContext accessControlContext = AccessController.getContext();
        return this.installWorker(string, new PrivilegedExceptionAction<AbstractBundle>(){

            @Override
            public AbstractBundle run() throws BundleException {
                URLConnection uRLConnection = inputStream != null ? new BundleSource(inputStream) : Framework.this.adaptor.mapLocationToURLConnection(string);
                return Framework.this.installWorkerPrivileged(string, uRLConnection, accessControlContext, bundleContextImpl);
            }
        }, bundleContextImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle installWorker(String string, PrivilegedExceptionAction<AbstractBundle> privilegedExceptionAction, BundleContext bundleContext) throws BundleException {
        Object object;
        Object object2 = this.installLock;
        synchronized (object2) {
            while (true) {
                Object object3;
                Object object4;
                if ((object = this.getBundleByLocation(string)) != null) {
                    object4 = bundleContext.getBundle(((AbstractBundle)object).getBundleId());
                    if (object4 == null) {
                        object3 = ((AbstractBundle)object).getBundleData();
                        String string2 = NLS.bind(Msg.BUNDLE_INSTALL_SAME_UNIQUEID, new Object[]{object3.getSymbolicName(), object3.getVersion().toString(), object3.getLocation()});
                        throw new BundleException(string2, 12);
                    }
                    return object;
                }
                object4 = Thread.currentThread();
                object3 = this.installLock.put(string, (Thread)object4);
                if (object3 == null) break;
                if (object4.equals(object3)) {
                    throw new BundleException(Msg.BUNDLE_INSTALL_RECURSION_EXCEPTION, 7);
                }
                try {
                    this.installLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new BundleException("Thread has been interrupted while waiting for the location lock.", interruptedException);
                }
            }
        }
        try {
            object2 = AccessController.doPrivileged(privilegedExceptionAction);
            this.publishBundleEvent(new BundleEvent(1, (Bundle)object2, bundleContext.getBundle()));
            object = object2;
            return object;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof RuntimeException) {
                throw (RuntimeException)privilegedActionException.getException();
            }
            throw (BundleException)privilegedActionException.getException();
        }
        finally {
            Map<String, Thread> map = this.installLock;
            synchronized (map) {
                this.installLock.remove(string);
                this.installLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle installWorkerPrivileged(String string, URLConnection uRLConnection, AccessControlContext accessControlContext, BundleContextImpl bundleContextImpl) throws BundleException {
        AbstractBundle abstractBundle;
        BundleOperation bundleOperation = this.adaptor.installBundle(string, uRLConnection);
        try {
            BundleData bundleData = bundleOperation.begin();
            abstractBundle = this.createAndVerifyBundle(1, bundleContextImpl.getBundle(), bundleData, true);
            BundleWatcher bundleWatcher = this.adaptor.getBundleWatcher();
            if (bundleWatcher != null) {
                bundleWatcher.watchBundle(abstractBundle, 1);
            }
            try {
                abstractBundle.load();
                if (System.getSecurityManager() != null) {
                    boolean bl;
                    boolean bl2 = bl = (bundleData.getType() & 0x16) != 0;
                    if (bl && !abstractBundle.hasPermission(new AllPermission())) {
                        throw new BundleException(Msg.BUNDLE_EXTENSION_PERMISSION, 6, new SecurityException(Msg.BUNDLE_EXTENSION_PERMISSION));
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                Framework.this.checkAdminPermission(abstractBundle, "lifecycle");
                                if (bl) {
                                    Framework.this.checkAdminPermission(abstractBundle, "extensionLifecycle");
                                }
                                return null;
                            }
                        }, accessControlContext);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
                this.bundles.add(abstractBundle);
                bundleOperation.commit(false);
            }
            catch (Throwable throwable) {
                this.bundles.remove(abstractBundle);
                BundleRepository bundleRepository = this.bundles;
                synchronized (bundleRepository) {
                    abstractBundle.unload();
                }
                abstractBundle.close();
                throw throwable;
            }
            finally {
                if (bundleWatcher != null) {
                    bundleWatcher.watchBundle(abstractBundle, 2);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                bundleOperation.undo();
            }
            catch (BundleException bundleException) {
                this.publishFrameworkEvent(2, this.systemBundle, bundleException);
            }
            if (throwable instanceof SecurityException) {
                throw (SecurityException)throwable;
            }
            if (throwable instanceof BundleException) {
                throw (BundleException)throwable;
            }
            throw new BundleException(throwable.getMessage(), throwable);
        }
        return abstractBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundle(long l) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(l);
        }
    }

    AbstractBundle getBundle(BundleContextImpl bundleContextImpl, long l) {
        AbstractBundle abstractBundle = this.getBundle(l);
        if (abstractBundle == null || bundleContextImpl.getBundle().getBundleId() == 0L) {
            return abstractBundle;
        }
        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>(1);
        arrayList.add(abstractBundle);
        this.notifyFindHooks(bundleContextImpl, arrayList);
        return arrayList.size() == 0 ? null : abstractBundle;
    }

    public BundleContextImpl getSystemBundleContext() {
        if (this.systemBundle == null) {
            return null;
        }
        return this.systemBundle.context;
    }

    public PackageAdminImpl getPackageAdmin() {
        return this.packageAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractBundle> getBundleBySymbolicName(String string, Version version) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundles(string, version);
        }
    }

    protected BundleRepository getBundles() {
        return this.bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getAllBundles() {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List<AbstractBundle> list = this.bundles.getBundles();
            int n = list.size();
            if (n == 0) {
                return null;
            }
            AbstractBundle[] abstractBundleArray = new AbstractBundle[n];
            list.toArray(abstractBundleArray);
            return abstractBundleArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractBundle[] getBundles(BundleContextImpl bundleContextImpl) {
        ArrayList<AbstractBundle> arrayList;
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            arrayList = new ArrayList<AbstractBundle>(this.bundles.getBundles());
        }
        this.notifyFindHooks(bundleContextImpl, arrayList);
        return arrayList.toArray(new AbstractBundle[arrayList.size()]);
    }

    private void notifyFindHooks(final BundleContextImpl bundleContextImpl, List<AbstractBundle> list) {
        final ShrinkableCollection<Bundle> shrinkableCollection = new ShrinkableCollection<Bundle>((Collection<Bundle>)list);
        if (System.getSecurityManager() == null) {
            this.notifyFindHooksPriviledged(bundleContextImpl, shrinkableCollection);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Framework.this.notifyFindHooksPriviledged(bundleContextImpl, shrinkableCollection);
                    return null;
                }
            });
        }
    }

    void notifyFindHooksPriviledged(final BundleContextImpl bundleContextImpl, final Collection<Bundle> collection) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println("notifyBundleFindHooks(" + collection + ")");
        }
        this.getServiceRegistry().notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object object, ServiceRegistration<?> serviceRegistration) throws Exception {
                if (object instanceof FindHook) {
                    ((FindHook)object).find(bundleContextImpl, collection);
                }
            }

            @Override
            public String getHookClassName() {
                return findHookName;
            }

            @Override
            public String getHookMethodName() {
                return "find";
            }
        });
    }

    private void notifyCollisionHooks(final int n, final Bundle bundle, List<AbstractBundle> list) {
        final ShrinkableCollection<Bundle> shrinkableCollection = new ShrinkableCollection<Bundle>((Collection<Bundle>)list);
        if (System.getSecurityManager() == null) {
            this.notifyCollisionHooksPriviledged(n, bundle, shrinkableCollection);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Framework.this.notifyCollisionHooksPriviledged(n, bundle, shrinkableCollection);
                    return null;
                }
            });
        }
    }

    void notifyCollisionHooksPriviledged(final int n, final Bundle bundle, final Collection<Bundle> collection) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println("notifyCollisionHooks(" + n + ", " + bundle + ", " + collection + ")");
        }
        this.getServiceRegistry().notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object object, ServiceRegistration<?> serviceRegistration) throws Exception {
                if (object instanceof CollisionHook) {
                    ((CollisionHook)object).filterCollisions(n, bundle, collection);
                }
            }

            @Override
            public String getHookClassName() {
                return collisionHookName;
            }

            @Override
            public String getHookMethodName() {
                return "filterCollisions";
            }
        });
    }

    protected void resumeBundle(AbstractBundle abstractBundle) {
        if (abstractBundle.isActive()) {
            return;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to resume bundle " + abstractBundle);
            }
            abstractBundle.resume();
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle resume exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.publishFrameworkEvent(2, abstractBundle, bundleException);
        }
    }

    protected boolean suspendBundle(AbstractBundle abstractBundle, boolean bl) {
        boolean bl2 = false;
        if (!abstractBundle.isActive() || abstractBundle.isFragment()) {
            return bl2;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to suspend bundle " + abstractBundle);
            }
            abstractBundle.suspend(bl);
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle suspend exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.publishFrameworkEvent(2, abstractBundle, bundleException);
        }
        if (!abstractBundle.isActive()) {
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle getBundleByLocation(String string) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            final String string2 = string;
            return AccessController.doPrivileged(new PrivilegedAction<AbstractBundle>(){

                @Override
                public AbstractBundle run() {
                    List<AbstractBundle> list = Framework.this.bundles.getBundles();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        AbstractBundle abstractBundle = list.get(i);
                        if (!string2.equals(abstractBundle.getLocation())) continue;
                        return abstractBundle;
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getBundleBySymbolicName(String string) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundles(string);
        }
    }

    protected File getDataFile(AbstractBundle abstractBundle, String string) {
        return AccessController.doPrivileged(new GetDataFileAction(abstractBundle, string));
    }

    protected void checkAdminPermission(Bundle bundle, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.getAdminPermission(bundle, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdminPermission getAdminPermission(Bundle bundle, String string) {
        Map<Long, Map<String, AdminPermission>> map = this.adminPermissions;
        synchronized (map) {
            AdminPermission adminPermission;
            Long l = new Long(bundle.getBundleId());
            Map<String, AdminPermission> map2 = this.adminPermissions.get(l);
            if (map2 == null) {
                map2 = new HashMap<String, AdminPermission>();
                this.adminPermissions.put(l, map2);
            }
            if ((adminPermission = map2.get(string)) == null) {
                adminPermission = new AdminPermission(bundle, string);
                map2.put(string, adminPermission);
            }
            return adminPermission;
        }
    }

    protected void installSecurityManager() {
        SecurityManager securityManager;
        String string = FrameworkProperties.getProperty("org.osgi.framework.security", FrameworkProperties.getProperty(PROP_EQUINOX_SECURITY, FrameworkProperties.getProperty("java.security.manager")));
        if (string != null && (securityManager = System.getSecurityManager()) == null) {
            if (string.length() == 0) {
                securityManager = new SecurityManager();
            } else if (string.equals(SECURITY_OSGI)) {
                securityManager = new EquinoxSecurityManager();
            } else {
                try {
                    Class<?> clazz = Class.forName(string);
                    securityManager = (SecurityManager)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (securityManager == null) {
                throw new NoClassDefFoundError(string);
            }
            if (Debug.DEBUG_SECURITY) {
                Debug.println("Setting SecurityManager to: " + securityManager);
            }
            System.setSecurityManager(securityManager);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFrameworkListener(FrameworkListener frameworkListener, BundleContextImpl bundleContextImpl) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> map = this.allFrameworkListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener> copyOnWriteIdentityMap = this.allFrameworkListeners.get(bundleContextImpl);
            if (copyOnWriteIdentityMap == null) {
                copyOnWriteIdentityMap = new CopyOnWriteIdentityMap();
                this.allFrameworkListeners.put(bundleContextImpl, copyOnWriteIdentityMap);
            }
            copyOnWriteIdentityMap.put(frameworkListener, frameworkListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFrameworkListener(FrameworkListener frameworkListener, BundleContextImpl bundleContextImpl) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> map = this.allFrameworkListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener> copyOnWriteIdentityMap = this.allFrameworkListeners.get(bundleContextImpl);
            if (copyOnWriteIdentityMap != null) {
                copyOnWriteIdentityMap.remove(frameworkListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllListeners(BundleContextImpl bundleContextImpl) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<EventListener, EventListener>> map = this.allBundleListeners;
        synchronized (map) {
            this.allBundleListeners.remove(bundleContextImpl);
        }
        map = this.allSyncBundleListeners;
        synchronized (map) {
            this.allSyncBundleListeners.remove(bundleContextImpl);
        }
        map = this.allFrameworkListeners;
        synchronized (map) {
            this.allFrameworkListeners.remove(bundleContextImpl);
        }
    }

    @Override
    public void publishFrameworkEvent(int n, Bundle bundle, Throwable throwable) {
        this.publishFrameworkEvent(n, bundle, throwable, null);
    }

    public void publishFrameworkEvent(int n, Bundle bundle, Throwable throwable, final FrameworkListener ... frameworkListenerArray) {
        if (bundle == null) {
            bundle = this.systemBundle;
        }
        final FrameworkEvent frameworkEvent = new FrameworkEvent(n, bundle, throwable);
        if (System.getSecurityManager() == null) {
            this.publishFrameworkEventPrivileged(frameworkEvent, frameworkListenerArray);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Framework.this.publishFrameworkEventPrivileged(frameworkEvent, frameworkListenerArray);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFrameworkEventPrivileged(FrameworkEvent frameworkEvent, FrameworkListener ... frameworkListenerArray) {
        HashMap<BundleContextImpl, Set<Map.Entry<FrameworkListener, FrameworkListener>>> hashMap;
        Object object = this.allFrameworkListeners;
        synchronized (object) {
            hashMap = new HashMap<BundleContextImpl, Set<Map.Entry<FrameworkListener, FrameworkListener>>>(this.allFrameworkListeners.size());
            for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> object2 : this.allFrameworkListeners.entrySet()) {
                CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener> copyOnWriteIdentityMap = object2.getValue();
                if (copyOnWriteIdentityMap.isEmpty()) continue;
                hashMap.put(object2.getKey(), copyOnWriteIdentityMap.entrySet());
            }
        }
        object = this.newListenerQueue();
        if (frameworkListenerArray != null && frameworkListenerArray.length > 0) {
            HashMap hashMap2 = new HashMap();
            for (FrameworkListener frameworkListener : frameworkListenerArray) {
                if (frameworkListener == null) continue;
                hashMap2.put(frameworkListener, frameworkListener);
            }
            if (hashMap2.size() > 0) {
                BundleContextImpl bundleContextImpl = this.getSystemBundleContext();
                ((ListenerQueue)object).queueListeners(hashMap2.entrySet(), bundleContextImpl);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            EventDispatcher eventDispatcher = (EventDispatcher)entry.getKey();
            Set set = (Set)entry.getValue();
            ((ListenerQueue)object).queueListeners(set, eventDispatcher);
        }
        ((ListenerQueue)object).dispatchEventAsynchronous(4, frameworkEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBundleListener(BundleListener bundleListener, BundleContextImpl bundleContextImpl) {
        if (bundleListener instanceof SynchronousBundleListener) {
            this.checkAdminPermission(bundleContextImpl.getBundle(), "listener");
            Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> map = this.allSyncBundleListeners;
            synchronized (map) {
                CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener> copyOnWriteIdentityMap = this.allSyncBundleListeners.get(bundleContextImpl);
                if (copyOnWriteIdentityMap == null) {
                    copyOnWriteIdentityMap = new CopyOnWriteIdentityMap();
                    this.allSyncBundleListeners.put(bundleContextImpl, copyOnWriteIdentityMap);
                }
                copyOnWriteIdentityMap.put((SynchronousBundleListener)bundleListener, (SynchronousBundleListener)bundleListener);
            }
        }
        Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> map = this.allBundleListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<BundleListener, BundleListener> copyOnWriteIdentityMap = this.allBundleListeners.get(bundleContextImpl);
            if (copyOnWriteIdentityMap == null) {
                copyOnWriteIdentityMap = new CopyOnWriteIdentityMap();
                this.allBundleListeners.put(bundleContextImpl, copyOnWriteIdentityMap);
            }
            copyOnWriteIdentityMap.put(bundleListener, bundleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBundleListener(BundleListener bundleListener, BundleContextImpl bundleContextImpl) {
        if (bundleListener instanceof SynchronousBundleListener) {
            this.checkAdminPermission(bundleContextImpl.getBundle(), "listener");
            Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> map = this.allSyncBundleListeners;
            synchronized (map) {
                CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener> copyOnWriteIdentityMap = this.allSyncBundleListeners.get(bundleContextImpl);
                if (copyOnWriteIdentityMap != null) {
                    copyOnWriteIdentityMap.remove(bundleListener);
                }
            }
        }
        Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> map = this.allBundleListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<BundleListener, BundleListener> copyOnWriteIdentityMap = this.allBundleListeners.get(bundleContextImpl);
            if (copyOnWriteIdentityMap != null) {
                copyOnWriteIdentityMap.remove(bundleListener);
            }
        }
    }

    public void publishBundleEvent(int n, Bundle bundle) {
        this.publishBundleEvent(new BundleEvent(n, bundle));
    }

    private void publishBundleEvent(final BundleEvent bundleEvent) {
        if (System.getSecurityManager() == null) {
            this.publishBundleEventPrivileged(bundleEvent);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Framework.this.publishBundleEventPrivileged(bundleEvent);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishBundleEventPrivileged(BundleEvent bundleEvent) {
        Set set;
        EventDispatcher eventDispatcher;
        Collection<BundleContext> collection;
        Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> entry22;
        HashMap<BundleContextImpl, Set<Map.Entry<SynchronousBundleListener, SynchronousBundleListener>>> hashMap;
        Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> map = this.allSyncBundleListeners;
        synchronized (map) {
            hashMap = new HashMap<BundleContextImpl, Set<Map.Entry<SynchronousBundleListener, SynchronousBundleListener>>>(this.allSyncBundleListeners.size());
            for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> entry22 : this.allSyncBundleListeners.entrySet()) {
                CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener> object = entry22.getValue();
                if (object.isEmpty()) continue;
                hashMap.put(entry22.getKey(), object.entrySet());
            }
        }
        map = null;
        if ((bundleEvent.getType() & 0x380) == 0) {
            collection = this.allBundleListeners;
            synchronized (collection) {
                map = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>>(this.allBundleListeners.size());
                for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> entry : this.allBundleListeners.entrySet()) {
                    CopyOnWriteIdentityMap<BundleListener, BundleListener> copyOnWriteIdentityMap = entry.getValue();
                    if (copyOnWriteIdentityMap.isEmpty()) continue;
                    map.put(entry.getKey(), (CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>)((Object)copyOnWriteIdentityMap.entrySet()));
                }
            }
        }
        collection = map == null ? Framework.asBundleContexts(hashMap.keySet()) : new ShrinkableCollection<BundleContext>(Framework.asBundleContexts(hashMap.keySet()), Framework.asBundleContexts(map.keySet()));
        this.notifyEventHooksPrivileged(bundleEvent, collection);
        if (!hashMap.isEmpty()) {
            entry22 = this.newListenerQueue();
            for (Map.Entry entry : hashMap.entrySet()) {
                eventDispatcher = (EventDispatcher)entry.getKey();
                set = (Set)entry.getValue();
                ((ListenerQueue)((Object)entry22)).queueListeners(set, eventDispatcher);
            }
            ((ListenerQueue)((Object)entry22)).dispatchEventSynchronous(2, bundleEvent);
        }
        if (map != null && !map.isEmpty()) {
            entry22 = this.newListenerQueue();
            for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> entry : map.entrySet()) {
                eventDispatcher = entry.getKey();
                set = (Set)((Object)entry.getValue());
                ((ListenerQueue)((Object)entry22)).queueListeners(set, eventDispatcher);
            }
            ((ListenerQueue)((Object)entry22)).dispatchEventAsynchronous(1, bundleEvent);
        }
    }

    public static Collection<BundleContext> asBundleContexts(Collection<? extends BundleContext> collection) {
        return collection;
    }

    private void notifyEventHooksPrivileged(final BundleEvent bundleEvent, final Collection<BundleContext> collection) {
        if (bundleEvent.getType() == -2147483647 || bundleEvent.getType() == Integer.MIN_VALUE) {
            return;
        }
        if (Debug.DEBUG_HOOKS) {
            Debug.println("notifyBundleEventHooks(" + bundleEvent.getType() + ":" + bundleEvent.getBundle() + ", " + collection + " )");
        }
        this.getServiceRegistry().notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object object, ServiceRegistration<?> serviceRegistration) throws Exception {
                if (object instanceof EventHook) {
                    ((EventHook)object).event(bundleEvent, collection);
                }
            }

            @Override
            public String getHookClassName() {
                return eventHookName;
            }

            @Override
            public String getHookMethodName() {
                return "event";
            }
        });
    }

    public <K, V, E> ListenerQueue<K, V, E> newListenerQueue() {
        return new ListenerQueue(this.eventManager);
    }

    private void initializeContextFinder() {
        Thread thread = Thread.currentThread();
        try {
            ClassLoader classLoader = null;
            String string = FrameworkProperties.getProperty(PROP_CONTEXTCLASSLOADER_PARENT);
            if (CONTEXTCLASSLOADER_PARENT_APP.equals(string)) {
                classLoader = ClassLoader.getSystemClassLoader();
            } else if (CONTEXTCLASSLOADER_PARENT_BOOT.equals(string)) {
                classLoader = null;
            } else if (CONTEXTCLASSLOADER_PARENT_FWK.equals(string)) {
                classLoader = Framework.class.getClassLoader();
            } else if (CONTEXTCLASSLOADER_PARENT_EXT.equals(string)) {
                ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
                if (classLoader2 != null) {
                    classLoader = classLoader2.getParent();
                }
            } else {
                classLoader = thread.getContextClassLoader();
            }
            this.contextFinder = new ContextFinder(classLoader);
            thread.setContextClassLoader(this.contextFinder);
            return;
        }
        catch (Exception exception) {
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 1, 0, NLS.bind(Msg.CANNOT_SET_CONTEXTFINDER, null), 0, exception, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            return;
        }
    }

    public static Field getField(Class<?> clazz, Class<?> clazz2, boolean bl) {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            boolean bl2 = Modifier.isStatic(fieldArray[i].getModifiers());
            if (bl == bl2 || !fieldArray[i].getType().equals(clazz2)) continue;
            fieldArray[i].setAccessible(true);
            return fieldArray[i];
        }
        return null;
    }

    private void installContentHandlerFactory(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory = new org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory(bundleContext, frameworkAdaptor);
        try {
            URLConnection.setContentHandlerFactory(contentHandlerFactory);
        }
        catch (Error error) {
            try {
                Framework.forceContentHandlerFactory(contentHandlerFactory);
            }
            catch (Exception exception) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, bundleContext.getBundle(), exception));
                throw error;
            }
        }
        this.contentHandlerFactory = contentHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceContentHandlerFactory(org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory) throws Exception {
        Field field = Framework.getField(URLConnection.class, ContentHandlerFactory.class, false);
        if (field == null) {
            throw new Exception("Could not find ContentHandlerFactory field");
        }
        Class<URLConnection> clazz = URLConnection.class;
        synchronized (URLConnection.class) {
            ContentHandlerFactory contentHandlerFactory2 = (ContentHandlerFactory)field.get(null);
            if (contentHandlerFactory2 != null) {
                try {
                    contentHandlerFactory2.getClass().getMethod("isMultiplexing", null);
                    Method method = contentHandlerFactory2.getClass().getMethod("register", Object.class);
                    method.invoke((Object)contentHandlerFactory2, contentHandlerFactory);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    contentHandlerFactory.setParentFactory(contentHandlerFactory2);
                    contentHandlerFactory2 = contentHandlerFactory;
                }
            }
            field.set(null, null);
            Framework.resetContentHandlers();
            URLConnection.setContentHandlerFactory(contentHandlerFactory2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallContentHandlerFactory() {
        try {
            Field field = Framework.getField(URLConnection.class, ContentHandlerFactory.class, false);
            if (field == null) {
                return;
            }
            Class<URLConnection> clazz = URLConnection.class;
            synchronized (URLConnection.class) {
                ContentHandlerFactory contentHandlerFactory = (ContentHandlerFactory)field.get(null);
                if (contentHandlerFactory == this.contentHandlerFactory) {
                    contentHandlerFactory = (ContentHandlerFactory)this.contentHandlerFactory.designateSuccessor();
                } else {
                    Method method = contentHandlerFactory.getClass().getMethod("unregister", Object.class);
                    method.invoke((Object)contentHandlerFactory, this.contentHandlerFactory);
                }
                field.set(null, null);
                Framework.resetContentHandlers();
                if (contentHandlerFactory != null) {
                    URLConnection.setContentHandlerFactory(contentHandlerFactory);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        {
            return;
        }
    }

    private static void resetContentHandlers() throws IllegalAccessException {
        Hashtable hashtable;
        Field field = Framework.getField(URLConnection.class, Hashtable.class, false);
        if (field != null && (hashtable = (Hashtable)field.get(null)) != null) {
            hashtable.clear();
        }
    }

    private void installURLStreamHandlerFactory(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        StreamHandlerFactory streamHandlerFactory = new StreamHandlerFactory(bundleContext, frameworkAdaptor);
        try {
            URL.setURLStreamHandlerFactory(streamHandlerFactory);
        }
        catch (Error error) {
            try {
                Framework.forceURLStreamHandlerFactory(streamHandlerFactory);
            }
            catch (Exception exception) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, bundleContext.getBundle(), exception));
                throw error;
            }
        }
        this.streamHandlerFactory = streamHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceURLStreamHandlerFactory(StreamHandlerFactory streamHandlerFactory) throws Exception {
        Object object;
        Field field = Framework.getField(URL.class, URLStreamHandlerFactory.class, false);
        if (field == null) {
            throw new Exception("Could not find URLStreamHandlerFactory field");
        }
        Object object2 = object = Framework.getURLStreamHandlerFactoryLock();
        synchronized (object2) {
            URLStreamHandlerFactory uRLStreamHandlerFactory = (URLStreamHandlerFactory)field.get(null);
            if (uRLStreamHandlerFactory != null) {
                try {
                    uRLStreamHandlerFactory.getClass().getMethod("isMultiplexing", null);
                    Method method = uRLStreamHandlerFactory.getClass().getMethod("register", Object.class);
                    method.invoke((Object)uRLStreamHandlerFactory, streamHandlerFactory);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    streamHandlerFactory.setParentFactory(uRLStreamHandlerFactory);
                    uRLStreamHandlerFactory = streamHandlerFactory;
                }
            }
            field.set(null, null);
            Framework.resetURLStreamHandlers();
            URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallURLStreamHandlerFactory() {
        try {
            Object object;
            Field field = Framework.getField(URL.class, URLStreamHandlerFactory.class, false);
            if (field == null) {
                return;
            }
            Object object2 = object = Framework.getURLStreamHandlerFactoryLock();
            synchronized (object2) {
                URLStreamHandlerFactory uRLStreamHandlerFactory = (URLStreamHandlerFactory)field.get(null);
                if (uRLStreamHandlerFactory == this.streamHandlerFactory) {
                    uRLStreamHandlerFactory = (URLStreamHandlerFactory)this.streamHandlerFactory.designateSuccessor();
                } else {
                    Method method = uRLStreamHandlerFactory.getClass().getMethod("unregister", Object.class);
                    method.invoke((Object)uRLStreamHandlerFactory, this.streamHandlerFactory);
                }
                field.set(null, null);
                Framework.resetURLStreamHandlers();
                if (uRLStreamHandlerFactory != null) {
                    URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object getURLStreamHandlerFactoryLock() throws IllegalAccessException {
        Object object;
        try {
            Field field = URL.class.getDeclaredField("streamHandlerLock");
            field.setAccessible(true);
            object = field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            object = URL.class;
        }
        return object;
    }

    private static void resetURLStreamHandlers() throws IllegalAccessException {
        Hashtable hashtable;
        Field field = Framework.getField(URL.class, Hashtable.class, false);
        if (field != null && (hashtable = (Hashtable)field.get(null)) != null) {
            hashtable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Framework framework = this;
        synchronized (framework) {
            while (this.active) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    void setForcedRestart(boolean bl) {
        this.forcedRestart = bl;
    }

    boolean isForcedRestart() {
        return this.forcedRestart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        boolean bl = l == 0L;
        long l2 = System.currentTimeMillis();
        long l3 = l;
        Framework framework = this;
        synchronized (framework) {
            FrameworkEvent[] frameworkEventArray = this.shutdownEvent;
            while (frameworkEventArray != null && frameworkEventArray[0] == null) {
                this.wait(l3);
                if (bl || (l3 = l2 + l - System.currentTimeMillis()) > 0L) continue;
            }
            if (frameworkEventArray == null || frameworkEventArray[0] == null) {
                return new FrameworkEvent(512, this.systemBundle, null);
            }
            return frameworkEventArray[0];
        }
    }

    public boolean isServiceAssignableTo(Bundle bundle, Bundle bundle2, String string, Class<?> clazz) {
        Object object;
        AbstractBundle abstractBundle = (AbstractBundle)bundle2;
        if (abstractBundle.isFragment()) {
            return false;
        }
        AbstractBundle abstractBundle2 = (AbstractBundle)bundle;
        if (abstractBundle == abstractBundle2) {
            return true;
        }
        String string2 = BundleLoader.getPackageName(string);
        if (string2.startsWith("java.")) {
            return true;
        }
        BundleLoader bundleLoader = abstractBundle2.getBundleLoader();
        if (bundleLoader == null) {
            return false;
        }
        BundleLoader bundleLoader2 = abstractBundle.getBundleLoader();
        if (bundleLoader2 == null) {
            return false;
        }
        PackageSource packageSource = bundleLoader2.getPackageSource(string2);
        if (packageSource == null) {
            return true;
        }
        if (this.isBootDelegationPackage(string2) && ((SystemBundleLoader)(object = (SystemBundleLoader)this.systemBundle.getBundleLoader())).isEEPackage(string2)) {
            return true;
        }
        object = bundleLoader.getPackageSource(string2);
        if (object == null) {
            Bundle bundle3;
            if (clazz != null && ServiceFactory.class.isAssignableFrom(clazz) && (bundle3 = this.packageAdmin.getBundle(clazz)) != null && bundle3 != bundle) {
                return true;
            }
            object = this.getPackageSource(clazz, string2);
            if (object == null) {
                return false;
            }
        }
        return ((PackageSource)object).hasCommonSource(packageSource);
    }

    private PackageSource getPackageSource(Class<?> clazz, String string) {
        if (clazz == null) {
            return null;
        }
        AbstractBundle abstractBundle = (AbstractBundle)this.packageAdmin.getBundle(clazz);
        if (abstractBundle == null) {
            return null;
        }
        BundleLoader bundleLoader = abstractBundle.getBundleLoader();
        if (bundleLoader == null) {
            return null;
        }
        PackageSource packageSource = bundleLoader.getPackageSource(string);
        if (packageSource != null) {
            return packageSource;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            packageSource = this.getPackageSource(classArray[i], string);
            if (packageSource == null) continue;
            return packageSource;
        }
        return this.getPackageSource(clazz.getSuperclass(), string);
    }

    public boolean isBootDelegationPackage(String string) {
        int n;
        if (this.bootDelegateAll) {
            return true;
        }
        if (this.bootDelegation != null) {
            for (n = 0; n < this.bootDelegation.length; ++n) {
                if (!string.equals(this.bootDelegation[n])) continue;
                return true;
            }
        }
        if (this.bootDelegationStems != null) {
            for (n = 0; n < this.bootDelegationStems.length; ++n) {
                if (!string.startsWith(this.bootDelegationStems[n])) continue;
                return true;
            }
        }
        return false;
    }

    SignedContentFactory getSignedContentFactory() {
        ServiceTracker<SignedContentFactory, SignedContentFactory> serviceTracker = this.signedContentFactory;
        return serviceTracker == null ? null : serviceTracker.getService();
    }

    ContextFinder getContextFinder() {
        return this.contextFinder;
    }

    public boolean isRefreshDuplicateBSNAllowed() {
        return this.allowRefreshDuplicateBSN;
    }

    static {
        Class<GetDataFileAction> clazz = GetDataFileAction.class;
        clazz.getName();
    }

    private class DuplicateBundleException
    extends BundleException
    implements StatusException {
        private static final long serialVersionUID = 135669822846323624L;
        private transient Bundle duplicate;

        public DuplicateBundleException(String string, Bundle bundle) {
            super(string, 9);
            this.duplicate = bundle;
        }

        @Override
        public Object getStatus() {
            return this.duplicate;
        }

        @Override
        public int getStatusCode() {
            return 1;
        }
    }

    static class GetDataFileAction
    implements PrivilegedAction<File> {
        private AbstractBundle bundle;
        private String filename;

        public GetDataFileAction(AbstractBundle abstractBundle, String string) {
            this.bundle = abstractBundle;
            this.filename = string;
        }

        @Override
        public File run() {
            return this.bundle.getBundleData().getDataFile(this.filename);
        }
    }
}

