/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.file;

import ancestris.modules.releve.file.FileBuffer;
import ancestris.modules.releve.file.FileManager;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.RecordBirth;
import ancestris.modules.releve.model.RecordDeath;
import ancestris.modules.releve.model.RecordMarriage;
import ancestris.modules.releve.model.RecordMisc;
import ancestris.modules.releve.model.RecordModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.util.Exceptions;

public class ReleveFileAncestrisV4 {
    private static final String fileSignature = "ANCESTRISV4";
    private static final char fieldSeparator = ';';
    private static final int nbFields = 90;

    public static boolean isValidFile(File inputFile, StringBuilder sb) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(ReleveFileAncestrisV4.checkUtf8Bom(new FileInputStream(inputFile)), "UTF-8"));
            String[] fields = ReleveFileAncestrisV4.splitLine(br);
            if (fields == null) {
                sb.append("ANCESTRISV4 ").append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.EmptyFile"), inputFile.getName()));
                return false;
            }
        }
        catch (Exception ex) {
            sb.append("ANCESTRISV4 ").append(ex.getMessage());
            return false;
        }
        return true;
    }

    private static InputStream checkUtf8Bom(InputStream is) throws IOException {
        byte[] utf8Bom = new byte[]{-17, -69, -65};
        PushbackInputStream pis = new PushbackInputStream(is, utf8Bom.length);
        byte[] bomRead = new byte[utf8Bom.length];
        if (pis.read(bomRead, 0, utf8Bom.length) == -1) {
            return is;
        }
        if (!Arrays.equals(bomRead, utf8Bom)) {
            pis.unread(bomRead);
        }
        return pis;
    }

    private static String[] splitLine(BufferedReader br) throws Exception {
        List<String> fieldList = FileManager.Line.splitCSV(br, ';');
        if (fieldList != null) {
            String[] fields = fieldList.toArray(new String[0]);
            if (fields.length == 90) {
                if (fields[0].equals(fileSignature)) {
                    return fields;
                }
                throw new Exception(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineBegin"), fileSignature, fields[0]));
            }
            throw new Exception(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.FieldNb"), fields.length, 90));
        }
        return null;
    }

    public static FileBuffer loadFile(File inputFile) {
        FileBuffer fileBuffer = new FileBuffer();
        try {
            fileBuffer = ReleveFileAncestrisV4.loadFile(ReleveFileAncestrisV4.checkUtf8Bom(new FileInputStream(inputFile)));
            return fileBuffer;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            fileBuffer.append(ex.toString()).append("\n");
            return fileBuffer;
        }
    }

    public static FileBuffer loadFile(InputStream inputStream) {
        FileBuffer fileBuffer = new FileBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int lineNumber = 0;
            block4: while (true) {
                try {
                    while (true) {
                        AbstractRecord record;
                        ++lineNumber;
                        String[] fields = ReleveFileAncestrisV4.splitLine(br);
                        if (fields == null) break block4;
                        if (fields[Field.eventType.ordinal()].equals("N/M/D/V")) {
                            --lineNumber;
                            continue;
                        }
                        if (fields[Field.eventType.ordinal()].equals("N")) {
                            record = new RecordBirth();
                            record.setPlace(fields[Field.nomCommune.ordinal()], fields[Field.codeCommune.ordinal()], fields[Field.nomDepartement.ordinal()], fields[Field.stateName.ordinal()], fields[Field.countryName.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.parish, fields[Field.parish.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.secondDate, fields[Field.secondDate.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.cote, fields[Field.cote.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[Field.freeComment.ordinal()]);
                            record.setIndi(fields[Field.indiFirstName.ordinal()], fields[Field.indiLastName.ordinal()], fields[Field.indiSex.ordinal()], "", fields[Field.indiBirthDate.ordinal()], fields[Field.indiBirthPlace.ordinal()], "", "", fields[Field.indiResidence.ordinal()], "", "", "", "", fields[Field.indiComment.ordinal()]);
                            record.setIndiFather(fields[Field.indiFatherFirstName.ordinal()], fields[Field.indiFatherLastName.ordinal()], fields[Field.indiFatherOccupation.ordinal()], fields[Field.indiFatherResidence.ordinal()], "", fields[Field.indiFatherComment.ordinal()], fields[Field.indiFatherDead.ordinal()], fields[Field.indiFatherAge.ordinal()]);
                            record.setIndiMother(fields[Field.indiMotherFirstName.ordinal()], fields[Field.indiMotherLastName.ordinal()], fields[Field.indiMotherOccupation.ordinal()], fields[Field.indiMotherResidence.ordinal()], "", fields[Field.indiMotherComment.ordinal()], fields[Field.indiMotherDead.ordinal()], fields[Field.indiMotherAge.ordinal()]);
                            record.setWitness1(fields[Field.witness1FirstName.ordinal()], fields[Field.witness1LastName.ordinal()], fields[Field.witness1Occupation.ordinal()], fields[Field.witness1Comment.ordinal()]);
                            record.setWitness2(fields[Field.witness2FirstName.ordinal()], fields[Field.witness2LastName.ordinal()], fields[Field.witness2Occupation.ordinal()], fields[Field.witness2Comment.ordinal()]);
                            record.setWitness3(fields[Field.witness3FirstName.ordinal()], fields[Field.witness3LastName.ordinal()], fields[Field.witness3Occupation.ordinal()], fields[Field.witness3Comment.ordinal()]);
                            record.setWitness4(fields[Field.witness4FirstName.ordinal()], fields[Field.witness4LastName.ordinal()], fields[Field.witness4Occupation.ordinal()], fields[Field.witness4Comment.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[Field.generalComment.ordinal()]);
                            fileBuffer.addRecord(record);
                            continue;
                        }
                        if (fields[Field.eventType.ordinal()].equals("M")) {
                            record = new RecordMarriage();
                            record.setPlace(fields[Field.nomCommune.ordinal()], fields[Field.codeCommune.ordinal()], fields[Field.nomDepartement.ordinal()], fields[Field.stateName.ordinal()], fields[Field.countryName.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.parish, fields[Field.parish.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.secondDate, fields[Field.secondDate.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.cote, fields[Field.cote.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[Field.freeComment.ordinal()]);
                            record.setIndi(fields[Field.indiFirstName.ordinal()], fields[Field.indiLastName.ordinal()], "M", fields[Field.indiAge.ordinal()], fields[Field.indiBirthDate.ordinal()], fields[Field.indiBirthPlace.ordinal()], "", fields[Field.indiOccupation.ordinal()], fields[Field.indiResidence.ordinal()], "", "", "", "", fields[Field.indiComment.ordinal()]);
                            record.setIndiMarried(fields[Field.indiMarriedFirstName.ordinal()], fields[Field.indiMarriedLastName.ordinal()], fields[Field.indiMarriedOccupation.ordinal()], fields[Field.indiMarriedResidence.ordinal()], "", fields[Field.indiMarriedComment.ordinal()], fields[Field.indiMarriedDead.ordinal()]);
                            record.setIndiFather(fields[Field.indiFatherFirstName.ordinal()], fields[Field.indiFatherLastName.ordinal()], fields[Field.indiFatherOccupation.ordinal()], fields[Field.indiFatherResidence.ordinal()], "", fields[Field.indiFatherComment.ordinal()], fields[Field.indiFatherDead.ordinal()], fields[Field.indiFatherAge.ordinal()]);
                            record.setIndiMother(fields[Field.indiMotherFirstName.ordinal()], fields[Field.indiMotherLastName.ordinal()], fields[Field.indiMotherOccupation.ordinal()], fields[Field.indiMotherResidence.ordinal()], "", fields[Field.indiMotherComment.ordinal()], fields[Field.indiMotherDead.ordinal()], fields[Field.indiMotherAge.ordinal()]);
                            record.setWife(fields[Field.wifeFirstName.ordinal()], fields[Field.wifeLastName.ordinal()], "F", fields[Field.wifeAge.ordinal()], fields[Field.wifeBirthDate.ordinal()], fields[Field.wifeBirthPlace.ordinal()], "", fields[Field.wifeOccupation.ordinal()], fields[Field.wifeResidence.ordinal()], "", fields[Field.wifeComment.ordinal()]);
                            record.setWifeMarried(fields[Field.wifeMarriedFirstName.ordinal()], fields[Field.wifeMarriedLastName.ordinal()], fields[Field.wifeMarriedOccupation.ordinal()], fields[Field.wifeMarriedResidence.ordinal()], "", fields[Field.wifeMarriedComment.ordinal()], fields[Field.wifeMarriedDead.ordinal()]);
                            record.setWifeFather(fields[Field.wifeFatherFirstName.ordinal()], fields[Field.wifeFatherLastName.ordinal()], fields[Field.wifeFatherOccupation.ordinal()], fields[Field.wifeFatherResidence.ordinal()], "", fields[Field.wifeFatherComment.ordinal()], fields[Field.wifeFatherDead.ordinal()], fields[Field.wifeFatherAge.ordinal()]);
                            record.setWifeMother(fields[Field.wifeMotherFirstName.ordinal()], fields[Field.wifeMotherLastName.ordinal()], fields[Field.wifeMotherOccupation.ordinal()], fields[Field.wifeMotherResidence.ordinal()], "", fields[Field.wifeMotherComment.ordinal()], fields[Field.wifeMotherDead.ordinal()], fields[Field.wifeMotherAge.ordinal()]);
                            record.setWitness1(fields[Field.witness1FirstName.ordinal()], fields[Field.witness1LastName.ordinal()], fields[Field.witness1Occupation.ordinal()], fields[Field.witness1Comment.ordinal()]);
                            record.setWitness2(fields[Field.witness2FirstName.ordinal()], fields[Field.witness2LastName.ordinal()], fields[Field.witness2Occupation.ordinal()], fields[Field.witness2Comment.ordinal()]);
                            record.setWitness3(fields[Field.witness3FirstName.ordinal()], fields[Field.witness3LastName.ordinal()], fields[Field.witness3Occupation.ordinal()], fields[Field.witness3Comment.ordinal()]);
                            record.setWitness4(fields[Field.witness4FirstName.ordinal()], fields[Field.witness4LastName.ordinal()], fields[Field.witness4Occupation.ordinal()], fields[Field.witness4Comment.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[Field.generalComment.ordinal()]);
                            fileBuffer.addRecord(record);
                            continue;
                        }
                        if (fields[Field.eventType.ordinal()].equals("D")) {
                            record = new RecordDeath();
                            record.setPlace(fields[Field.nomCommune.ordinal()], fields[Field.codeCommune.ordinal()], fields[Field.nomDepartement.ordinal()], fields[Field.stateName.ordinal()], fields[Field.countryName.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.parish, fields[Field.parish.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.secondDate, fields[Field.secondDate.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.cote, fields[Field.cote.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[Field.freeComment.ordinal()]);
                            record.setIndi(fields[Field.indiFirstName.ordinal()], fields[Field.indiLastName.ordinal()], fields[Field.indiSex.ordinal()], fields[Field.indiAge.ordinal()], fields[Field.indiBirthDate.ordinal()], fields[Field.indiBirthPlace.ordinal()], "", fields[Field.indiOccupation.ordinal()], fields[Field.indiResidence.ordinal()], "", "", "", "", fields[Field.indiComment.ordinal()]);
                            record.setIndiMarried(fields[Field.indiMarriedFirstName.ordinal()], fields[Field.indiMarriedLastName.ordinal()], fields[Field.indiMarriedOccupation.ordinal()], fields[Field.indiMarriedResidence.ordinal()], "", fields[Field.indiMarriedComment.ordinal()], fields[Field.indiMarriedDead.ordinal()]);
                            record.setIndiFather(fields[Field.indiFatherFirstName.ordinal()], fields[Field.indiFatherLastName.ordinal()], fields[Field.indiFatherOccupation.ordinal()], fields[Field.indiFatherResidence.ordinal()], "", fields[Field.indiFatherComment.ordinal()], fields[Field.indiFatherDead.ordinal()], fields[Field.indiFatherAge.ordinal()]);
                            record.setIndiMother(fields[Field.indiMotherFirstName.ordinal()], fields[Field.indiMotherLastName.ordinal()], fields[Field.indiMotherOccupation.ordinal()], fields[Field.indiMotherResidence.ordinal()], "", fields[Field.indiMotherComment.ordinal()], fields[Field.indiMotherDead.ordinal()], fields[Field.indiMotherAge.ordinal()]);
                            record.setWitness1(fields[Field.witness1FirstName.ordinal()], fields[Field.witness1LastName.ordinal()], fields[Field.witness1Occupation.ordinal()], fields[Field.witness1Comment.ordinal()]);
                            record.setWitness2(fields[Field.witness2FirstName.ordinal()], fields[Field.witness2LastName.ordinal()], fields[Field.witness2Occupation.ordinal()], fields[Field.witness2Comment.ordinal()]);
                            record.setWitness3(fields[Field.witness3FirstName.ordinal()], fields[Field.witness3LastName.ordinal()], fields[Field.witness3Occupation.ordinal()], fields[Field.witness3Comment.ordinal()]);
                            record.setWitness4(fields[Field.witness4FirstName.ordinal()], fields[Field.witness4LastName.ordinal()], fields[Field.witness4Occupation.ordinal()], fields[Field.witness4Comment.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[Field.generalComment.ordinal()]);
                            fileBuffer.addRecord(record);
                            continue;
                        }
                        if (fields[Field.eventType.ordinal()].equals("V")) {
                            record = new RecordMisc();
                            record.setFieldValue(AbstractRecord.FieldType.eventType, fields[Field.eventTypeName.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.notary, fields[Field.notaryComment.ordinal()]);
                            record.setPlace(fields[Field.nomCommune.ordinal()], fields[Field.codeCommune.ordinal()], fields[Field.nomDepartement.ordinal()], fields[Field.stateName.ordinal()], fields[Field.countryName.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.parish, fields[Field.parish.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.secondDate, fields[Field.secondDate.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.cote, fields[Field.cote.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[Field.freeComment.ordinal()]);
                            record.setIndi(fields[Field.indiFirstName.ordinal()], fields[Field.indiLastName.ordinal()], fields[Field.indiSex.ordinal()], fields[Field.indiAge.ordinal()], fields[Field.indiBirthDate.ordinal()], fields[Field.indiBirthPlace.ordinal()], "", fields[Field.indiOccupation.ordinal()], fields[Field.indiResidence.ordinal()], "", "", "", "", fields[Field.indiComment.ordinal()]);
                            record.setIndiMarried(fields[Field.indiMarriedFirstName.ordinal()], fields[Field.indiMarriedLastName.ordinal()], fields[Field.indiMarriedOccupation.ordinal()], fields[Field.indiMarriedResidence.ordinal()], "", fields[Field.indiMarriedComment.ordinal()], fields[Field.indiMarriedDead.ordinal()]);
                            record.setIndiFather(fields[Field.indiFatherFirstName.ordinal()], fields[Field.indiFatherLastName.ordinal()], fields[Field.indiFatherOccupation.ordinal()], fields[Field.indiFatherResidence.ordinal()], "", fields[Field.indiFatherComment.ordinal()], fields[Field.indiFatherDead.ordinal()], fields[Field.indiFatherAge.ordinal()]);
                            record.setIndiMother(fields[Field.indiMotherFirstName.ordinal()], fields[Field.indiMotherLastName.ordinal()], fields[Field.indiMotherOccupation.ordinal()], fields[Field.indiMotherResidence.ordinal()], "", fields[Field.indiMotherComment.ordinal()], fields[Field.indiMotherDead.ordinal()], fields[Field.indiMotherAge.ordinal()]);
                            record.setWife(fields[Field.wifeFirstName.ordinal()], fields[Field.wifeLastName.ordinal()], fields[Field.wifeSex.ordinal()], fields[Field.wifeAge.ordinal()], fields[Field.wifeBirthDate.ordinal()], fields[Field.wifeBirthPlace.ordinal()], "", fields[Field.wifeOccupation.ordinal()], fields[Field.wifeResidence.ordinal()], "", fields[Field.wifeComment.ordinal()]);
                            record.setWifeMarried(fields[Field.wifeMarriedFirstName.ordinal()], fields[Field.wifeMarriedLastName.ordinal()], fields[Field.wifeMarriedOccupation.ordinal()], fields[Field.wifeMarriedResidence.ordinal()], "", fields[Field.wifeMarriedComment.ordinal()], fields[Field.wifeMarriedDead.ordinal()]);
                            record.setWifeFather(fields[Field.wifeFatherFirstName.ordinal()], fields[Field.wifeFatherLastName.ordinal()], fields[Field.wifeFatherOccupation.ordinal()], fields[Field.wifeFatherResidence.ordinal()], "", fields[Field.wifeFatherComment.ordinal()], fields[Field.wifeFatherDead.ordinal()], fields[Field.wifeFatherAge.ordinal()]);
                            record.setWifeMother(fields[Field.wifeMotherFirstName.ordinal()], fields[Field.wifeMotherLastName.ordinal()], fields[Field.wifeMotherOccupation.ordinal()], fields[Field.wifeMotherResidence.ordinal()], "", fields[Field.wifeMotherComment.ordinal()], fields[Field.wifeMotherDead.ordinal()], fields[Field.wifeMotherAge.ordinal()]);
                            record.setWitness1(fields[Field.witness1FirstName.ordinal()], fields[Field.witness1LastName.ordinal()], fields[Field.witness1Occupation.ordinal()], fields[Field.witness1Comment.ordinal()]);
                            record.setWitness2(fields[Field.witness2FirstName.ordinal()], fields[Field.witness2LastName.ordinal()], fields[Field.witness2Occupation.ordinal()], fields[Field.witness2Comment.ordinal()]);
                            record.setWitness3(fields[Field.witness3FirstName.ordinal()], fields[Field.witness3LastName.ordinal()], fields[Field.witness3Occupation.ordinal()], fields[Field.witness3Comment.ordinal()]);
                            record.setWitness4(fields[Field.witness4FirstName.ordinal()], fields[Field.witness4LastName.ordinal()], fields[Field.witness4Occupation.ordinal()], fields[Field.witness4Comment.ordinal()]);
                            record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[Field.generalComment.ordinal()]);
                            fileBuffer.addRecord(record);
                            continue;
                        }
                        fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                        fileBuffer.append("\n");
                        fileBuffer.append(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.UnknownEventType")).append(" ");
                        fileBuffer.append(fields[Field.eventType.ordinal()]);
                        fileBuffer.append("\n");
                    }
                }
                catch (Exception e) {
                    fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                    fileBuffer.append("\n");
                    fileBuffer.append(e.toString()).append("\n");
                    continue;
                }
                break;
            }
            br.close();
        }
        catch (IOException e) {
            fileBuffer.append(e.toString()).append("\n");
        }
        return fileBuffer;
    }

    public static StringBuilder saveFile(RecordModel recordModel, AbstractRecord.RecordType recordType, File fileName, boolean append) {
        StringBuilder sb = new StringBuilder();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, append), "UTF-8");
            if (!append) {
                writer.write(ReleveFileAncestrisV4.getHeader().toString());
            }
            for (int index = 0; index < recordModel.getRowCount(); ++index) {
                AbstractRecord record = recordModel.getRecord(index);
                if (recordType != null && recordType != record.getType()) continue;
                FileManager.Line line = new FileManager.Line(';');
                try {
                    if (record instanceof RecordBirth) {
                        line.appendCsvFn(fileSignature, new String[0]);
                        line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getStateName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                        line.appendCsvFn("N", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.secondDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), new String[0]);
                        line.appendCsv(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                    }
                    if (record instanceof RecordMarriage) {
                        line.appendCsvFn(fileSignature, new String[0]);
                        line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getStateName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                        line.appendCsvFn("M", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.secondDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), new String[0]);
                        line.appendCsv(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                    } else if (record instanceof RecordDeath) {
                        line.appendCsvFn(fileSignature, new String[0]);
                        line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getStateName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                        line.appendCsvFn("D", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.secondDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), new String[0]);
                        line.appendCsv(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                    } else if (record instanceof RecordMisc) {
                        line.appendCsvFn(fileSignature, new String[0]);
                        line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getStateName(), new String[0]);
                        line.appendCsvFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                        line.appendCsvFn("V", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventType), new String[0]);
                        line.appendCsvFn("", new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.secondDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.notary), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeSex), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherAge), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherDead), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), new String[0]);
                        line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), new String[0]);
                        line.appendCsv(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                    }
                    line.appendCsv("\n", new String[0]);
                    writer.write(line.toString());
                    continue;
                }
                catch (IOException e) {
                    sb.append("Line ").append(" ").append(e).append("\n");
                    sb.append("   ").append(line).append("\n");
                }
            }
            writer.close();
        }
        catch (IOException e) {
            sb.append(e).append("\n");
        }
        return sb;
    }

    private static FileManager.Line getHeader() {
        FileManager.Line line = new FileManager.Line(';');
        line.appendCsvFn(fileSignature, new String[0]);
        line.appendCsvFn("CityName", new String[0]);
        line.appendCsvFn("CityCode", new String[0]);
        line.appendCsvFn("County", new String[0]);
        line.appendCsvFn("State", new String[0]);
        line.appendCsvFn("Country", new String[0]);
        line.appendCsvFn("Parish", new String[0]);
        line.appendCsvFn("N/M/D/V", new String[0]);
        line.appendCsvFn("EventTypeTag", new String[0]);
        line.appendCsvFn("EventTypeName", new String[0]);
        line.appendCsvFn("EventDate", new String[0]);
        line.appendCsvFn("SecondDate", new String[0]);
        line.appendCsvFn("Cote", new String[0]);
        line.appendCsvFn("FreeComment", new String[0]);
        line.appendCsvFn("Notary", new String[0]);
        line.appendCsvFn("IndiLastName", new String[0]);
        line.appendCsvFn("IndiFirstName", new String[0]);
        line.appendCsvFn("IndiSex", new String[0]);
        line.appendCsvFn("IndiPlace", new String[0]);
        line.appendCsvFn("IndiBirthDate", new String[0]);
        line.appendCsvFn("IndiAge", new String[0]);
        line.appendCsvFn("IndiOccupation", new String[0]);
        line.appendCsvFn("IndiResidence", new String[0]);
        line.appendCsvFn("IndiComment", new String[0]);
        line.appendCsvFn("IndiMarriedLastName", new String[0]);
        line.appendCsvFn("IndiMarriedFirstName", new String[0]);
        line.appendCsvFn("IndiMarriedDead", new String[0]);
        line.appendCsvFn("IndiMarriedOccupation", new String[0]);
        line.appendCsvFn("IndiMarriedResidence", new String[0]);
        line.appendCsvFn("IndiMarriedComment", new String[0]);
        line.appendCsvFn("IndiFatherLastName", new String[0]);
        line.appendCsvFn("IndiFatherFirstName", new String[0]);
        line.appendCsvFn("IndiFatherAge", new String[0]);
        line.appendCsvFn("IndiFatherDead", new String[0]);
        line.appendCsvFn("IndiFatherOccupation", new String[0]);
        line.appendCsvFn("IndiFatherResidence", new String[0]);
        line.appendCsvFn("IndiFatherComment", new String[0]);
        line.appendCsvFn("IndiMotherLastName", new String[0]);
        line.appendCsvFn("indiMotherfirstName", new String[0]);
        line.appendCsvFn("IndiMotherAge", new String[0]);
        line.appendCsvFn("IndiMotherDead", new String[0]);
        line.appendCsvFn("IndiMotherOccupation", new String[0]);
        line.appendCsvFn("IndiMotherResidence", new String[0]);
        line.appendCsvFn("IndiMotherComment", new String[0]);
        line.appendCsvFn("WifeLastName", new String[0]);
        line.appendCsvFn("WifeFirstName", new String[0]);
        line.appendCsvFn("WifeSex", new String[0]);
        line.appendCsvFn("WifePlace", new String[0]);
        line.appendCsvFn("WifeBirthDate", new String[0]);
        line.appendCsvFn("WifeAge", new String[0]);
        line.appendCsvFn("WifeOccupation", new String[0]);
        line.appendCsvFn("WifeResidence", new String[0]);
        line.appendCsvFn("WifeComment", new String[0]);
        line.appendCsvFn("WifeMarriedLastName", new String[0]);
        line.appendCsvFn("WifeMarriedFirstName", new String[0]);
        line.appendCsvFn("WifeMarriedDead", new String[0]);
        line.appendCsvFn("WifeMarriedOccupation", new String[0]);
        line.appendCsvFn("WifeMarriedResidence", new String[0]);
        line.appendCsvFn("WifeMarriedComment", new String[0]);
        line.appendCsvFn("WifeFatherLastName", new String[0]);
        line.appendCsvFn("WifeFatherFirstName", new String[0]);
        line.appendCsvFn("WifeFatherAge", new String[0]);
        line.appendCsvFn("WifeFatherDead", new String[0]);
        line.appendCsvFn("WifeFatherOccupation", new String[0]);
        line.appendCsvFn("WifeFatherResidence", new String[0]);
        line.appendCsvFn("WifeFatherComment", new String[0]);
        line.appendCsvFn("WifeMotherLastName", new String[0]);
        line.appendCsvFn("WifeMotherFirstName", new String[0]);
        line.appendCsvFn("WifeMotherAge", new String[0]);
        line.appendCsvFn("WifeMotherDead", new String[0]);
        line.appendCsvFn("WifeMotherOccupation", new String[0]);
        line.appendCsvFn("WifeMotherResidence", new String[0]);
        line.appendCsvFn("WifeMotherComment", new String[0]);
        line.appendCsvFn("Witness1LastName", new String[0]);
        line.appendCsvFn("Witness1FirstName", new String[0]);
        line.appendCsvFn("Witness1Occupation", new String[0]);
        line.appendCsvFn("Witness1Comment", new String[0]);
        line.appendCsvFn("Witness2LastName", new String[0]);
        line.appendCsvFn("Witness2FirstName", new String[0]);
        line.appendCsvFn("Witness2Occupation", new String[0]);
        line.appendCsvFn("Witness2Comment", new String[0]);
        line.appendCsvFn("Witness3LastName", new String[0]);
        line.appendCsvFn("Witness3FirstName", new String[0]);
        line.appendCsvFn("Witness3Occupation", new String[0]);
        line.appendCsvFn("Witness3Comment", new String[0]);
        line.appendCsvFn("Witness4LastName", new String[0]);
        line.appendCsvFn("Witness4FirstName", new String[0]);
        line.appendCsvFn("Witness4Occupation", new String[0]);
        line.appendCsvFn("Witness4Comment", new String[0]);
        line.appendCsv("GeneralComment", new String[0]);
        line.appendCsv("\n", new String[0]);
        return line;
    }

    static enum Field {
        ancetris,
        nomCommune,
        codeCommune,
        nomDepartement,
        stateName,
        countryName,
        parish,
        eventType,
        eventTypeName,
        eventTypeComment,
        eventDate,
        secondDate,
        cote,
        freeComment,
        notaryComment,
        indiLastName,
        indiFirstName,
        indiSex,
        indiBirthPlace,
        indiBirthDate,
        indiAge,
        indiOccupation,
        indiResidence,
        indiComment,
        indiMarriedLastName,
        indiMarriedFirstName,
        indiMarriedDead,
        indiMarriedOccupation,
        indiMarriedResidence,
        indiMarriedComment,
        indiFatherLastName,
        indiFatherFirstName,
        indiFatherAge,
        indiFatherDead,
        indiFatherOccupation,
        indiFatherResidence,
        indiFatherComment,
        indiMotherLastName,
        indiMotherFirstName,
        indiMotherAge,
        indiMotherDead,
        indiMotherOccupation,
        indiMotherResidence,
        indiMotherComment,
        wifeLastName,
        wifeFirstName,
        wifeSex,
        wifeBirthPlace,
        wifeBirthDate,
        wifeAge,
        wifeOccupation,
        wifeResidence,
        wifeComment,
        wifeMarriedLastName,
        wifeMarriedFirstName,
        wifeMarriedDead,
        wifeMarriedOccupation,
        wifeMarriedResidence,
        wifeMarriedComment,
        wifeFatherLastName,
        wifeFatherFirstName,
        wifeFatherAge,
        wifeFatherDead,
        wifeFatherOccupation,
        wifeFatherResidence,
        wifeFatherComment,
        wifeMotherLastName,
        wifeMotherFirstName,
        wifeMotherAge,
        wifeMotherDead,
        wifeMotherOccupation,
        wifeMotherResidence,
        wifeMotherComment,
        witness1LastName,
        witness1FirstName,
        witness1Occupation,
        witness1Comment,
        witness2LastName,
        witness2FirstName,
        witness2Occupation,
        witness2Comment,
        witness3LastName,
        witness3FirstName,
        witness3Occupation,
        witness3Comment,
        witness4LastName,
        witness4FirstName,
        witness4Occupation,
        witness4Comment,
        generalComment;

    }
}

