/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.genealogieonline;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.SaveOptionsWidget;
import ancestris.modules.exports.genealogieonline.GenealogieonlineExport;
import ancestris.util.ProgressListener;
import ancestris.util.Utilities;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.io.Filter;
import genj.util.Trackable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GenealogieonlineExportAction
extends AbstractAncestrisContextAction {
    public GenealogieonlineExportAction() {
        this.setIconBase("ancestris/modules/exports/genealogieonline/genealogieonline.png");
        this.setText(NbBundle.getMessage(GenealogieonlineExportAction.class, (String)"CTL_GenealogieonlineExportAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            Gedcom myGedcom = contextToOpen.getGedcom();
            String gedcomName = this.removeExtension(myGedcom.getName());
            ArrayList theFilters = new ArrayList(6);
            AncestrisPlugin.lookupAll(Filter.class).stream().filter(f -> f.canApplyTo(myGedcom)).forEachOrdered(f -> theFilters.add(f));
            Lookup.getDefault().lookupAll(Filter.class).stream().filter(f -> f.canApplyTo(myGedcom)).forEachOrdered(f -> theFilters.add(f));
            SaveOptionsWidget options = new SaveOptionsWidget(myGedcom, theFilters.toArray(new Filter[0]), SaveOptionsWidget.OptionsSaveType.GENEANET);
            File file = new FileChooserBuilder(GenealogieonlineExportAction.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FileChooserTitle", (Object)myGedcom.getName())).setApproveText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FileChooserOKButton")).setFileFilter((FileFilter)FileChooserBuilder.getGedcomFilter()).setAcceptAllFileFilterUsed(false).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setAccessory((JComponent)options).setFileHiding(true).setSelectedFile(new File(gedcomName + "-genealogieonline")).showSaveDialog();
            if (file != null) {
                options.saveOptions();
                GenealogieonlineExport exportGenealogieonline = new GenealogieonlineExport(myGedcom, file, options);
                Utilities.setCursorWaiting(null);
                ProgressListener.Dispatcher.processStarted((Trackable)exportGenealogieonline);
                exportGenealogieonline.run();
                ProgressListener.Dispatcher.processStopped((Trackable)exportGenealogieonline);
                Utilities.setCursorNormal(null);
            }
        }
    }

    private String removeExtension(String filename) {
        int extensionIndex;
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = filename.lastIndexOf(separator);
        if (lastSeparatorIndex != -1) {
            filename = filename.substring(lastSeparatorIndex + 1);
        }
        if ((extensionIndex = filename.lastIndexOf(".")) == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }
}

