/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnectionMetaData;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.connector.OracleManagedConnection;

public class OracleManagedConnectionMetaData
implements ManagedConnectionMetaData {
    private OracleManagedConnection managedConnection = null;
    private OracleDatabaseMetaData databaseMetaData = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    OracleManagedConnectionMetaData(OracleManagedConnection oracleManagedConnection) throws ResourceException {
        try {
            this.managedConnection = oracleManagedConnection;
            OracleConnection oracleConnection = (OracleConnection)oracleManagedConnection.getPhysicalConnection();
            this.databaseMetaData = (OracleDatabaseMetaData)oracleConnection.getMetaData();
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException("Exception: " + exception.getMessage());
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    public String getEISProductName() throws ResourceException {
        try {
            return this.databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public String getEISProductVersion() throws ResourceException {
        try {
            return this.databaseMetaData.getDatabaseProductVersion();
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException("Exception: " + exception.getMessage());
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    public int getMaxConnections() throws ResourceException {
        try {
            return this.databaseMetaData.getMaxConnections();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public String getUserName() throws ResourceException {
        try {
            return this.databaseMetaData.getUserName();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }
}

