# Shader Variations

To build multiple variations of a shader, add a file named X.json corresponding to shader file X.  A
variation is generated by building the shader with different definitions (a la glslang_validator's
-DName=1).  These definitions come from flags and enumerations defined in the json file.  Without a
.json file, the shader is generated as is (1 variation).

There are multiple possible fields in the json file:

- "Description": This contains the license and other comments, which will be ignored.
- "Flags": this is a list of flags.  Each flag FLAG defines a shader variation with or without the
  define FLAG=1.
- other: any other field is a similar list to flags, except that each entry in this enumeration is a
  variation.  Similar to "flags", every entry ENTRY results in an ENTRY=1 define.

Flags are shorthand for 2-entry enumerations.  Given n flags, there are 2^n variations where every
flag is either present or not.  For enumerations, only one entry is active in any variation.  Thus,
an enumeration with n entries generates n variations.

## Example

Here is an example json file:

{
    "Description": [
        "Copyright 2018 The ANGLE Project Authors. All rights reserved.",
        "Use of this source code is governed by a BSD-style license that can be",
        "found in the LICENSE file.",
        "",
        "RayTrace.comp.json: Build parameters for RayTrace.comp."
    ],
    "Flags": [
        "NanFilter",
        "WorkaroundIntelBug"
    ],
    "RayTraceQuality": [
        "IsRTLowRes",
        "IsRTHighRes",
        "IsRTAwesome"
    ],
    "ImageType": [
        "IsR",
        "IsRG",
        "IsRGB",
        "IsRGBA"
    ]
}

This will generate 2^2 * 3 * 4 shaders.
