% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-construction.R
\name{update_ggplot}
\alias{update_ggplot}
\alias{ggplot_add}
\title{Add custom objects to ggplot}
\usage{
update_ggplot(object, plot, ...)

ggplot_add(object, plot, ...)
}
\arguments{
\item{object}{An object to add to the plot}

\item{plot}{The ggplot object to add \code{object} to}
}
\value{
A modified ggplot object
}
\description{
This generic allows you to add your own methods for adding custom objects to
a ggplot with \link[=add_gg]{+.gg}. The \code{ggplot_add()} function is vestigial and
the \code{update_ggplot()} function should be used instead.
}
\details{
Custom methods for \code{update_ggplot()} are intended to update the \code{plot} variable
using information from a custom \code{object}. This can become convenient when
writing extensions that don't build on the pre-existing grammar like
layers, facets, coords and themes. The \code{update_ggplot()} function is never
intended to be used directly, but it is triggered when an object is added
to a plot via the \code{+} operator. Please note that the full \code{plot} object is
exposed at this point, which comes with the responsibility of returning
the plot intact.
}
\examples{
# making a new method for the generic
# in this example, we enable adding text elements
S7::method(update_ggplot, list(element_text, class_ggplot)) <-
  function(object, plot, ...) {
    plot + theme(text = object)
  }

# we can now use `+` to add our object to a plot
ggplot(mpg, aes(displ, cty)) +
  geom_point() +
  element_text(colour = "red")

# clean-up
}
\keyword{internal}
