# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._event_routes_operations import (
    build_add_request,
    build_delete_request,
    build_get_by_id_request,
    build_list_request,
)
from .._configuration import AzureDigitalTwinsAPIConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class EventRoutesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.digitaltwins.core.aio.AzureDigitalTwinsAPI`'s
        :attr:`event_routes` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AzureDigitalTwinsAPIConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, event_routes_list_options: Optional[_models.EventRoutesListOptions] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.DigitalTwinsEventRoute"]:
        """Retrieves all event routes.
        Status codes:


        * 200 OK.

        :param event_routes_list_options: Parameter group. Default value is None.
        :type event_routes_list_options: ~azure.digitaltwins.core.models.EventRoutesListOptions
        :return: An iterator like instance of either DigitalTwinsEventRoute or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.digitaltwins.core.models.DigitalTwinsEventRoute]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.EventRouteCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _traceparent = None
                _tracestate = None
                _max_items_per_page = None
                if event_routes_list_options is not None:
                    _max_items_per_page = event_routes_list_options.max_items_per_page
                    _traceparent = event_routes_list_options.traceparent
                    _tracestate = event_routes_list_options.tracestate

                _request = build_list_request(
                    traceparent=_traceparent,
                    tracestate=_tracestate,
                    max_items_per_page=_max_items_per_page,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("EventRouteCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_by_id(
        self, id: str, event_routes_get_by_id_options: Optional[_models.EventRoutesGetByIdOptions] = None, **kwargs: Any
    ) -> _models.DigitalTwinsEventRoute:
        """Retrieves an event route.
        Status codes:


        * 200 OK
        * 404 Not Found

          * EventRouteNotFound - The event route was not found.

        :param id: The id for an event route. The id is unique within event routes and case sensitive.
         Required.
        :type id: str
        :param event_routes_get_by_id_options: Parameter group. Default value is None.
        :type event_routes_get_by_id_options: ~azure.digitaltwins.core.models.EventRoutesGetByIdOptions
        :return: DigitalTwinsEventRoute or the result of cls(response)
        :rtype: ~azure.digitaltwins.core.models.DigitalTwinsEventRoute
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DigitalTwinsEventRoute] = kwargs.pop("cls", None)

        _traceparent = None
        _tracestate = None
        if event_routes_get_by_id_options is not None:
            _traceparent = event_routes_get_by_id_options.traceparent
            _tracestate = event_routes_get_by_id_options.tracestate

        _request = build_get_by_id_request(
            id=id,
            traceparent=_traceparent,
            tracestate=_tracestate,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DigitalTwinsEventRoute", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add(
        self,
        id: str,
        event_route: _models.DigitalTwinsEventRoute,
        event_routes_add_options: Optional[_models.EventRoutesAddOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Adds or replaces an event route.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * EventRouteEndpointInvalid - The endpoint provided does not exist or is not active.
          * EventRouteFilterInvalid - The event route filter is invalid.
          * EventRouteIdInvalid - The event route id is invalid.
          * LimitExceeded - The maximum number of event routes allowed has been reached.

        :param id: The id for an event route. The id is unique within event routes and case sensitive.
         Required.
        :type id: str
        :param event_route: The event route data. Required.
        :type event_route: ~azure.digitaltwins.core.models.DigitalTwinsEventRoute
        :param event_routes_add_options: Parameter group. Default value is None.
        :type event_routes_add_options: ~azure.digitaltwins.core.models.EventRoutesAddOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add(
        self,
        id: str,
        event_route: IO[bytes],
        event_routes_add_options: Optional[_models.EventRoutesAddOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Adds or replaces an event route.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * EventRouteEndpointInvalid - The endpoint provided does not exist or is not active.
          * EventRouteFilterInvalid - The event route filter is invalid.
          * EventRouteIdInvalid - The event route id is invalid.
          * LimitExceeded - The maximum number of event routes allowed has been reached.

        :param id: The id for an event route. The id is unique within event routes and case sensitive.
         Required.
        :type id: str
        :param event_route: The event route data. Required.
        :type event_route: IO[bytes]
        :param event_routes_add_options: Parameter group. Default value is None.
        :type event_routes_add_options: ~azure.digitaltwins.core.models.EventRoutesAddOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add(
        self,
        id: str,
        event_route: Union[_models.DigitalTwinsEventRoute, IO[bytes]],
        event_routes_add_options: Optional[_models.EventRoutesAddOptions] = None,
        **kwargs: Any
    ) -> None:
        """Adds or replaces an event route.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * EventRouteEndpointInvalid - The endpoint provided does not exist or is not active.
          * EventRouteFilterInvalid - The event route filter is invalid.
          * EventRouteIdInvalid - The event route id is invalid.
          * LimitExceeded - The maximum number of event routes allowed has been reached.

        :param id: The id for an event route. The id is unique within event routes and case sensitive.
         Required.
        :type id: str
        :param event_route: The event route data. Is either a DigitalTwinsEventRoute type or a
         IO[bytes] type. Required.
        :type event_route: ~azure.digitaltwins.core.models.DigitalTwinsEventRoute or IO[bytes]
        :param event_routes_add_options: Parameter group. Default value is None.
        :type event_routes_add_options: ~azure.digitaltwins.core.models.EventRoutesAddOptions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _traceparent = None
        _tracestate = None
        if event_routes_add_options is not None:
            _traceparent = event_routes_add_options.traceparent
            _tracestate = event_routes_add_options.tracestate
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(event_route, (IOBase, bytes)):
            _content = event_route
        else:
            _json = self._serialize.body(event_route, "DigitalTwinsEventRoute")

        _request = build_add_request(
            id=id,
            traceparent=_traceparent,
            tracestate=_tracestate,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete(
        self, id: str, event_routes_delete_options: Optional[_models.EventRoutesDeleteOptions] = None, **kwargs: Any
    ) -> None:
        """Deletes an event route.
        Status codes:


        * 204 No Content
        * 404 Not Found

          * EventRouteNotFound - The event route was not found.

        :param id: The id for an event route. The id is unique within event routes and case sensitive.
         Required.
        :type id: str
        :param event_routes_delete_options: Parameter group. Default value is None.
        :type event_routes_delete_options: ~azure.digitaltwins.core.models.EventRoutesDeleteOptions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _traceparent = None
        _tracestate = None
        if event_routes_delete_options is not None:
            _traceparent = event_routes_delete_options.traceparent
            _tracestate = event_routes_delete_options.tracestate

        _request = build_delete_request(
            id=id,
            traceparent=_traceparent,
            tracestate=_tracestate,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
