# == Class: manila::client
#
# Installs Manila python client.
#
# === Parameters
#
# [*package_ensure*]
#   Ensure state for package. Defaults to 'present'.
#
class manila::client (
  Stdlib::Ensure::Package $package_ensure = 'present',
) {
  include manila::deps
  include manila::params

  package { 'python-manilaclient':
    ensure => $package_ensure,
    name   => $manila::params::client_package,
    tag    => ['openstack', 'openstackclient'],
  }

  include openstacklib::openstackclient
}
