; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -disable-auto-paired-vec-st=false < %s | FileCheck %s \
; RUN:   --check-prefix=LE-PAIRED
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=future -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   -disable-auto-paired-vec-st=false < %s | FileCheck %s \
; RUN:   --check-prefix=LE-PAIRED-WACC
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -disable-auto-paired-vec-st=false < %s | \
; RUN:   FileCheck %s --check-prefix=BE-PAIRED
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=future -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -disable-auto-paired-vec-st=false < %s | \
; RUN:   FileCheck %s --check-prefix=BE-PAIRED-WACC
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -ppc-vsr-nums-as-vr \
; RUN:   -ppc-asm-full-reg-names -mtriple=powerpc64le-unknown-linux-gnu < %s \
; RUN:   | FileCheck %s --check-prefix=LE-PWR9
; RUN: llc -verify-machineinstrs -mcpu=pwr8 -ppc-vsr-nums-as-vr \
; RUN:   -ppc-asm-full-reg-names -mtriple=powerpc64le-unknown-linux-gnu < %s \
; RUN:   | FileCheck %s --check-prefix=LE-PWR8
; RUN: llc -verify-machineinstrs -mcpu=pwr9 -ppc-vsr-nums-as-vr \
; RUN:   -ppc-asm-full-reg-names -mtriple=powerpc64-unknown-linux-gnu < %s \
; RUN:   | FileCheck %s --check-prefix=BE-PWR9
; RUN: llc -verify-machineinstrs -mcpu=pwr8 -ppc-vsr-nums-as-vr \
; RUN:   -ppc-asm-full-reg-names -mtriple=powerpc64-unknown-linux-gnu < %s \
; RUN:   | FileCheck %s --check-prefix=BE-PWR8

@f = common dso_local local_unnamed_addr global <512 x i1> zeroinitializer, align 16
@g = common dso_local local_unnamed_addr global <256 x i1> zeroinitializer, align 16

define dso_local void @testLdSt(i64 %SrcIdx, i64 %DstIdx) {
; LE-PAIRED-LABEL: testLdSt:
; LE-PAIRED:       # %bb.0: # %entry
; LE-PAIRED-NEXT:    plxv vs3, f@PCREL+64(0), 1
; LE-PAIRED-NEXT:    plxv vs2, f@PCREL+80(0), 1
; LE-PAIRED-NEXT:    plxv vs1, f@PCREL+96(0), 1
; LE-PAIRED-NEXT:    plxv vs0, f@PCREL+112(0), 1
; LE-PAIRED-NEXT:    pstxv vs0, f@PCREL+176(0), 1
; LE-PAIRED-NEXT:    pstxv vs1, f@PCREL+160(0), 1
; LE-PAIRED-NEXT:    pstxv vs2, f@PCREL+144(0), 1
; LE-PAIRED-NEXT:    pstxv vs3, f@PCREL+128(0), 1
; LE-PAIRED-NEXT:    blr
;
; LE-PAIRED-WACC-LABEL: testLdSt:
; LE-PAIRED-WACC:       # %bb.0: # %entry
; LE-PAIRED-WACC-NEXT:    plxv v3, f@PCREL+64(0), 1
; LE-PAIRED-WACC-NEXT:    plxv v5, f@PCREL+96(0), 1
; LE-PAIRED-WACC-NEXT:    plxv v2, f@PCREL+80(0), 1
; LE-PAIRED-WACC-NEXT:    plxv v4, f@PCREL+112(0), 1
; LE-PAIRED-WACC-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; LE-PAIRED-WACC-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; LE-PAIRED-WACC-NEXT:    pstxv v4, f@PCREL+176(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv v5, f@PCREL+160(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv v2, f@PCREL+144(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv v3, f@PCREL+128(0), 1
; LE-PAIRED-WACC-NEXT:    blr
;
; BE-PAIRED-LABEL: testLdSt:
; BE-PAIRED:       # %bb.0: # %entry
; BE-PAIRED-NEXT:    addis r3, r2, f@toc@ha
; BE-PAIRED-NEXT:    addi r3, r3, f@toc@l
; BE-PAIRED-NEXT:    lxv vs3, 112(r3)
; BE-PAIRED-NEXT:    lxv vs2, 96(r3)
; BE-PAIRED-NEXT:    lxv vs1, 80(r3)
; BE-PAIRED-NEXT:    lxv vs0, 64(r3)
; BE-PAIRED-NEXT:    stxv vs1, 144(r3)
; BE-PAIRED-NEXT:    stxv vs0, 128(r3)
; BE-PAIRED-NEXT:    stxv vs3, 176(r3)
; BE-PAIRED-NEXT:    stxv vs2, 160(r3)
; BE-PAIRED-NEXT:    blr
;
; BE-PAIRED-WACC-LABEL: testLdSt:
; BE-PAIRED-WACC:       # %bb.0: # %entry
; BE-PAIRED-WACC-NEXT:    addis r3, r2, f@toc@ha
; BE-PAIRED-WACC-NEXT:    addi r3, r3, f@toc@l
; BE-PAIRED-WACC-NEXT:    lxv v3, 112(r3)
; BE-PAIRED-WACC-NEXT:    lxv v5, 80(r3)
; BE-PAIRED-WACC-NEXT:    lxv v2, 96(r3)
; BE-PAIRED-WACC-NEXT:    lxv v4, 64(r3)
; BE-PAIRED-WACC-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; BE-PAIRED-WACC-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; BE-PAIRED-WACC-NEXT:    stxv v5, 176(r3)
; BE-PAIRED-WACC-NEXT:    stxv v4, 160(r3)
; BE-PAIRED-WACC-NEXT:    stxv v3, 144(r3)
; BE-PAIRED-WACC-NEXT:    stxv v2, 128(r3)
; BE-PAIRED-WACC-NEXT:    blr
;
; LE-PWR9-LABEL: testLdSt:
; LE-PWR9:       # %bb.0: # %entry
; LE-PWR9-NEXT:    addis r3, r2, f@toc@ha
; LE-PWR9-NEXT:    addi r3, r3, f@toc@l
; LE-PWR9-NEXT:    lxv vs1, 96(r3)
; LE-PWR9-NEXT:    lxv vs0, 64(r3)
; LE-PWR9-NEXT:    lxv vs2, 112(r3)
; LE-PWR9-NEXT:    stxv vs1, 160(r3)
; LE-PWR9-NEXT:    lxv vs1, 80(r3)
; LE-PWR9-NEXT:    stxv vs2, 176(r3)
; LE-PWR9-NEXT:    stxv vs0, 128(r3)
; LE-PWR9-NEXT:    stxv vs1, 144(r3)
; LE-PWR9-NEXT:    blr
;
; LE-PWR8-LABEL: testLdSt:
; LE-PWR8:       # %bb.0: # %entry
; LE-PWR8-NEXT:    addis r3, r2, f@toc@ha
; LE-PWR8-NEXT:    li r4, 64
; LE-PWR8-NEXT:    addi r3, r3, f@toc@l
; LE-PWR8-NEXT:    lxvd2x vs0, r3, r4
; LE-PWR8-NEXT:    li r4, 80
; LE-PWR8-NEXT:    lxvd2x vs1, r3, r4
; LE-PWR8-NEXT:    li r4, 96
; LE-PWR8-NEXT:    lxvd2x vs2, r3, r4
; LE-PWR8-NEXT:    li r4, 112
; LE-PWR8-NEXT:    lxvd2x vs3, r3, r4
; LE-PWR8-NEXT:    li r4, 176
; LE-PWR8-NEXT:    stxvd2x vs3, r3, r4
; LE-PWR8-NEXT:    li r4, 160
; LE-PWR8-NEXT:    stxvd2x vs2, r3, r4
; LE-PWR8-NEXT:    li r4, 144
; LE-PWR8-NEXT:    stxvd2x vs1, r3, r4
; LE-PWR8-NEXT:    li r4, 128
; LE-PWR8-NEXT:    stxvd2x vs0, r3, r4
; LE-PWR8-NEXT:    blr
;
; BE-PWR9-LABEL: testLdSt:
; BE-PWR9:       # %bb.0: # %entry
; BE-PWR9-NEXT:    addis r3, r2, f@toc@ha
; BE-PWR9-NEXT:    addi r3, r3, f@toc@l
; BE-PWR9-NEXT:    lxv vs1, 96(r3)
; BE-PWR9-NEXT:    lxv vs0, 64(r3)
; BE-PWR9-NEXT:    lxv vs2, 112(r3)
; BE-PWR9-NEXT:    stxv vs1, 160(r3)
; BE-PWR9-NEXT:    lxv vs1, 80(r3)
; BE-PWR9-NEXT:    stxv vs2, 176(r3)
; BE-PWR9-NEXT:    stxv vs0, 128(r3)
; BE-PWR9-NEXT:    stxv vs1, 144(r3)
; BE-PWR9-NEXT:    blr
;
; BE-PWR8-LABEL: testLdSt:
; BE-PWR8:       # %bb.0: # %entry
; BE-PWR8-NEXT:    addis r3, r2, f@toc@ha
; BE-PWR8-NEXT:    li r4, 64
; BE-PWR8-NEXT:    addi r3, r3, f@toc@l
; BE-PWR8-NEXT:    lxvd2x vs0, r3, r4
; BE-PWR8-NEXT:    li r4, 80
; BE-PWR8-NEXT:    lxvd2x vs1, r3, r4
; BE-PWR8-NEXT:    li r4, 96
; BE-PWR8-NEXT:    lxvd2x vs2, r3, r4
; BE-PWR8-NEXT:    li r4, 112
; BE-PWR8-NEXT:    lxvd2x vs3, r3, r4
; BE-PWR8-NEXT:    li r4, 176
; BE-PWR8-NEXT:    stxvd2x vs3, r3, r4
; BE-PWR8-NEXT:    li r4, 160
; BE-PWR8-NEXT:    stxvd2x vs2, r3, r4
; BE-PWR8-NEXT:    li r4, 144
; BE-PWR8-NEXT:    stxvd2x vs1, r3, r4
; BE-PWR8-NEXT:    li r4, 128
; BE-PWR8-NEXT:    stxvd2x vs0, r3, r4
; BE-PWR8-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds <512 x i1>, ptr @f, i64 1
  %0 = load <512 x i1>, ptr %arrayidx, align 64
  %arrayidx1 = getelementptr inbounds <512 x i1>, ptr @f, i64 2
  store <512 x i1> %0, ptr %arrayidx1, align 64
  ret void
}

define dso_local void @testXLdSt(i64 %SrcIdx, i64 %DstIdx) {
; LE-PAIRED-LABEL: testXLdSt:
; LE-PAIRED:       # %bb.0: # %entry
; LE-PAIRED-NEXT:    paddi r5, 0, f@PCREL, 1
; LE-PAIRED-NEXT:    sldi r3, r3, 6
; LE-PAIRED-NEXT:    add r6, r5, r3
; LE-PAIRED-NEXT:    lxvx vs3, r5, r3
; LE-PAIRED-NEXT:    sldi r3, r4, 6
; LE-PAIRED-NEXT:    add r4, r5, r3
; LE-PAIRED-NEXT:    lxv vs2, 16(r6)
; LE-PAIRED-NEXT:    lxv vs1, 32(r6)
; LE-PAIRED-NEXT:    lxv vs0, 48(r6)
; LE-PAIRED-NEXT:    stxvx vs3, r5, r3
; LE-PAIRED-NEXT:    stxv vs0, 48(r4)
; LE-PAIRED-NEXT:    stxv vs1, 32(r4)
; LE-PAIRED-NEXT:    stxv vs2, 16(r4)
; LE-PAIRED-NEXT:    blr
;
; LE-PAIRED-WACC-LABEL: testXLdSt:
; LE-PAIRED-WACC:       # %bb.0: # %entry
; LE-PAIRED-WACC-NEXT:    paddi r5, 0, f@PCREL, 1
; LE-PAIRED-WACC-NEXT:    sldi r3, r3, 6
; LE-PAIRED-WACC-NEXT:    add r6, r5, r3
; LE-PAIRED-WACC-NEXT:    lxvx v3, r5, r3
; LE-PAIRED-WACC-NEXT:    lxv v2, 16(r6)
; LE-PAIRED-WACC-NEXT:    lxv v5, 32(r6)
; LE-PAIRED-WACC-NEXT:    lxv v4, 48(r6)
; LE-PAIRED-WACC-NEXT:    sldi r3, r4, 6
; LE-PAIRED-WACC-NEXT:    add r4, r5, r3
; LE-PAIRED-WACC-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; LE-PAIRED-WACC-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; LE-PAIRED-WACC-NEXT:    stxvx v3, r5, r3
; LE-PAIRED-WACC-NEXT:    stxv v4, 48(r4)
; LE-PAIRED-WACC-NEXT:    stxv v5, 32(r4)
; LE-PAIRED-WACC-NEXT:    stxv v2, 16(r4)
; LE-PAIRED-WACC-NEXT:    blr
;
; BE-PAIRED-LABEL: testXLdSt:
; BE-PAIRED:       # %bb.0: # %entry
; BE-PAIRED-NEXT:    addis r5, r2, f@toc@ha
; BE-PAIRED-NEXT:    addi r5, r5, f@toc@l
; BE-PAIRED-NEXT:    sldi r3, r3, 6
; BE-PAIRED-NEXT:    add r6, r5, r3
; BE-PAIRED-NEXT:    lxv vs3, 48(r6)
; BE-PAIRED-NEXT:    lxv vs2, 32(r6)
; BE-PAIRED-NEXT:    lxvx vs0, r5, r3
; BE-PAIRED-NEXT:    lxv vs1, 16(r6)
; BE-PAIRED-NEXT:    sldi r3, r4, 6
; BE-PAIRED-NEXT:    add r4, r5, r3
; BE-PAIRED-NEXT:    stxvx vs0, r5, r3
; BE-PAIRED-NEXT:    stxv vs1, 16(r4)
; BE-PAIRED-NEXT:    stxv vs3, 48(r4)
; BE-PAIRED-NEXT:    stxv vs2, 32(r4)
; BE-PAIRED-NEXT:    blr
;
; BE-PAIRED-WACC-LABEL: testXLdSt:
; BE-PAIRED-WACC:       # %bb.0: # %entry
; BE-PAIRED-WACC-NEXT:    addis r5, r2, f@toc@ha
; BE-PAIRED-WACC-NEXT:    addi r5, r5, f@toc@l
; BE-PAIRED-WACC-NEXT:    sldi r3, r3, 6
; BE-PAIRED-WACC-NEXT:    add r6, r5, r3
; BE-PAIRED-WACC-NEXT:    lxvx v2, r5, r3
; BE-PAIRED-WACC-NEXT:    lxv v5, 48(r6)
; BE-PAIRED-WACC-NEXT:    lxv v3, 16(r6)
; BE-PAIRED-WACC-NEXT:    lxv v4, 32(r6)
; BE-PAIRED-WACC-NEXT:    sldi r3, r4, 6
; BE-PAIRED-WACC-NEXT:    add r4, r5, r3
; BE-PAIRED-WACC-NEXT:    dmxxinstdmr512 wacc0, vsp34, vsp36, 0
; BE-PAIRED-WACC-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; BE-PAIRED-WACC-NEXT:    stxvx v2, r5, r3
; BE-PAIRED-WACC-NEXT:    stxv v5, 48(r4)
; BE-PAIRED-WACC-NEXT:    stxv v4, 32(r4)
; BE-PAIRED-WACC-NEXT:    stxv v3, 16(r4)
; BE-PAIRED-WACC-NEXT:    blr
;
; LE-PWR9-LABEL: testXLdSt:
; LE-PWR9:       # %bb.0: # %entry
; LE-PWR9-NEXT:    addis r5, r2, f@toc@ha
; LE-PWR9-NEXT:    sldi r3, r3, 6
; LE-PWR9-NEXT:    addi r5, r5, f@toc@l
; LE-PWR9-NEXT:    add r6, r5, r3
; LE-PWR9-NEXT:    lxvx vs3, r5, r3
; LE-PWR9-NEXT:    sldi r3, r4, 6
; LE-PWR9-NEXT:    lxv vs0, 16(r6)
; LE-PWR9-NEXT:    lxv vs1, 32(r6)
; LE-PWR9-NEXT:    lxv vs2, 48(r6)
; LE-PWR9-NEXT:    stxvx vs3, r5, r3
; LE-PWR9-NEXT:    add r3, r5, r3
; LE-PWR9-NEXT:    stxv vs2, 48(r3)
; LE-PWR9-NEXT:    stxv vs1, 32(r3)
; LE-PWR9-NEXT:    stxv vs0, 16(r3)
; LE-PWR9-NEXT:    blr
;
; LE-PWR8-LABEL: testXLdSt:
; LE-PWR8:       # %bb.0: # %entry
; LE-PWR8-NEXT:    addis r5, r2, f@toc@ha
; LE-PWR8-NEXT:    sldi r3, r3, 6
; LE-PWR8-NEXT:    li r7, 16
; LE-PWR8-NEXT:    li r8, 32
; LE-PWR8-NEXT:    li r9, 48
; LE-PWR8-NEXT:    addi r5, r5, f@toc@l
; LE-PWR8-NEXT:    add r6, r5, r3
; LE-PWR8-NEXT:    lxvd2x vs3, r5, r3
; LE-PWR8-NEXT:    sldi r3, r4, 6
; LE-PWR8-NEXT:    lxvd2x vs0, r6, r7
; LE-PWR8-NEXT:    lxvd2x vs1, r6, r8
; LE-PWR8-NEXT:    lxvd2x vs2, r6, r9
; LE-PWR8-NEXT:    stxvd2x vs3, r5, r3
; LE-PWR8-NEXT:    add r3, r5, r3
; LE-PWR8-NEXT:    stxvd2x vs2, r3, r9
; LE-PWR8-NEXT:    stxvd2x vs1, r3, r8
; LE-PWR8-NEXT:    stxvd2x vs0, r3, r7
; LE-PWR8-NEXT:    blr
;
; BE-PWR9-LABEL: testXLdSt:
; BE-PWR9:       # %bb.0: # %entry
; BE-PWR9-NEXT:    addis r5, r2, f@toc@ha
; BE-PWR9-NEXT:    sldi r3, r3, 6
; BE-PWR9-NEXT:    addi r5, r5, f@toc@l
; BE-PWR9-NEXT:    add r6, r5, r3
; BE-PWR9-NEXT:    lxvx vs3, r5, r3
; BE-PWR9-NEXT:    sldi r3, r4, 6
; BE-PWR9-NEXT:    lxv vs0, 16(r6)
; BE-PWR9-NEXT:    lxv vs1, 32(r6)
; BE-PWR9-NEXT:    lxv vs2, 48(r6)
; BE-PWR9-NEXT:    stxvx vs3, r5, r3
; BE-PWR9-NEXT:    add r3, r5, r3
; BE-PWR9-NEXT:    stxv vs2, 48(r3)
; BE-PWR9-NEXT:    stxv vs1, 32(r3)
; BE-PWR9-NEXT:    stxv vs0, 16(r3)
; BE-PWR9-NEXT:    blr
;
; BE-PWR8-LABEL: testXLdSt:
; BE-PWR8:       # %bb.0: # %entry
; BE-PWR8-NEXT:    addis r5, r2, f@toc@ha
; BE-PWR8-NEXT:    sldi r3, r3, 6
; BE-PWR8-NEXT:    li r7, 32
; BE-PWR8-NEXT:    li r8, 48
; BE-PWR8-NEXT:    sldi r4, r4, 6
; BE-PWR8-NEXT:    addi r5, r5, f@toc@l
; BE-PWR8-NEXT:    add r6, r5, r3
; BE-PWR8-NEXT:    lxvd2x vs0, r5, r3
; BE-PWR8-NEXT:    li r3, 16
; BE-PWR8-NEXT:    lxvd2x vs1, r6, r3
; BE-PWR8-NEXT:    lxvd2x vs2, r6, r7
; BE-PWR8-NEXT:    lxvd2x vs3, r6, r8
; BE-PWR8-NEXT:    add r6, r5, r4
; BE-PWR8-NEXT:    stxvd2x vs0, r5, r4
; BE-PWR8-NEXT:    stxvd2x vs3, r6, r8
; BE-PWR8-NEXT:    stxvd2x vs2, r6, r7
; BE-PWR8-NEXT:    stxvd2x vs1, r6, r3
; BE-PWR8-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds <512 x i1>, ptr @f, i64 %SrcIdx
  %0 = load <512 x i1>, ptr %arrayidx, align 64
  %arrayidx1 = getelementptr inbounds <512 x i1>, ptr @f, i64 %DstIdx
  store <512 x i1> %0, ptr %arrayidx1, align 64
  ret void
}

define dso_local void @testUnalignedLdSt() {
; LE-PAIRED-LABEL: testUnalignedLdSt:
; LE-PAIRED:       # %bb.0: # %entry
; LE-PAIRED-NEXT:    plxv vs3, f@PCREL+11(0), 1
; LE-PAIRED-NEXT:    plxv vs2, f@PCREL+27(0), 1
; LE-PAIRED-NEXT:    plxv vs1, f@PCREL+43(0), 1
; LE-PAIRED-NEXT:    plxv vs0, f@PCREL+59(0), 1
; LE-PAIRED-NEXT:    pstxv vs0, f@PCREL+67(0), 1
; LE-PAIRED-NEXT:    pstxv vs1, f@PCREL+51(0), 1
; LE-PAIRED-NEXT:    pstxv vs2, f@PCREL+35(0), 1
; LE-PAIRED-NEXT:    pstxv vs3, f@PCREL+19(0), 1
; LE-PAIRED-NEXT:    blr
;
; LE-PAIRED-WACC-LABEL: testUnalignedLdSt:
; LE-PAIRED-WACC:       # %bb.0: # %entry
; LE-PAIRED-WACC-NEXT:    plxv v3, f@PCREL+11(0), 1
; LE-PAIRED-WACC-NEXT:    plxv v5, f@PCREL+43(0), 1
; LE-PAIRED-WACC-NEXT:    plxv v2, f@PCREL+27(0), 1
; LE-PAIRED-WACC-NEXT:    plxv v4, f@PCREL+59(0), 1
; LE-PAIRED-WACC-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; LE-PAIRED-WACC-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; LE-PAIRED-WACC-NEXT:    pstxv v4, f@PCREL+67(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv v5, f@PCREL+51(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv v2, f@PCREL+35(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv v3, f@PCREL+19(0), 1
; LE-PAIRED-WACC-NEXT:    blr
;
; BE-PAIRED-LABEL: testUnalignedLdSt:
; BE-PAIRED:       # %bb.0: # %entry
; BE-PAIRED-NEXT:    addis r3, r2, f@toc@ha
; BE-PAIRED-NEXT:    addi r3, r3, f@toc@l
; BE-PAIRED-NEXT:    plxv vs3, 59(r3), 0
; BE-PAIRED-NEXT:    plxv vs2, 43(r3), 0
; BE-PAIRED-NEXT:    plxv vs1, 27(r3), 0
; BE-PAIRED-NEXT:    plxv vs0, 11(r3), 0
; BE-PAIRED-NEXT:    pstxv vs1, 35(r3), 0
; BE-PAIRED-NEXT:    pstxv vs0, 19(r3), 0
; BE-PAIRED-NEXT:    pstxv vs3, 67(r3), 0
; BE-PAIRED-NEXT:    pstxv vs2, 51(r3), 0
; BE-PAIRED-NEXT:    blr
;
; BE-PAIRED-WACC-LABEL: testUnalignedLdSt:
; BE-PAIRED-WACC:       # %bb.0: # %entry
; BE-PAIRED-WACC-NEXT:    addis r3, r2, f@toc@ha
; BE-PAIRED-WACC-NEXT:    addi r3, r3, f@toc@l
; BE-PAIRED-WACC-NEXT:    plxv v3, 59(r3), 0
; BE-PAIRED-WACC-NEXT:    plxv v5, 27(r3), 0
; BE-PAIRED-WACC-NEXT:    plxv v2, 43(r3), 0
; BE-PAIRED-WACC-NEXT:    plxv v4, 11(r3), 0
; BE-PAIRED-WACC-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; BE-PAIRED-WACC-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; BE-PAIRED-WACC-NEXT:    pstxv v5, 67(r3), 0
; BE-PAIRED-WACC-NEXT:    pstxv v4, 51(r3), 0
; BE-PAIRED-WACC-NEXT:    pstxv v3, 35(r3), 0
; BE-PAIRED-WACC-NEXT:    pstxv v2, 19(r3), 0
; BE-PAIRED-WACC-NEXT:    blr
;
; LE-PWR9-LABEL: testUnalignedLdSt:
; LE-PWR9:       # %bb.0: # %entry
; LE-PWR9-NEXT:    addis r3, r2, f@toc@ha
; LE-PWR9-NEXT:    li r4, 11
; LE-PWR9-NEXT:    addi r3, r3, f@toc@l
; LE-PWR9-NEXT:    lxvx vs0, r3, r4
; LE-PWR9-NEXT:    li r4, 27
; LE-PWR9-NEXT:    lxvx vs1, r3, r4
; LE-PWR9-NEXT:    li r4, 43
; LE-PWR9-NEXT:    lxvx vs2, r3, r4
; LE-PWR9-NEXT:    li r4, 59
; LE-PWR9-NEXT:    lxvx vs3, r3, r4
; LE-PWR9-NEXT:    li r4, 67
; LE-PWR9-NEXT:    stxvx vs3, r3, r4
; LE-PWR9-NEXT:    li r4, 51
; LE-PWR9-NEXT:    stxvx vs2, r3, r4
; LE-PWR9-NEXT:    li r4, 35
; LE-PWR9-NEXT:    stxvx vs1, r3, r4
; LE-PWR9-NEXT:    li r4, 19
; LE-PWR9-NEXT:    stxvx vs0, r3, r4
; LE-PWR9-NEXT:    blr
;
; LE-PWR8-LABEL: testUnalignedLdSt:
; LE-PWR8:       # %bb.0: # %entry
; LE-PWR8-NEXT:    addis r3, r2, f@toc@ha
; LE-PWR8-NEXT:    li r4, 11
; LE-PWR8-NEXT:    addi r3, r3, f@toc@l
; LE-PWR8-NEXT:    lxvd2x vs0, r3, r4
; LE-PWR8-NEXT:    li r4, 27
; LE-PWR8-NEXT:    lxvd2x vs1, r3, r4
; LE-PWR8-NEXT:    li r4, 43
; LE-PWR8-NEXT:    lxvd2x vs2, r3, r4
; LE-PWR8-NEXT:    li r4, 59
; LE-PWR8-NEXT:    lxvd2x vs3, r3, r4
; LE-PWR8-NEXT:    li r4, 67
; LE-PWR8-NEXT:    stxvd2x vs3, r3, r4
; LE-PWR8-NEXT:    li r4, 51
; LE-PWR8-NEXT:    stxvd2x vs2, r3, r4
; LE-PWR8-NEXT:    li r4, 35
; LE-PWR8-NEXT:    stxvd2x vs1, r3, r4
; LE-PWR8-NEXT:    li r4, 19
; LE-PWR8-NEXT:    stxvd2x vs0, r3, r4
; LE-PWR8-NEXT:    blr
;
; BE-PWR9-LABEL: testUnalignedLdSt:
; BE-PWR9:       # %bb.0: # %entry
; BE-PWR9-NEXT:    addis r3, r2, f@toc@ha
; BE-PWR9-NEXT:    li r4, 11
; BE-PWR9-NEXT:    addi r3, r3, f@toc@l
; BE-PWR9-NEXT:    lxvx vs0, r3, r4
; BE-PWR9-NEXT:    li r4, 27
; BE-PWR9-NEXT:    lxvx vs1, r3, r4
; BE-PWR9-NEXT:    li r4, 43
; BE-PWR9-NEXT:    lxvx vs2, r3, r4
; BE-PWR9-NEXT:    li r4, 59
; BE-PWR9-NEXT:    lxvx vs3, r3, r4
; BE-PWR9-NEXT:    li r4, 67
; BE-PWR9-NEXT:    stxvx vs3, r3, r4
; BE-PWR9-NEXT:    li r4, 51
; BE-PWR9-NEXT:    stxvx vs2, r3, r4
; BE-PWR9-NEXT:    li r4, 35
; BE-PWR9-NEXT:    stxvx vs1, r3, r4
; BE-PWR9-NEXT:    li r4, 19
; BE-PWR9-NEXT:    stxvx vs0, r3, r4
; BE-PWR9-NEXT:    blr
;
; BE-PWR8-LABEL: testUnalignedLdSt:
; BE-PWR8:       # %bb.0: # %entry
; BE-PWR8-NEXT:    addis r3, r2, f@toc@ha
; BE-PWR8-NEXT:    li r4, 11
; BE-PWR8-NEXT:    addi r3, r3, f@toc@l
; BE-PWR8-NEXT:    lxvd2x vs0, r3, r4
; BE-PWR8-NEXT:    li r4, 27
; BE-PWR8-NEXT:    lxvd2x vs1, r3, r4
; BE-PWR8-NEXT:    li r4, 43
; BE-PWR8-NEXT:    lxvd2x vs2, r3, r4
; BE-PWR8-NEXT:    li r4, 59
; BE-PWR8-NEXT:    lxvd2x vs3, r3, r4
; BE-PWR8-NEXT:    li r4, 67
; BE-PWR8-NEXT:    stxvd2x vs3, r3, r4
; BE-PWR8-NEXT:    li r4, 51
; BE-PWR8-NEXT:    stxvd2x vs2, r3, r4
; BE-PWR8-NEXT:    li r4, 35
; BE-PWR8-NEXT:    stxvd2x vs1, r3, r4
; BE-PWR8-NEXT:    li r4, 19
; BE-PWR8-NEXT:    stxvd2x vs0, r3, r4
; BE-PWR8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr @f, i64 11
  %add.ptr1 = getelementptr inbounds i8, ptr @f, i64 19
  %0 = load <512 x i1>, ptr %add.ptr, align 64
  store <512 x i1> %0, ptr %add.ptr1, align 64
  ret void
}

define dso_local void @testLdStPair(i64 %SrcIdx, i64 %DstIdx) {
; LE-PAIRED-LABEL: testLdStPair:
; LE-PAIRED:       # %bb.0: # %entry
; LE-PAIRED-NEXT:    plxv vs0, g@PCREL+48(0), 1
; LE-PAIRED-NEXT:    plxv vs1, g@PCREL+32(0), 1
; LE-PAIRED-NEXT:    pstxv vs0, g@PCREL+80(0), 1
; LE-PAIRED-NEXT:    pstxv vs1, g@PCREL+64(0), 1
; LE-PAIRED-NEXT:    blr
;
; LE-PAIRED-WACC-LABEL: testLdStPair:
; LE-PAIRED-WACC:       # %bb.0: # %entry
; LE-PAIRED-WACC-NEXT:    plxv vs0, g@PCREL+48(0), 1
; LE-PAIRED-WACC-NEXT:    plxv vs1, g@PCREL+32(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv vs0, g@PCREL+80(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv vs1, g@PCREL+64(0), 1
; LE-PAIRED-WACC-NEXT:    blr
;
; BE-PAIRED-LABEL: testLdStPair:
; BE-PAIRED:       # %bb.0: # %entry
; BE-PAIRED-NEXT:    addis r3, r2, g@toc@ha
; BE-PAIRED-NEXT:    addi r3, r3, g@toc@l
; BE-PAIRED-NEXT:    lxv vs0, 32(r3)
; BE-PAIRED-NEXT:    lxv vs1, 48(r3)
; BE-PAIRED-NEXT:    stxv vs1, 80(r3)
; BE-PAIRED-NEXT:    stxv vs0, 64(r3)
; BE-PAIRED-NEXT:    blr
;
; BE-PAIRED-WACC-LABEL: testLdStPair:
; BE-PAIRED-WACC:       # %bb.0: # %entry
; BE-PAIRED-WACC-NEXT:    addis r3, r2, g@toc@ha
; BE-PAIRED-WACC-NEXT:    addi r3, r3, g@toc@l
; BE-PAIRED-WACC-NEXT:    lxv vs0, 48(r3)
; BE-PAIRED-WACC-NEXT:    lxv vs1, 32(r3)
; BE-PAIRED-WACC-NEXT:    stxv vs0, 80(r3)
; BE-PAIRED-WACC-NEXT:    stxv vs1, 64(r3)
; BE-PAIRED-WACC-NEXT:    blr
;
; LE-PWR9-LABEL: testLdStPair:
; LE-PWR9:       # %bb.0: # %entry
; LE-PWR9-NEXT:    addis r3, r2, g@toc@ha
; LE-PWR9-NEXT:    addi r3, r3, g@toc@l
; LE-PWR9-NEXT:    lxv vs0, 32(r3)
; LE-PWR9-NEXT:    lxv vs1, 48(r3)
; LE-PWR9-NEXT:    stxv vs1, 80(r3)
; LE-PWR9-NEXT:    stxv vs0, 64(r3)
; LE-PWR9-NEXT:    blr
;
; LE-PWR8-LABEL: testLdStPair:
; LE-PWR8:       # %bb.0: # %entry
; LE-PWR8-NEXT:    addis r3, r2, g@toc@ha
; LE-PWR8-NEXT:    li r4, 32
; LE-PWR8-NEXT:    addi r3, r3, g@toc@l
; LE-PWR8-NEXT:    lxvd2x vs0, r3, r4
; LE-PWR8-NEXT:    li r4, 48
; LE-PWR8-NEXT:    lxvd2x vs1, r3, r4
; LE-PWR8-NEXT:    li r4, 80
; LE-PWR8-NEXT:    stxvd2x vs1, r3, r4
; LE-PWR8-NEXT:    li r4, 64
; LE-PWR8-NEXT:    stxvd2x vs0, r3, r4
; LE-PWR8-NEXT:    blr
;
; BE-PWR9-LABEL: testLdStPair:
; BE-PWR9:       # %bb.0: # %entry
; BE-PWR9-NEXT:    addis r3, r2, g@toc@ha
; BE-PWR9-NEXT:    addi r3, r3, g@toc@l
; BE-PWR9-NEXT:    lxv vs0, 32(r3)
; BE-PWR9-NEXT:    lxv vs1, 48(r3)
; BE-PWR9-NEXT:    stxv vs1, 80(r3)
; BE-PWR9-NEXT:    stxv vs0, 64(r3)
; BE-PWR9-NEXT:    blr
;
; BE-PWR8-LABEL: testLdStPair:
; BE-PWR8:       # %bb.0: # %entry
; BE-PWR8-NEXT:    addis r3, r2, g@toc@ha
; BE-PWR8-NEXT:    li r4, 32
; BE-PWR8-NEXT:    addi r3, r3, g@toc@l
; BE-PWR8-NEXT:    lxvd2x vs0, r3, r4
; BE-PWR8-NEXT:    li r4, 48
; BE-PWR8-NEXT:    lxvd2x vs1, r3, r4
; BE-PWR8-NEXT:    li r4, 80
; BE-PWR8-NEXT:    stxvd2x vs1, r3, r4
; BE-PWR8-NEXT:    li r4, 64
; BE-PWR8-NEXT:    stxvd2x vs0, r3, r4
; BE-PWR8-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds <256 x i1>, ptr @g, i64 1
  %0 = load <256 x i1>, ptr %arrayidx, align 64
  %arrayidx1 = getelementptr inbounds <256 x i1>, ptr @g, i64 2
  store <256 x i1> %0, ptr %arrayidx1, align 64
  ret void
}

define dso_local void @testXLdStPair(i64 %SrcIdx, i64 %DstIdx) {
; LE-PAIRED-LABEL: testXLdStPair:
; LE-PAIRED:       # %bb.0: # %entry
; LE-PAIRED-NEXT:    sldi r3, r3, 5
; LE-PAIRED-NEXT:    paddi r5, 0, g@PCREL, 1
; LE-PAIRED-NEXT:    add r6, r5, r3
; LE-PAIRED-NEXT:    lxvx vs0, r5, r3
; LE-PAIRED-NEXT:    sldi r3, r4, 5
; LE-PAIRED-NEXT:    add r4, r5, r3
; LE-PAIRED-NEXT:    lxv vs1, 16(r6)
; LE-PAIRED-NEXT:    stxvx vs0, r5, r3
; LE-PAIRED-NEXT:    stxv vs1, 16(r4)
; LE-PAIRED-NEXT:    blr
;
; LE-PAIRED-WACC-LABEL: testXLdStPair:
; LE-PAIRED-WACC:       # %bb.0: # %entry
; LE-PAIRED-WACC-NEXT:    sldi r3, r3, 5
; LE-PAIRED-WACC-NEXT:    paddi r5, 0, g@PCREL, 1
; LE-PAIRED-WACC-NEXT:    add r6, r5, r3
; LE-PAIRED-WACC-NEXT:    lxvx vs0, r5, r3
; LE-PAIRED-WACC-NEXT:    lxv vs1, 16(r6)
; LE-PAIRED-WACC-NEXT:    sldi r3, r4, 5
; LE-PAIRED-WACC-NEXT:    add r4, r5, r3
; LE-PAIRED-WACC-NEXT:    stxvx vs0, r5, r3
; LE-PAIRED-WACC-NEXT:    stxv vs1, 16(r4)
; LE-PAIRED-WACC-NEXT:    blr
;
; BE-PAIRED-LABEL: testXLdStPair:
; BE-PAIRED:       # %bb.0: # %entry
; BE-PAIRED-NEXT:    addis r5, r2, g@toc@ha
; BE-PAIRED-NEXT:    sldi r3, r3, 5
; BE-PAIRED-NEXT:    addi r5, r5, g@toc@l
; BE-PAIRED-NEXT:    add r6, r5, r3
; BE-PAIRED-NEXT:    lxvx vs0, r5, r3
; BE-PAIRED-NEXT:    sldi r3, r4, 5
; BE-PAIRED-NEXT:    add r4, r5, r3
; BE-PAIRED-NEXT:    lxv vs1, 16(r6)
; BE-PAIRED-NEXT:    stxvx vs0, r5, r3
; BE-PAIRED-NEXT:    stxv vs1, 16(r4)
; BE-PAIRED-NEXT:    blr
;
; BE-PAIRED-WACC-LABEL: testXLdStPair:
; BE-PAIRED-WACC:       # %bb.0: # %entry
; BE-PAIRED-WACC-NEXT:    addis r5, r2, g@toc@ha
; BE-PAIRED-WACC-NEXT:    sldi r3, r3, 5
; BE-PAIRED-WACC-NEXT:    addi r5, r5, g@toc@l
; BE-PAIRED-WACC-NEXT:    add r6, r5, r3
; BE-PAIRED-WACC-NEXT:    lxvx vs0, r5, r3
; BE-PAIRED-WACC-NEXT:    lxv vs1, 16(r6)
; BE-PAIRED-WACC-NEXT:    sldi r3, r4, 5
; BE-PAIRED-WACC-NEXT:    add r4, r5, r3
; BE-PAIRED-WACC-NEXT:    stxvx vs0, r5, r3
; BE-PAIRED-WACC-NEXT:    stxv vs1, 16(r4)
; BE-PAIRED-WACC-NEXT:    blr
;
; LE-PWR9-LABEL: testXLdStPair:
; LE-PWR9:       # %bb.0: # %entry
; LE-PWR9-NEXT:    addis r5, r2, g@toc@ha
; LE-PWR9-NEXT:    sldi r3, r3, 5
; LE-PWR9-NEXT:    sldi r4, r4, 5
; LE-PWR9-NEXT:    addi r5, r5, g@toc@l
; LE-PWR9-NEXT:    add r6, r5, r3
; LE-PWR9-NEXT:    lxvx vs1, r5, r3
; LE-PWR9-NEXT:    lxv vs0, 16(r6)
; LE-PWR9-NEXT:    add r6, r5, r4
; LE-PWR9-NEXT:    stxvx vs1, r5, r4
; LE-PWR9-NEXT:    stxv vs0, 16(r6)
; LE-PWR9-NEXT:    blr
;
; LE-PWR8-LABEL: testXLdStPair:
; LE-PWR8:       # %bb.0: # %entry
; LE-PWR8-NEXT:    addis r5, r2, g@toc@ha
; LE-PWR8-NEXT:    sldi r3, r3, 5
; LE-PWR8-NEXT:    li r7, 16
; LE-PWR8-NEXT:    addi r5, r5, g@toc@l
; LE-PWR8-NEXT:    add r6, r5, r3
; LE-PWR8-NEXT:    lxvd2x vs1, r5, r3
; LE-PWR8-NEXT:    sldi r3, r4, 5
; LE-PWR8-NEXT:    lxvd2x vs0, r6, r7
; LE-PWR8-NEXT:    add r4, r5, r3
; LE-PWR8-NEXT:    stxvd2x vs1, r5, r3
; LE-PWR8-NEXT:    stxvd2x vs0, r4, r7
; LE-PWR8-NEXT:    blr
;
; BE-PWR9-LABEL: testXLdStPair:
; BE-PWR9:       # %bb.0: # %entry
; BE-PWR9-NEXT:    addis r5, r2, g@toc@ha
; BE-PWR9-NEXT:    sldi r3, r3, 5
; BE-PWR9-NEXT:    sldi r4, r4, 5
; BE-PWR9-NEXT:    addi r5, r5, g@toc@l
; BE-PWR9-NEXT:    add r6, r5, r3
; BE-PWR9-NEXT:    lxvx vs1, r5, r3
; BE-PWR9-NEXT:    lxv vs0, 16(r6)
; BE-PWR9-NEXT:    add r6, r5, r4
; BE-PWR9-NEXT:    stxvx vs1, r5, r4
; BE-PWR9-NEXT:    stxv vs0, 16(r6)
; BE-PWR9-NEXT:    blr
;
; BE-PWR8-LABEL: testXLdStPair:
; BE-PWR8:       # %bb.0: # %entry
; BE-PWR8-NEXT:    addis r5, r2, g@toc@ha
; BE-PWR8-NEXT:    sldi r3, r3, 5
; BE-PWR8-NEXT:    sldi r4, r4, 5
; BE-PWR8-NEXT:    addi r5, r5, g@toc@l
; BE-PWR8-NEXT:    add r6, r5, r3
; BE-PWR8-NEXT:    lxvd2x vs0, r5, r3
; BE-PWR8-NEXT:    li r3, 16
; BE-PWR8-NEXT:    lxvd2x vs1, r6, r3
; BE-PWR8-NEXT:    add r6, r5, r4
; BE-PWR8-NEXT:    stxvd2x vs0, r5, r4
; BE-PWR8-NEXT:    stxvd2x vs1, r6, r3
; BE-PWR8-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds <256 x i1>, ptr @g, i64 %SrcIdx
  %0 = load <256 x i1>, ptr %arrayidx, align 64
  %arrayidx1 = getelementptr inbounds <256 x i1>, ptr @g, i64 %DstIdx
  store <256 x i1> %0, ptr %arrayidx1, align 64
  ret void
}

define dso_local void @testUnalignedLdStPair() {
; LE-PAIRED-LABEL: testUnalignedLdStPair:
; LE-PAIRED:       # %bb.0: # %entry
; LE-PAIRED-NEXT:    plxv vs0, g@PCREL+27(0), 1
; LE-PAIRED-NEXT:    plxv vs1, g@PCREL+11(0), 1
; LE-PAIRED-NEXT:    pstxv vs0, g@PCREL+35(0), 1
; LE-PAIRED-NEXT:    pstxv vs1, g@PCREL+19(0), 1
; LE-PAIRED-NEXT:    blr
;
; LE-PAIRED-WACC-LABEL: testUnalignedLdStPair:
; LE-PAIRED-WACC:       # %bb.0: # %entry
; LE-PAIRED-WACC-NEXT:    plxv vs0, g@PCREL+27(0), 1
; LE-PAIRED-WACC-NEXT:    plxv vs1, g@PCREL+11(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv vs0, g@PCREL+35(0), 1
; LE-PAIRED-WACC-NEXT:    pstxv vs1, g@PCREL+19(0), 1
; LE-PAIRED-WACC-NEXT:    blr
;
; BE-PAIRED-LABEL: testUnalignedLdStPair:
; BE-PAIRED:       # %bb.0: # %entry
; BE-PAIRED-NEXT:    addis r3, r2, g@toc@ha
; BE-PAIRED-NEXT:    addi r3, r3, g@toc@l
; BE-PAIRED-NEXT:    plxv vs0, 11(r3), 0
; BE-PAIRED-NEXT:    plxv vs1, 27(r3), 0
; BE-PAIRED-NEXT:    pstxv vs1, 35(r3), 0
; BE-PAIRED-NEXT:    pstxv vs0, 19(r3), 0
; BE-PAIRED-NEXT:    blr
;
; BE-PAIRED-WACC-LABEL: testUnalignedLdStPair:
; BE-PAIRED-WACC:       # %bb.0: # %entry
; BE-PAIRED-WACC-NEXT:    addis r3, r2, g@toc@ha
; BE-PAIRED-WACC-NEXT:    addi r3, r3, g@toc@l
; BE-PAIRED-WACC-NEXT:    plxv vs0, 27(r3), 0
; BE-PAIRED-WACC-NEXT:    plxv vs1, 11(r3), 0
; BE-PAIRED-WACC-NEXT:    pstxv vs0, 35(r3), 0
; BE-PAIRED-WACC-NEXT:    pstxv vs1, 19(r3), 0
; BE-PAIRED-WACC-NEXT:    blr
;
; LE-PWR9-LABEL: testUnalignedLdStPair:
; LE-PWR9:       # %bb.0: # %entry
; LE-PWR9-NEXT:    addis r3, r2, g@toc@ha
; LE-PWR9-NEXT:    li r4, 11
; LE-PWR9-NEXT:    addi r3, r3, g@toc@l
; LE-PWR9-NEXT:    lxvx vs0, r3, r4
; LE-PWR9-NEXT:    li r4, 27
; LE-PWR9-NEXT:    lxvx vs1, r3, r4
; LE-PWR9-NEXT:    li r4, 35
; LE-PWR9-NEXT:    stxvx vs1, r3, r4
; LE-PWR9-NEXT:    li r4, 19
; LE-PWR9-NEXT:    stxvx vs0, r3, r4
; LE-PWR9-NEXT:    blr
;
; LE-PWR8-LABEL: testUnalignedLdStPair:
; LE-PWR8:       # %bb.0: # %entry
; LE-PWR8-NEXT:    addis r3, r2, g@toc@ha
; LE-PWR8-NEXT:    li r4, 11
; LE-PWR8-NEXT:    addi r3, r3, g@toc@l
; LE-PWR8-NEXT:    lxvd2x vs0, r3, r4
; LE-PWR8-NEXT:    li r4, 27
; LE-PWR8-NEXT:    lxvd2x vs1, r3, r4
; LE-PWR8-NEXT:    li r4, 35
; LE-PWR8-NEXT:    stxvd2x vs1, r3, r4
; LE-PWR8-NEXT:    li r4, 19
; LE-PWR8-NEXT:    stxvd2x vs0, r3, r4
; LE-PWR8-NEXT:    blr
;
; BE-PWR9-LABEL: testUnalignedLdStPair:
; BE-PWR9:       # %bb.0: # %entry
; BE-PWR9-NEXT:    addis r3, r2, g@toc@ha
; BE-PWR9-NEXT:    li r4, 11
; BE-PWR9-NEXT:    addi r3, r3, g@toc@l
; BE-PWR9-NEXT:    lxvx vs0, r3, r4
; BE-PWR9-NEXT:    li r4, 27
; BE-PWR9-NEXT:    lxvx vs1, r3, r4
; BE-PWR9-NEXT:    li r4, 35
; BE-PWR9-NEXT:    stxvx vs1, r3, r4
; BE-PWR9-NEXT:    li r4, 19
; BE-PWR9-NEXT:    stxvx vs0, r3, r4
; BE-PWR9-NEXT:    blr
;
; BE-PWR8-LABEL: testUnalignedLdStPair:
; BE-PWR8:       # %bb.0: # %entry
; BE-PWR8-NEXT:    addis r3, r2, g@toc@ha
; BE-PWR8-NEXT:    li r4, 11
; BE-PWR8-NEXT:    addi r3, r3, g@toc@l
; BE-PWR8-NEXT:    lxvd2x vs0, r3, r4
; BE-PWR8-NEXT:    li r4, 27
; BE-PWR8-NEXT:    lxvd2x vs1, r3, r4
; BE-PWR8-NEXT:    li r4, 35
; BE-PWR8-NEXT:    stxvd2x vs1, r3, r4
; BE-PWR8-NEXT:    li r4, 19
; BE-PWR8-NEXT:    stxvd2x vs0, r3, r4
; BE-PWR8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, ptr @g, i64 11
  %add.ptr1 = getelementptr inbounds i8, ptr @g, i64 19
  %0 = load <256 x i1>, ptr %add.ptr, align 64
  store <256 x i1> %0, ptr %add.ptr1, align 64
  ret void
}
