/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2019-2022 Bootlin
 * Author: Paul Kocialkowski <paul.kocialkowski@bootlin.com>
 *
 * Copyright (C) 2014 Xylon d.o.o.
 * Author: Davor Joja <davor.joja@logicbricks.com>
 */

#ifndef _LOGICVC_REGS_H_
#define _LOGICVC_REGS_H_

#define LOGICVC_DIMENSIONS_MAX		(BIT(16) - 1)

#define LOGICVC_HSYNC_FRONT_PORCH_REG	0x00
#define LOGICVC_HSYNC_REG		0x08
#define LOGICVC_HSYNC_BACK_PORCH_REG	0x10
#define LOGICVC_HRES_REG		0x18
#define LOGICVC_VSYNC_FRONT_PORCH_REG	0x20
#define LOGICVC_VSYNC_REG		0x28
#define LOGICVC_VSYNC_BACK_PORCH_REG	0x30
#define LOGICVC_VRES_REG		0x38

#define LOGICVC_CTRL_REG		0x40
#define LOGICVC_CTRL_CLOCK_INVERT	BIT(8)
#define LOGICVC_CTRL_PIXEL_INVERT	BIT(7)
#define LOGICVC_CTRL_DE_INVERT		BIT(5)
#define LOGICVC_CTRL_DE_ENABLE		BIT(4)
#define LOGICVC_CTRL_VSYNC_INVERT	BIT(3)
#define LOGICVC_CTRL_VSYNC_ENABLE	BIT(2)
#define LOGICVC_CTRL_HSYNC_INVERT	BIT(1)
#define LOGICVC_CTRL_HSYNC_ENABLE	BIT(0)

#define LOGICVC_DTYPE_REG		0x48
#define LOGICVC_BACKGROUND_COLOR_REG	0x50

#define LOGICVC_BUFFER_SEL_REG		0x58
#define LOGICVC_BUFFER_SEL_VALUE(i, v) \
	(BIT(10 + (i)) | ((v) << (2 * (i))))
#define LOGICVC_BUFFER_SEL_MAX		2

#define LOGICVC_DOUBLE_CLUT_REG		0x60

#define LOGICVC_INT_STAT_REG		0x68
#define LOGICVC_INT_STAT_V_SYNC		BIT(5)

#define LOGICVC_INT_MASK_REG		0x70
#define LOGICVC_INT_MASK_V_SYNC		BIT(5)

#define LOGICVC_POWER_CTRL_REG		0x78
#define LOGICVC_POWER_CTRL_BACKLIGHT_ENABLE	BIT(0)
#define LOGICVC_POWER_CTRL_VDD_ENABLE		BIT(1)
#define LOGICVC_POWER_CTRL_VEE_ENABLE		BIT(2)
#define LOGICVC_POWER_CTRL_VIDEO_ENABLE		BIT(3)

#define LOGICVC_IP_VERSION_REG		0xf8
#define LOGICVC_IP_VERSION_MAJOR_MASK	GENMASK(16, 11)
#define LOGICVC_IP_VERSION_MINOR_MASK	GENMASK(10, 5)
#define LOGICVC_IP_VERSION_LEVEL_MASK	GENMASK(4, 0)

#define LOGICVC_LAYER_ADDRESS_REG(i)	(0x100 + (i) * 0x80)
#define LOGICVC_LAYER_HOFFSET_REG(i)	(0x100 + (i) * 0x80)

#define LOGICVC_LAYER_VOFFSET_REG(i)	(0x108 + (i) * 0x80)
#define LOGICVC_LAYER_VOFFSET_MAX	4095

#define LOGICVC_LAYER_HPOSITION_REG(i)	(0x110 + (i) * 0x80)
#define LOGICVC_LAYER_VPOSITION_REG(i)	(0x118 + (i) * 0x80)
#define LOGICVC_LAYER_WIDTH_REG(i)	(0x120 + (i) * 0x80)
#define LOGICVC_LAYER_HEIGHT_REG(i)	(0x128 + (i) * 0x80)
#define LOGICVC_LAYER_ALPHA_REG(i)	(0x130 + (i) * 0x80)

#define LOGICVC_LAYER_CTRL_REG(i)	(0x138 + (i) * 0x80)
#define LOGICVC_LAYER_CTRL_ENABLE	BIT(0)
#define LOGICVC_LAYER_CTRL_COLOR_KEY_DISABLE	BIT(1)
#define LOGICVC_LAYER_CTRL_PIXEL_FORMAT_INVERT	BIT(4)

#define LOGICVC_LAYER_COLOR_KEY_REG(i)	(0x140 + (i) * 0x80)

#endif
