//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ReplicationFabricsServer is a fake server for instances of the armrecoveryservicessiterecovery.ReplicationFabricsClient type.
type ReplicationFabricsServer struct {
	// BeginCheckConsistency is the fake for method ReplicationFabricsClient.BeginCheckConsistency
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCheckConsistency func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, options *armrecoveryservicessiterecovery.ReplicationFabricsClientBeginCheckConsistencyOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientCheckConsistencyResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method ReplicationFabricsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, input armrecoveryservicessiterecovery.FabricCreationInput, options *armrecoveryservicessiterecovery.ReplicationFabricsClientBeginCreateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ReplicationFabricsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, options *armrecoveryservicessiterecovery.ReplicationFabricsClientBeginDeleteOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ReplicationFabricsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, options *armrecoveryservicessiterecovery.ReplicationFabricsClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.ReplicationFabricsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ReplicationFabricsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceName string, resourceGroupName string, options *armrecoveryservicessiterecovery.ReplicationFabricsClientListOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientListResponse])

	// BeginMigrateToAAD is the fake for method ReplicationFabricsClient.BeginMigrateToAAD
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginMigrateToAAD func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, options *armrecoveryservicessiterecovery.ReplicationFabricsClientBeginMigrateToAADOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientMigrateToAADResponse], errResp azfake.ErrorResponder)

	// BeginPurge is the fake for method ReplicationFabricsClient.BeginPurge
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginPurge func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, options *armrecoveryservicessiterecovery.ReplicationFabricsClientBeginPurgeOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientPurgeResponse], errResp azfake.ErrorResponder)

	// BeginReassociateGateway is the fake for method ReplicationFabricsClient.BeginReassociateGateway
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReassociateGateway func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, failoverProcessServerRequest armrecoveryservicessiterecovery.FailoverProcessServerRequest, options *armrecoveryservicessiterecovery.ReplicationFabricsClientBeginReassociateGatewayOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientReassociateGatewayResponse], errResp azfake.ErrorResponder)

	// BeginRenewCertificate is the fake for method ReplicationFabricsClient.BeginRenewCertificate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRenewCertificate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, renewCertificate armrecoveryservicessiterecovery.RenewCertificateInput, options *armrecoveryservicessiterecovery.ReplicationFabricsClientBeginRenewCertificateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientRenewCertificateResponse], errResp azfake.ErrorResponder)
}

// NewReplicationFabricsServerTransport creates a new instance of ReplicationFabricsServerTransport with the provided implementation.
// The returned ReplicationFabricsServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.ReplicationFabricsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReplicationFabricsServerTransport(srv *ReplicationFabricsServer) *ReplicationFabricsServerTransport {
	return &ReplicationFabricsServerTransport{
		srv:                     srv,
		beginCheckConsistency:   newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientCheckConsistencyResponse]](),
		beginCreate:             newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientCreateResponse]](),
		beginDelete:             newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientDeleteResponse]](),
		newListPager:            newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientListResponse]](),
		beginMigrateToAAD:       newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientMigrateToAADResponse]](),
		beginPurge:              newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientPurgeResponse]](),
		beginReassociateGateway: newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientReassociateGatewayResponse]](),
		beginRenewCertificate:   newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientRenewCertificateResponse]](),
	}
}

// ReplicationFabricsServerTransport connects instances of armrecoveryservicessiterecovery.ReplicationFabricsClient to instances of ReplicationFabricsServer.
// Don't use this type directly, use NewReplicationFabricsServerTransport instead.
type ReplicationFabricsServerTransport struct {
	srv                     *ReplicationFabricsServer
	beginCheckConsistency   *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientCheckConsistencyResponse]]
	beginCreate             *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientCreateResponse]]
	beginDelete             *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientDeleteResponse]]
	newListPager            *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientListResponse]]
	beginMigrateToAAD       *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientMigrateToAADResponse]]
	beginPurge              *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientPurgeResponse]]
	beginReassociateGateway *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientReassociateGatewayResponse]]
	beginRenewCertificate   *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationFabricsClientRenewCertificateResponse]]
}

// Do implements the policy.Transporter interface for ReplicationFabricsServerTransport.
func (r *ReplicationFabricsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReplicationFabricsClient.BeginCheckConsistency":
		resp, err = r.dispatchBeginCheckConsistency(req)
	case "ReplicationFabricsClient.BeginCreate":
		resp, err = r.dispatchBeginCreate(req)
	case "ReplicationFabricsClient.BeginDelete":
		resp, err = r.dispatchBeginDelete(req)
	case "ReplicationFabricsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ReplicationFabricsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "ReplicationFabricsClient.BeginMigrateToAAD":
		resp, err = r.dispatchBeginMigrateToAAD(req)
	case "ReplicationFabricsClient.BeginPurge":
		resp, err = r.dispatchBeginPurge(req)
	case "ReplicationFabricsClient.BeginReassociateGateway":
		resp, err = r.dispatchBeginReassociateGateway(req)
	case "ReplicationFabricsClient.BeginRenewCertificate":
		resp, err = r.dispatchBeginRenewCertificate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReplicationFabricsServerTransport) dispatchBeginCheckConsistency(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCheckConsistency == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCheckConsistency not implemented")}
	}
	beginCheckConsistency := r.beginCheckConsistency.get(req)
	if beginCheckConsistency == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkConsistency`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCheckConsistency(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCheckConsistency = &respr
		r.beginCheckConsistency.add(req, beginCheckConsistency)
	}

	resp, err := server.PollerResponderNext(beginCheckConsistency, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginCheckConsistency.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCheckConsistency) {
		r.beginCheckConsistency.remove(req)
	}

	return resp, nil
}

func (r *ReplicationFabricsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := r.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.FabricCreationInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		r.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		r.beginCreate.remove(req)
	}

	return resp, nil
}

func (r *ReplicationFabricsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := r.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/remove`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginDelete(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		r.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		r.beginDelete.remove(req)
	}

	return resp, nil
}

func (r *ReplicationFabricsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var options *armrecoveryservicessiterecovery.ReplicationFabricsClientGetOptions
	if filterParam != nil {
		options = &armrecoveryservicessiterecovery.ReplicationFabricsClientGetOptions{
			Filter: filterParam,
		}
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Fabric, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReplicationFabricsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListPager(resourceNameParam, resourceGroupNameParam, nil)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armrecoveryservicessiterecovery.ReplicationFabricsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationFabricsServerTransport) dispatchBeginMigrateToAAD(req *http.Request) (*http.Response, error) {
	if r.srv.BeginMigrateToAAD == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateToAAD not implemented")}
	}
	beginMigrateToAAD := r.beginMigrateToAAD.get(req)
	if beginMigrateToAAD == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migratetoaad`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginMigrateToAAD(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateToAAD = &respr
		r.beginMigrateToAAD.add(req, beginMigrateToAAD)
	}

	resp, err := server.PollerResponderNext(beginMigrateToAAD, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginMigrateToAAD.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateToAAD) {
		r.beginMigrateToAAD.remove(req)
	}

	return resp, nil
}

func (r *ReplicationFabricsServerTransport) dispatchBeginPurge(req *http.Request) (*http.Response, error) {
	if r.srv.BeginPurge == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPurge not implemented")}
	}
	beginPurge := r.beginPurge.get(req)
	if beginPurge == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginPurge(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPurge = &respr
		r.beginPurge.add(req, beginPurge)
	}

	resp, err := server.PollerResponderNext(beginPurge, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginPurge.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPurge) {
		r.beginPurge.remove(req)
	}

	return resp, nil
}

func (r *ReplicationFabricsServerTransport) dispatchBeginReassociateGateway(req *http.Request) (*http.Response, error) {
	if r.srv.BeginReassociateGateway == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReassociateGateway not implemented")}
	}
	beginReassociateGateway := r.beginReassociateGateway.get(req)
	if beginReassociateGateway == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reassociateGateway`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.FailoverProcessServerRequest](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginReassociateGateway(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReassociateGateway = &respr
		r.beginReassociateGateway.add(req, beginReassociateGateway)
	}

	resp, err := server.PollerResponderNext(beginReassociateGateway, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginReassociateGateway.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReassociateGateway) {
		r.beginReassociateGateway.remove(req)
	}

	return resp, nil
}

func (r *ReplicationFabricsServerTransport) dispatchBeginRenewCertificate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginRenewCertificate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRenewCertificate not implemented")}
	}
	beginRenewCertificate := r.beginRenewCertificate.get(req)
	if beginRenewCertificate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/renewCertificate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.RenewCertificateInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginRenewCertificate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRenewCertificate = &respr
		r.beginRenewCertificate.add(req, beginRenewCertificate)
	}

	resp, err := server.PollerResponderNext(beginRenewCertificate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginRenewCertificate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRenewCertificate) {
		r.beginRenewCertificate.remove(req)
	}

	return resp, nil
}
