from __future__ import absolute_import, division, print_function

# this is so useful that we might as well store it centrally
model_1yjp = """\
CRYST1   21.937    4.866   23.477  90.00 107.08  90.00 P 1 21 1      2
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.045585  0.000000  0.014006        0.00000
SCALE2      0.000000  0.205508  0.000000        0.00000
SCALE3      0.000000  0.000000  0.044560        0.00000
ATOM      1  N   GLY A   1      -9.009   4.612   6.102  1.00 16.77           N
ATOM      2  CA  GLY A   1      -9.052   4.207   4.651  1.00 16.57           C
ATOM      3  C   GLY A   1      -8.015   3.140   4.419  1.00 16.16           C
ATOM      4  O   GLY A   1      -7.523   2.521   5.381  1.00 16.78           O
ATOM      5  N   ASN A   2      -7.656   2.923   3.155  1.00 15.02           N
ATOM      6  CA  ASN A   2      -6.522   2.038   2.831  1.00 14.10           C
ATOM      7  C   ASN A   2      -5.241   2.537   3.427  1.00 13.13           C
ATOM      8  O   ASN A   2      -4.978   3.742   3.426  1.00 11.91           O
ATOM      9  CB  ASN A   2      -6.346   1.881   1.341  1.00 15.38           C
ATOM     10  CG  ASN A   2      -7.584   1.342   0.692  1.00 14.08           C
ATOM     11  OD1 ASN A   2      -8.025   0.227   1.016  1.00 17.46           O
ATOM     12  ND2 ASN A   2      -8.204   2.155  -0.169  1.00 11.72           N
ATOM     13  N   ASN A   3      -4.438   1.590   3.905  1.00 12.26           N
ATOM     14  CA  ASN A   3      -3.193   1.904   4.589  1.00 11.74           C
ATOM     15  C   ASN A   3      -1.955   1.332   3.895  1.00 11.10           C
ATOM     16  O   ASN A   3      -1.872   0.119   3.648  1.00 10.42           O
ATOM     17  CB  ASN A   3      -3.259   1.378   6.042  1.00 12.15           C
ATOM     18  CG  ASN A   3      -2.006   1.739   6.861  1.00 12.82           C
ATOM     19  OD1 ASN A   3      -1.702   2.925   7.072  1.00 15.05           O
ATOM     20  ND2 ASN A   3      -1.271   0.715   7.306  1.00 13.48           N
ATOM     21  N   GLN A   4      -1.005   2.228   3.598  1.00 10.29           N
ATOM     22  CA  GLN A   4       0.384   1.888   3.199  1.00 10.53           C
ATOM     23  C   GLN A   4       1.435   2.606   4.088  1.00 10.24           C
ATOM     24  O   GLN A   4       1.547   3.843   4.115  1.00  8.86           O
ATOM     25  CB  GLN A   4       0.656   2.148   1.711  1.00  9.80           C
ATOM     26  CG  GLN A   4       1.944   1.458   1.213  1.00 10.25           C
ATOM     27  CD  GLN A   4       2.504   2.044  -0.089  1.00 12.43           C
ATOM     28  OE1 GLN A   4       2.744   3.268  -0.190  1.00 14.62           O
ATOM     29  NE2 GLN A   4       2.750   1.161  -1.091  1.00  9.05           N
ATOM     30  N   GLN A   5       2.154   1.821   4.871  1.00 10.38           N
ATOM     31  CA  GLN A   5       3.270   2.361   5.640  1.00 11.39           C
ATOM     32  C   GLN A   5       4.594   1.768   5.172  1.00 11.52           C
ATOM     33  O   GLN A   5       4.768   0.546   5.054  1.00 12.05           O
ATOM     34  CB  GLN A   5       3.056   2.183   7.147  1.00 11.96           C
ATOM     35  CG  GLN A   5       1.829   2.950   7.647  1.00 10.81           C
ATOM     36  CD  GLN A   5       1.344   2.414   8.954  1.00 13.10           C
ATOM     37  OE1 GLN A   5       0.774   1.325   9.002  1.00 10.65           O
ATOM     38  NE2 GLN A   5       1.549   3.187  10.039  1.00 12.30           N
ATOM     39  N   ASN A   6       5.514   2.664   4.856  1.00 11.99           N
ATOM     40  CA  ASN A   6       6.831   2.310   4.318  1.00 12.30           C
ATOM     41  C   ASN A   6       7.854   2.761   5.324  1.00 13.40           C
ATOM     42  O   ASN A   6       8.219   3.943   5.374  1.00 13.92           O
ATOM     43  CB  ASN A   6       7.065   3.016   2.993  1.00 12.13           C
ATOM     44  CG  ASN A   6       5.961   2.735   2.003  1.00 12.77           C
ATOM     45  OD1 ASN A   6       5.798   1.604   1.551  1.00 14.27           O
ATOM     46  ND2 ASN A   6       5.195   3.747   1.679  1.00 10.07           N
ATOM     47  N   TYR A   7       8.292   1.817   6.147  1.00 14.70           N
ATOM     48  CA  TYR A   7       9.159   2.144   7.299  1.00 15.18           C
ATOM     49  C   TYR A   7      10.603   2.331   6.885  1.00 15.91           C
ATOM     50  O   TYR A   7      11.041   1.811   5.855  1.00 15.76           O
ATOM     51  CB  TYR A   7       9.061   1.065   8.369  1.00 15.35           C
ATOM     52  CG  TYR A   7       7.665   0.929   8.902  1.00 14.45           C
ATOM     53  CD1 TYR A   7       6.771   0.021   8.327  1.00 15.68           C
ATOM     54  CD2 TYR A   7       7.210   1.756   9.920  1.00 14.80           C
ATOM     55  CE1 TYR A   7       5.480  -0.094   8.796  1.00 13.46           C
ATOM     56  CE2 TYR A   7       5.904   1.649  10.416  1.00 14.33           C
ATOM     57  CZ  TYR A   7       5.047   0.729   9.831  1.00 15.09           C
ATOM     58  OH  TYR A   7       3.766   0.589  10.291  1.00 14.39           O
ATOM     59  OXT TYR A   7      11.358   2.999   7.612  1.00 17.49           O
END
"""
model_1yjp_cif = """\
data_1YJP
#
_entry.id   1YJP
#
_audit.revision_id     1
_audit.creation_date   2005-01-14
_audit.update_record   'initial release'
#
_audit_conform.dict_name       mmcif_pdbx.dic
_audit_conform.dict_version    5.286
_audit_conform.dict_location   http://mmcif.pdb.org/dictionaries/ascii/mmcif_pdbx.dic
#
loop_
_database_2.database_id
_database_2.database_code
PDB   1YJP
RCSB  RCSB031590
WWPDB D_1000031590
#
_pdbx_database_related.db_name        PDB
_pdbx_database_related.db_id          1YJO
_pdbx_database_related.details        .
_pdbx_database_related.content_type   unspecified
#
_pdbx_database_status.entry_id                        1YJP
_pdbx_database_status.deposit_site                    RCSB
_pdbx_database_status.process_site                    RCSB
_pdbx_database_status.recvd_initial_deposition_date   2005-01-15
_pdbx_database_status.status_code                     REL
_pdbx_database_status.status_code_sf                  REL
_pdbx_database_status.status_code_mr                  ?
_pdbx_database_status.SG_entry                        ?
_pdbx_database_status.pdb_format_compatible           Y
_pdbx_database_status.status_code_cs                  ?
_pdbx_database_status.methods_development_category    ?
#
loop_
_audit_author.name
_audit_author.pdbx_ordinal
'Nelson, R.'    1
'Sawaya, M.R.'  2
'Balbirnie, M.' 3
'Madsen, A.O.'  4
'Riekel, C.'    5
'Grothe, R.'    6
'Eisenberg, D.' 7
#
loop_
_citation.id
_citation.title
_citation.journal_abbrev
_citation.journal_volume
_citation.page_first
_citation.page_last
_citation.year
_citation.journal_id_ASTM
_citation.country
_citation.journal_id_ISSN
_citation.journal_id_CSD
_citation.book_publisher
_citation.pdbx_database_id_PubMed
_citation.pdbx_database_id_DOI
primary 'Structure of the cross-beta spine of amyloid-like fibrils.'               Nature                     435 773 778 2005
NATUAS UK 0028-0836 0006 ? 15944695 10.1038/nature03680
1       'Refinement of Macromolecular Structures by the Maximum-Likelihood Method' 'Acta Crystallogr.,Sect.D' 53  240 255 1997
ABCRE6 DK 0907-4449 0766 ? ?        ?
#
loop_
_citation_author.citation_id
_citation_author.name
_citation_author.ordinal
primary 'Nelson, R.'      1
primary 'Sawaya, M.R.'    2
primary 'Balbirnie, M.'   3
primary 'Madsen, A.O.'    4
primary 'Riekel, C.'      5
primary 'Grothe, R.'      6
primary 'Eisenberg, D.'   7
1       'Murshudov, G.N.' 8
1       'Vagin, A.A.'     9
1       'Dodson, E.J.'    10
#
_cell.entry_id           1YJP
_cell.length_a           21.937
_cell.length_b           4.866
_cell.length_c           23.477
_cell.angle_alpha        90.00
_cell.angle_beta         107.08
_cell.angle_gamma        90.00
_cell.Z_PDB              2
_cell.pdbx_unique_axis   ?
#
_symmetry.entry_id                         1YJP
_symmetry.space_group_name_H-M             'P 1 21 1'
_symmetry.pdbx_full_space_group_name_H-M   ?
_symmetry.cell_setting                     ?
_symmetry.Int_Tables_number                4
_symmetry.space_group_name_Hall            ?
#
loop_
_entity.id
_entity.type
_entity.src_method
_entity.pdbx_description
_entity.formula_weight
_entity.pdbx_number_of_molecules
_entity.pdbx_ec
_entity.pdbx_mutation
_entity.pdbx_fragment
_entity.details
1 polymer syn 'Eukaryotic peptide chain release factor GTP-binding subunit' 836.807 1 ? ? 'prion determining domain of Sup35' ?
2 water   nat water                                                         18.015  7 ? ? ?                                   ?
#
_entity_name_com.entity_id   1
_entity_name_com.name
'ERF2, Translation release factor 3, ERF3, ERF-3, Omnipotent suppressor protein 2, G1 to S phase transition protein 1'
#
_entity_poly.entity_id                      1
_entity_poly.type                           'polypeptide(L)'
_entity_poly.nstd_linkage                   no
_entity_poly.nstd_monomer                   no
_entity_poly.pdbx_seq_one_letter_code       GNNQQNY
_entity_poly.pdbx_seq_one_letter_code_can   GNNQQNY
_entity_poly.pdbx_strand_id                 A
_entity_poly.pdbx_target_identifier         ?
#
loop_
_entity_poly_seq.entity_id
_entity_poly_seq.num
_entity_poly_seq.mon_id
_entity_poly_seq.hetero
1 1 GLY n
1 2 ASN n
1 3 ASN n
1 4 GLN n
1 5 GLN n
1 6 ASN n
1 7 TYR n
#
_pdbx_entity_src_syn.entity_id              1
_pdbx_entity_src_syn.pdbx_src_id            1
_pdbx_entity_src_syn.pdbx_alt_source_flag   sample
_pdbx_entity_src_syn.pdbx_beg_seq_num       ?
_pdbx_entity_src_syn.pdbx_end_seq_num       ?
_pdbx_entity_src_syn.organism_scientific    ?
_pdbx_entity_src_syn.organism_common_name   ?
_pdbx_entity_src_syn.ncbi_taxonomy_id       ?
_pdbx_entity_src_syn.details                'This sequence is from the prion determining domain of Saccharomyces cerevisiae Sup35'
#
_struct_ref.id                         1
_struct_ref.db_name                    UNP
_struct_ref.db_code                    ERF2_YEAST
_struct_ref.pdbx_db_accession          P05453
_struct_ref.entity_id                  1
_struct_ref.pdbx_seq_one_letter_code   GNNQQNY
_struct_ref.pdbx_align_begin           7
_struct_ref.pdbx_db_isoform            ?
#
_struct_ref_seq.align_id                      1
_struct_ref_seq.ref_id                        1
_struct_ref_seq.pdbx_PDB_id_code              1YJP
_struct_ref_seq.pdbx_strand_id                A
_struct_ref_seq.seq_align_beg                 1
_struct_ref_seq.pdbx_seq_align_beg_ins_code   ?
_struct_ref_seq.seq_align_end                 7
_struct_ref_seq.pdbx_seq_align_end_ins_code   ?
_struct_ref_seq.pdbx_db_accession             P05453
_struct_ref_seq.db_align_beg                  7
_struct_ref_seq.pdbx_db_align_beg_ins_code    ?
_struct_ref_seq.db_align_end                  13
_struct_ref_seq.pdbx_db_align_end_ins_code    ?
_struct_ref_seq.pdbx_auth_seq_align_beg       1
_struct_ref_seq.pdbx_auth_seq_align_end       7
#
loop_
_chem_comp.id
_chem_comp.type
_chem_comp.mon_nstd_flag
_chem_comp.name
_chem_comp.pdbx_synonyms
_chem_comp.formula
_chem_comp.formula_weight
ASN 'L-peptide linking' y ASPARAGINE ? 'C4 H8 N2 O3'  132.118
GLN 'L-peptide linking' y GLUTAMINE  ? 'C5 H10 N2 O3' 146.144
GLY 'peptide linking'   y GLYCINE    ? 'C2 H5 N O2'   75.067
HOH non-polymer         . WATER      ? 'H2 O'         18.015
TYR 'L-peptide linking' y TYROSINE   ? 'C9 H11 N O3'  181.189
#
_exptl.method            'X-RAY DIFFRACTION'
_exptl.entry_id          1YJP
_exptl.crystals_number   1
#
_exptl_crystal.id                    1
_exptl_crystal.density_meas          ?
_exptl_crystal.density_percent_sol   14.03
_exptl_crystal.density_Matthews      1.43
_exptl_crystal.description           ?
_exptl_crystal.F_000                 ?
_exptl_crystal.preparation           ?
#
_exptl_crystal_grow.crystal_id      1
_exptl_crystal_grow.method          'VAPOR DIFFUSION, HANGING DROP'
_exptl_crystal_grow.pH              7
_exptl_crystal_grow.temp            298
_exptl_crystal_grow.temp_details    ?
_exptl_crystal_grow.pdbx_details    'water, pH 7, VAPOR DIFFUSION, HANGING DROP, temperature 298K'
_exptl_crystal_grow.pdbx_pH_range   .
#
_diffrn.id                     1
_diffrn.ambient_temp           100
_diffrn.ambient_temp_details   ?
_diffrn.crystal_id             1
#
_diffrn_detector.diffrn_id              1
_diffrn_detector.detector               CCD
_diffrn_detector.type                   MARRESEARCH
_diffrn_detector.pdbx_collection_date   2004-06-12
_diffrn_detector.details                'Ellipsoidal Mirror'
#
_diffrn_radiation.diffrn_id                        1
_diffrn_radiation.wavelength_id                    1
_diffrn_radiation.pdbx_diffrn_protocol             'SINGLE WAVELENGTH'
_diffrn_radiation.monochromator                    'channel-cut Si-111 monochromator'
_diffrn_radiation.pdbx_monochromatic_or_laue_m_l   M
_diffrn_radiation.pdbx_scattering_type             x-ray
#
_diffrn_radiation_wavelength.id           1
_diffrn_radiation_wavelength.wavelength   0.975
_diffrn_radiation_wavelength.wt           1.0
#
_diffrn_source.diffrn_id                   1
_diffrn_source.source                      SYNCHROTRON
_diffrn_source.type                        'ESRF BEAMLINE ID13'
_diffrn_source.pdbx_wavelength             0.975
_diffrn_source.pdbx_wavelength_list        0.975
_diffrn_source.pdbx_synchrotron_site       ESRF
_diffrn_source.pdbx_synchrotron_beamline   ID13
#
_reflns.d_resolution_low             80.00
_reflns.d_resolution_high            1.80
_reflns.number_obs                   509
_reflns.percent_possible_obs         89.5
_reflns.pdbx_Rmerge_I_obs            0.204
_reflns.pdbx_chi_squared             1.057
_reflns.entry_id                     1YJP
_reflns.observed_criterion_sigma_F   0
_reflns.observed_criterion_sigma_I   0
_reflns.number_all                   509
_reflns.pdbx_Rsym_value              ?
_reflns.pdbx_netI_over_sigmaI        3.75
_reflns.B_iso_Wilson_estimate        45.6
_reflns.pdbx_redundancy              2.0
_reflns.R_free_details               ?
_reflns.limit_h_max                  ?
_reflns.limit_h_min                  ?
_reflns.limit_k_max                  ?
_reflns.limit_k_min                  ?
_reflns.limit_l_max                  ?
_reflns.limit_l_min                  ?
_reflns.observed_criterion_F_max     ?
_reflns.observed_criterion_F_min     ?
_reflns.pdbx_scaling_rejects         ?
_reflns.pdbx_diffrn_id               1
_reflns.pdbx_ordinal                 1
#
_reflns_shell.d_res_low              1.94
_reflns_shell.d_res_high             1.80
_reflns_shell.number_unique_all      85
_reflns_shell.percent_possible_all   84.2
_reflns_shell.Rmerge_I_obs           0.491
_reflns_shell.pdbx_redundancy        ?
_reflns_shell.pdbx_chi_squared       1.092
_reflns_shell.number_unique_obs      ?
_reflns_shell.meanI_over_sigI_obs    1.5
_reflns_shell.pdbx_Rsym_value        ?
_reflns_shell.percent_possible_obs   ?
_reflns_shell.number_measured_all    ?
_reflns_shell.number_measured_obs    ?
_reflns_shell.pdbx_diffrn_id         ?
_reflns_shell.pdbx_ordinal           1
#
_refine.entry_id                                 1YJP
_refine.ls_d_res_high                            1.80
_refine.ls_d_res_low                             22.44
_refine.pdbx_ls_sigma_F                          0
_refine.pdbx_ls_sigma_I                          0
_refine.ls_number_reflns_all                     474
_refine.ls_number_reflns_obs                     474
_refine.ls_number_reflns_R_free                  20
_refine.ls_percent_reflns_obs                    ?
_refine.ls_R_factor_all                          0.18139
_refine.ls_R_factor_obs                          0.18139
_refine.ls_R_factor_R_work                       0.18086
_refine.ls_R_factor_R_free                       0.19014
_refine.ls_redundancy_reflns_obs                 ?
_refine.pdbx_data_cutoff_high_absF               ?
_refine.pdbx_data_cutoff_low_absF                ?
_refine.ls_number_parameters                     ?
_refine.ls_number_restraints                     ?
_refine.ls_percent_reflns_R_free                 ?
_refine.ls_R_factor_R_free_error                 ?
_refine.ls_R_factor_R_free_error_details         ?
_refine.pdbx_method_to_determine_struct          'FOURIER SYNTHESIS'
_refine.pdbx_starting_model                      ?
_refine.pdbx_ls_cross_valid_method               THROUGHOUT
_refine.pdbx_R_Free_selection_details            RANDOM
_refine.pdbx_stereochem_target_val_spec_case     ?
_refine.pdbx_stereochemistry_target_values       'Engh & Huber'
_refine.solvent_model_details                    ?
_refine.solvent_model_param_bsol                 ?
_refine.solvent_model_param_ksol                 ?
_refine.occupancy_max                            ?
_refine.occupancy_min                            ?
_refine.pdbx_isotropic_thermal_model             ?
_refine.B_iso_mean                               ?
_refine.aniso_B[1][1]                            ?
_refine.aniso_B[1][2]                            ?
_refine.aniso_B[1][3]                            ?
_refine.aniso_B[2][2]                            ?
_refine.aniso_B[2][3]                            ?
_refine.aniso_B[3][3]                            ?
_refine.details                                  ?
_refine.B_iso_min                                ?
_refine.B_iso_max                                ?
_refine.correlation_coeff_Fo_to_Fc               ?
_refine.correlation_coeff_Fo_to_Fc_free          ?
_refine.pdbx_solvent_vdw_probe_radii             ?
_refine.pdbx_solvent_ion_probe_radii             ?
_refine.pdbx_solvent_shrinkage_radii             ?
_refine.overall_SU_R_Cruickshank_DPI             ?
_refine.overall_SU_R_free                        ?
_refine.overall_SU_B                             ?
_refine.overall_SU_ML                            ?
_refine.pdbx_overall_ESU_R                       ?
_refine.pdbx_overall_ESU_R_Free                  ?
_refine.pdbx_data_cutoff_high_rms_absF           ?
_refine.ls_wR_factor_R_free                      ?
_refine.ls_wR_factor_R_work                      ?
_refine.overall_FOM_free_R_set                   ?
_refine.overall_FOM_work_R_set                   ?
_refine.pdbx_refine_id                           'X-RAY DIFFRACTION'
_refine.pdbx_diffrn_id                           1
_refine.pdbx_TLS_residual_ADP_flag               ?
_refine.pdbx_overall_phase_error                 ?
_refine.pdbx_overall_SU_R_free_Cruickshank_DPI   ?
_refine.pdbx_overall_SU_R_Blow_DPI               ?
_refine.pdbx_overall_SU_R_free_Blow_DPI          ?
#
_refine_hist.pdbx_refine_id                   'X-RAY DIFFRACTION'
_refine_hist.cycle_id                         LAST
_refine_hist.pdbx_number_atoms_protein        59
_refine_hist.pdbx_number_atoms_nucleic_acid   0
_refine_hist.pdbx_number_atoms_ligand         0
_refine_hist.number_atoms_solvent             7
_refine_hist.number_atoms_total               66
_refine_hist.d_res_high                       1.80
_refine_hist.d_res_low                        22.44
#
loop_
_refine_ls_restr.type
_refine_ls_restr.dev_ideal
_refine_ls_restr.dev_ideal_target
_refine_ls_restr.number
_refine_ls_restr.weight
_refine_ls_restr.pdbx_refine_id
_refine_ls_restr.pdbx_restraint_function
r_angle_refined_deg 1.228 ? ? ? 'X-RAY DIFFRACTION' ?
r_bond_refined_d    0.014 ? ? ? 'X-RAY DIFFRACTION' ?
#
_struct.entry_id                  1YJP
_struct.title                     'Structure of GNNQQNY from yeast prion Sup35'
_struct.pdbx_descriptor           PROTEIN
_struct.pdbx_model_details        ?
_struct.pdbx_CASP_flag            ?
_struct.pdbx_model_type_details   ?
#
_struct_keywords.entry_id        1YJP
_struct_keywords.pdbx_keywords   'PROTEIN BINDING'
_struct_keywords.text            'beta sheet, steric zipper, glutamine zipper, asparagine zipper, PROTEIN BINDING'
#
loop_
_struct_asym.id
_struct_asym.pdbx_blank_PDB_chainid_flag
_struct_asym.pdbx_modified
_struct_asym.entity_id
_struct_asym.details
A N N 1 ?
B N N 2 ?
#
_atom_sites.entry_id                    1YJP
_atom_sites.fract_transf_matrix[1][1]   0.045585
_atom_sites.fract_transf_matrix[1][2]   0.000000
_atom_sites.fract_transf_matrix[1][3]   0.014006
_atom_sites.fract_transf_matrix[2][1]   0.000000
_atom_sites.fract_transf_matrix[2][2]   0.205508
_atom_sites.fract_transf_matrix[2][3]   0.000000
_atom_sites.fract_transf_matrix[3][1]   0.000000
_atom_sites.fract_transf_matrix[3][2]   0.000000
_atom_sites.fract_transf_matrix[3][3]   0.044560
_atom_sites.fract_transf_vector[1]      0.00000
_atom_sites.fract_transf_vector[2]      0.00000
_atom_sites.fract_transf_vector[3]      0.00000
#
loop_
_atom_type.symbol
C
N
O
#
loop_
_atom_site.group_PDB
_atom_site.id
_atom_site.type_symbol
_atom_site.label_atom_id
_atom_site.label_alt_id
_atom_site.label_comp_id
_atom_site.label_asym_id
_atom_site.label_entity_id
_atom_site.label_seq_id
_atom_site.pdbx_PDB_ins_code
_atom_site.Cartn_x
_atom_site.Cartn_y
_atom_site.Cartn_z
_atom_site.occupancy
_atom_site.B_iso_or_equiv
_atom_site.pdbx_formal_charge
_atom_site.auth_seq_id
_atom_site.auth_comp_id
_atom_site.auth_asym_id
_atom_site.auth_atom_id
_atom_site.pdbx_PDB_model_num
ATOM   1  N N   . GLY A 1 1 ? -9.009  4.612  6.102  1.00 16.77 ? 1  GLY A N   1
ATOM   2  C CA  . GLY A 1 1 ? -9.052  4.207  4.651  1.00 16.57 ? 1  GLY A CA  1
ATOM   3  C C   . GLY A 1 1 ? -8.015  3.140  4.419  1.00 16.16 ? 1  GLY A C   1
ATOM   4  O O   . GLY A 1 1 ? -7.523  2.521  5.381  1.00 16.78 ? 1  GLY A O   1
ATOM   5  N N   . ASN A 1 2 ? -7.656  2.923  3.155  1.00 15.02 ? 2  ASN A N   1
ATOM   6  C CA  . ASN A 1 2 ? -6.522  2.038  2.831  1.00 14.10 ? 2  ASN A CA  1
ATOM   7  C C   . ASN A 1 2 ? -5.241  2.537  3.427  1.00 13.13 ? 2  ASN A C   1
ATOM   8  O O   . ASN A 1 2 ? -4.978  3.742  3.426  1.00 11.91 ? 2  ASN A O   1
ATOM   9  C CB  . ASN A 1 2 ? -6.346  1.881  1.341  1.00 15.38 ? 2  ASN A CB  1
ATOM   10 C CG  . ASN A 1 2 ? -7.584  1.342  0.692  1.00 14.08 ? 2  ASN A CG  1
ATOM   11 O OD1 . ASN A 1 2 ? -8.025  0.227  1.016  1.00 17.46 ? 2  ASN A OD1 1
ATOM   12 N ND2 . ASN A 1 2 ? -8.204  2.155  -0.169 1.00 11.72 ? 2  ASN A ND2 1
ATOM   13 N N   . ASN A 1 3 ? -4.438  1.590  3.905  1.00 12.26 ? 3  ASN A N   1
ATOM   14 C CA  . ASN A 1 3 ? -3.193  1.904  4.589  1.00 11.74 ? 3  ASN A CA  1
ATOM   15 C C   . ASN A 1 3 ? -1.955  1.332  3.895  1.00 11.10 ? 3  ASN A C   1
ATOM   16 O O   . ASN A 1 3 ? -1.872  0.119  3.648  1.00 10.42 ? 3  ASN A O   1
ATOM   17 C CB  . ASN A 1 3 ? -3.259  1.378  6.042  1.00 12.15 ? 3  ASN A CB  1
ATOM   18 C CG  . ASN A 1 3 ? -2.006  1.739  6.861  1.00 12.82 ? 3  ASN A CG  1
ATOM   19 O OD1 . ASN A 1 3 ? -1.702  2.925  7.072  1.00 15.05 ? 3  ASN A OD1 1
ATOM   20 N ND2 . ASN A 1 3 ? -1.271  0.715  7.306  1.00 13.48 ? 3  ASN A ND2 1
ATOM   21 N N   . GLN A 1 4 ? -1.005  2.228  3.598  1.00 10.29 ? 4  GLN A N   1
ATOM   22 C CA  . GLN A 1 4 ? 0.384   1.888  3.199  1.00 10.53 ? 4  GLN A CA  1
ATOM   23 C C   . GLN A 1 4 ? 1.435   2.606  4.088  1.00 10.24 ? 4  GLN A C   1
ATOM   24 O O   . GLN A 1 4 ? 1.547   3.843  4.115  1.00 8.86  ? 4  GLN A O   1
ATOM   25 C CB  . GLN A 1 4 ? 0.656   2.148  1.711  1.00 9.80  ? 4  GLN A CB  1
ATOM   26 C CG  . GLN A 1 4 ? 1.944   1.458  1.213  1.00 10.25 ? 4  GLN A CG  1
ATOM   27 C CD  . GLN A 1 4 ? 2.504   2.044  -0.089 1.00 12.43 ? 4  GLN A CD  1
ATOM   28 O OE1 . GLN A 1 4 ? 2.744   3.268  -0.190 1.00 14.62 ? 4  GLN A OE1 1
ATOM   29 N NE2 . GLN A 1 4 ? 2.750   1.161  -1.091 1.00 9.05  ? 4  GLN A NE2 1
ATOM   30 N N   . GLN A 1 5 ? 2.154   1.821  4.871  1.00 10.38 ? 5  GLN A N   1
ATOM   31 C CA  . GLN A 1 5 ? 3.270   2.361  5.640  1.00 11.39 ? 5  GLN A CA  1
ATOM   32 C C   . GLN A 1 5 ? 4.594   1.768  5.172  1.00 11.52 ? 5  GLN A C   1
ATOM   33 O O   . GLN A 1 5 ? 4.768   0.546  5.054  1.00 12.05 ? 5  GLN A O   1
ATOM   34 C CB  . GLN A 1 5 ? 3.056   2.183  7.147  1.00 11.96 ? 5  GLN A CB  1
ATOM   35 C CG  . GLN A 1 5 ? 1.829   2.950  7.647  1.00 10.81 ? 5  GLN A CG  1
ATOM   36 C CD  . GLN A 1 5 ? 1.344   2.414  8.954  1.00 13.10 ? 5  GLN A CD  1
ATOM   37 O OE1 . GLN A 1 5 ? 0.774   1.325  9.002  1.00 10.65 ? 5  GLN A OE1 1
ATOM   38 N NE2 . GLN A 1 5 ? 1.549   3.187  10.039 1.00 12.30 ? 5  GLN A NE2 1
ATOM   39 N N   . ASN A 1 6 ? 5.514   2.664  4.856  1.00 11.99 ? 6  ASN A N   1
ATOM   40 C CA  . ASN A 1 6 ? 6.831   2.310  4.318  1.00 12.30 ? 6  ASN A CA  1
ATOM   41 C C   . ASN A 1 6 ? 7.854   2.761  5.324  1.00 13.40 ? 6  ASN A C   1
ATOM   42 O O   . ASN A 1 6 ? 8.219   3.943  5.374  1.00 13.92 ? 6  ASN A O   1
ATOM   43 C CB  . ASN A 1 6 ? 7.065   3.016  2.993  1.00 12.13 ? 6  ASN A CB  1
ATOM   44 C CG  . ASN A 1 6 ? 5.961   2.735  2.003  1.00 12.77 ? 6  ASN A CG  1
ATOM   45 O OD1 . ASN A 1 6 ? 5.798   1.604  1.551  1.00 14.27 ? 6  ASN A OD1 1
ATOM   46 N ND2 . ASN A 1 6 ? 5.195   3.747  1.679  1.00 10.07 ? 6  ASN A ND2 1
ATOM   47 N N   . TYR A 1 7 ? 8.292   1.817  6.147  1.00 14.70 ? 7  TYR A N   1
ATOM   48 C CA  . TYR A 1 7 ? 9.159   2.144  7.299  1.00 15.18 ? 7  TYR A CA  1
ATOM   49 C C   . TYR A 1 7 ? 10.603  2.331  6.885  1.00 15.91 ? 7  TYR A C   1
ATOM   50 O O   . TYR A 1 7 ? 11.041  1.811  5.855  1.00 15.76 ? 7  TYR A O   1
ATOM   51 C CB  . TYR A 1 7 ? 9.061   1.065  8.369  1.00 15.35 ? 7  TYR A CB  1
ATOM   52 C CG  . TYR A 1 7 ? 7.665   0.929  8.902  1.00 14.45 ? 7  TYR A CG  1
ATOM   53 C CD1 . TYR A 1 7 ? 6.771   0.021  8.327  1.00 15.68 ? 7  TYR A CD1 1
ATOM   54 C CD2 . TYR A 1 7 ? 7.210   1.756  9.920  1.00 14.80 ? 7  TYR A CD2 1
ATOM   55 C CE1 . TYR A 1 7 ? 5.480   -0.094 8.796  1.00 13.46 ? 7  TYR A CE1 1
ATOM   56 C CE2 . TYR A 1 7 ? 5.904   1.649  10.416 1.00 14.33 ? 7  TYR A CE2 1
ATOM   57 C CZ  . TYR A 1 7 ? 5.047   0.729  9.831  1.00 15.09 ? 7  TYR A CZ  1
ATOM   58 O OH  . TYR A 1 7 ? 3.766   0.589  10.291 1.00 14.39 ? 7  TYR A OH  1
ATOM   59 O OXT . TYR A 1 7 ? 11.358  2.999  7.612  1.00 17.49 ? 7  TYR A OXT 1
HETATM 60 O O   . HOH B 2 . ? -6.471  5.227  7.124  1.00 22.62 ? 8  HOH A O   1
HETATM 61 O O   . HOH B 2 . ? 10.431  1.858  3.216  1.00 19.71 ? 9  HOH A O   1
HETATM 62 O O   . HOH B 2 . ? -11.286 1.756  -1.468 1.00 17.08 ? 10 HOH A O   1
HETATM 63 O O   . HOH B 2 . ? 11.808  4.179  9.970  1.00 23.99 ? 11 HOH A O   1
HETATM 64 O O   . HOH B 2 . ? 13.605  1.327  9.198  1.00 26.17 ? 12 HOH A O   1
HETATM 65 O O   . HOH B 2 . ? -2.749  3.429  10.024 1.00 39.15 ? 13 HOH A O   1
HETATM 66 O O   . HOH B 2 . ? -1.500  0.682  10.967 1.00 43.49 ? 14 HOH A O   1
#
loop_
_pdbx_poly_seq_scheme.asym_id
_pdbx_poly_seq_scheme.entity_id
_pdbx_poly_seq_scheme.seq_id
_pdbx_poly_seq_scheme.mon_id
_pdbx_poly_seq_scheme.ndb_seq_num
_pdbx_poly_seq_scheme.pdb_seq_num
_pdbx_poly_seq_scheme.auth_seq_num
_pdbx_poly_seq_scheme.pdb_mon_id
_pdbx_poly_seq_scheme.auth_mon_id
_pdbx_poly_seq_scheme.pdb_strand_id
_pdbx_poly_seq_scheme.pdb_ins_code
_pdbx_poly_seq_scheme.hetero
A 1 1 GLY 1 1 1 GLY GLY A . n
A 1 2 ASN 2 2 2 ASN ASN A . n
A 1 3 ASN 3 3 3 ASN ASN A . n
A 1 4 GLN 4 4 4 GLN GLN A . n
A 1 5 GLN 5 5 5 GLN GLN A . n
A 1 6 ASN 6 6 6 ASN ASN A . n
A 1 7 TYR 7 7 7 TYR TYR A . n
#
loop_
_pdbx_nonpoly_scheme.asym_id
_pdbx_nonpoly_scheme.entity_id
_pdbx_nonpoly_scheme.mon_id
_pdbx_nonpoly_scheme.ndb_seq_num
_pdbx_nonpoly_scheme.pdb_seq_num
_pdbx_nonpoly_scheme.auth_seq_num
_pdbx_nonpoly_scheme.pdb_mon_id
_pdbx_nonpoly_scheme.auth_mon_id
_pdbx_nonpoly_scheme.pdb_strand_id
_pdbx_nonpoly_scheme.pdb_ins_code
B 2 HOH 1 8  8  HOH HOH A .
B 2 HOH 2 9  9  HOH HOH A .
B 2 HOH 3 10 10 HOH HOH A .
B 2 HOH 4 11 11 HOH HOH A .
B 2 HOH 5 12 12 HOH HOH A .
B 2 HOH 6 13 13 HOH HOH A .
B 2 HOH 7 14 14 HOH HOH A .
#
_pdbx_struct_assembly.id                   1
_pdbx_struct_assembly.details              author_defined_assembly
_pdbx_struct_assembly.method_details       ?
_pdbx_struct_assembly.oligomeric_details   dimeric
_pdbx_struct_assembly.oligomeric_count     2
#
_pdbx_struct_assembly_gen.assembly_id       1
_pdbx_struct_assembly_gen.oper_expression   1,2
_pdbx_struct_assembly_gen.asym_id_list      A,B
#
loop_
_pdbx_struct_oper_list.id
_pdbx_struct_oper_list.type
_pdbx_struct_oper_list.name
_pdbx_struct_oper_list.symmetry_operation
_pdbx_struct_oper_list.matrix[1][1]
_pdbx_struct_oper_list.matrix[1][2]
_pdbx_struct_oper_list.matrix[1][3]
_pdbx_struct_oper_list.vector[1]
_pdbx_struct_oper_list.matrix[2][1]
_pdbx_struct_oper_list.matrix[2][2]
_pdbx_struct_oper_list.matrix[2][3]
_pdbx_struct_oper_list.vector[2]
_pdbx_struct_oper_list.matrix[3][1]
_pdbx_struct_oper_list.matrix[3][2]
_pdbx_struct_oper_list.matrix[3][3]
_pdbx_struct_oper_list.vector[3]
1 'identity operation'         1_555 x,y,z       1.0000000000  0.0000000000 0.0000000000 0.0000000000 0.0000000000 1.0000000000
0.0000000000 0.0000000000 0.0000000000 0.0000000000 1.0000000000  0.0000000000
2 'crystal symmetry operation' 2_555 -x,y+1/2,-z -1.0000000000 0.0000000000 0.0000000000 0.0000000000 0.0000000000 1.0000000000
0.0000000000 2.4330000000 0.0000000000 0.0000000000 -1.0000000000 0.0000000000
#
loop_
_pdbx_audit_revision_history.ordinal
_pdbx_audit_revision_history.data_content_type
_pdbx_audit_revision_history.major_revision
_pdbx_audit_revision_history.minor_revision
_pdbx_audit_revision_history.revision_date
1 'Structure model' 1 0 2005-06-14
2 'Structure model' 1 1 2008-04-30
3 'Structure model' 1 2 2011-07-13
4 'Structure model' 1 3 2017-10-11
#
_pdbx_audit_revision_details.ordinal             1
_pdbx_audit_revision_details.revision_ordinal    1
_pdbx_audit_revision_details.data_content_type   'Structure model'
_pdbx_audit_revision_details.provider            repository
_pdbx_audit_revision_details.type                'Initial release'
_pdbx_audit_revision_details.description         ?
#
loop_
_pdbx_audit_revision_group.ordinal
_pdbx_audit_revision_group.revision_ordinal
_pdbx_audit_revision_group.data_content_type
_pdbx_audit_revision_group.group
1 2 'Structure model' 'Version format compliance'
2 3 'Structure model' 'Version format compliance'
3 4 'Structure model' 'Refinement description'
#
_pdbx_audit_revision_category.ordinal             1
_pdbx_audit_revision_category.revision_ordinal    4
_pdbx_audit_revision_category.data_content_type   'Structure model'
_pdbx_audit_revision_category.category            software
#
loop_
_software.name
_software.version
_software.date
_software.type
_software.contact_author
_software.contact_author_email
_software.classification
_software.location
_software.language
_software.citation_id
_software.pdbx_ordinal
REFMAC    . ? program 'Murshudov, G.N.' ccp4@dl.ac.uk refinement       http://www.ccp4.ac.uk/main.html Fortran ? 1
DENZO     . ? ?       ?                 ?             'data reduction' ?                               ?       ? 2
SCALEPACK . ? ?       ?                 ?             'data scaling'   ?                               ?       ? 3
#
_pdbx_database_remark.id     300
_pdbx_database_remark.text
;BIOMOLECULE: 1
THIS ENTRY CONTAINS THE CRYSTALLOGRAPHIC ASYMMETRIC UNIT
WHICH CONSISTS OF 1 CHAIN(S).  The second beta strand of
the beta sandwich is generated as described in remark 350.
Beta sheets are generated from unit cell translations
along the unit cell b dimension: x,y+1,z.
;
#
_pdbx_entity_nonpoly.entity_id   2
_pdbx_entity_nonpoly.name        water
_pdbx_entity_nonpoly.comp_id     HOH
#
"""
model_1yjp_with_waters = model_1yjp.replace('END', '''TER
HETATM   61  O   HOH A   8      -6.471   5.227   7.124  1.00 22.62           O
HETATM   62  O   HOH A   9      10.431   1.858   3.216  1.00 19.71           O
HETATM   63  O   HOH A  10     -11.286   1.756  -1.468  1.00 17.08           O
HETATM   64  O   HOH A  11      11.808   4.179   9.970  1.00 23.99           O
HETATM   65  O   HOH A  12      13.605   1.327   9.198  1.00 26.17           O
HETATM   66  O   HOH A  13      -2.749   3.429  10.024  1.00 39.15           O
HETATM   67  O   HOH A  14      -1.500   0.682  10.967  1.00 43.49           O
END
''')
# smallest PDB with a "ligand"
model_1aL1 = '''
CRYST1   62.350   62.350   62.350  90.00  90.00  90.00 I 41 3 2     48
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.016038  0.000000  0.000000        0.00000
SCALE2      0.000000  0.016038  0.000000        0.00000
SCALE3      0.000000  0.000000  0.016038        0.00000
HETATM    1  C   ACE A   0      31.227  38.585  11.521  1.00 25.00           C
HETATM    2  O   ACE A   0      30.433  37.878  10.859  1.00 25.00           O
HETATM    3  CH3 ACE A   0      30.894  39.978  11.951  1.00 25.00           C
ATOM      4  N   GLU A   1      32.153  37.943  12.252  1.00 25.00           N
ATOM      5  CA  GLU A   1      32.594  36.639  11.811  1.00 25.00           C
ATOM      6  C   GLU A   1      32.002  35.428  12.514  1.00 25.00           C
ATOM      7  O   GLU A   1      32.521  34.279  12.454  1.00 25.00           O
ATOM      8  CB  GLU A   1      34.093  36.609  11.812  1.00 25.00           C
ATOM      9  CG  GLU A   1      34.609  36.464  13.285  1.00 25.00           C
ATOM     10  CD  GLU A   1      36.125  36.460  13.044  1.00 25.00           C
ATOM     11  OE1 GLU A   1      36.442  35.745  12.084  1.00 25.00           O
ATOM     12  OE2 GLU A   1      36.684  37.260  13.809  1.00 25.00           O
ATOM     13  N   LEU A   2      30.895  35.627  13.188  1.00 25.00           N
ATOM     14  CA  LEU A   2      30.067  34.612  13.814  1.00 25.00           C
ATOM     15  C   LEU A   2      29.025  34.315  12.695  1.00 25.00           C
ATOM     16  O   LEU A   2      28.665  33.168  12.395  1.00 25.00           O
ATOM     17  CB  LEU A   2      29.515  35.034  15.156  1.00 25.00           C
ATOM     18  CG  LEU A   2      28.434  34.122  15.752  1.00 25.00           C
ATOM     19  CD1 LEU A   2      29.008  33.110  16.720  1.00 25.00           C
ATOM     20  CD2 LEU A   2      27.350  34.963  16.399  1.00 25.00           C
ATOM     21  N   LEU A   3      28.628  35.417  12.027  1.00 25.00           N
ATOM     22  CA  LEU A   3      27.686  35.251  10.912  1.00 25.00           C
ATOM     23  C   LEU A   3      28.396  34.389   9.850  1.00 25.00           C
ATOM     24  O   LEU A   3      27.770  33.565   9.191  1.00 25.00           O
ATOM     25  CB  LEU A   3      27.084  36.547  10.374  1.00 25.00           C
ATOM     26  CG  LEU A   3      26.064  36.325   9.246  1.00 25.00           C
ATOM     27  CD1 LEU A   3      24.784  35.715   9.770  1.00 25.00           C
ATOM     28  CD2 LEU A   3      25.777  37.594   8.497  1.00 25.00           C
ATOM     29  N   LYS A   4      29.674  34.603   9.703  1.00 25.00           N
ATOM     30  CA  LYS A   4      30.512  33.899   8.748  1.00 25.00           C
ATOM     31  C   LYS A   4      30.578  32.417   9.098  1.00 25.00           C
ATOM     32  O   LYS A   4      30.261  31.531   8.280  1.00 25.00           O
ATOM     33  CB  LYS A   4      31.924  34.471   8.710  1.00 25.00           C
ATOM     34  CG  LYS A   4      32.539  34.431   7.317  1.00 25.00           C
ATOM     35  CD  LYS A   4      34.046  34.511   7.426  1.00 25.00           C
ATOM     36  CE  LYS A   4      34.729  33.782   6.289  1.00 25.00           C
ATOM     37  NZ  LYS A   4      34.710  34.603   5.059  1.00 25.00           N
ATOM     38  N   LYS A   5      30.993  32.153  10.327  1.00 25.00           N
ATOM     39  CA  LYS A   5      31.104  30.730  10.715  1.00 25.00           C
ATOM     40  C   LYS A   5      29.734  30.111  10.595  1.00 25.00           C
ATOM     41  O   LYS A   5      29.602  29.133   9.833  1.00 25.00           O
ATOM     42  CB  LYS A   5      31.793  30.525  12.023  1.00 25.00           C
ATOM     43  CG  LYS A   5      33.284  30.906  12.043  1.00 25.00           C
ATOM     44  N   LEU A   6      28.753  30.676  11.269  1.00 25.00           N
ATOM     45  CA  LEU A   6      27.375  30.124  11.257  1.00 25.00           C
ATOM     46  C   LEU A   6      26.938  29.849   9.827  1.00 25.00           C
ATOM     47  O   LEU A   6      26.490  28.746   9.489  1.00 25.00           O
ATOM     48  CB  LEU A   6      26.459  31.026  12.062  1.00 25.00           C
ATOM     49  CG  LEU A   6      24.966  30.925  11.913  1.00 25.00           C
ATOM     50  CD1 LEU A   6      24.329  29.894  12.837  1.00 25.00           C
ATOM     51  CD2 LEU A   6      24.339  32.286  12.234  1.00 25.00           C
ATOM     52  N   LEU A   7      27.110  30.857   9.002  1.00 25.00           N
ATOM     53  CA  LEU A   7      26.760  30.849   7.586  1.00 25.00           C
ATOM     54  C   LEU A   7      27.408  29.683   6.868  1.00 25.00           C
ATOM     55  O   LEU A   7      26.743  29.154   5.950  1.00 25.00           O
ATOM     56  CB  LEU A   7      27.003  32.249   6.971  1.00 25.00           C
ATOM     57  CG  LEU A   7      25.878  33.239   6.752  1.00 25.00           C
ATOM     58  CD1 LEU A   7      26.241  34.705   6.949  1.00 25.00           C
ATOM     59  CD2 LEU A   7      25.397  33.158   5.297  1.00 25.00           C
ATOM     60  N   GLU A   8      28.603  29.243   7.208  1.00 25.00           N
ATOM     61  CA  GLU A   8      29.260  28.146   6.496  1.00 25.00           C
ATOM     62  C   GLU A   8      28.759  26.751   6.831  1.00 25.00           C
ATOM     63  O   GLU A   8      28.974  25.822   6.023  1.00 25.00           O
ATOM     64  CB  GLU A   8      30.742  28.009   6.785  1.00 25.00           C
ATOM     65  CG  GLU A   8      31.432  29.271   7.271  1.00 25.00           C
ATOM     66  CD  GLU A   8      32.846  28.933   7.703  1.00 25.00           C
ATOM     67  OE1 GLU A   8      33.727  28.886   6.851  1.00 25.00           O
ATOM     68  OE2 GLU A   8      32.945  28.685   8.934  1.00 25.00           O
ATOM     69  N   GLU A   9      28.216  26.687   8.024  1.00 25.00           N
ATOM     70  CA  GLU A   9      27.676  25.450   8.602  1.00 25.00           C
ATOM     71  C   GLU A   9      26.228  25.197   8.197  1.00 25.00           C
ATOM     72  O   GLU A   9      25.741  24.063   8.299  1.00 25.00           O
ATOM     73  CB  GLU A   9      27.655  25.571  10.131  1.00 25.00           C
ATOM     74  CG  GLU A   9      28.212  24.450  10.999  1.00 25.00           C
ATOM     75  CD  GLU A   9      29.424  24.893  11.771  1.00 25.00           C
ATOM     76  OE1 GLU A   9      29.571  24.773  12.967  1.00 25.00           O
ATOM     77  OE2 GLU A   9      30.236  25.448  10.993  1.00 25.00           O
ATOM     78  N   LEU A  10      25.547  26.243   7.776  1.00 25.00           N
ATOM     79  CA  LEU A  10      24.138  26.200   7.405  1.00 25.00           C
ATOM     80  C   LEU A  10      23.858  25.477   6.104  1.00 25.00           C
ATOM     81  O   LEU A  10      24.653  25.474   5.162  1.00 25.00           O
ATOM     82  CB  LEU A  10      23.611  27.641   7.410  1.00 25.00           C
ATOM     83  CG  LEU A  10      22.355  27.821   8.248  1.00 25.00           C
ATOM     84  CD1 LEU A  10      22.565  27.116   9.582  1.00 25.00           C
ATOM     85  CD2 LEU A  10      22.151  29.317   8.369  1.00 25.00           C
ATOM     86  N   LYS A  11      22.674  24.898   6.074  1.00 25.00           N
ATOM     87  CA  LYS A  11      22.163  24.138   4.939  1.00 25.00           C
ATOM     88  C   LYS A  11      21.851  25.032   3.731  1.00 25.00           C
ATOM     89  O   LYS A  11      21.403  26.185   3.840  1.00 25.00           O
ATOM     90  CB  LYS A  11      20.933  23.323   5.327  1.00 25.00           C
ATOM     91  N   GLY A  12      22.109  24.411   2.573  1.00 25.00           N
ATOM     92  CA  GLY A  12      21.938  24.917   1.234  1.00 25.00           C
ATOM     93  C   GLY A  12      21.882  26.448   1.133  1.00 25.00           C
ATOM     94  O   GLY A  12      22.838  26.994   0.516  1.00 25.00           O
ATOM     95  OXT GLY A  12      20.888  27.022   1.650  1.00 25.00           O
TER      96      GLY A  12
HETATM   97  S   SO4 A  13      31.477  38.950  15.821  0.50 25.00           S
HETATM   98  O1  SO4 A  13      31.243  38.502  17.238  0.50 25.00           O
HETATM   99  O2  SO4 A  13      30.616  40.133  15.527  0.50 25.00           O
HETATM  100  O3  SO4 A  13      31.158  37.816  14.905  0.50 25.00           O
HETATM  101  O4  SO4 A  13      32.916  39.343  15.640  0.50 25.00           O
END
'''
