+++
title = "google_logging_folder_exclusions resource"
draft = false
gh_repo = "inspec"
platform = "gcp"

[menu]
  [menu.inspec]
    title = "google_logging_folder_exclusions"
    identifier = "inspec/resources/gcp/google_logging_folder_exclusions.md google_logging_folder_exclusions resource"
    parent = "inspec/resources/gcp"
+++

## Syntax

A `google_logging_folder_exclusions` is used to test a Google FolderExclusion resource

## Examples

```ruby
# Getting folder exclusions is complicated due to the name being generated by the server.
# This can be drastically simplified if you have the name when writing the test
describe.one do
  google_resourcemanager_folders(parent: 'organizations/12345').names.each do |name|
    # name on a folder is in the form `folders/12345`
    describe google_logging_folder_exclusions(folder: name.split('/')[1]) do
      its('names'){ should include 'inspec-folder-exclusion' }
      its('descriptions'){ should include 'My folder exclusion description' }
      its('filters'){ should include 'resource.type = gce_instance AND severity <= DEBUG' }
    end
  end
end
```

## Properties

Properties that can be accessed from the `google_logging_folder_exclusions` resource:

See the [google_logging_folder_exclusion](/inspec/resources/google_logging_folder_exclusion/#properties) resource for more information.

`folders`
: an array of `google_logging_folder_exclusion` folder

`names`
: an array of `google_logging_folder_exclusion` name

`descriptions`
: an array of `google_logging_folder_exclusion` description

`filters`
: an array of `google_logging_folder_exclusion` filter

`disableds`
: an array of `google_logging_folder_exclusion` disabled

## Filter Criteria

This resource supports all of the above properties as filter criteria, which can be used
with `where` as a block or a method.

## GCP Permissions

Ensure the [Stackdriver Logging API](https://console.cloud.google.com/apis/library/logging.googleapis.com/) is enabled for the current project.
