/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;

public class ETileConcatenation
extends ETile {
    private final double marginx = 20.0;
    private final List<ETile> tiles = new ArrayList<ETile>();

    @Override
    public void push(ETile tile) {
        this.tiles.add(0, tile);
    }

    public void pushLast(ETile tile) {
        this.tiles.add(tile);
    }

    public void overideFirst(ETile tile) {
        this.tiles.set(0, tile);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double fullLinePos = this.getH1(stringBounder);
        double x = 0.0;
        this.drawHline(ug, fullLinePos, 0.0, x);
        for (int i = 0; i < this.tiles.size(); ++i) {
            ETile tile = this.tiles.get(i);
            double linePos = tile.getH1(stringBounder);
            tile.drawU(ug.apply(new UTranslate(x, fullLinePos - linePos)));
            x += tile.calculateDimension(stringBounder).getWidth();
            if (i == this.tiles.size() - 1) continue;
            this.drawHlineDirected(ug, fullLinePos, x, x + 20.0, 0.5, 25.0);
            x += 20.0;
        }
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        double result = 0.0;
        for (ETile tile : this.tiles) {
            result = Math.max(result, tile.getH1(stringBounder));
        }
        return result;
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        double result = 0.0;
        for (ETile tile : this.tiles) {
            result = Math.max(result, tile.getH2(stringBounder));
        }
        return result;
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        double width = 0.0;
        for (int i = 0; i < this.tiles.size(); ++i) {
            ETile tile = this.tiles.get(i);
            width += tile.getWidth(stringBounder);
            if (i == this.tiles.size() - 1) continue;
            width += 20.0;
        }
        return width;
    }

    public ETile getFirst() {
        return this.tiles.get(0);
    }
}

