/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleDatumWithConnection;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class DatumWithConnection
extends Datum
implements OracleDatumWithConnection {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;
    protected DatumWithConnection targetDatumWithConnection = null;

    public oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        if (this.targetDatumWithConnection != null) {
            return this.targetDatumWithConnection.getPhysicalConnection();
        }
        if (this.physicalConnection == null) {
            try {
                this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.physicalConnection;
    }

    public DatumWithConnection(byte[] elements) throws SQLException {
        super(elements);
    }

    public DatumWithConnection() {
    }

    public static void assertNotNull(Connection conn) throws SQLException {
        if (conn == null) {
            throw (SQLException)DatabaseError.createSqlException(68, "Connection is null").fillInStackTrace();
        }
    }

    public static void assertNotNull(TypeDescriptor desc) throws SQLException {
        if (desc == null) {
            throw (SQLException)DatabaseError.createSqlException(61).fillInStackTrace();
        }
    }

    @Override
    public void setPhysicalConnectionOf(Connection conn) {
        if (this.ojiOracleDatumWithConnection != null) {
            this.ojiOracleDatumWithConnection.setPhysicalConnectionOf(conn);
        } else if (this.targetDatumWithConnection != null) {
            this.targetDatumWithConnection.setPhysicalConnectionOf(conn);
        } else {
            this.physicalConnection = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        }
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getJavaSqlConnection();
        }
        return this.getPhysicalConnection().getWrapper();
    }

    @Override
    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getOracleConnection();
        }
        return this.getPhysicalConnection().getWrapper();
    }

    @Override
    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getInternalConnection();
        }
        return this.getPhysicalConnection();
    }

    @Override
    public OracleConnection getConnection() throws SQLException {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getConnection();
        }
        if (this.targetDatumWithConnection != null) {
            return this.targetDatumWithConnection.getConnection();
        }
        OracleConnection ret = null;
        try {
            ret = (OracleConnection)((OracleConnection)this.physicalConnection).getWrapper();
        }
        catch (ClassCastException ex) {
            throw (SQLException)DatabaseError.createSqlException(103).fillInStackTrace();
        }
        return ret;
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        if (this.targetDatumWithConnection != null) {
            return this.targetDatumWithConnection.getConnectionDuringExceptionHandling();
        }
        return this.physicalConnection;
    }
}

