/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.net.aso.AESDataIntegrity;
import oracle.net.aso.AsoException;
import oracle.net.aso.EncryptionAlgorithm;
import oracle.net.aso.MessageDigestAlgorithm;
import oracle.net.aso.RC4;

public final class DataIntegrityAlgorithm {
    private final EncryptionAlgorithm encryptionEngine;
    private byte[] feederBytes;
    private final String dataIntegrityAlgName;
    protected MessageDigestAlgorithm digestEngine;

    public DataIntegrityAlgorithm(byte[] key, byte[] iv, String algName, boolean allowWeakCrypto) throws AsoException {
        this.dataIntegrityAlgName = algName;
        this.digestEngine = new JCEDigestWrapper(algName);
        this.encryptionEngine = this.useAES() ? new AESDataIntegrity(key, iv, allowWeakCrypto) : new RC4(key, iv, allowWeakCrypto);
        this.feederBytes = new byte[this.size()];
    }

    public boolean compare(byte[] buffer, byte[] xsum) throws AsoException {
        byte[] output = this.encryptionEngine.decrypt(this.feederBytes);
        this.digestEngine.reset();
        this.digestEngine.update(buffer, 0, buffer.length);
        this.digestEngine.update(output, 0, output.length);
        byte[] tempBuff = new byte[this.size()];
        this.digestEngine.digest(tempBuff, 0);
        boolean areDifferent = false;
        for (int i = 0; i < this.size(); ++i) {
            if (tempBuff[i] == xsum[i]) continue;
            areDifferent = true;
            break;
        }
        return areDifferent;
    }

    public byte[] compute(byte[] source, int length) throws AsoException {
        if (source.length < length) {
            return null;
        }
        byte[] output = this.encryptionEngine.encrypt(this.feederBytes);
        this.digestEngine.reset();
        this.digestEngine.update(source, 0, length);
        this.digestEngine.update(output, 0, output.length);
        this.digestEngine.digest(output, 0);
        return output;
    }

    public int takeSessionKey(byte[] key, byte[] iv) {
        try {
            this.encryptionEngine.setSessionKey(key, iv);
        }
        catch (AsoException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    public void renew() throws AsoException {
        this.encryptionEngine.renewKey();
    }

    public int size() {
        return this.digestEngine.getDigestLength();
    }

    public String getProviderName() {
        return this.digestEngine.getProviderName();
    }

    private boolean useAES() {
        return this.dataIntegrityAlgName == "SHA256" || this.dataIntegrityAlgName == "SHA384" || this.dataIntegrityAlgName == "SHA512";
    }

    class JCEDigestWrapper
    implements MessageDigestAlgorithm {
        private MessageDigest jceEngine = null;

        JCEDigestWrapper(String algorithmName) {
            try {
                this.initializeEngine(algorithmName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        private void initializeEngine(String algorithmName) throws NoSuchAlgorithmException {
            switch (algorithmName) {
                case "SHA1": {
                    this.jceEngine = MessageDigest.getInstance("SHA-1");
                    break;
                }
                case "SHA256": {
                    this.jceEngine = MessageDigest.getInstance("SHA-256");
                    break;
                }
                case "SHA384": {
                    this.jceEngine = MessageDigest.getInstance("SHA-384");
                    break;
                }
                case "SHA512": {
                    this.jceEngine = MessageDigest.getInstance("SHA-512");
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported Algorithm : " + algorithmName);
                }
            }
        }

        @Override
        public int getDigestLength() {
            return this.jceEngine.getDigestLength();
        }

        @Override
        public void reset() {
            this.jceEngine.reset();
        }

        @Override
        public void update(byte[] input, int off, int len) {
            this.jceEngine.update(input, off, len);
        }

        @Override
        public int digest(byte[] output, int offset) {
            try {
                return this.jceEngine.digest(output, offset, output.length);
            }
            catch (DigestException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getProviderName() {
            return this.jceEngine.getProvider().getName();
        }
    }
}

