/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.XSAttribute;

final class XSAttributeI
extends XSAttribute {
    String attributeName = null;
    byte[] attributeNameBytes;
    String attributeValue = null;
    byte[] attributeValueBytes;
    String attributeDefaultValue = null;
    byte[] attributeDefaultValueBytes;
    long flag = 0L;

    XSAttributeI() {
    }

    @Override
    public void setAttributeName(String _attributeName) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.attributeName = _attributeName;
    }

    void doCharConversion(DBConversion conv) throws SQLException {
        this.attributeNameBytes = (byte[])(this.attributeName != null ? conv.StringToCharBytes(this.attributeName) : null);
        this.attributeValueBytes = (byte[])(this.attributeValue != null ? conv.StringToCharBytes(this.attributeValue) : null);
        this.attributeDefaultValueBytes = (byte[])(this.attributeDefaultValue != null ? conv.StringToCharBytes(this.attributeDefaultValue) : null);
    }

    @Override
    public void setAttributeValue(String _attributeValue) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.attributeValue = _attributeValue;
    }

    @Override
    public void setAttributeDefaultValue(String _attributeDefaultValue) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.attributeDefaultValue = _attributeDefaultValue;
    }

    @Override
    public void setFlag(long _flag) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.flag = _flag;
    }

    @Override
    public String getAttributeName() {
        InternalFactory.xsSecurityCheck();
        return this.attributeName;
    }

    @Override
    public String getAttributeValue() {
        InternalFactory.xsSecurityCheck();
        return this.attributeValue;
    }

    @Override
    public String getAttributeDefaultValue() {
        InternalFactory.xsSecurityCheck();
        return this.attributeDefaultValue;
    }

    @Override
    public long getFlag() {
        InternalFactory.xsSecurityCheck();
        return this.flag;
    }

    void marshal(T4CMAREngine mar) throws IOException {
        if (this.attributeNameBytes != null) {
            mar.marshalUB4(this.attributeNameBytes.length);
            mar.marshalCLR(this.attributeNameBytes, this.attributeNameBytes.length);
        } else {
            mar.marshalUB4(0L);
        }
        if (this.attributeValueBytes != null) {
            mar.marshalUB4(this.attributeValueBytes.length);
            mar.marshalCLR(this.attributeValueBytes, this.attributeValueBytes.length);
        } else {
            mar.marshalUB4(0L);
        }
        if (this.attributeDefaultValueBytes != null) {
            mar.marshalUB4(this.attributeDefaultValueBytes.length);
            mar.marshalCLR(this.attributeDefaultValueBytes, this.attributeDefaultValueBytes.length);
        } else {
            mar.marshalUB4(0L);
        }
        mar.marshalUB4(this.flag);
    }

    static XSAttributeI unmarshal(T4CMAREngine mar) throws SQLException, IOException {
        int attributeDefaultValueLength;
        int attributeValueLength;
        int[] intArr = new int[1];
        String attributeName = null;
        String attributeValue = null;
        String attributeDefaultValue = null;
        int attributeNameLength = (int)mar.unmarshalUB4();
        if (attributeNameLength > 0) {
            byte[] attributeNameBytesTemp = new byte[attributeNameLength];
            mar.unmarshalCLR(attributeNameBytesTemp, 0, intArr);
            attributeName = mar.conv.CharBytesToString(attributeNameBytesTemp, intArr[0]);
        }
        if ((attributeValueLength = (int)mar.unmarshalUB4()) > 0) {
            byte[] attributeValueBytesTemp = new byte[attributeValueLength];
            mar.unmarshalCLR(attributeValueBytesTemp, 0, intArr);
            attributeValue = mar.conv.CharBytesToString(attributeValueBytesTemp, intArr[0]);
        }
        if ((attributeDefaultValueLength = (int)mar.unmarshalUB4()) > 0) {
            byte[] attributeDefaultValueBytesTemp = new byte[attributeDefaultValueLength];
            mar.unmarshalCLR(attributeDefaultValueBytesTemp, 0, intArr);
            attributeDefaultValue = mar.conv.CharBytesToString(attributeDefaultValueBytesTemp, intArr[0]);
        }
        long flag = mar.unmarshalUB4();
        XSAttributeI attr = new XSAttributeI();
        attr.setAttributeName(attributeName);
        attr.setAttributeValue(attributeValue);
        attr.setAttributeDefaultValue(attributeDefaultValue);
        attr.setFlag(flag);
        return attr;
    }
}

