/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class BinaryDoubleAccessor
extends Accessor {
    static final int MAXLENGTH = 8;
    private final byte[] tmpBytes;

    BinaryDoubleAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.BINARY_DOUBLE, stmt, 8, isStoredInBindData);
        this.tmpBytes = new byte[this.representationMaxLength];
        this.init(stmt, 101, 101, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    BinaryDoubleAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.BINARY_DOUBLE, stmt, 8, false);
        this.tmpBytes = new byte[this.representationMaxLength];
        this.init(stmt, 101, 101, form, false);
        this.initForDescribe(101, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        int max_field_size = stmt.maxFieldSize;
        if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
            max_len = max_field_size;
        }
        this.initForDataAccess(0, max_len, null);
    }

    static double longBitsToDouble(long bits) {
        bits = (bits & Long.MIN_VALUE) != 0L ? (bits &= Long.MAX_VALUE) : (bits ^= 0xFFFFFFFFFFFFFFFFL);
        return Double.longBitsToDouble(bits);
    }

    static long doubleToLongBits(double value) {
        long bits = Double.doubleToRawLongBits(value);
        bits = (bits & Long.MIN_VALUE) == 0L ? (bits |= Long.MIN_VALUE) : (bits ^= 0xFFFFFFFFFFFFFFFFL);
        return bits;
    }

    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, short form, int external_type) throws SQLException {
        this.init(stmt, internal_type, database_type, form, false);
        this.initForDataAccess(external_type, max_len, null);
    }

    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        this.init(stmt, internal_type, database_type, form, false);
        this.initForDescribe(internal_type, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        int max_field_size = stmt.maxFieldSize;
        if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
            max_len = max_field_size;
        }
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    double getDouble(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return 0.0;
        }
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, this.representationMaxLength);
        return BinaryDoubleAccessor.decodeDouble(this.tmpBytes);
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return BinaryDoubleAccessor.doubleToString(this.getDouble(currentRow));
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new Double(this.getDouble(currentRow));
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
        return new Double(this.getDouble(currentRow));
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getBINARY_DOUBLE(currentRow);
    }

    @Override
    BINARY_DOUBLE getBINARY_DOUBLE(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new BINARY_DOUBLE(this.rowData.get(this.getOffset(currentRow), this.getLength(currentRow)));
    }

    @Override
    NUMBER getNUMBER(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new NUMBER(this.getDouble(currentRow));
    }

    @Override
    BigInteger getBigInteger(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return this.getBigDecimal(currentRow).toBigInteger();
    }

    @Override
    BigDecimal getBigDecimal(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return BinaryDoubleAccessor.doubleToBigDecimal(this.getDouble(currentRow));
    }

    @Override
    byte getByte(int currentRow) throws SQLException {
        return BinaryDoubleAccessor.doubleToByte(this.getDouble(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    short getShort(int currentRow) throws SQLException {
        return BinaryDoubleAccessor.doubleToShort(this.getDouble(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    int getInt(int currentRow) throws SQLException {
        return BinaryDoubleAccessor.doubleToInt(this.getDouble(currentRow), this.getConnectionDuringExceptionHandling());
    }

    @Override
    long getLong(int currentRow) throws SQLException {
        return BinaryDoubleAccessor.doubleToLong(this.getDouble(currentRow));
    }

    @Override
    float getFloat(int currentRow) throws SQLException {
        return BinaryDoubleAccessor.doubleToFloat(this.getDouble(currentRow));
    }

    @Override
    boolean getBoolean(int currentRow) throws SQLException {
        return BinaryDoubleAccessor.doubleToBoolean(this.getDouble(currentRow));
    }

    static double decodeDouble(byte[] encodedDouble) {
        int b0 = encodedDouble[0];
        int b1 = encodedDouble[1];
        int b2 = encodedDouble[2];
        int b3 = encodedDouble[3];
        int b4 = encodedDouble[4];
        int b5 = encodedDouble[5];
        int b6 = encodedDouble[6];
        int b7 = encodedDouble[7];
        if ((b0 & 0x80) != 0) {
            b0 &= 0x7F;
            b1 &= 0xFF;
            b2 &= 0xFF;
            b3 &= 0xFF;
            b4 &= 0xFF;
            b5 &= 0xFF;
            b6 &= 0xFF;
            b7 &= 0xFF;
        } else {
            b0 = ~b0 & 0xFF;
            b1 = ~b1 & 0xFF;
            b2 = ~b2 & 0xFF;
            b3 = ~b3 & 0xFF;
            b4 = ~b4 & 0xFF;
            b5 = ~b5 & 0xFF;
            b6 = ~b6 & 0xFF;
            b7 = ~b7 & 0xFF;
        }
        int hiBits = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        int loBits = b4 << 24 | b5 << 16 | b6 << 8 | b7;
        long longBits = (long)hiBits << 32 | (long)loBits & 0xFFFFFFFFL;
        return Double.longBitsToDouble(longBits);
    }

    static byte doubleToByte(double doubleValue, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        if (doubleValue >= -128.0 && doubleValue <= 127.0) {
            return (byte)doubleValue;
        }
        throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 26).fillInStackTrace();
    }

    static short doubleToShort(double doubleValue, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        if (doubleValue >= -32768.0 && doubleValue <= 32767.0) {
            return (short)doubleValue;
        }
        throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 26).fillInStackTrace();
    }

    static int doubleToInt(double doubleValue, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        if (doubleValue >= -2.147483648E9 && doubleValue <= 2.147483647E9) {
            return (int)doubleValue;
        }
        throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 26).fillInStackTrace();
    }

    static float doubleToFloat(double doubleValue) {
        return (float)doubleValue;
    }

    static long doubleToLong(double doubleValue) {
        return (long)doubleValue;
    }

    static String doubleToString(double doubleValue) {
        return Double.toString(doubleValue);
    }

    static BigDecimal doubleToBigDecimal(double doubleValue) {
        return new BigDecimal(BinaryDoubleAccessor.doubleToString(doubleValue));
    }

    static boolean doubleToBoolean(double doubleValue) {
        return doubleValue != 0.0;
    }
}

