/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPEndpoint
implements Endpoint {
    private String host;
    private int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private int listenPort = -1;
    private TCPTransport transport = null;
    private static String localHost;
    private static boolean localHostKnown;
    private static final Map<TCPEndpoint, LinkedList<TCPEndpoint>> localEndpoints;
    private static final int FORMAT_HOST_PORT = 0;
    private static final int FORMAT_HOST_PORT_FACTORY = 1;

    private static int getInt(String string, int n) {
        return AccessController.doPrivileged(new GetIntegerAction(string, n));
    }

    private static boolean getBoolean(String string) {
        return AccessController.doPrivileged(new GetBooleanAction(string));
    }

    private static String getHostnameProperty() {
        return AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.hostname"));
    }

    public TCPEndpoint(String string, int n) {
        this(string, n, null, null);
    }

    public TCPEndpoint(String string, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        if (string == null) {
            string = "";
        }
        this.host = string;
        this.port = n;
        this.csf = rMIClientSocketFactory;
        this.ssf = rMIServerSocketFactory;
    }

    public static TCPEndpoint getLocalEndpoint(int n) {
        return TCPEndpoint.getLocalEndpoint(n, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TCPEndpoint getLocalEndpoint(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        TCPEndpoint tCPEndpoint = null;
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            TCPEndpoint tCPEndpoint2 = new TCPEndpoint(null, n, rMIClientSocketFactory, rMIServerSocketFactory);
            LinkedList<TCPEndpoint> linkedList = localEndpoints.get(tCPEndpoint2);
            String string = TCPEndpoint.resampleLocalHost();
            if (linkedList == null) {
                tCPEndpoint = new TCPEndpoint(string, n, rMIClientSocketFactory, rMIServerSocketFactory);
                linkedList = new LinkedList();
                linkedList.add(tCPEndpoint);
                tCPEndpoint.listenPort = n;
                tCPEndpoint.transport = new TCPTransport(linkedList);
                localEndpoints.put(tCPEndpoint2, linkedList);
                if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                    TCPTransport.tcpLog.log(Log.BRIEF, "created local endpoint for socket factory " + rMIServerSocketFactory + " on port " + n);
                }
            } else {
                LinkedList<TCPEndpoint> linkedList2 = linkedList;
                synchronized (linkedList2) {
                    tCPEndpoint = linkedList.getLast();
                    String string2 = tCPEndpoint.host;
                    int n2 = tCPEndpoint.port;
                    TCPTransport tCPTransport = tCPEndpoint.transport;
                    if (string != null && !string.equals(string2)) {
                        if (n2 != 0) {
                            linkedList.clear();
                        }
                        tCPEndpoint = new TCPEndpoint(string, n2, rMIClientSocketFactory, rMIServerSocketFactory);
                        tCPEndpoint.listenPort = n;
                        tCPEndpoint.transport = tCPTransport;
                        linkedList.add(tCPEndpoint);
                    }
                }
            }
        }
        return tCPEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String resampleLocalHost() {
        String string = TCPEndpoint.getHostnameProperty();
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            if (string != null) {
                if (!localHostKnown) {
                    TCPEndpoint.setLocalHost(string);
                } else if (!string.equals(localHost)) {
                    localHost = string;
                    if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                        TCPTransport.tcpLog.log(Log.BRIEF, "updated local hostname to: " + localHost);
                    }
                }
            }
            return localHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setLocalHost(String string) {
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            if (!localHostKnown) {
                localHost = string;
                localHostKnown = true;
                if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                    TCPTransport.tcpLog.log(Log.BRIEF, "local host set to " + string);
                }
                Iterator<LinkedList<TCPEndpoint>> iterator = localEndpoints.values().iterator();
                while (iterator.hasNext()) {
                    LinkedList<TCPEndpoint> linkedList;
                    LinkedList<TCPEndpoint> linkedList2 = linkedList = iterator.next();
                    synchronized (linkedList2) {
                        for (TCPEndpoint tCPEndpoint : linkedList) {
                            tCPEndpoint.host = string;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefaultPort(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        TCPEndpoint tCPEndpoint = new TCPEndpoint(null, 0, rMIClientSocketFactory, rMIServerSocketFactory);
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            LinkedList<TCPEndpoint> linkedList = localEndpoints.get(tCPEndpoint);
            Object object = linkedList;
            synchronized (object) {
                int n2 = linkedList.size();
                TCPEndpoint tCPEndpoint2 = linkedList.getLast();
                for (TCPEndpoint tCPEndpoint3 : linkedList) {
                    tCPEndpoint3.port = n;
                }
                if (n2 > 1) {
                    linkedList.clear();
                    linkedList.add(tCPEndpoint2);
                }
            }
            object = new TCPEndpoint(null, n, rMIClientSocketFactory, rMIServerSocketFactory);
            localEndpoints.put((TCPEndpoint)object, linkedList);
            if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                TCPTransport.tcpLog.log(Log.BRIEF, "default port for server socket factory " + rMIServerSocketFactory + " and client socket factory " + rMIClientSocketFactory + " set to " + n);
            }
        }
    }

    @Override
    public Transport getOutboundTransport() {
        TCPEndpoint tCPEndpoint = TCPEndpoint.getLocalEndpoint(0, null, null);
        return tCPEndpoint.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<TCPTransport> allKnownTransports() {
        HashSet<TCPTransport> hashSet;
        Map<TCPEndpoint, LinkedList<TCPEndpoint>> map = localEndpoints;
        synchronized (map) {
            hashSet = new HashSet<TCPTransport>(localEndpoints.size());
            for (LinkedList<TCPEndpoint> linkedList : localEndpoints.values()) {
                TCPEndpoint tCPEndpoint = linkedList.getFirst();
                hashSet.add(tCPEndpoint.transport);
            }
        }
        return hashSet;
    }

    public static void shedConnectionCaches() {
        for (TCPTransport tCPTransport : TCPEndpoint.allKnownTransports()) {
            tCPTransport.shedConnectionCaches();
        }
    }

    @Override
    public void exportObject(Target target) throws RemoteException {
        this.transport.exportObject(target);
    }

    @Override
    public Channel getChannel() {
        return this.getOutboundTransport().getChannel(this);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    @Override
    public Transport getInboundTransport() {
        return this.transport;
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.csf;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public String toString() {
        return "[" + this.host + ":" + this.port + (this.ssf != null ? "," + this.ssf : "") + (this.csf != null ? "," + this.csf : "") + "]";
    }

    public int hashCode() {
        return this.port;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TCPEndpoint) {
            TCPEndpoint tCPEndpoint = (TCPEndpoint)object;
            if (this.port != tCPEndpoint.port || !this.host.equals(tCPEndpoint.host)) {
                return false;
            }
            if (this.csf == null ^ tCPEndpoint.csf == null || this.ssf == null ^ tCPEndpoint.ssf == null) {
                return false;
            }
            if (!(this.csf == null || this.csf.getClass() == tCPEndpoint.csf.getClass() && this.csf.equals(tCPEndpoint.csf))) {
                return false;
            }
            return this.ssf == null || this.ssf.getClass() == tCPEndpoint.ssf.getClass() && this.ssf.equals(tCPEndpoint.ssf);
        }
        return false;
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        if (this.csf == null) {
            objectOutput.writeByte(0);
            objectOutput.writeUTF(this.host);
            objectOutput.writeInt(this.port);
        } else {
            objectOutput.writeByte(1);
            objectOutput.writeUTF(this.host);
            objectOutput.writeInt(this.port);
            objectOutput.writeObject(this.csf);
        }
    }

    public static TCPEndpoint read(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        String string;
        RMIClientSocketFactory rMIClientSocketFactory = null;
        byte by = objectInput.readByte();
        switch (by) {
            case 0: {
                string = objectInput.readUTF();
                n = objectInput.readInt();
                break;
            }
            case 1: {
                string = objectInput.readUTF();
                n = objectInput.readInt();
                rMIClientSocketFactory = (RMIClientSocketFactory)objectInput.readObject();
                if (rMIClientSocketFactory == null || !Proxy.isProxyClass(rMIClientSocketFactory.getClass())) break;
                throw new IOException("Invalid SocketFactory");
            }
            default: {
                throw new IOException("invalid endpoint format");
            }
        }
        return new TCPEndpoint(string, n, rMIClientSocketFactory, null);
    }

    public void writeHostPortFormat(DataOutput dataOutput) throws IOException {
        if (this.csf != null) {
            throw new InternalError("TCPEndpoint.writeHostPortFormat: called for endpoint with non-null socket factory");
        }
        dataOutput.writeUTF(this.host);
        dataOutput.writeInt(this.port);
    }

    public static TCPEndpoint readHostPortFormat(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        int n = dataInput.readInt();
        return new TCPEndpoint(string, n);
    }

    private static RMISocketFactory chooseFactory() {
        RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
        if (rMISocketFactory == null) {
            rMISocketFactory = TCPTransport.defaultSocketFactory;
        }
        return rMISocketFactory;
    }

    Socket newSocket() throws RemoteException {
        Socket socket;
        if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
            TCPTransport.tcpLog.log(Log.VERBOSE, "opening socket to " + this);
        }
        try {
            RMIClientSocketFactory rMIClientSocketFactory = this.csf;
            if (rMIClientSocketFactory == null) {
                rMIClientSocketFactory = TCPEndpoint.chooseFactory();
            }
            socket = rMIClientSocketFactory.createSocket(this.host, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            throw new java.rmi.UnknownHostException("Unknown host: " + this.host, unknownHostException);
        }
        catch (ConnectException connectException) {
            throw new java.rmi.ConnectException("Connection refused to host: " + this.host, connectException);
        }
        catch (IOException iOException) {
            try {
                TCPEndpoint.shedConnectionCaches();
            }
            catch (Exception | OutOfMemoryError throwable) {
                // empty catch block
            }
            throw new ConnectIOException("Exception creating connection to: " + this.host, iOException);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            socket.setKeepAlive(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return socket;
    }

    ServerSocket newServerSocket() throws IOException {
        RMIServerSocketFactory rMIServerSocketFactory;
        if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
            TCPTransport.tcpLog.log(Log.VERBOSE, "creating server socket on " + this);
        }
        if ((rMIServerSocketFactory = this.ssf) == null) {
            rMIServerSocketFactory = TCPEndpoint.chooseFactory();
        }
        ServerSocket serverSocket = rMIServerSocketFactory.createServerSocket(this.listenPort);
        if (this.listenPort == 0) {
            TCPEndpoint.setDefaultPort(serverSocket.getLocalPort(), this.csf, this.ssf);
        }
        return serverSocket;
    }

    static {
        localHostKnown = true;
        localHost = TCPEndpoint.getHostnameProperty();
        if (localHost == null) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                byte[] byArray = inetAddress.getAddress();
                if (byArray[0] == 127 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1) {
                    localHostKnown = false;
                }
                localHost = TCPEndpoint.getBoolean("java.rmi.server.useLocalHostName") ? FQDN.attemptFQDN(inetAddress) : inetAddress.getHostAddress();
            }
            catch (Exception exception) {
                localHostKnown = false;
                localHost = null;
            }
        }
        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
            TCPTransport.tcpLog.log(Log.BRIEF, "localHostKnown = " + localHostKnown + ", localHost = " + localHost);
        }
        localEndpoints = new HashMap<TCPEndpoint, LinkedList<TCPEndpoint>>();
    }

    private static class FQDN
    implements Runnable {
        private String reverseLookup;
        private String hostAddress;

        private FQDN(String string) {
            this.hostAddress = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String attemptFQDN(InetAddress inetAddress) throws UnknownHostException {
            String string = inetAddress.getHostName();
            if (string.indexOf(46) < 0) {
                String string2 = inetAddress.getHostAddress();
                FQDN fQDN = new FQDN(string2);
                int n = TCPEndpoint.getInt("sun.rmi.transport.tcp.localHostNameTimeOut", 10000);
                try {
                    FQDN fQDN2 = fQDN;
                    synchronized (fQDN2) {
                        fQDN.getFQDN();
                        fQDN.wait(n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                string = fQDN.getHost();
                if (string == null || string.equals("") || string.indexOf(46) < 0) {
                    string = string2;
                }
            }
            return string;
        }

        private void getFQDN() {
            Thread thread = AccessController.doPrivileged(new NewThreadAction(this, "FQDN Finder", true));
            thread.start();
        }

        private synchronized String getHost() {
            return this.reverseLookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string = null;
            try {
                string = InetAddress.getByName(this.hostAddress).getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                FQDN fQDN = this;
                synchronized (fQDN) {
                    this.reverseLookup = string;
                    this.notify();
                }
            }
            finally {
                FQDN fQDN = this;
                synchronized (fQDN) {
                    this.reverseLookup = string;
                    this.notify();
                }
            }
        }
    }
}

