/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import jdk.jfr.AnnotationElement;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Type;

final class MetadataWriter {
    private final MetadataDescriptor.Element metadata = new MetadataDescriptor.Element("metadata");
    private final MetadataDescriptor.Element root = new MetadataDescriptor.Element("root");

    public MetadataWriter(MetadataDescriptor metadataDescriptor) {
        metadataDescriptor.getTypes().forEach(type -> this.makeTypeElement(this.metadata, (Type)type));
        this.root.add(this.metadata);
        MetadataDescriptor.Element element = new MetadataDescriptor.Element("region");
        element.addAttribute("locale", metadataDescriptor.locale);
        element.addAttribute("gmtOffset", metadataDescriptor.gmtOffset);
        this.root.add(element);
    }

    public void writeBinary(DataOutput dataOutput) throws IOException {
        HashSet<String> hashSet = new HashSet<String>(1000);
        this.buildStringPool(this.root, hashSet);
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>(hashSet.size());
        int n = 0;
        int n2 = hashSet.size();
        this.writeInt(dataOutput, n2);
        for (String string : hashSet) {
            linkedHashMap.put(string, n);
            this.writeString(dataOutput, string);
            ++n;
        }
        this.write(dataOutput, this.root, linkedHashMap);
    }

    private void writeString(DataOutput dataOutput, String string) throws IOException {
        if (string == null) {
            dataOutput.writeByte(0);
            return;
        }
        dataOutput.writeByte(4);
        int n = string.length();
        this.writeInt(dataOutput, n);
        for (int i = 0; i < n; ++i) {
            this.writeInt(dataOutput, string.charAt(i));
        }
    }

    private void writeInt(DataOutput dataOutput, int n) throws IOException {
        long l = (long)n & 0xFFFFFFFFL;
        if (l < 128L) {
            dataOutput.write((byte)l);
            return;
        }
        dataOutput.write((byte)(l | 0x80L));
        if ((l >>= 7) < 128L) {
            dataOutput.write((byte)l);
            return;
        }
        dataOutput.write((byte)(l | 0x80L));
        if ((l >>= 7) < 128L) {
            dataOutput.write((byte)l);
            return;
        }
        dataOutput.write((byte)(l | 0x80L));
        if ((l >>= 7) < 128L) {
            dataOutput.write((byte)l);
            return;
        }
        dataOutput.write((byte)(l >>= 7));
    }

    private void buildStringPool(MetadataDescriptor.Element element, Set<String> set) {
        set.add(element.name);
        for (MetadataDescriptor.Attribute object : element.attributes) {
            set.add(object.name);
            set.add(object.value);
        }
        for (MetadataDescriptor.Element element2 : element.elements) {
            this.buildStringPool(element2, set);
        }
    }

    private void write(DataOutput dataOutput, MetadataDescriptor.Element element, HashMap<String, Integer> hashMap) throws IOException {
        this.writeInt(dataOutput, hashMap.get(element.name));
        this.writeInt(dataOutput, element.attributes.size());
        for (MetadataDescriptor.Attribute object : element.attributes) {
            this.writeInt(dataOutput, hashMap.get(object.name));
            this.writeInt(dataOutput, hashMap.get(object.value));
        }
        this.writeInt(dataOutput, element.elements.size());
        for (MetadataDescriptor.Element element2 : element.elements) {
            this.write(dataOutput, element2, hashMap);
        }
    }

    private void makeTypeElement(MetadataDescriptor.Element element, Type type) {
        MetadataDescriptor.Element element2 = element.newChild("class");
        element2.addAttribute("name", type.getName());
        String string = type.getSuperType();
        if (string != null) {
            element2.addAttribute("superType", string);
        }
        if (type.isSimpleType()) {
            element2.addAttribute("simpleType", true);
        }
        element2.addAttribute("id", type.getId());
        if (type instanceof PlatformEventType) {
            for (SettingDescriptor object : ((PlatformEventType)type).getSettings()) {
                this.makeSettingElement(element2, object);
            }
        }
        for (ValueDescriptor valueDescriptor : type.getFields()) {
            this.makeFieldElement(element2, valueDescriptor);
        }
        for (AnnotationElement annotationElement : type.getAnnotationElements()) {
            this.makeAnnotation(element2, annotationElement);
        }
    }

    private void makeSettingElement(MetadataDescriptor.Element element, SettingDescriptor settingDescriptor) {
        MetadataDescriptor.Element element2 = element.newChild("setting");
        element2.addAttribute("name", settingDescriptor.getName());
        element2.addAttribute("class", settingDescriptor.getTypeId());
        element2.addAttribute("defaultValue", settingDescriptor.getDefaultValue());
        for (AnnotationElement annotationElement : settingDescriptor.getAnnotationElements()) {
            this.makeAnnotation(element2, annotationElement);
        }
    }

    private void makeFieldElement(MetadataDescriptor.Element element, ValueDescriptor valueDescriptor) {
        MetadataDescriptor.Element element2 = element.newChild("field");
        element2.addAttribute("name", valueDescriptor.getName());
        element2.addAttribute("class", valueDescriptor.getTypeId());
        if (valueDescriptor.isArray()) {
            element2.addAttribute("dimension", 1);
        }
        if (PrivateAccess.getInstance().isConstantPool(valueDescriptor)) {
            element2.addAttribute("constantPool", true);
        }
        for (AnnotationElement annotationElement : valueDescriptor.getAnnotationElements()) {
            this.makeAnnotation(element2, annotationElement);
        }
    }

    private void makeAnnotation(MetadataDescriptor.Element element, AnnotationElement annotationElement) {
        MetadataDescriptor.Element element2 = element.newChild("annotation");
        element2.addAttribute("class", annotationElement.getTypeId());
        List<Object> list = annotationElement.getValues();
        int n = 0;
        for (ValueDescriptor valueDescriptor : annotationElement.getValueDescriptors()) {
            Object object = list.get(n++);
            if (valueDescriptor.isArray()) {
                element2.addArrayAttribute(element2, valueDescriptor.getName(), object);
                continue;
            }
            element2.addAttribute(valueDescriptor.getName(), object);
        }
    }
}

