/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.objects;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.testng.IClass;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.internal.IObject;
import org.testng.internal.Parameters;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.objects.IObjectDispenser;
import org.testng.internal.objects.pojo.BasicAttributes;
import org.testng.internal.objects.pojo.CreationAttributes;
import org.testng.internal.objects.pojo.DetailedAttributes;
import org.testng.util.Strings;
import org.testng.xml.XmlTest;

class SimpleObjectDispenser
implements IObjectDispenser {
    private final ITestObjectFactory objectFactory;

    SimpleObjectDispenser(ITestObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public void setNextDispenser(IObjectDispenser dispenser) {
        throw new UnsupportedOperationException("Cannot allow adding any further downstream object dispensers.");
    }

    @Override
    public Object dispense(CreationAttributes attributes) {
        DetailedAttributes detailed = attributes.getDetailedAttributes();
        if (detailed != null) {
            return SimpleObjectDispenser.createInstance(detailed.getDeclaringClass(), detailed.getClasses(), detailed.getXmlTest(), detailed.getFinder(), this.objectFactory, detailed.isCreate(), detailed.getErrorMsgPrefix());
        }
        BasicAttributes basic = attributes.getBasicAttributes();
        if (basic == null) {
            throw new TestNGException("Encountered problems in creating instances.");
        }
        if (basic.getRawClass() == null) {
            try {
                return this.objectFactory.newInstance(basic.getTestClass().getRealClass(), new Object[0]);
            }
            catch (TestNGException e) {
                return null;
            }
        }
        return this.objectFactory.newInstance(basic.getRawClass(), new Object[0]);
    }

    static <T> T createInstance(Class<T> declaringClass, Map<Class<?>, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, ITestObjectFactory objectFactory, boolean create, String errorMsgPrefix) {
        T result;
        block10: {
            result = null;
            try {
                Constructor<T> constructor = SimpleObjectDispenser.findAnnotatedConstructor(finder, declaringClass);
                if (null != constructor) {
                    try {
                        result = SimpleObjectDispenser.instantiateUsingParameterizedConstructor(finder, constructor, xmlTest, objectFactory);
                        break block10;
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
                result = SimpleObjectDispenser.instantiateUsingDefaultConstructor(declaringClass, classes, xmlTest, objectFactory);
            }
            catch (TestNGException ex) {
                throw ex;
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Throwable cause) {
                throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ": " + cause.getMessage(), cause);
            }
        }
        if (result == null && create) {
            Object suffix = "instantiated";
            if (!Modifier.isPublic(declaringClass.getModifiers())) {
                suffix = (String)suffix + "/accessed.";
            }
            if (Strings.isNotNullAndNotEmpty(errorMsgPrefix)) {
                suffix = (String)suffix + ". Root cause: " + errorMsgPrefix;
            }
            throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ". Check to make sure it can be " + (String)suffix);
        }
        return result;
    }

    private static <T> T instantiateUsingParameterizedConstructor(IAnnotationFinder finder, Constructor<T> constructor, XmlTest xmlTest, ITestObjectFactory objectFactory) {
        IFactoryAnnotation factoryAnnotation = finder.findAnnotation(constructor, IFactoryAnnotation.class);
        if (factoryAnnotation != null) {
            throw new IllegalArgumentException("No factory annotation found.");
        }
        IParametersAnnotation parametersAnnotation = finder.findAnnotation(constructor, IParametersAnnotation.class);
        if (parametersAnnotation == null) {
            return null;
        }
        String[] parameterNames = parametersAnnotation.getValue();
        Object[] parameters = Parameters.createInstantiationParameters(constructor, "@Parameters", finder, parameterNames, xmlTest.getAllParameters(), xmlTest.getSuite());
        return objectFactory.newInstance(constructor, parameters);
    }

    private static <T> T instantiateUsingDefaultConstructor(Class<T> declaringClass, Map<Class<?>, IClass> classes, XmlTest xmlTest, ITestObjectFactory factory) throws NoSuchMethodException {
        Constructor<T> ct;
        boolean isStatic;
        Class[] parameterTypes = new Class[]{};
        Object[] parameters = new Object[]{};
        Class<?> ec = declaringClass.getEnclosingClass();
        boolean bl = isStatic = 0 != (declaringClass.getModifiers() & 8);
        if (null != ec && !isStatic) {
            parameterTypes = new Class[]{ec};
            parameters = new Object[]{SimpleObjectDispenser.computeParameters(classes, ec, factory)};
        }
        try {
            ct = declaringClass.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            ct = declaringClass.getDeclaredConstructor(String.class);
            parameters = new Object[]{xmlTest.getName()};
        }
        ct.setAccessible(true);
        return factory.newInstance(ct, parameters);
    }

    private static Object computeParameters(Map<Class<?>, IClass> classes, Class<?> ec, ITestObjectFactory factory) throws NoSuchMethodException {
        IClass enclosingIClass = classes.get(ec);
        if (enclosingIClass == null) {
            return factory.newInstance(ec, new Object[0]);
        }
        IObject.IdentifiableObject[] enclosingInstances = IObject.objects(enclosingIClass, false);
        if (enclosingInstances.length == 0) {
            return factory.newInstance(ec.getConstructor(ec), new Object[0]);
        }
        return enclosingInstances[0].getInstance();
    }

    private static <T> Constructor<T> findAnnotatedConstructor(IAnnotationFinder finder, Class<T> declaringClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> result : constructors = declaringClass.getDeclaredConstructors()) {
            IParametersAnnotation parametersAnnotation = finder.findAnnotation(result, IParametersAnnotation.class);
            if (parametersAnnotation != null) {
                Class<?>[] parameterTypes;
                String[] parameters = parametersAnnotation.getValue();
                if (parameters.length != (parameterTypes = result.getParameterTypes()).length) {
                    throw new TestNGException("Parameter count mismatch:  " + String.valueOf(result) + "\naccepts " + parameterTypes.length + " parameters but the @Test annotation declares " + parameters.length);
                }
                return result;
            }
            IFactoryAnnotation factoryAnnotation = finder.findAnnotation(result, IFactoryAnnotation.class);
            if (factoryAnnotation == null) continue;
            return result;
        }
        return null;
    }
}

