/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.gradle.cache.Cache;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.DeferredResult;
import org.gradle.internal.execution.Execution;
import org.gradle.internal.execution.Identity;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Build.class})
public interface ExecutionEngine {
    public Request createRequest(UnitOfWork var1);

    public static interface Result {
        public Try<Execution> getExecution();

        public CachingState getCachingState();

        public <T> Try<T> getOutputAs(Class<T> var1);

        public ImmutableList<String> getExecutionReasons();

        public Optional<OriginMetadata> getReusedOutputOriginMetadata();

        @VisibleForTesting
        public Optional<ExecutionOutputState> getAfterExecutionOutputState();
    }

    public static interface Request {
        public void forceNonIncremental(String var1);

        public void withValidationContext(WorkValidationContext var1);

        public Result execute();

        public <T> Deferrable<Try<T>> executeDeferred(Cache<Identity, DeferredResult<T>> var1);
    }
}

