/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;

public final class FList<E>
extends AbstractList<E> {
    private static final FList<?> EMPTY_LIST = new FList<Object>(null, null, 0);
    private final E myHead;
    private final FList<E> myTail;
    private final int mySize;

    private FList(E head, FList<E> tail, int size) {
        this.myHead = head;
        this.myTail = tail;
        this.mySize = size;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("index = " + index + ", size = " + this.mySize);
        }
        FList<E> current = this;
        while (index > 0) {
            current = current.myTail;
            --index;
        }
        return current.myHead;
    }

    public FList<E> prepend(E elem) {
        return new FList<E>(elem, this, this.mySize + 1);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private FList<E> list;
            {
                this.list = FList.this;
            }

            @Override
            public boolean hasNext() {
                return this.list.size() > 0;
            }

            @Override
            public E next() {
                if (this.list.size() == 0) {
                    throw new NoSuchElementException();
                }
                Object res2 = this.list.myHead;
                this.list = this.list.getTail();
                assert (this.list != null);
                return res2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public FList<E> getTail() {
        return this.myTail;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof FList) {
            FList<E> list1 = this;
            FList<E> list2 = (FList<E>)o2;
            if (this.mySize != list2.mySize) {
                return false;
            }
            while (list1 != null) {
                if (!Comparing.equal(list1.myHead, list2.myHead)) {
                    return false;
                }
                if ((list1 = list1.getTail()) != (list2 = list2.getTail())) continue;
                return true;
            }
            return true;
        }
        return super.equals(o2);
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (FList<E> each = this; each != null; each = each.getTail()) {
            result2 = result2 * 31 + (each.myHead != null ? each.myHead.hashCode() : 0);
        }
        return result2;
    }

    public static <E> FList<E> emptyList() {
        return EMPTY_LIST;
    }
}

