#!/usr/bin/env bash

# SPDX-FileCopyrightText: Copyright (c) 2023-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set -euxo pipefail

SCRIPT=$(readlink -f $0)
HERE=$(dirname $SCRIPT)

export GST_DEBUG=*:0
export GSTREAMER_PATH=/opt/gstreamer
export PATH=${GSTREAMER_PATH}/bin:${PATH}
export LD_LIBRARY_PATH=${GSTREAMER_PATH}/lib/x86_64-linux-gnu:${LD_LIBRARY_PATH:-}
export GI_TYPELIB_PATH=${GSTREAMER_PATH}/lib/x86_64-linux-gnu/girepository-1.0:/usr/lib/x86_64-linux-gnu/girepository-1.0:${GI_TYPELIB_PATH:-}
export GST_PY_PATH=$(find ${GSTREAMER_PATH}/lib -type d -name "python3.*")
export PYTHONPATH=${GST_PY_PATH}/site-packages:${GSTREAMER_PATH}/lib/python3/dist-packages:${PYTHONPATH:-}

until [[ -S /tmp/.X11-unix/X4 ]]; do sleep 1; done && echo 'X Server is ready'
export PULSE_SERVER=unix:/run/pulse/native
export WEBRTC_ENCODER=${WEBRTC_ENCODER:-vp9enc}
export WEBRTC_ENABLE_RESIZE=${WEBRTC_ENABLE_RESIZE:-true}
export HTTP_PORT=${HTTP_PORT:-8080}
export TURN_HOST=${TURN_HOST:-$HOST_IP}
export TURN_PORT=${TURN_PORT:-3478}
export TURN_USERNAME=${TURN_USERNAME:-nvidia}
export TURN_PASSWORD=${TURN_PASSWORD:-nvidia}
export TURN_PROTOCOL=${TURN_PROTOCOL:-tcp}
# Support the old SCREEN environment variable for backwards compatibility
export MAX_RESOLUTION=${SCREEN}
export MAX_RESOLUTION=${MAX_RESOLUTION:-1920x1080}
# if AUTH_USERNAME is set - enable authentification
if [ -n "${WEB_USERNAME}" ]; then
  export ENABLE_BASIC_AUTH=true
  export BASIC_AUTH_USER=${WEB_USERNAME}
  if [ -n "${WEB_PASSWORD}" ]; then
    export BASIC_AUTH_PASSWORD=${WEB_PASSWORD}
  fi
fi
selkies-gstreamer-resize $MAX_RESOLUTION
selkies-gstreamer --port=$HTTP_PORT
