﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/tnb/Tnb_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace tnb {
namespace Model {

/**
 * <p>Metadata related to a network operation.</p> <p>A network operation is any
 * operation that is done to your network, such as network instance instantiation
 * or termination.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperationsMetadata">AWS
 * API Reference</a></p>
 */
class ListSolNetworkOperationsMetadata {
 public:
  AWS_TNB_API ListSolNetworkOperationsMetadata() = default;
  AWS_TNB_API ListSolNetworkOperationsMetadata(Aws::Utils::Json::JsonView jsonValue);
  AWS_TNB_API ListSolNetworkOperationsMetadata& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_TNB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The date that the resource was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  ListSolNetworkOperationsMetadata& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date that the resource was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModified() const { return m_lastModified; }
  inline bool LastModifiedHasBeenSet() const { return m_lastModifiedHasBeenSet; }
  template <typename LastModifiedT = Aws::Utils::DateTime>
  void SetLastModified(LastModifiedT&& value) {
    m_lastModifiedHasBeenSet = true;
    m_lastModified = std::forward<LastModifiedT>(value);
  }
  template <typename LastModifiedT = Aws::Utils::DateTime>
  ListSolNetworkOperationsMetadata& WithLastModified(LastModifiedT&& value) {
    SetLastModified(std::forward<LastModifiedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The network service descriptor id used for the operation.</p> <p>Only present
   * if the updateType is <code>UPDATE_NS</code>.</p>
   */
  inline const Aws::String& GetNsdInfoId() const { return m_nsdInfoId; }
  inline bool NsdInfoIdHasBeenSet() const { return m_nsdInfoIdHasBeenSet; }
  template <typename NsdInfoIdT = Aws::String>
  void SetNsdInfoId(NsdInfoIdT&& value) {
    m_nsdInfoIdHasBeenSet = true;
    m_nsdInfoId = std::forward<NsdInfoIdT>(value);
  }
  template <typename NsdInfoIdT = Aws::String>
  ListSolNetworkOperationsMetadata& WithNsdInfoId(NsdInfoIdT&& value) {
    SetNsdInfoId(std::forward<NsdInfoIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The network function id used for the operation.</p> <p>Only present if the
   * updateType is <code>MODIFY_VNF_INFO</code>.</p>
   */
  inline const Aws::String& GetVnfInstanceId() const { return m_vnfInstanceId; }
  inline bool VnfInstanceIdHasBeenSet() const { return m_vnfInstanceIdHasBeenSet; }
  template <typename VnfInstanceIdT = Aws::String>
  void SetVnfInstanceId(VnfInstanceIdT&& value) {
    m_vnfInstanceIdHasBeenSet = true;
    m_vnfInstanceId = std::forward<VnfInstanceIdT>(value);
  }
  template <typename VnfInstanceIdT = Aws::String>
  ListSolNetworkOperationsMetadata& WithVnfInstanceId(VnfInstanceIdT&& value) {
    SetVnfInstanceId(std::forward<VnfInstanceIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createdAt{};
  bool m_createdAtHasBeenSet = false;

  Aws::Utils::DateTime m_lastModified{};
  bool m_lastModifiedHasBeenSet = false;

  Aws::String m_nsdInfoId;
  bool m_nsdInfoIdHasBeenSet = false;

  Aws::String m_vnfInstanceId;
  bool m_vnfInstanceIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace tnb
}  // namespace Aws
