/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTrigger;
import org.jkiss.dbeaver.ext.generic.edit.GenericTriggerManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class CubridTriggerManager
extends GenericTriggerManager<CubridTrigger>
implements DBEObjectRenamer<CubridTrigger> {
    public static final String BASE_TRIGGER_NAME = "new_trigger";

    public boolean canCreateObject(@NotNull Object container) {
        CubridTable table = (CubridTable)((Object)container);
        boolean isShard = table.getDataSource().isShard();
        return !isShard && container instanceof GenericTableBase;
    }

    protected CubridTrigger createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new CubridTrigger((GenericTableBase)container, BASE_TRIGGER_NAME, monitor);
    }

    public void createTrigger(CubridTrigger trigger, StringBuilder sb) {
        sb.append("\n").append(trigger.getActionTime()).append(" ");
        if (trigger.getEvent().equals("COMMIT") || trigger.getEvent().equals("ROLLBACK")) {
            sb.append(trigger.getEvent());
        } else {
            sb.append(trigger.getEvent());
            sb.append(" ON ").append(trigger.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL));
            if (trigger.getEvent().contains("UPDATE") && trigger.getTargetColumn() != null) {
                sb.append("(" + DBUtils.getQuotedIdentifier((DBPDataSource)trigger.getDataSource(), (String)trigger.getTargetColumn()) + ")");
            }
            if (trigger.getCondition() != null) {
                sb.append("\nIF ").append(trigger.getCondition());
            }
        }
        sb.append("\nEXECUTE ");
        if (trigger.getActionType().equals("REJECT") || trigger.getActionType().equals("INVALIDATE TRANSACTION")) {
            sb.append(trigger.getActionType());
        } else if (trigger.getActionType().equals("PRINT")) {
            sb.append(trigger.getActionType()).append(" ");
            sb.append(trigger.getActionDefinition() == null ? "" : SQLUtils.quoteString((DBSObject)trigger, (String)trigger.getActionDefinition()));
        } else {
            sb.append(trigger.getActionDefinition() == null ? "" : trigger.getActionDefinition());
        }
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        CubridTrigger trigger = (CubridTrigger)command.getObject();
        CubridDataSource dataSource = (CubridDataSource)trigger.getDataSource();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TRIGGER ").append(trigger.getFullyQualifiedName(DBPEvaluationContext.DDL));
        sb.append(trigger.getActive() ? "\nSTATUS ACTIVE" : "\nSTATUS INACTIVE");
        sb.append("\nPRIORITY ").append(trigger.getPriority());
        this.createTrigger(trigger, sb);
        if (trigger.getDescription() != null) {
            sb.append("\nCOMMENT ").append(SQLUtils.quoteString((DBSObject)trigger, (String)trigger.getDescription()));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Trigger", sb.toString()));
        if (!dataSource.getSupportMultiSchema() && !trigger.getOwner().getName().equalsIgnoreCase(dataSource.getCurrentUser())) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Change Owner", "ALTER TRIGGER " + DBUtils.getQuotedIdentifier((DBPDataSource)trigger.getDataSource(), (String)trigger.getName()) + " OWNER TO " + DBUtils.getQuotedIdentifier((DBSObject)trigger.getOwner())));
        }
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        CubridTrigger trigger = (CubridTrigger)command.getObject();
        String triggerName = trigger.getFullyQualifiedName(DBPEvaluationContext.DDL);
        if (command.hasProperty((Object)"active")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("ALTER TRIGGER " + triggerName + " STATUS " + (trigger.getActive() ? "ACTIVE" : "INACTIVE")));
        }
        if (command.hasProperty((Object)"priority")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("ALTER TRIGGER " + triggerName + " PRIORITY " + trigger.getPriority()));
        }
        if (command.hasProperty((Object)"description")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("ALTER TRIGGER " + triggerName + " COMMENT " + SQLUtils.quoteString((DBSObject)trigger, (String)CommonUtils.notEmpty((String)trigger.getDescription()))));
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        CubridTrigger trigger = (CubridTrigger)command.getObject();
        boolean isSupportMultiSchema = ((CubridDataSource)trigger.getDataSource()).getSupportMultiSchema();
        String schemaName = isSupportMultiSchema ? DBUtils.getQuotedIdentifier((DBSObject)trigger.getOwner()) + "." : "";
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename Trigger", "RENAME TRIGGER " + schemaName + DBUtils.getQuotedIdentifier((DBPDataSource)trigger.getDataSource(), (String)command.getOldName()) + " AS " + schemaName + DBUtils.getQuotedIdentifier((DBPDataSource)trigger.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull CubridTrigger object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    public boolean canEditObject(CubridTrigger object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    public boolean canDeleteObject(CubridTrigger object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }
}

