/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.tools;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;
import org.jkiss.dbeaver.model.struct.DBSObject;

public final class ExasolJDBCObjectSimpleCacheLiterals<OWNER extends DBSObject, OBJECT extends DBSObject>
extends JDBCObjectCache<OWNER, OBJECT> {
    private final String query;
    private final Class<OBJECT> objectType;
    private final Object[] queryParameters;
    private Constructor<OBJECT> objectConstructor;
    private String executeQuery = "";

    public ExasolJDBCObjectSimpleCacheLiterals(Class<OBJECT> objectType, String query, Object ... args) {
        this.query = query;
        this.objectType = objectType;
        this.queryParameters = args;
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OWNER owner) throws SQLException {
        JDBCStatement dbStat = session.createStatement();
        for (int i = 0; i < this.queryParameters.length; ++i) {
            this.queryParameters[i] = ExasolUtils.quoteString(this.queryParameters[i].toString());
        }
        this.executeQuery = String.format(this.query, this.queryParameters);
        ((JDBCStatementImpl)dbStat).setQueryString(this.executeQuery);
        return dbStat;
    }

    protected OBJECT fetchObject(@NotNull JDBCSession session, @NotNull OWNER owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
        try {
            if (this.objectConstructor == null) {
                for (Class argType = owner.getClass(); argType != null; argType = argType.getSuperclass()) {
                    try {
                        this.objectConstructor = this.objectType.getConstructor(argType, ResultSet.class);
                        break;
                    }
                    catch (Exception e) {
                        for (Class<?> intType : argType.getInterfaces()) {
                            try {
                                this.objectConstructor = this.objectType.getConstructor(intType, ResultSet.class);
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                        if (this.objectConstructor != null) break;
                        continue;
                    }
                }
                if (this.objectConstructor == null) {
                    throw new DBException("Can't find proper constructor for object '" + this.objectType.getName() + "'");
                }
            }
            return (OBJECT)((DBSObject)this.objectConstructor.newInstance(owner, resultSet));
        }
        catch (Exception e) {
            throw new DBException("Error creating cache object", e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e);
        }
    }
}

