/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class MySQLUtils {
    private static final Log log = Log.getLog(MySQLUtils.class);
    private static final String COLUMN_POSTFIX_PRIV = "_priv";
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();

    public static int typeNameToValueType(String typeName) {
        Integer valueType = typeMap.get(typeName.toLowerCase(Locale.ENGLISH));
        return valueType == null ? 1111 : valueType;
    }

    public static List<String> collectPrivilegeNames(ResultSet resultSet) {
        try {
            ArrayList<String> privs = new ArrayList<String>();
            ResultSetMetaData rsMetaData = resultSet.getMetaData();
            int colCount = rsMetaData.getColumnCount();
            for (int i = 0; i < colCount; ++i) {
                String colName = rsMetaData.getColumnName(i + 1);
                if (!colName.toLowerCase(Locale.ENGLISH).endsWith(COLUMN_POSTFIX_PRIV)) continue;
                privs.add(colName.substring(0, colName.length() - COLUMN_POSTFIX_PRIV.length()));
            }
            return privs;
        }
        catch (SQLException e) {
            log.debug((Object)e);
            return Collections.emptyList();
        }
    }

    public static Map<String, Boolean> collectPrivileges(List<String> privNames, ResultSet resultSet) {
        TreeMap<String, Boolean> privs = new TreeMap<String, Boolean>();
        for (String privName : privNames) {
            privs.put(privName, "Y".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)(privName + COLUMN_POSTFIX_PRIV))));
        }
        return privs;
    }

    public static String getMySQLConsoleBinaryName() {
        return RuntimeUtils.getNativeBinaryName((String)"mysql");
    }

    @NotNull
    public static String getMariaDBConsoleBinaryName() {
        return RuntimeUtils.getNativeBinaryName((String)"mariadb");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String determineCurrentDatabase(JDBCSession session) throws DBCException {
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT DATABASE()");){
            String string;
            block18: {
                JDBCResultSet resultSet;
                block16: {
                    String string2;
                    block17: {
                        resultSet = dbStat.executeQuery();
                        try {
                            if (!resultSet.next()) break block16;
                            string2 = resultSet.getString(1);
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return string2;
                }
                string = null;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public static boolean isMariaDB(DBPDriver driver) {
        return "org.mariadb.jdbc.Driver".equals(driver.getDriverClassName());
    }

    public static boolean isAlterUSerSupported(MySQLDataSource dataSource) {
        return dataSource.isMariaDB() ? dataSource.isServerVersionAtLeast(10, 2) : dataSource.isServerVersionAtLeast(5, 7);
    }

    public static boolean isColumnSridSupported(@NotNull MySQLDataSource dataSource) {
        return !dataSource.isMariaDB() && dataSource.isServerVersionAtLeast(8, 0);
    }

    public static boolean isSpatialDataType(@NotNull String name) {
        switch (name.toLowerCase(Locale.ROOT)) {
            case "geometry": 
            case "point": 
            case "linestring": 
            case "polygon": 
            case "multipoint": 
            case "multilinestring": 
            case "multipolygon": 
            case "geometrycollection": {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static File getClientExecutablePath(@NotNull AbstractNativeToolSettings<?> settings) throws IOException {
        return MySQLUtils.getExecutablePath(settings, "mysql", "mariadb");
    }

    @NotNull
    public static File getDumpExecutablePath(@NotNull AbstractNativeToolSettings<?> settings) throws IOException {
        return MySQLUtils.getExecutablePath(settings, "mysqldump", "mariadb-dump");
    }

    @NotNull
    private static File getExecutablePath(@NotNull AbstractNativeToolSettings<?> settings, @NotNull String mysqlName, @NotNull String mariaName) throws IOException {
        DBPNativeClientLocation location = settings.getClientHome();
        if (location == null) {
            throw new IOException("MySQL client location is not specified");
        }
        try {
            return RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)location, (String)"bin", (String)mysqlName);
        }
        catch (IOException ignored) {
            return RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)location, (String)"bin", (String)mariaName);
        }
    }

    static {
        typeMap.put("bit", -7);
        typeMap.put("bool", 16);
        typeMap.put("boolean", 16);
        typeMap.put("tinyint", -6);
        typeMap.put("smallint", 5);
        typeMap.put("mediumint", 4);
        typeMap.put("int", 4);
        typeMap.put("integer", 4);
        typeMap.put("int24", 4);
        typeMap.put("bigint", -5);
        typeMap.put("real", 8);
        typeMap.put("float", 7);
        typeMap.put("decimal", 3);
        typeMap.put("dec", 3);
        typeMap.put("numeric", 3);
        typeMap.put("double", 8);
        typeMap.put("double precision", 8);
        typeMap.put("char", 1);
        typeMap.put("varchar", 12);
        typeMap.put("date", 91);
        typeMap.put("time", 92);
        typeMap.put("year", 91);
        typeMap.put("timestamp", 93);
        typeMap.put("datetime", 93);
        typeMap.put("tinyblob", -2);
        typeMap.put("blob", -4);
        typeMap.put("mediumblob", -4);
        typeMap.put("longblob", -4);
        typeMap.put("tinytext", 12);
        typeMap.put("text", 12);
        typeMap.put("mediumtext", 12);
        typeMap.put("longtext", 12);
        typeMap.put("enum", 1);
        typeMap.put("set", 1);
        typeMap.put("geometry", -2);
        typeMap.put("binary", -2);
        typeMap.put("varbinary", -3);
        typeMap.put("uuid", 1);
    }
}

