/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.oauth.code;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import org.jkiss.code.NotNull;

public class OAuthRequestURLBuilder {
    private final String baseURL;
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    private boolean includeDefaultScope = true;
    private boolean includeState = true;
    private boolean includeNonce = true;
    private boolean includePKCE = false;
    private String codeChallenge;

    public OAuthRequestURLBuilder(@NotNull String baseURL) {
        this.baseURL = baseURL;
    }

    public OAuthRequestURLBuilder withClientId(@NotNull String clientId) {
        this.params.put("client_id", clientId);
        return this;
    }

    public OAuthRequestURLBuilder withRedirectURI(@NotNull String redirectURI) {
        this.params.put("redirect_uri", redirectURI);
        return this;
    }

    public OAuthRequestURLBuilder withScope(@NotNull String scope) {
        this.params.put("scope", scope);
        this.includeDefaultScope = false;
        return this;
    }

    public OAuthRequestURLBuilder withCodeChallenge(@NotNull String codeChallenge) {
        this.includePKCE = true;
        this.codeChallenge = codeChallenge;
        return this;
    }

    public OAuthRequestURLBuilder withParam(@NotNull String key, @NotNull String value) {
        this.params.put(key, value);
        return this;
    }

    public OAuthRequestURLBuilder withParams(@NotNull Map<String, String> customParams) {
        this.params.putAll(customParams);
        return this;
    }

    public OAuthRequestURLBuilder withPrompt(@NotNull String prompt) {
        return this.withParam("prompt", prompt);
    }

    public OAuthRequestURLBuilder disableState() {
        this.includeState = false;
        return this;
    }

    public OAuthRequestURLBuilder disableNonce() {
        this.includeNonce = false;
        return this;
    }

    public OAuthRequestURLBuilder disableDefaultScope() {
        this.includeDefaultScope = false;
        return this;
    }

    @NotNull
    public String build() throws IOException {
        if (!this.params.containsKey("client_id")) {
            throw new IOException("Missing client_id");
        }
        if (!this.params.containsKey("redirect_uri")) {
            throw new IOException("Missing redirect_uri");
        }
        this.params.putIfAbsent("response_type", "code");
        if (this.includePKCE) {
            if (this.codeChallenge == null) {
                throw new IOException("Missing code challenge");
            }
            this.params.put("code_challenge", this.codeChallenge);
            this.params.put("code_challenge_method", "S256");
        }
        if (this.includeState) {
            this.params.putIfAbsent("state", UUID.randomUUID().toString());
        }
        if (this.includeNonce) {
            this.params.putIfAbsent("nonce", UUID.randomUUID().toString());
        }
        if (this.includeDefaultScope && !this.params.containsKey("scope")) {
            this.params.put("scope", "openid email profile");
        }
        return this.baseURL + "?" + OAuthRequestURLBuilder.buildURLParameters(this.params);
    }

    public static String buildURLParameters(Map<String, String> params) {
        StringJoiner encodedParams = new StringJoiner("&");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            encodedParams.add(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
        }
        return encodedParams.toString();
    }
}

